/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.location;

import cn.featherfly.common.location.LocationPoint;
import cn.featherfly.common.location.RectangleRange;

public class LocationUtils {
    private static final double EARTH_RADIUS = 6371000.0;

    private LocationUtils() {
    }

    public static double hav(double theta) {
        double s = Math.sin(theta / 2.0);
        return s * s;
    }

    public static double getDistance(LocationPoint point0, LocationPoint point1) {
        double lat0 = Math.toRadians(point0.getLatitude());
        double lat1 = Math.toRadians(point1.getLatitude());
        double lng0 = Math.toRadians(point0.getLongitude());
        double lng1 = Math.toRadians(point1.getLongitude());
        double dlng = Math.abs(lng0 - lng1);
        double dlat = Math.abs(lat0 - lat1);
        double h = LocationUtils.hav(dlat) + Math.cos(lat0) * Math.cos(lat1) * LocationUtils.hav(dlng);
        double distance = 1.2742E7 * Math.asin(Math.sqrt(h));
        return distance;
    }

    public static RectangleRange getRectanglePoint(LocationPoint point, double distance) {
        double lat = point.getLatitude();
        double lng = point.getLongitude();
        double dlng = 2.0 * Math.asin(Math.sin(distance / 1.2742E7) / Math.cos(Math.toRadians(lat)));
        dlng = Math.toDegrees(dlng);
        double dlat = distance / 6371000.0;
        dlat = Math.toDegrees(dlat);
        RectangleRange rectangleRange = new RectangleRange();
        rectangleRange.setLeftTop(new LocationPoint(lat + dlat, lng - dlng));
        rectangleRange.setLeftBottom(new LocationPoint(lat - dlat, lng - dlng));
        rectangleRange.setRightTop(new LocationPoint(lat + dlat, lng + dlng));
        rectangleRange.setRightBottom(new LocationPoint(lat - dlat, lng + dlng));
        return rectangleRange;
    }
}

