/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang.string;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.lang.Lang;
import java.util.Map;
import java.util.function.Function;

public class StringFormatter {
    private char startSymbol;
    private char endSymbol;

    public StringFormatter(char startSymbol, char endSymbol) {
        this.startSymbol = startSymbol;
        this.endSymbol = endSymbol;
    }

    public char getStartSymbol() {
        return this.startSymbol;
    }

    public char getEndSymbol() {
        return this.endSymbol;
    }

    public String format(String str, Object ... args) {
        return this.format(str, this.startSymbol, this.endSymbol, (Object)Lang.toMapStringKey(args));
    }

    public String format(String str, Map<String, Object> args) {
        return this.format(str, this.startSymbol, this.endSymbol, (Object)args);
    }

    public <O> String format(String str, O args) {
        return this.format(str, this.startSymbol, this.endSymbol, args);
    }

    private String format(String str, char startSymbol, char endSymbol, Object args) {
        Function<String, Object> getParam;
        if (Lang.isEmpty(str)) {
            return str;
        }
        if (args instanceof Map) {
            Map argsMap = (Map)args;
            getParam = name -> argsMap.get(name);
        } else {
            getParam = name -> BeanUtils.getProperty(args, name);
        }
        StringBuilder sb = new StringBuilder(str);
        int nameStartIndex = -1;
        int nameEndIndex = -1;
        boolean isEnd = false;
        boolean sameStartEnd = startSymbol == endSymbol;
        for (int index = 0; index < sb.length(); ++index) {
            char c = sb.charAt(index);
            boolean bl = isEnd = index == sb.length() - 1;
            if (nameStartIndex == -1) {
                if (startSymbol == c) {
                    if (!isEnd && sb.charAt(index + 1) == startSymbol) {
                        sb.deleteCharAt(index);
                        continue;
                    }
                    nameStartIndex = index;
                    continue;
                }
                if (c == endSymbol && !isEnd && sb.charAt(index + 1) == endSymbol) {
                    sb.deleteCharAt(index);
                }
            }
            if (nameStartIndex < 0) continue;
            if (startSymbol == c && !sameStartEnd) {
                if (!isEnd && sb.charAt(index + 1) == startSymbol) {
                    sb.deleteCharAt(index);
                    continue;
                }
                nameStartIndex = index;
                continue;
            }
            if (c != endSymbol && !isEnd) continue;
            nameEndIndex = index;
            String name2 = sb.substring(nameStartIndex + 1, nameEndIndex);
            sb.insert(++nameEndIndex, getParam.apply(name2));
            sb.delete(nameStartIndex, nameEndIndex);
            index -= nameEndIndex - nameStartIndex - 1;
            nameStartIndex = -1;
            nameEndIndex = -1;
        }
        return sb.toString();
    }
}

