/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang.reflect;

public enum Modifier {
    PUBLIC(1),
    PRIVATE(2),
    PROTECTED(4),
    STATIC(8),
    FINAL(16),
    SYNCHRONIZED(32),
    VOLATILE(64),
    TRANSIENT(128),
    NATIVE(256),
    INTERFACE(512),
    ABSTRACT(1024),
    STRICT(2048);

    private int modifier;

    private Modifier(int modifier) {
        this.modifier = modifier;
    }

    public boolean isModifier(int modifier) {
        boolean result = false;
        switch (this) {
            case PUBLIC: {
                result = java.lang.reflect.Modifier.isPublic(modifier);
                break;
            }
            case PRIVATE: {
                result = java.lang.reflect.Modifier.isPrivate(modifier);
                break;
            }
            case PROTECTED: {
                result = java.lang.reflect.Modifier.isProtected(modifier);
                break;
            }
            case STATIC: {
                result = java.lang.reflect.Modifier.isStatic(modifier);
                break;
            }
            case FINAL: {
                result = java.lang.reflect.Modifier.isFinal(modifier);
                break;
            }
            case SYNCHRONIZED: {
                result = java.lang.reflect.Modifier.isSynchronized(modifier);
                break;
            }
            case VOLATILE: {
                result = java.lang.reflect.Modifier.isVolatile(modifier);
                break;
            }
            case TRANSIENT: {
                result = java.lang.reflect.Modifier.isTransient(modifier);
                break;
            }
            case NATIVE: {
                result = java.lang.reflect.Modifier.isNative(modifier);
                break;
            }
            case INTERFACE: {
                result = java.lang.reflect.Modifier.isInterface(modifier);
                break;
            }
            case ABSTRACT: {
                result = java.lang.reflect.Modifier.isAbstract(modifier);
                break;
            }
            case STRICT: {
                result = java.lang.reflect.Modifier.isStrict(modifier);
                break;
            }
        }
        return result;
    }

    public int getModifier() {
        return this.modifier;
    }
}

