/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang.matcher;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.matcher.FieldMatcher;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTypeMatcher
implements FieldMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldTypeMatcher.class);
    private Class<?> fieldType;
    private boolean matchSubType;

    public FieldTypeMatcher(Class<?> fieldType) {
        this.fieldType = fieldType;
    }

    public FieldTypeMatcher(Class<?> fieldType, boolean matchSubType) {
        this.fieldType = fieldType;
        this.matchSubType = matchSubType;
    }

    @Override
    public boolean match(Field field) {
        if (this.fieldType == null || field == null) {
            return false;
        }
        if (this.matchSubType) {
            LOGGER.debug("{} \u5339\u914d\u7c7b\u578b\uff08\u5305\u542b\u5b50\u7c7b\u578b\uff09 {}", (Object)this.fieldType.getName(), (Object)field.getType().getName());
            return ClassUtils.isParent(this.fieldType, field.getType());
        }
        LOGGER.debug("{} \u5339\u914d\u7c7b\u578b {}", (Object)this.fieldType.getName(), (Object)field.getType().getName());
        return this.fieldType == field.getType();
    }
}

