/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.lang.Lang;

public final class UriUtils {
    public static final String SEPARATOR = "/";

    private UriUtils() {
    }

    public static String convertSeparator(String uri) {
        return uri.replace("\\", SEPARATOR);
    }

    public static String[] splitUri(String uri) {
        String[] uris = null;
        if ((uri = UriUtils.removeStartAndEndSeparator(uri)).contains(SEPARATOR)) {
            uris = uri.split(SEPARATOR);
        }
        return uris;
    }

    public static String linkUri(String startUri, String endUri) {
        return UriUtils.linkUri(startUri, endUri, true);
    }

    public static String linkUri(String startUri, String endUri, boolean ignoreCaseEmpty) {
        if (ignoreCaseEmpty && Lang.isEmpty(startUri)) {
            return endUri;
        }
        if (ignoreCaseEmpty && Lang.isEmpty(endUri)) {
            return startUri;
        }
        startUri = UriUtils.removeEndSeparator(startUri);
        endUri = UriUtils.removeStartAndEndSeparator(endUri);
        return startUri + SEPARATOR + endUri;
    }

    public static String linkUri(String ... uris) {
        return UriUtils.linkUri(true, uris);
    }

    public static String linkUri(boolean ignoreCaseEmpty, String ... uris) {
        String resultUri = null;
        if (uris != null && uris.length > 0) {
            resultUri = uris[0];
            if (uris.length > 1) {
                for (int i = 1; i < uris.length; ++i) {
                    resultUri = UriUtils.linkUri(resultUri, uris[i], ignoreCaseEmpty);
                }
            }
        }
        return resultUri;
    }

    public static String removeStartSeparator(String uri) {
        while (uri.startsWith(SEPARATOR)) {
            uri = uri.substring(1, uri.length());
        }
        return uri;
    }

    public static String removeEndSeparator(String uri) {
        while (uri.endsWith(SEPARATOR)) {
            uri = uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    public static String removeStartAndEndSeparator(String uri) {
        uri = UriUtils.removeStartSeparator(uri);
        uri = UriUtils.removeEndSeparator(uri);
        return uri;
    }
}

