/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.lang.Strings;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public final class UUIDGenerator {
    private static final char[] LETTERS_MAP;
    private static final int NUMBER_THREE = 3;
    private static final int NUMBER_FOUR = 4;
    private static final int NUMBER_TEN = 10;
    private static final int NUMBER_SIXTEEN = 16;
    private static final int NUMBER_SIXTY_TWO = 62;
    private static final int NUMBER_SIXTY_FOUR = 64;
    private static final int NUMBER_THREETY_SIX = 36;
    private static final char[] CHARS_MAP;

    private UUIDGenerator() {
    }

    public static String generateUUID36() {
        return UUIDGenerator.generate();
    }

    public static String generateUUID32() {
        return Strings.replace(UUIDGenerator.generate().toString(), "-", "");
    }

    public static String generateUUID22Letters() {
        String uuid = UUIDGenerator.generateUUID32();
        uuid = "0" + uuid;
        return UUIDGenerator.hexTo64Letters(uuid);
    }

    public static String generateUUID22Chars() {
        String uuid = UUIDGenerator.generateUUID32();
        uuid = "0" + uuid;
        return UUIDGenerator.hexTo64CHARS(uuid);
    }

    public static String generateUUID() {
        return UUIDGenerator.generateUUID32();
    }

    private static String generate() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        UUID uuid = new UUID(random.nextInt(), random.nextInt());
        return uuid.toString();
    }

    private static String hexTo64Letters(String hex) {
        StringBuffer r = new StringBuffer();
        int index = 0;
        int[] buff = new int[3];
        int l = hex.length();
        for (int i = 0; i < l; ++i) {
            index = i % 3;
            buff[index] = Integer.parseInt("" + hex.charAt(i), 16);
            if (index != 2) continue;
            r.append(LETTERS_MAP[buff[0] << 2 | buff[1] >>> 2]);
            r.append(LETTERS_MAP[(buff[1] & 3) << 4 | buff[2]]);
        }
        return r.toString();
    }

    private static String hexTo64CHARS(String hex) {
        StringBuffer r = new StringBuffer();
        int index = 0;
        int[] buff = new int[3];
        int l = hex.length();
        for (int i = 0; i < l; ++i) {
            index = i % 3;
            buff[index] = Integer.parseInt("" + hex.charAt(i), 16);
            if (index != 2) continue;
            r.append(CHARS_MAP[buff[0] << 2 | buff[1] >>> 2]);
            r.append(CHARS_MAP[(buff[1] & 3) << 4 | buff[2]]);
        }
        return r.toString();
    }

    static {
        int i;
        LETTERS_MAP = new char[64];
        for (i = 0; i < 10; ++i) {
            UUIDGenerator.LETTERS_MAP[i] = (char)(48 + i);
        }
        for (i = 10; i < 36; ++i) {
            UUIDGenerator.LETTERS_MAP[i] = (char)(97 + i - 10);
        }
        for (i = 36; i < 62; ++i) {
            UUIDGenerator.LETTERS_MAP[i] = (char)(65 + i - 36);
        }
        UUIDGenerator.LETTERS_MAP[62] = 95;
        UUIDGenerator.LETTERS_MAP[63] = 45;
        int last = 63;
        CHARS_MAP = new char[64];
        for (int i2 = 0; i2 < last; ++i2) {
            UUIDGenerator.CHARS_MAP[i2] = (char)(33 + i2);
            if (CHARS_MAP[i2] == '\"') {
                UUIDGenerator.CHARS_MAP[i2] = 123;
                continue;
            }
            if (CHARS_MAP[i2] != '\'') continue;
            UUIDGenerator.CHARS_MAP[i2] = 125;
        }
        UUIDGenerator.CHARS_MAP[last] = 124;
    }
}

