/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.lang.Lang;

public final class SystemPropertyUtils {
    private static final String JAVA_VERSION = "java.version";
    private static final String JAVA_VENDOR = "java.vendor";
    private static final String JAVA_VENDOR_URL = "java.vendor.url";
    private static final String JAVA_HOME = "java.home";
    private static final String JAVA_VM_SPECIFICATION_VERSION = "java.vm.specification.version";
    private static final String JAVA_VM_SPECIFICATION_VENDOR = "java.vm.specification.vendor";
    private static final String JAVA_VM_SPECIFICATION_NAME = "java.vm.specification.name";
    private static final String JAVA_VM_VERSION = "java.vm.version";
    private static final String JAVA_VM_VENDOR = "java.vm.vendor";
    private static final String JAVA_VM_NAME = "java.vm.name";
    private static final String JAVA_SPECIFICATION_VENDOR = "java.specification.vendor";
    private static final String JAVA_SPECIFICATION_NAME = "java.specification.name";
    private static final String JAVA_CLASS_VERSION = "java.class.version";
    private static final String JAVA_CLASS_PATH = "java.class.path";
    private static final String JAVA_LIBRARY_PATH = "java.library.path";
    private static final String JAVA_SPECIFICATION_VERSION = "java.specification.version";
    private static final String JAVA_IO_TEMDIR = "java.io.tmpdir";
    private static final String JAVA_COMPILER = "java.compiler";
    private static final String JAVA_EXT_DIRS = "java.ext.dirs";
    private static final String OS_NAME = "os.name";
    private static final String OS_VERSION = "os.version";
    private static final String OS_ARCH = "os.arch";
    private static final String FILE_SEPARATOR = "file.separator";
    private static final String PATH_SEPARATOR = "path.separator";
    private static final String LINE_SEPARATOR = "line.separator";
    private static final String USER_NAME = "user.name";
    private static final String USER_HOME = "user.home";
    private static final String USER_DIR = "user.dir";

    private SystemPropertyUtils() {
    }

    public static String getJavaLibraryPath() {
        return System.getProperty(JAVA_LIBRARY_PATH);
    }

    public static String getJavaClassPath() {
        return System.getProperty(JAVA_CLASS_PATH);
    }

    public static String getJavaIoTmpdir() {
        return System.getProperty(JAVA_IO_TEMDIR);
    }

    public static String getJavaVersion() {
        return System.getProperty(JAVA_VERSION);
    }

    public static String getJavaVendor() {
        return System.getProperty(JAVA_VENDOR);
    }

    public static String getJavaVendorUrl() {
        return System.getProperty(JAVA_VENDOR_URL);
    }

    public static String getJavaHome() {
        return System.getProperty(JAVA_HOME);
    }

    public static String getJavaVmSpecificationVersion() {
        return System.getProperty(JAVA_VM_SPECIFICATION_VERSION);
    }

    public static String getJavaVmSpecificationVendor() {
        return System.getProperty(JAVA_VM_SPECIFICATION_VENDOR);
    }

    public static String getJavaVmSpecificationName() {
        return System.getProperty(JAVA_VM_SPECIFICATION_NAME);
    }

    public static String getJavaVmVersion() {
        return System.getProperty(JAVA_VM_VERSION);
    }

    public static String getJavaVmVendor() {
        return System.getProperty(JAVA_VM_VENDOR);
    }

    public static String getJavaVmName() {
        return System.getProperty(JAVA_VM_NAME);
    }

    public static String getJavaSpecificationVersion() {
        return System.getProperty(JAVA_SPECIFICATION_VERSION);
    }

    public static String getJavaSpecificationVendor() {
        return System.getProperty(JAVA_SPECIFICATION_VENDOR);
    }

    public static String getJavaSpecificationName() {
        return System.getProperty(JAVA_SPECIFICATION_NAME);
    }

    public static String getJavaClassVersion() {
        return System.getProperty(JAVA_CLASS_VERSION);
    }

    public static String getJavaCompiler() {
        return System.getProperty(JAVA_COMPILER);
    }

    public static String getExtDirs() {
        return System.getProperty(JAVA_EXT_DIRS);
    }

    public static String getOsName() {
        return System.getProperty(OS_NAME);
    }

    public static String getOsArch() {
        return System.getProperty(OS_ARCH);
    }

    public static String getOsVersion() {
        return System.getProperty(OS_VERSION);
    }

    public static String getFileSeparator() {
        return System.getProperty(FILE_SEPARATOR);
    }

    public static String getPathSeparator() {
        return System.getProperty(PATH_SEPARATOR);
    }

    public static String getLineSeparator() {
        return System.getProperty(LINE_SEPARATOR);
    }

    public static String getUserName() {
        return System.getProperty(USER_NAME);
    }

    public static String getUserHome() {
        return System.getProperty(USER_HOME);
    }

    public static String getUserDir() {
        return System.getProperty(USER_DIR);
    }

    public static String getProperty(String key) {
        return System.getProperty(key);
    }

    public static String setJavaLibraryPath(String javaLibraryPath) {
        return System.setProperty(JAVA_LIBRARY_PATH, javaLibraryPath);
    }

    public static String setJavaClassPath(String javaclassPath) {
        return System.setProperty(JAVA_CLASS_PATH, javaclassPath);
    }

    public static String setJavaIoTmpdir(String javaIoTmpdir) {
        return System.setProperty(JAVA_IO_TEMDIR, javaIoTmpdir);
    }

    public static String setProperty(String key, String value) {
        return System.setProperty(key, value);
    }

    public static String addProperty(String key, String value) {
        String pv = SystemPropertyUtils.getProperty(key);
        if (Lang.isNotEmpty(pv)) {
            value = pv + SystemPropertyUtils.getPathSeparator() + value;
        }
        return System.setProperty(key, value);
    }

    public static boolean isWindows() {
        return SystemPropertyUtils.getOsName().startsWith("Windows");
    }

    public static boolean isLinux() {
        return SystemPropertyUtils.getOsName().startsWith("Linux");
    }
}

