/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.exception.UnsupportedException;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.number.Radix;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public final class NumberUtils {
    private static final char[] LETTERS62;
    private static final char[] LETTERS64;
    private static final char[] LETTERS93;
    private static final char[] LETTERS128;
    private static final int NUMBER_TEN = 10;
    private static final int NUMBER_THREETY_SIX = 36;
    private static final Map<Character, Integer> LETTERS128_DIGITS_MAP;

    private NumberUtils() {
    }

    public static <T extends Number> T convert(Number number, Class<T> targetClass) {
        return NumberUtils.value(number, targetClass);
    }

    public static <T extends Number> int compare(T number1, T number2) {
        if (number1 == null && number2 == null) {
            return 0;
        }
        if (number1 == null) {
            return 1;
        }
        if (number2 == null) {
            return -1;
        }
        if (number1 instanceof Byte) {
            return Byte.compare(number1.byteValue(), number2.byteValue());
        }
        if (number1 instanceof Short) {
            return Short.compare(number1.shortValue(), number2.shortValue());
        }
        if (number1 instanceof Integer) {
            return Integer.compare(number1.intValue(), number2.intValue());
        }
        if (number1 instanceof Long) {
            return Long.compare(number1.longValue(), number2.longValue());
        }
        if (number1 instanceof Float) {
            return Float.compare(number1.floatValue(), number2.floatValue());
        }
        if (number1 instanceof Double) {
            return Double.compare(number1.doubleValue(), number2.doubleValue());
        }
        if (number1 instanceof BigInteger) {
            return ((BigInteger)number1).compareTo((BigInteger)number2);
        }
        if (number1 instanceof BigDecimal) {
            return ((BigDecimal)number1).compareTo((BigDecimal)number2);
        }
        throw new UnsupportedException("unsupported for " + number1.getClass().getName());
    }

    public static <T extends Number> T value(Number number, Class<T> toType) {
        if (number == null) {
            return null;
        }
        Number value = null;
        if (toType == Integer.class || toType == Integer.TYPE) {
            value = number.intValue();
        } else if (toType == Long.class || toType == Long.TYPE) {
            value = number.longValue();
        } else if (toType == Double.class || toType == Double.TYPE) {
            value = number.doubleValue();
        } else if (toType == Float.class || toType == Float.TYPE) {
            value = Float.valueOf(number.floatValue());
        } else if (toType == BigInteger.class) {
            value = new BigInteger(number.toString());
        } else if (toType == BigDecimal.class) {
            value = new BigDecimal(number.toString());
        } else if (toType == Byte.class || toType == Byte.TYPE) {
            value = number.byteValue();
        } else if (toType == Short.class || toType == Short.TYPE) {
            value = number.shortValue();
        }
        if (value != null) {
            return (T)value;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u76ee\u6807\u7c7b\u578b\uff1a" + toType.getName());
    }

    public static <T extends Number> T parse(String source, Class<T> toType) {
        if (Lang.isEmpty(source)) {
            return null;
        }
        Number value = null;
        if (toType == Integer.class || toType == Integer.TYPE) {
            value = Integer.parseInt(source);
        } else if (toType == Long.class || toType == Long.TYPE) {
            value = Long.parseLong(source);
        } else if (toType == Double.class || toType == Double.TYPE) {
            value = Double.parseDouble(source);
        } else if (toType == Float.class || toType == Float.TYPE) {
            value = Float.valueOf(Float.parseFloat(source));
        } else if (toType == BigInteger.class) {
            value = new BigInteger(source);
        } else if (toType == BigDecimal.class) {
            value = new BigDecimal(source);
        } else if (toType == Byte.class || toType == Byte.TYPE) {
            value = Byte.parseByte(source);
        } else if (toType == Short.class || toType == Short.TYPE) {
            value = Short.parseShort(source);
        }
        if (value != null) {
            return (T)value;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u76ee\u6807\u7c7b\u578b\uff1a" + toType.getName());
    }

    public static Byte parse(String target, Byte defaultValue) {
        try {
            return Byte.parseByte(target);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Integer parse(String target, Integer defaultValue) {
        try {
            return Integer.parseInt(target);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Long parse(String target, Long defaultValue) {
        try {
            return Long.parseLong(target);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Double parse(String target, Double defaultValue) {
        try {
            return Double.parseDouble(target);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Float parse(String target, Float defaultValue) {
        try {
            return Float.valueOf(Float.parseFloat(target));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <N extends Number> String fillingAtStart(N number, int minLength, char sign) {
        AssertIllegalArgument.isNotNull(number, "N number");
        int requiredLength = minLength - number.toString().length();
        if (requiredLength > 0) {
            StringBuilder pattern = new StringBuilder("'");
            for (int i = 0; i < requiredLength; ++i) {
                pattern.append(sign);
            }
            pattern.append("'#");
            return new DecimalFormat(pattern.toString()).format(number);
        }
        return number.toString();
    }

    public static byte[] toByteArray(long longSource) {
        byte[] byteArray = new byte[8];
        int j = 7;
        int i = 0;
        while (i < 8) {
            byteArray[i] = (byte)(longSource >> 8 * j);
            ++i;
            --j;
        }
        return byteArray;
    }

    public static long toLong(byte ... bytes) {
        long iOutcome = 0L;
        int j = 7;
        long oxff = 255L;
        int i = 0;
        while (i < bytes.length) {
            byte bLoop = bytes[i];
            iOutcome += ((long)bLoop & oxff) << 8 * j;
            ++i;
            --j;
        }
        return iOutcome;
    }

    public static byte[] toByteArray(int intSource) {
        byte[] bLocalArr = new byte[4];
        for (int i = 0; i < 4 && i < 4; ++i) {
            bLocalArr[i] = (byte)(intSource >> 8 * i & 0xFF);
        }
        return bLocalArr;
    }

    public static int toInt(byte ... bytes) {
        int iOutcome = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte bLoop = bytes[i];
            iOutcome += (bLoop & 0xFF) << 8 * i;
        }
        return iOutcome;
    }

    public static byte[] toByteArray(short shortSource) {
        byte[] bLocalArr = new byte[2];
        for (int i = 0; i < 4 && i < 2; ++i) {
            bLocalArr[i] = (byte)(shortSource >> 8 * i & 0xFF);
        }
        return bLocalArr;
    }

    public static short toShort(byte ... bytes) {
        short iOutcome = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte bLoop = bytes[i];
            iOutcome = (short)(iOutcome + ((bLoop & 0xFF) << 8 * i));
        }
        return iOutcome;
    }

    public static String toString(byte number, Radix radix) {
        return NumberUtils.toString(BigInteger.valueOf(number), radix);
    }

    public static String toString(short number, Radix radix) {
        return NumberUtils.toString(BigInteger.valueOf(number), radix);
    }

    public static String toString(int number, Radix radix) {
        return NumberUtils.toString(BigInteger.valueOf(number), radix);
    }

    public static String toString(long number, Radix radix) {
        return NumberUtils.toString(BigInteger.valueOf(number), radix);
    }

    public static String toString(BigInteger number, Radix radix) {
        switch (radix) {
            case RADIX62: {
                return NumberUtils.toString62Unit(number);
            }
            case RADIX64: {
                return NumberUtils.toString64Unit(number);
            }
            case RADIX16: {
                String result = number.toString(radix.value());
                if (result.length() % 2 == 1) {
                    result = "0" + result;
                }
                return result;
            }
        }
        return number.toString(radix.value());
    }

    public static String toString62Unit(byte number) {
        return NumberUtils.toString62Unit((long)number);
    }

    public static String toString62Unit(short number) {
        return NumberUtils.toString62Unit((long)number);
    }

    public static String toString62Unit(int number) {
        return NumberUtils.toString62Unit((long)number);
    }

    public static String toString62Unit(long number) {
        boolean reverse = false;
        if (number < 0L) {
            reverse = true;
            number = 0L - number;
        } else if (number == 0L) {
            return "0";
        }
        StringBuilder buf = new StringBuilder();
        while (number != 0L) {
            buf.append(LETTERS62[(int)(number % (long)Radix.RADIX62.value())]);
            number /= (long)Radix.RADIX62.value();
        }
        if (reverse) {
            buf.append('-');
        }
        return buf.reverse().toString();
    }

    public static String toString62Unit(BigInteger number) {
        if (number.equals(BigInteger.ZERO)) {
            return "0";
        }
        boolean reverse = false;
        BigInteger abs = number.abs();
        boolean bl = reverse = !abs.equals(number);
        if (reverse) {
            number = abs;
        }
        StringBuilder buf = new StringBuilder();
        while (!number.equals(BigInteger.ZERO)) {
            buf.append(LETTERS62[number.mod(BigInteger.valueOf(Radix.RADIX62.value())).intValue()]);
            number = number.divide(BigInteger.valueOf(Radix.RADIX62.value()));
        }
        if (reverse) {
            buf.append('-');
        }
        return buf.reverse().toString();
    }

    public static String toString64Unit(byte number) {
        return NumberUtils.toString64Unit((long)number);
    }

    public static String toString64Unit(short number) {
        return NumberUtils.toString64Unit((long)number);
    }

    public static String toString64Unit(int number) {
        return NumberUtils.toString64Unit((long)number);
    }

    public static String toString64Unit(long number) {
        boolean reverse = false;
        if (number < 0L) {
            reverse = true;
            number = 0L - number;
        } else if (number == 0L) {
            return "0";
        }
        StringBuilder buf = new StringBuilder();
        while (number != 0L) {
            buf.append(LETTERS64[(int)(number % (long)Radix.RADIX64.value())]);
            number /= (long)Radix.RADIX64.value();
        }
        if (reverse) {
            buf.append('-');
        }
        return buf.reverse().toString();
    }

    public static String toString64Unit(BigInteger number) {
        if (number.equals(BigInteger.ZERO)) {
            return "0";
        }
        boolean reverse = false;
        BigInteger abs = number.abs();
        boolean bl = reverse = !abs.equals(number);
        if (reverse) {
            number = abs;
        }
        StringBuilder buf = new StringBuilder();
        while (!number.equals(BigInteger.ZERO)) {
            buf.append(LETTERS64[number.mod(BigInteger.valueOf(Radix.RADIX64.value())).intValue()]);
            number = number.divide(BigInteger.valueOf(Radix.RADIX64.value()));
        }
        if (reverse) {
            buf.append('-');
        }
        return buf.reverse().toString();
    }

    public static String toString93Unit(byte number) {
        return NumberUtils.toString93Unit((long)number);
    }

    public static String toString93Unit(short number) {
        return NumberUtils.toString93Unit((long)number);
    }

    public static String toString93Unit(int number) {
        return NumberUtils.toString93Unit((long)number);
    }

    public static String toString93Unit(long number) {
        boolean reverse = false;
        if (number < 0L) {
            reverse = true;
            number = 0L - number;
        } else if (number == 0L) {
            return "0";
        }
        StringBuilder buf = new StringBuilder();
        while (number != 0L) {
            buf.append(LETTERS93[(int)(number % (long)Radix.RADIX93.value())]);
            number /= (long)Radix.RADIX93.value();
        }
        if (reverse) {
            buf.append('-');
        }
        return buf.reverse().toString();
    }

    public static String toString93Unit(BigInteger number) {
        if (number.equals(BigInteger.ZERO)) {
            return "0";
        }
        boolean reverse = false;
        BigInteger abs = number.abs();
        boolean bl = reverse = !abs.equals(number);
        if (reverse) {
            number = abs;
        }
        StringBuilder buf = new StringBuilder();
        while (!number.equals(BigInteger.ZERO)) {
            buf.append(LETTERS93[number.mod(BigInteger.valueOf(Radix.RADIX93.value())).intValue()]);
            number = number.divide(BigInteger.valueOf(Radix.RADIX93.value()));
        }
        if (reverse) {
            buf.append('-');
        }
        return buf.reverse().toString();
    }

    public static String toString128Unit(byte number) {
        return NumberUtils.toString128Unit((long)number);
    }

    public static String toString128Unit(short number) {
        return NumberUtils.toString128Unit((long)number);
    }

    public static String toString128Unit(int number) {
        return NumberUtils.toString128Unit((long)number);
    }

    public static String toString128Unit(long number) {
        boolean reverse = false;
        if (number < 0L) {
            reverse = true;
            number = 0L - number;
        } else if (number == 0L) {
            return "0";
        }
        StringBuilder buf = new StringBuilder();
        while (number != 0L) {
            buf.append(LETTERS128[(int)(number % (long)Radix.RADIX128.value())]);
            number /= (long)Radix.RADIX128.value();
        }
        if (reverse) {
            buf.append('-');
        }
        return buf.reverse().toString();
    }

    public static String toString128Unit(BigInteger number) {
        if (number.equals(BigInteger.ZERO)) {
            return "0";
        }
        boolean reverse = false;
        BigInteger abs = number.abs();
        boolean bl = reverse = !abs.equals(number);
        if (reverse) {
            number = abs;
        }
        StringBuilder buf = new StringBuilder();
        while (!number.equals(BigInteger.ZERO)) {
            buf.append(LETTERS128[number.mod(BigInteger.valueOf(Radix.RADIX128.value())).intValue()]);
            number = number.divide(BigInteger.valueOf(Radix.RADIX128.value()));
        }
        if (reverse) {
            buf.append('-');
        }
        return buf.reverse().toString();
    }

    public static BigInteger parse(String numberStr, Radix radix) {
        switch (radix) {
            case RADIX62: {
                return NumberUtils.parse62Unit(numberStr);
            }
            case RADIX64: {
                return NumberUtils.parse64Unit(numberStr);
            }
            case RADIX93: {
                return NumberUtils.parse93Unit(numberStr);
            }
            case RADIX128: {
                return NumberUtils.parse128Unit(numberStr);
            }
        }
        return new BigInteger(numberStr, radix.value());
    }

    public static int parse62UnitToInt(String numberStr) {
        return NumberUtils.parse62Unit(numberStr).intValue();
    }

    public static long parse62UnitToLong(String numberStr) {
        boolean reverse = false;
        if (numberStr.charAt(0) == '-') {
            reverse = true;
            numberStr = numberStr.substring(1);
        }
        long result = 0L;
        long multiplier = 1L;
        for (int pos = numberStr.length() - 1; pos >= 0; --pos) {
            int index = NumberUtils.getIndex(numberStr, pos, Radix.RADIX62);
            result += (long)index * multiplier;
            multiplier *= (long)Radix.RADIX62.value();
        }
        if (reverse) {
            return 0L - result;
        }
        return result;
    }

    public static BigInteger parse62Unit(String numberStr) {
        boolean reverse = false;
        if (numberStr.charAt(0) == '-') {
            reverse = true;
            numberStr = numberStr.substring(1);
        }
        BigInteger result = BigInteger.ZERO;
        BigInteger multiplier = BigInteger.ONE;
        for (int pos = numberStr.length() - 1; pos >= 0; --pos) {
            int index = NumberUtils.getIndex(numberStr, pos, Radix.RADIX62);
            result = result.add(multiplier.multiply(BigInteger.valueOf(index)));
            multiplier = multiplier.multiply(BigInteger.valueOf(Radix.RADIX62.value()));
        }
        if (reverse) {
            return BigInteger.ZERO.subtract(result);
        }
        return result;
    }

    public static int parse64UnitToInt(String numberStr) {
        return NumberUtils.parse64Unit(numberStr).intValue();
    }

    public static long parse64UnitToLong(String numberStr) {
        boolean reverse = false;
        if (numberStr.charAt(0) == '-') {
            reverse = true;
            numberStr = numberStr.substring(1);
        }
        long result = 0L;
        long multiplier = 1L;
        for (int pos = numberStr.length() - 1; pos >= 0; --pos) {
            int index = NumberUtils.getIndex(numberStr, pos, Radix.RADIX64);
            result += (long)index * multiplier;
            multiplier *= (long)Radix.RADIX64.value();
        }
        if (reverse) {
            return 0L - result;
        }
        return result;
    }

    public static BigInteger parse64Unit(String numberStr) {
        boolean reverse = false;
        if (numberStr.charAt(0) == '-') {
            reverse = true;
            numberStr = numberStr.substring(1);
        }
        BigInteger result = BigInteger.ZERO;
        BigInteger multiplier = BigInteger.ONE;
        for (int pos = numberStr.length() - 1; pos >= 0; --pos) {
            int index = NumberUtils.getIndex(numberStr, pos, Radix.RADIX64);
            result = result.add(multiplier.multiply(BigInteger.valueOf(index)));
            multiplier = multiplier.multiply(BigInteger.valueOf(Radix.RADIX64.value()));
        }
        if (reverse) {
            return BigInteger.ZERO.subtract(result);
        }
        return result;
    }

    public static int parse93UnitToInt(String numberStr) {
        return NumberUtils.parse93Unit(numberStr).intValue();
    }

    public static long parse93UnitToLong(String numberStr) {
        boolean reverse = false;
        if (numberStr.charAt(0) == '-') {
            reverse = true;
            numberStr = numberStr.substring(1);
        }
        long result = 0L;
        long multiplier = 1L;
        for (int pos = numberStr.length() - 1; pos >= 0; --pos) {
            int index = NumberUtils.getIndex(numberStr, pos, Radix.RADIX93);
            result += (long)index * multiplier;
            multiplier *= (long)Radix.RADIX93.value();
        }
        if (reverse) {
            return 0L - result;
        }
        return result;
    }

    public static BigInteger parse93Unit(String numberStr) {
        boolean reverse = false;
        if (numberStr.charAt(0) == '-') {
            reverse = true;
            numberStr = numberStr.substring(1);
        }
        BigInteger result = BigInteger.ZERO;
        BigInteger multiplier = BigInteger.ONE;
        for (int pos = numberStr.length() - 1; pos >= 0; --pos) {
            int index = NumberUtils.getIndex(numberStr, pos, Radix.RADIX93);
            result = result.add(multiplier.multiply(BigInteger.valueOf(index)));
            multiplier = multiplier.multiply(BigInteger.valueOf(Radix.RADIX93.value()));
        }
        if (reverse) {
            return BigInteger.ZERO.subtract(result);
        }
        return result;
    }

    public static int parse128UnitToInt(String numberStr) {
        return NumberUtils.parse128Unit(numberStr).intValue();
    }

    public static long parse128UnitToLong(String numberStr) {
        return NumberUtils.parse128Unit(numberStr).longValue();
    }

    public static BigInteger parse128Unit(String numberStr) {
        boolean reverse = false;
        if (numberStr.charAt(0) == '-') {
            reverse = true;
            numberStr = numberStr.substring(1);
        }
        BigInteger result = BigInteger.ZERO;
        BigInteger multiplier = BigInteger.ONE;
        for (int pos = numberStr.length() - 1; pos >= 0; --pos) {
            int index = NumberUtils.getIndex(numberStr, pos, Radix.RADIX128);
            result = result.add(multiplier.multiply(BigInteger.valueOf(index)));
            multiplier = multiplier.multiply(BigInteger.valueOf(Radix.RADIX128.value()));
        }
        if (reverse) {
            return BigInteger.ZERO.subtract(result);
        }
        return result;
    }

    private static int getIndex(String s, int pos, Radix radix) {
        char c = s.charAt(pos);
        Integer value = LETTERS128_DIGITS_MAP.get(Character.valueOf(c));
        switch (radix) {
            case RADIX62: {
                if (value != null) break;
                throw new IllegalArgumentException("Unknow character for unit62 " + c);
            }
            case RADIX64: {
                if (value != null) break;
                throw new IllegalArgumentException("Unknow character for unit64 " + c);
            }
            case RADIX93: {
                if (value != null) break;
                throw new IllegalArgumentException("Unknow character for unit93 " + c);
            }
            case RADIX128: {
                if (value != null) break;
                throw new IllegalArgumentException("Unknow character for unit128 " + c);
            }
            default: {
                throw new IllegalArgumentException("not support for the radix -> " + (Object)((Object)radix));
            }
        }
        return value;
    }

    static {
        int i;
        int i2;
        LETTERS128_DIGITS_MAP = new HashMap<Character, Integer>();
        LETTERS62 = new char[Radix.RADIX62.value()];
        LETTERS64 = new char[Radix.RADIX64.value()];
        LETTERS93 = new char[Radix.RADIX93.value()];
        LETTERS128 = new char[Radix.RADIX128.value()];
        for (i2 = 0; i2 < 10; ++i2) {
            NumberUtils.LETTERS62[i2] = (char)(48 + i2);
            NumberUtils.LETTERS64[i2] = (char)(48 + i2);
            NumberUtils.LETTERS93[i2] = (char)(48 + i2);
        }
        for (i2 = 10; i2 < 36; ++i2) {
            NumberUtils.LETTERS62[i2] = (char)(97 + i2 - 10);
            NumberUtils.LETTERS64[i2] = (char)(97 + i2 - 10);
            NumberUtils.LETTERS93[i2] = (char)(97 + i2 - 10);
        }
        for (i2 = 36; i2 < Radix.RADIX62.value(); ++i2) {
            NumberUtils.LETTERS62[i2] = (char)(65 + i2 - 36);
            NumberUtils.LETTERS64[i2] = (char)(65 + i2 - 36);
            NumberUtils.LETTERS93[i2] = (char)(65 + i2 - 36);
        }
        int c63 = 95;
        int c64 = 126;
        NumberUtils.LETTERS64[Radix.RADIX62.value()] = c63;
        NumberUtils.LETTERS64[Radix.RADIX62.value() + 1] = c64;
        NumberUtils.LETTERS93[Radix.RADIX62.value()] = c63;
        NumberUtils.LETTERS93[Radix.RADIX62.value() + 1] = c64;
        int offset = 1;
        for (i = 33; i < 48; ++i) {
            if (i == 45) continue;
            NumberUtils.LETTERS93[Radix.RADIX62.value() + ++offset] = (char)i;
        }
        for (i = 58; i < 65; ++i) {
            NumberUtils.LETTERS93[Radix.RADIX62.value() + ++offset] = (char)i;
        }
        for (i = 91; i < 97; ++i) {
            if (i == c63) continue;
            NumberUtils.LETTERS93[Radix.RADIX62.value() + ++offset] = (char)i;
        }
        for (i = 123; i < 126; ++i) {
            NumberUtils.LETTERS93[Radix.RADIX62.value() + ++offset] = (char)i;
        }
        ArrayUtils.fillAll(LETTERS128, LETTERS93);
        ArrayUtils.fillAll(LETTERS128, Radix.RADIX93.value(), new char[]{'\u00a9', '\u00df', '\u00bf', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00b5', '\u00b6', '\u00c2', '\u00c4', '\u00c6', '\u00ca', '\u00cb', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d4', '\u00d6', '\u00db', '\u00dc', '\u00dd', '\u00e2', '\u00e4', '\u00e6', '\u00ea', '\u00eb', '\u00ee', '\u00f0', '\u00f1', '\u00fd', '\u00af', '\u00ae'});
        for (i = 0; i < LETTERS128.length; ++i) {
            LETTERS128_DIGITS_MAP.put(Character.valueOf(LETTERS128[i]), i);
        }
    }
}

