/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.bean;

import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.NoSuchPropertyException;
import cn.featherfly.common.bean.rule.CopyRule;
import cn.featherfly.common.bean.rule.CopyRuleAlwaysCopy;
import cn.featherfly.common.bean.rule.CopyRuleEnum;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.Lang;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanUtils.class);
    private static final CopyRule DEFAULT_RULE = new CopyRuleAlwaysCopy();

    private BeanUtils() {
    }

    public static <E> void setProperty(E bean, String name, Object value) {
        AssertIllegalArgument.isNotNull(bean, "E bean");
        AssertIllegalArgument.isNotEmpty(name, "String name");
        BeanDescriptor<E> beanDescriptor = BeanDescriptor.getBeanDescriptor(ClassUtils.castGenericType(bean.getClass(), bean));
        beanDescriptor.setProperty(bean, name, value);
    }

    public static <E> void addProperty(E bean, String name, Object value) {
        AssertIllegalArgument.isNotNull(bean, "E bean");
        AssertIllegalArgument.isNotEmpty(name, "String name");
        BeanDescriptor<E> beanDescriptor = BeanDescriptor.getBeanDescriptor(ClassUtils.castGenericType(bean.getClass(), bean));
        beanDescriptor.getChildBeanProperty(name);
        beanDescriptor.addProperty(bean, name, value);
    }

    public static <E> void setField(E bean, String name, Object value) {
        AssertIllegalArgument.isNotNull(bean, "E bean");
        AssertIllegalArgument.isNotEmpty(name, "String name");
        BeanDescriptor<E> beanDescriptor = BeanDescriptor.getBeanDescriptor(ClassUtils.castGenericType(bean.getClass(), bean));
        beanDescriptor.getBeanProperty(name).setValueForce(bean, value);
    }

    public static <E> Object getProperty(E bean, String name) {
        AssertIllegalArgument.isNotNull(bean, "E bean");
        AssertIllegalArgument.isNotEmpty(name, "String name");
        BeanDescriptor<E> beanDescriptor = BeanDescriptor.getBeanDescriptor(ClassUtils.castGenericType(bean.getClass(), bean));
        return beanDescriptor.getProperty(bean, name);
    }

    public static <E> Object getField(E bean, String name) {
        AssertIllegalArgument.isNotNull(bean, "E bean");
        AssertIllegalArgument.isNotEmpty(name, "String name");
        BeanDescriptor<E> beanDescriptor = BeanDescriptor.getBeanDescriptor(ClassUtils.castGenericType(bean.getClass(), bean));
        return beanDescriptor.getBeanProperty(name).getValueForce(bean);
    }

    public static <E> Map<String, Object> toMap(E bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (bean == null) {
            return map;
        }
        BeanDescriptor<E> beanDescriptor = BeanDescriptor.getBeanDescriptor(ClassUtils.castGenericType(bean.getClass(), bean));
        for (BeanProperty<?> beanProperty : beanDescriptor.getBeanProperties()) {
            if (!beanProperty.isReadable()) continue;
            map.put(beanProperty.getName(), beanProperty.getValue(bean));
        }
        return map;
    }

    public static <E> E fromMap(Map<String, Object> map, Class<E> type) {
        return BeanUtils.fromMap(map, type, true);
    }

    public static <E> E fromMap(Map<String, Object> map, Class<E> type, boolean ignoreNull) {
        AssertIllegalArgument.isNotNull(type, "Class<E> type");
        E e = BeanUtils.instantiateClass(type);
        BeanUtils.fillProperties(map, e, ignoreNull);
        return e;
    }

    public static <E> void fillProperties(Map<String, Object> map, E bean) {
        BeanUtils.fillProperties(map, bean, true);
    }

    public static <E> void fillProperties(Map<String, Object> map, E bean, boolean ignoreNull) {
        AssertIllegalArgument.isNotNull(bean, "Class<E> type");
        if (Lang.isEmpty(map)) {
            return;
        }
        BeanDescriptor<E> beanDescriptor = BeanDescriptor.getBeanDescriptor(ClassUtils.castGenericType(bean.getClass(), bean));
        for (BeanProperty<?> beanProperty : beanDescriptor.getBeanProperties()) {
            String name = beanProperty.getName();
            if (!beanProperty.isWritable() || !map.containsKey(name)) continue;
            Object value = map.get(name);
            if (ignoreNull && value == null) continue;
            beanProperty.setValue(bean, value);
        }
    }

    public static <E> void mergeProperties(E target, E from) {
        BeanUtils.mergeProperties(target, from, DEFAULT_RULE);
    }

    public static <E> void mergeProperties(E target, E from, CopyRuleEnum copyRuleEnum) {
        BeanUtils.mergeProperties(target, from, copyRuleEnum.getCopyRule());
    }

    public static <E> void mergeProperties(E target, E from, CopyRule rule) {
        if (target == null) {
            LOGGER.debug("\u76ee\u6807\u5bf9\u8c61target\u4e3a\u7a7a");
            return;
        }
        if (from == null) {
            LOGGER.debug("\u6765\u6e90\u5bf9\u8c61from\u4e3a\u7a7a");
            return;
        }
        BeanDescriptor<E> targetBeanDescriptor = BeanDescriptor.getBeanDescriptor(ClassUtils.castGenericType(target.getClass(), target));
        BeanDescriptor<E> fromBeanDescriptor = BeanDescriptor.getBeanDescriptor(ClassUtils.castGenericType(from.getClass(), from));
        for (BeanProperty<?> fromProperty : fromBeanDescriptor.getBeanProperties()) {
            String name = fromProperty.getName();
            BeanUtils.copyProperty(target, targetBeanDescriptor, from, fromProperty, name, rule);
        }
    }

    public static <E> void copyProperties(E target, E from) {
        BeanUtils.copyProperties(target, from, DEFAULT_RULE);
    }

    public static <E> void copyProperties(E target, E from, CopyRuleEnum copyRuleEnum) {
        BeanUtils.copyProperties(target, from, copyRuleEnum.getCopyRule());
    }

    public static <E> void copyProperties(E target, E from, CopyRule rule) {
        if (target == null) {
            LOGGER.debug("\u76ee\u6807\u5bf9\u8c61target\u4e3a\u7a7a");
            return;
        }
        if (from == null) {
            LOGGER.debug("\u6765\u6e90\u5bf9\u8c61from\u4e3a\u7a7a");
            return;
        }
        if (target.getClass() == from.getClass() || ClassUtils.isParent(from.getClass(), target.getClass())) {
            BeanDescriptor<E> targetBeanDescriptor = BeanDescriptor.getBeanDescriptor(ClassUtils.castGenericType(target.getClass(), target));
            BeanDescriptor<E> fromBeanDescriptor = BeanDescriptor.getBeanDescriptor(ClassUtils.castGenericType(from.getClass(), from));
            for (BeanProperty<?> beanProperty : fromBeanDescriptor.getBeanProperties()) {
                String name = beanProperty.getName();
                BeanUtils.copyProperty(target, targetBeanDescriptor, from, beanProperty, name, rule);
            }
            for (Field field : from.getClass().getFields()) {
                try {
                    ClassUtils.setFieldValue(target, field.getName(), ClassUtils.getFieldValue(from, field.getName()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else if (ClassUtils.isParent(target.getClass(), from.getClass())) {
            BeanDescriptor<E> targetBeanDescriptor = BeanDescriptor.getBeanDescriptor(ClassUtils.castGenericType(target.getClass(), target));
            for (BeanProperty<?> fromProperty : targetBeanDescriptor.getBeanProperties()) {
                String string = fromProperty.getName();
                BeanUtils.copyProperty(target, from, string, rule);
            }
            for (Field field : target.getClass().getFields()) {
                try {
                    ClassUtils.setFieldValue(target, field.getName(), ClassUtils.getFieldValue(from, field.getName()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            throw new IllegalArgumentException(String.format("\u76ee\u6807\u5bf9\u8c61\u548c\u6e90\u5bf9\u8c61\u4e0d\u662f\u76f8\u540c\u7c7b\u578b\u4e5f\u4e0d\u662f\u7ee7\u627f\u5173\u7cfbtarget[%s]\uff0cfrom[%s]", target.getClass().getName(), from.getClass().getName()));
        }
    }

    public static <E> void copyProperty(E target, E from, String name) {
        BeanUtils.copyProperty(target, from, name, DEFAULT_RULE);
    }

    public static <E> void copyProperty(E target, E from, String name, CopyRuleEnum copyRuleEnum) {
        BeanUtils.copyProperty(target, from, name, copyRuleEnum.getCopyRule());
    }

    public static <E> void copyProperty(E target, E from, String name, CopyRule rule) {
        BeanDescriptor<?> targetBeanDescriptor = BeanDescriptor.getBeanDescriptor(target.getClass());
        BeanDescriptor<?> fromBeanDescriptor = BeanDescriptor.getBeanDescriptor(from.getClass());
        BeanProperty fromProperty = fromBeanDescriptor.getBeanProperty(name);
        BeanUtils.copyProperty(target, targetBeanDescriptor, from, fromProperty, name, rule);
    }

    private static <E> void copyProperty(E target, BeanDescriptor<?> targetBeanDescriptor, E from, BeanProperty<?> fromProperty, String name, CopyRule rule) {
        try {
            BeanProperty targetProperty = targetBeanDescriptor.getBeanProperty(name);
            BeanUtils.copyProperty(target, targetProperty, from, fromProperty, name, rule);
        }
        catch (NoSuchPropertyException e) {
            LOGGER.debug("\u7c7b{}\u6ca1\u6709\u5c5e\u6027{}", new Object[]{target.getClass().getName(), name});
            return;
        }
    }

    private static <E> void copyProperty(E target, BeanProperty<?> targetProperty, E from, BeanProperty<?> fromProperty, String name, CopyRule rule) {
        if (!fromProperty.isReadable()) {
            LOGGER.debug("\u7c7b{}\u7684\u5c5e\u6027{}\u4e0d\u53ef\u8bfb", new Object[]{from.getClass().getName(), fromProperty.getName()});
        } else if (!targetProperty.isWritable()) {
            LOGGER.debug("\u7c7b{}\u7684\u5c5e\u6027{}\u4e0d\u53ef\u5199", new Object[]{target.getClass().getName(), targetProperty.getName()});
        } else {
            Object value = fromProperty.getValue(from);
            if (rule.isCopyEnabled(target, from, name, value)) {
                targetProperty.setValue(target, value);
            }
        }
    }

    public static <T> T instantiateClass(Class<T> clazz) {
        return ClassUtils.newInstance(clazz);
    }

    public static <T> T instantiateClass(Class<T> clazz, Object ... args) {
        return ClassUtils.newInstance(clazz, args);
    }

    public static <T> T instantiateClass(Constructor<T> ctor, Object[] args) {
        return ClassUtils.newInstance(ctor, args);
    }

    public static <E> String toString(E object) {
        if (object == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(object.getClass().getSimpleName()).append("[\n");
        BeanDescriptor<E> beanDescriptor = BeanDescriptor.getBeanDescriptor(ClassUtils.castGenericType(object.getClass(), object));
        beanDescriptor.getBeanProperties().forEach(bp -> builder.append("  ").append(bp.getName()).append(" = ").append(bp.getValueForce(object)).append("\n"));
        builder.append("]");
        return builder.toString();
    }
}

