/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.attributes;

import com.google.gson.JsonObject;
import hex.genmodel.attributes.ModelJsonReader;
import hex.genmodel.attributes.Table;
import hex.genmodel.attributes.parameters.KeyValue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public class VariableImportances
implements Serializable {
    public final String[] _variables;
    public final double[] _importances;

    public VariableImportances(String[] variableNames, double[] relativeImportances) {
        this._variables = variableNames;
        this._importances = relativeImportances;
    }

    protected static VariableImportances extractFromJson(JsonObject modelJson) {
        Table table = ModelJsonReader.readTable(modelJson, "output.variable_importances");
        if (table == null) {
            return null;
        }
        double[] relativeVarimps = new double[table.rows()];
        String[] varNames = new String[table.rows()];
        int varImportanceCol = table.findColumnIndex("Relative Importance");
        int varNameCol = table.findColumnIndex("Variable");
        if (varImportanceCol == -1) {
            return null;
        }
        if (varNameCol == -1) {
            return null;
        }
        for (int i = 0; i < table.rows(); ++i) {
            relativeVarimps[i] = (Double)table.getCell(varImportanceCol, i);
            varNames[i] = (String)table.getCell(varNameCol, i);
        }
        return new VariableImportances(varNames, relativeVarimps);
    }

    public KeyValue[] topN(int n) {
        if (n <= 0 || n > this._importances.length) {
            n = this._importances.length;
        }
        KeyValue[] sortedImportances = new KeyValue[this._importances.length];
        for (int i = 0; i < this._importances.length; ++i) {
            sortedImportances[i] = new KeyValue(this._variables[i], this._importances[i]);
        }
        Arrays.sort(sortedImportances, new Comparator<KeyValue>(){

            @Override
            public int compare(KeyValue o1, KeyValue o2) {
                return o1.getValue() > o2.getValue() ? -1 : 0;
            }
        });
        return Arrays.copyOfRange(sortedImportances, 0, n);
    }

    public int numberOfUsedVariables() {
        int numberOfUsedVariables = 0;
        for (double importance : this._importances) {
            if (importance == 0.0) continue;
            ++numberOfUsedVariables;
        }
        return numberOfUsedVariables;
    }
}

