/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.ModelCategory;
import hex.genmodel.AbstractMojoWriter;
import hex.genmodel.MojoModel;
import hex.genmodel.descriptor.ModelDescriptor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class MojoPipelineWriter
extends AbstractMojoWriter {
    private Map<String, MojoModel> _models;
    private Map<String, String> _inputMapping;
    private String _mainModelAlias;

    MojoPipelineWriter(Map<String, MojoModel> models, Map<String, String> inputMapping, String mainModelAlias) {
        super(MojoPipelineWriter.makePipelineDescriptor(models, inputMapping, mainModelAlias));
        this._models = models;
        this._inputMapping = inputMapping;
        this._mainModelAlias = mainModelAlias;
    }

    @Override
    public String mojoVersion() {
        return "1.00";
    }

    @Override
    protected void writeModelData() throws IOException {
        this.writekv("submodel_count", this._models.size());
        int modelNum = 0;
        for (Map.Entry<String, MojoModel> model : this._models.entrySet()) {
            this.writekv("submodel_key_" + modelNum, model.getKey());
            this.writekv("submodel_dir_" + modelNum, "models/" + model.getKey() + "/");
            ++modelNum;
        }
        this.writekv("generated_column_count", this._inputMapping.size());
        int generatedColumnNum = 0;
        for (Map.Entry<String, String> mapping : this._inputMapping.entrySet()) {
            String inputSpec = mapping.getValue();
            String[] inputSpecArr = inputSpec.split(":", 2);
            this.writekv("generated_column_name_" + generatedColumnNum, mapping.getKey());
            this.writekv("generated_column_model_" + generatedColumnNum, inputSpecArr[0]);
            this.writekv("generated_column_index_" + generatedColumnNum, Integer.valueOf(inputSpecArr[1]));
            ++generatedColumnNum;
        }
        this.writekv("main_model", this._mainModelAlias);
    }

    private static MojoPipelineDescriptor makePipelineDescriptor(Map<String, MojoModel> models, Map<String, String> inputMapping, String mainModelAlias) {
        MojoModel finalModel = models.get(mainModelAlias);
        if (finalModel == null) {
            throw new IllegalArgumentException("Main model is missing. There is no model with alias '" + mainModelAlias + "'.");
        }
        LinkedHashMap<String, String[]> schema = MojoPipelineWriter.deriveInputSchema(models, inputMapping, finalModel);
        return new MojoPipelineDescriptor(schema, finalModel);
    }

    private static LinkedHashMap<String, String[]> deriveInputSchema(Map<String, MojoModel> allModels, Map<String, String> inputMapping, MojoModel finalModel) {
        LinkedHashMap<String, String[]> schema = new LinkedHashMap<String, String[]>();
        for (MojoModel model : allModels.values()) {
            if (model == finalModel) continue;
            for (int i = 0; i < model.nfeatures(); ++i) {
                String fName = model._names[i];
                if (schema.containsKey(fName)) {
                    Object[] domain = schema.get(fName);
                    if (Arrays.equals(domain, model._domains[i])) continue;
                    throw new IllegalStateException("Domains of column '" + fName + "' differ.");
                }
                schema.put(fName, model._domains[i]);
            }
        }
        for (int i = 0; i < finalModel._names.length; ++i) {
            String fName = finalModel._names[i];
            if (inputMapping.containsKey(fName)) continue;
            schema.put(fName, finalModel._domains[i]);
        }
        return schema;
    }

    private static class MojoPipelineDescriptor
    implements ModelDescriptor {
        private final MojoModel _finalModel;
        private final String[] _names;
        private final String[][] _domains;

        private MojoPipelineDescriptor(LinkedHashMap<String, String[]> schema, MojoModel finalModel) {
            this._finalModel = finalModel;
            this._names = new String[schema.size()];
            this._domains = new String[schema.size()][];
            int i = 0;
            for (Map.Entry<String, String[]> field : schema.entrySet()) {
                this._names[i] = field.getKey();
                this._domains[i] = field.getValue();
                ++i;
            }
        }

        @Override
        public String[][] scoringDomains() {
            return this._domains;
        }

        @Override
        public String projectVersion() {
            return this._finalModel._h2oVersion;
        }

        @Override
        public String algoName() {
            return "pipeline";
        }

        @Override
        public String algoFullName() {
            return "MOJO Pipeline";
        }

        @Override
        public String offsetColumn() {
            return this._finalModel._offsetColumn;
        }

        @Override
        public String weightsColumn() {
            return null;
        }

        @Override
        public String foldColumn() {
            return null;
        }

        @Override
        public String treatmentColumn() {
            return null;
        }

        @Override
        public ModelCategory getModelCategory() {
            return this._finalModel._category;
        }

        @Override
        public boolean isSupervised() {
            return this._finalModel.isSupervised();
        }

        @Override
        public int nfeatures() {
            return this.isSupervised() ? this.columnNames().length - 1 : this.columnNames().length;
        }

        @Override
        public String[] features() {
            return Arrays.copyOf(this.columnNames(), this.nfeatures());
        }

        @Override
        public int nclasses() {
            return this._finalModel.nclasses();
        }

        @Override
        public String[] columnNames() {
            return this._names;
        }

        @Override
        public boolean balanceClasses() {
            return this._finalModel._balanceClasses;
        }

        @Override
        public double defaultThreshold() {
            return this._finalModel._defaultThreshold;
        }

        @Override
        public double[] priorClassDist() {
            return this._finalModel._priorClassDistrib;
        }

        @Override
        public double[] modelClassDist() {
            return this._finalModel._modelClassDistrib;
        }

        @Override
        public String uuid() {
            return this._finalModel._uuid;
        }

        @Override
        public String timestamp() {
            return String.valueOf(new Date().getTime());
        }

        @Override
        public String[] getOrigNames() {
            return null;
        }

        @Override
        public String[][] getOrigDomains() {
            return null;
        }
    }
}

