/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.fasttext;

import ai.djl.Device;
import ai.djl.MalformedModelException;
import ai.djl.Model;
import ai.djl.fasttext.FtAbstractBlock;
import ai.djl.fasttext.jni.FtWrapper;
import ai.djl.fasttext.zoo.nlp.textclassification.FtTextClassification;
import ai.djl.fasttext.zoo.nlp.word_embedding.FtWordEmbeddingBlock;
import ai.djl.inference.Predictor;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.nn.Block;
import ai.djl.training.Trainer;
import ai.djl.training.TrainingConfig;
import ai.djl.translate.Translator;
import ai.djl.util.PairList;
import ai.djl.util.Utils;
import ai.djl.util.passthrough.PassthroughNDManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class FtModel
implements Model {
    FtAbstractBlock block;
    private Path modelDir;
    private String modelName;
    private Map<String, String> properties;

    public FtModel(String name) {
        this.modelName = name;
        this.properties = new ConcurrentHashMap<String, String>();
    }

    public void load(Path modelPath, String prefix, Map<String, ?> options) throws IOException, MalformedModelException {
        if (Files.notExists(modelPath, new LinkOption[0])) {
            throw new FileNotFoundException("Model directory doesn't exist: " + modelPath.toAbsolutePath());
        }
        this.modelDir = modelPath.toAbsolutePath();
        Path modelFile = this.findModelFile(prefix);
        if (modelFile == null && (modelFile = this.findModelFile(this.modelDir.toFile().getName())) == null) {
            throw new FileNotFoundException("No .ftz or .bin file found in : " + modelPath);
        }
        String modelFilePath = modelFile.toString();
        FtWrapper fta = FtWrapper.newInstance();
        if (!fta.checkModel(modelFilePath)) {
            throw new MalformedModelException("Malformed FastText model file:" + modelFilePath);
        }
        fta.loadModel(modelFilePath);
        if (options != null) {
            for (Map.Entry<String, ?> entry : options.entrySet()) {
                this.properties.put(entry.getKey(), entry.getValue().toString());
            }
        }
        String modelType = fta.getModelType();
        this.properties.put("model-type", modelType);
        if ("sup".equals(modelType)) {
            String labelPrefix = this.properties.getOrDefault("label-prefix", "__label__");
            this.block = new FtTextClassification(fta, labelPrefix);
            this.modelDir = this.block.getModelFile();
        } else if ("cbow".equals(modelType) || "sg".equals(modelType)) {
            this.block = new FtWordEmbeddingBlock(fta);
            this.modelDir = this.block.getModelFile();
        } else {
            throw new MalformedModelException("Unexpected FastText model type: " + modelType);
        }
    }

    public void load(InputStream modelStream, Map<String, ?> options) {
        throw new UnsupportedOperationException("Not supported.");
    }

    private Path findModelFile(String prefix) {
        Path modelFile;
        if (Files.isRegularFile(this.modelDir, new LinkOption[0])) {
            Path file = this.modelDir;
            this.modelDir = this.modelDir.getParent();
            String fileName = file.toFile().getName();
            this.modelName = fileName.endsWith(".ftz") || fileName.endsWith(".bin") ? fileName.substring(0, fileName.length() - 4) : fileName;
            return file;
        }
        if (prefix == null) {
            prefix = this.modelName;
        }
        if (Files.notExists(modelFile = this.modelDir.resolve(prefix), new LinkOption[0]) || !Files.isRegularFile(modelFile, new LinkOption[0])) {
            if (prefix.endsWith(".ftz") || prefix.endsWith(".bin")) {
                return null;
            }
            modelFile = this.modelDir.resolve(prefix + ".ftz");
            if (!(!Files.notExists(modelFile, new LinkOption[0]) && Files.isRegularFile(modelFile, new LinkOption[0]) || !Files.notExists(modelFile = this.modelDir.resolve(prefix + ".bin"), new LinkOption[0]) && Files.isRegularFile(modelFile, new LinkOption[0]))) {
                return null;
            }
        }
        return modelFile;
    }

    public void save(Path modelDir, String newModelName) {
    }

    public Path getModelPath() {
        return this.modelDir;
    }

    public FtAbstractBlock getBlock() {
        return this.block;
    }

    public void setBlock(Block block) {
        if (!(block instanceof FtAbstractBlock)) {
            throw new IllegalArgumentException("Expected a FtAbstractBlock Block");
        }
        this.block = (FtAbstractBlock)block;
    }

    public String getName() {
        return this.modelName;
    }

    public Trainer newTrainer(TrainingConfig trainingConfig) {
        throw new UnsupportedOperationException("FastText only supports training using the FtAbstractBlocks");
    }

    public <I, O> Predictor<I, O> newPredictor(Translator<I, O> translator, Device device) {
        return new Predictor((Model)this, translator, device, false);
    }

    public void setDataType(DataType dataType) {
    }

    public DataType getDataType() {
        return DataType.UNKNOWN;
    }

    public PairList<String, Shape> describeInput() {
        return null;
    }

    public PairList<String, Shape> describeOutput() {
        return null;
    }

    public String[] getArtifactNames() {
        return Utils.EMPTY_ARRAY;
    }

    public <T> T getArtifact(String name, Function<InputStream, T> function) {
        return null;
    }

    public URL getArtifact(String artifactName) {
        return null;
    }

    public InputStream getArtifactAsStream(String name) {
        return null;
    }

    public NDManager getNDManager() {
        return PassthroughNDManager.INSTANCE;
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void close() {
        this.block.close();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("Model (\n\tName: ").append(this.modelName);
        if (this.modelDir != null) {
            sb.append("\n\tModel location: ").append(this.modelDir.toAbsolutePath());
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            sb.append("\n\t").append(entry.getKey()).append(": ").append(entry.getValue());
        }
        sb.append("\n)");
        return sb.toString();
    }
}

