/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.jni;

import ai.djl.util.Platform;
import ai.djl.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LibUtils {
    private static final Logger logger = LoggerFactory.getLogger(LibUtils.class);
    private static final String LIB_NAME = "djl_torch";
    private static final String NATIVE_LIB_NAME = "torch";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+(-\\w)?)(-SNAPSHOT)?(-\\d+)?");

    private LibUtils() {
    }

    public static void loadLibrary() {
        if (System.getProperty("java.vendor.url").equals("http://www.android.com/")) {
            System.loadLibrary(LIB_NAME);
            return;
        }
        String libName = LibUtils.findOverrideLibrary();
        if (libName == null) {
            AtomicBoolean fallback = new AtomicBoolean(false);
            String nativeLibDir = LibUtils.findNativeLibrary(fallback);
            if (nativeLibDir != null) {
                libName = LibUtils.copyJniLibraryFromClasspath(Paths.get(nativeLibDir, new String[0]), fallback.get());
            } else {
                throw new IllegalStateException("Native library not found");
            }
        }
        logger.debug("Loading pytorch library from: {}", (Object)libName);
        if (System.getProperty("os.name").startsWith("Win")) {
            LibUtils.loadWinDependencies(libName);
        }
        System.load(libName);
    }

    private static void loadWinDependencies(String libName) {
        Path libDir = Paths.get(libName, new String[0]).getParent();
        if (libDir == null) {
            throw new IllegalArgumentException("Invalid library path!");
        }
        try (Stream<Path> paths = Files.walk(libDir, new FileVisitOption[0]);){
            paths.filter(path -> {
                String name = path.getFileName().toString();
                return !"c10_cuda.dll".equals(name) && !"torch.dll".equals(name) && !"torch_cpu.dll".equals(name) && !"torch_cuda.dll".equals(name) && !"fbgemm.dll".equals(name) && Files.isRegularFile(path, new LinkOption[0]) && !name.endsWith("djl_torch.dll");
            }).map(path -> path.toAbsolutePath().toString()).forEach(System::load);
            System.load(libDir.resolve("fbgemm.dll").toAbsolutePath().toString());
            System.load(libDir.resolve("torch_cpu.dll").toAbsolutePath().toString());
            if (Files.exists(libDir.resolve("c10_cuda.dll"), new LinkOption[0])) {
                System.load(libDir.resolve("c10_cuda.dll").toAbsolutePath().toString());
                System.load(libDir.resolve("torch_cuda.dll").toAbsolutePath().toString());
            }
            System.load(libDir.resolve("torch.dll").toAbsolutePath().toString());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Folder not exist! " + libDir, e);
        }
    }

    private static String findOverrideLibrary() {
        String libName;
        String libPath = System.getenv("PYTORCH_LIBRARY_PATH");
        if (libPath != null && (libName = LibUtils.findLibraryInPath(libPath)) != null) {
            return libName;
        }
        libPath = System.getProperty("java.library.path");
        if (libPath != null) {
            return LibUtils.findLibraryInPath(libPath);
        }
        return null;
    }

    private static String findLibraryInPath(String libPath) {
        String[] paths = libPath.split(File.pathSeparator);
        List<String> mappedLibNames = Collections.singletonList(System.mapLibraryName(LIB_NAME));
        for (String path : paths) {
            File p = new File(path);
            if (!p.exists()) continue;
            for (String name : mappedLibNames) {
                if (p.isFile() && p.getName().endsWith(name)) {
                    return p.getAbsolutePath();
                }
                File file = new File(path, name);
                if (!file.exists() || !file.isFile()) continue;
                return file.getAbsolutePath();
            }
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private static String copyJniLibraryFromClasspath(Path nativeDir, boolean fallback) {
        String string;
        InputStream stream;
        Path tmp;
        block23: {
            block22: {
                String name = System.mapLibraryName(LIB_NAME);
                Platform platform = Platform.fromSystem();
                String classifier = platform.getClassifier();
                String flavor = platform.getFlavor();
                if (fallback || flavor.isEmpty()) {
                    flavor = "cpu";
                }
                Properties prop = new Properties();
                try (InputStream stream2 = LibUtils.class.getResourceAsStream("/jnilib/" + classifier + "/" + flavor + "/pytorch.properties");){
                    prop.load(stream2);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot find pytorch property file", e);
                }
                String version = prop.getProperty("version");
                Path path = nativeDir.resolve(version + flavor + name);
                if (Files.exists(path, new LinkOption[0])) {
                    return path.toAbsolutePath().toString();
                }
                tmp = null;
                stream = LibUtils.class.getResourceAsStream("/jnilib/" + classifier + "/" + flavor + "/" + name);
                tmp = Files.createTempFile(nativeDir, "jni", "tmp", new FileAttribute[0]);
                Files.copy(stream, tmp, StandardCopyOption.REPLACE_EXISTING);
                Utils.moveQuietly((Path)tmp, (Path)path);
                string = path.toAbsolutePath().toString();
                if (stream == null) break block22;
                stream.close();
            }
            if (tmp == null) break block23;
            Utils.deleteQuietly((Path)tmp);
        }
        return string;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot copy jni files", e);
                    }
                }
                catch (Throwable throwable3) {
                    if (tmp != null) {
                        Utils.deleteQuietly(tmp);
                    }
                    throw throwable3;
                }
            }
        }
    }

    private static synchronized String findNativeLibrary(AtomicBoolean fallback) {
        Enumeration<URL> urls;
        try {
            urls = Thread.currentThread().getContextClassLoader().getResources("native/lib/pytorch.properties");
        }
        catch (IOException e) {
            logger.warn("", (Throwable)e);
            return null;
        }
        if (!urls.hasMoreElements()) {
            return null;
        }
        Platform systemPlatform = Platform.fromSystem();
        try {
            Platform matching = null;
            Platform placeholder = null;
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                Platform platform = Platform.fromUrl((URL)url);
                if (platform.isPlaceholder()) {
                    placeholder = platform;
                    continue;
                }
                if (!platform.matches(systemPlatform)) continue;
                matching = platform;
                break;
            }
            if (matching != null) {
                return LibUtils.copyNativeLibraryFromClasspath(matching);
            }
            if (placeholder != null) {
                try {
                    return LibUtils.downloadPyTorch(placeholder, fallback);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to download PyTorch native library", e);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read PyTorch native library jar properties", e);
        }
        throw new IllegalStateException("Your PyTorch native library jar does not match your operating system. Make sure the Maven Dependency Classifier matches your system type.");
    }

    private static String copyNativeLibraryFromClasspath(Platform platform) {
        String string;
        block15: {
            Path tmp = null;
            String version = platform.getVersion();
            String flavor = platform.getFlavor();
            String classifier = platform.getClassifier();
            try {
                String libName = System.mapLibraryName(NATIVE_LIB_NAME);
                Path cacheDir = LibUtils.getCacheDir();
                logger.debug("Using cache dir: {}", (Object)cacheDir);
                Path dir = cacheDir.resolve(version + flavor + '-' + classifier);
                Path path = dir.resolve(libName);
                if (Files.exists(path, new LinkOption[0])) {
                    String string2 = dir.toAbsolutePath().toString();
                    return string2;
                }
                Files.createDirectories(cacheDir, new FileAttribute[0]);
                tmp = Files.createTempDirectory(cacheDir, "tmp", new FileAttribute[0]);
                for (String file : platform.getLibraries()) {
                    String libPath = "/native/lib/" + file;
                    try (InputStream is = LibUtils.class.getResourceAsStream(libPath);){
                        Files.copy(is, tmp.resolve(file), StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                Utils.moveQuietly((Path)tmp, (Path)dir);
                string = dir.toAbsolutePath().toString();
                if (tmp == null) break block15;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to extract PyTorch native library", e);
            }
            finally {
                if (tmp != null) {
                    Utils.deleteQuietly(tmp);
                }
            }
            Utils.deleteQuietly((Path)tmp);
        }
        return string;
    }

    /*
     * Exception decompiling
     */
    private static String downloadPyTorch(Platform platform, AtomicBoolean fallback) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Path getCacheDir() {
        String cacheDir = System.getProperty("ENGINE_CACHE_DIR");
        if ((cacheDir == null || cacheDir.isEmpty()) && ((cacheDir = System.getenv("ENGINE_CACHE_DIR")) == null || cacheDir.isEmpty())) {
            cacheDir = System.getProperty("DJL_CACHE_DIR");
            if ((cacheDir == null || cacheDir.isEmpty()) && ((cacheDir = System.getenv("DJL_CACHE_DIR")) == null || cacheDir.isEmpty())) {
                String userHome = System.getProperty("user.home");
                return Paths.get(userHome, ".pytorch/cache");
            }
            return Paths.get(cacheDir, "pytorch");
        }
        return Paths.get(cacheDir, ".pytorch/cache");
    }
}

