/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.pytorch.engine;

import ai.djl.Device;
import ai.djl.engine.Engine;
import ai.djl.ndarray.BaseNDManager;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.ndarray.types.SparseFormat;
import ai.djl.pytorch.engine.PtNDArray;
import ai.djl.pytorch.jni.JniUtils;
import ai.djl.pytorch.jni.Pointer;
import ai.djl.util.PairList;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.file.Path;

public class PtNDManager
extends BaseNDManager {
    private static final PtNDManager SYSTEM_MANAGER = new SystemManager();

    private PtNDManager(NDManager parent, Device device) {
        super(parent, device);
    }

    static PtNDManager getSystemManager() {
        return SYSTEM_MANAGER;
    }

    public ByteBuffer allocateDirect(int capacity) {
        return ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
    }

    public synchronized void attach(String resourceId, AutoCloseable resource) {
        if (!Boolean.getBoolean("ai.djl.pytorch.disable_close_resource_on_finalize")) {
            super.attach(resourceId, resource);
            return;
        }
        if (this.closed.get()) {
            throw new IllegalStateException("NDManager has been closed already.");
        }
        HardReference ref = new HardReference(resource);
        this.resources.put(resourceId, ref);
    }

    public PtNDArray create(Pointer handle) {
        PtNDArray array = new PtNDArray(this, handle);
        this.attach(array.getUid(), array);
        return array;
    }

    public PtNDArray create(Shape shape, DataType dataType, Device device) {
        return JniUtils.createEmptyNdArray(this, shape, dataType, device, SparseFormat.DENSE);
    }

    public PtNDArray create(Buffer data, Shape shape, DataType dataType) {
        int size = data.remaining();
        DataType inputType = DataType.fromBuffer((Buffer)data);
        int numOfBytes = inputType.getNumOfBytes();
        ByteBuffer buf = this.allocateDirect(size * numOfBytes);
        switch (inputType) {
            case FLOAT32: {
                buf.asFloatBuffer().put((FloatBuffer)data);
                break;
            }
            case FLOAT64: {
                buf.asDoubleBuffer().put((DoubleBuffer)data);
                break;
            }
            case UINT8: 
            case INT8: 
            case BOOLEAN: {
                buf.put((ByteBuffer)data);
                break;
            }
            case INT32: {
                buf.asIntBuffer().put((IntBuffer)data);
                break;
            }
            case INT64: {
                buf.asLongBuffer().put((LongBuffer)data);
                break;
            }
            default: {
                throw new AssertionError((Object)"Show never happen");
            }
        }
        return JniUtils.createNdFromByteBuffer(this, buf, shape, dataType, SparseFormat.DENSE, this.device);
    }

    public NDArray createCSR(Buffer data, long[] indptr, long[] indices, Shape shape, Device device) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray createRowSparse(Buffer data, Shape dataShape, long[] indices, Shape shape, Device device) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList load(Path path, Device device) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray zeros(Shape shape, DataType dataType, Device device) {
        return JniUtils.createZerosNdArray(this, shape, dataType, device, SparseFormat.DENSE);
    }

    public NDArray ones(Shape shape, DataType dataType, Device device) {
        return JniUtils.createOnesNdArray(this, shape, dataType, device, SparseFormat.DENSE);
    }

    public NDArray arange(int start, int stop, int step, DataType dataType, Device device) {
        return this.arange((float)start, (float)stop, (float)step, dataType, device);
    }

    public NDArray arange(float start, float stop, float step, DataType dataType, Device device) {
        if (Math.signum(stop - start) != Math.signum(step)) {
            return this.create(new Shape(new long[]{0L}), dataType, device);
        }
        return JniUtils.arange(this, start, stop, step, dataType, device, SparseFormat.DENSE);
    }

    public NDArray eye(int rows, int cols, int k, DataType dataType, Device device) {
        if (k != 0) {
            throw new UnsupportedOperationException("index of the diagonal is not supported in PyTorch");
        }
        return JniUtils.eye(this, rows, cols, dataType, device, SparseFormat.DENSE);
    }

    public NDArray linspace(float start, float stop, int num, boolean endpoint, Device device) {
        if (!endpoint) {
            throw new UnsupportedOperationException("endpoint only support true");
        }
        return JniUtils.linspace(this, start, stop, num, DataType.FLOAT32, device, SparseFormat.DENSE);
    }

    public NDArray randomUniform(float low, float high, Shape shape, DataType dataType, Device device) {
        return JniUtils.uniform(this, low, high, shape, dataType, device);
    }

    public NDArray randomNormal(float loc, float scale, Shape shape, DataType dataType, Device device) {
        return JniUtils.normal(this, loc, scale, shape, dataType, device);
    }

    public NDArray randomMultinomial(int n, NDArray pValues) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDArray randomMultinomial(int n, NDArray pValues, Shape shape) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public PtNDManager newSubManager() {
        return this.newSubManager(this.device);
    }

    public PtNDManager newSubManager(Device device) {
        PtNDManager manager = new PtNDManager((NDManager)this, device);
        this.attach(manager.uid, (AutoCloseable)((Object)manager));
        return manager;
    }

    public void invoke(String operation, NDArray[] src, NDArray[] dest, PairList<String, ?> params) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public NDList invoke(String operation, NDList src, PairList<String, ?> params) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Engine getEngine() {
        return Engine.getEngine((String)"PyTorch");
    }

    private static final class HardReference
    extends WeakReference<AutoCloseable> {
        private AutoCloseable obj;

        HardReference(AutoCloseable obj) {
            super(obj);
            this.obj = obj;
        }

        private AutoCloseable getReference() {
            return this.obj;
        }
    }

    private static final class SystemManager
    extends PtNDManager {
        SystemManager() {
            super(null, Device.defaultDevice());
        }

        @Override
        public void attach(String resourceId, AutoCloseable resource) {
        }

        public void detach(String resourceId) {
        }

        public void close() {
        }
    }
}

