/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter.sensor.implementations;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.ekf.filter.FilterTools;
import us.ihmc.ekf.filter.RobotState;
import us.ihmc.ekf.filter.sensor.Sensor;
import us.ihmc.ekf.filter.state.implementations.JointState;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class JointPositionSensor
extends Sensor {
    private static final int measurementSize = 1;
    private double measurement = Double.NaN;
    private final String jointName;
    private final String name;
    private final DoubleProvider jointPositionVariance;
    private final double sqrtHz;
    private final YoDouble rawMeasurement;

    public JointPositionSensor(String jointName, double dt, YoRegistry registry) {
        this(jointName, FilterTools.stringToPrefix(jointName), dt, registry);
    }

    public JointPositionSensor(String jointName, String parameterGroup, double dt, YoRegistry registry) {
        this.jointName = jointName;
        this.sqrtHz = 1.0 / Math.sqrt(dt);
        this.name = FilterTools.stringToPrefix(jointName + "Position");
        this.jointPositionVariance = FilterTools.findOrCreate(parameterGroup + "JointPositionVariance", registry, 1.0);
        this.rawMeasurement = new YoDouble(this.name + "raw", registry);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setJointPositionMeasurement(double jointPosition) {
        this.measurement = jointPosition;
        this.rawMeasurement.set(this.measurement);
    }

    @Override
    public int getMeasurementSize() {
        return 1;
    }

    @Override
    public void getMeasurementJacobian(DMatrix1Row jacobianToPack, RobotState robotState) {
        jacobianToPack.reshape(1, robotState.getSize());
        CommonOps_DDRM.fill((DMatrixD1)jacobianToPack, (double)0.0);
        jacobianToPack.set(0, robotState.findJointPositionIndex(this.jointName), 1.0);
    }

    @Override
    public void getResidual(DMatrix1Row residualToPack, RobotState robotState) {
        residualToPack.reshape(1, 1);
        JointState jointState = robotState.getJointState(this.jointName);
        residualToPack.set(0, this.measurement - jointState.getQ());
    }

    @Override
    public void getRMatrix(DMatrix1Row matrixToPack) {
        matrixToPack.reshape(1, 1);
        matrixToPack.set(0, 0, this.jointPositionVariance.getValue() * this.sqrtHz);
    }
}

