/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import us.ihmc.commons.Conversions;
import us.ihmc.ekf.filter.RobotState;
import us.ihmc.ekf.filter.StateEstimator;
import us.ihmc.ekf.filter.sensor.Sensor;
import us.ihmc.ekf.filter.sensor.implementations.AngularVelocitySensor;
import us.ihmc.ekf.filter.sensor.implementations.LinearAccelerationSensor;
import us.ihmc.ekf.filter.sensor.implementations.LinearVelocitySensor;
import us.ihmc.ekf.filter.state.implementations.PoseState;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class ImuOrientationEstimator {
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final PoseState poseState;
    private final LinearAccelerationSensor linearAccelerationSensor;
    private final AngularVelocitySensor angularVelocitySensor;
    private final LinearVelocitySensor linearVelocitySensor;
    private final StateEstimator stateEstimator;
    private final Vector3D zeroLinearVelocityMeasurement = new Vector3D();
    private final FrameQuaternion orientationEstimate = new FrameQuaternion();
    private final FrameVector3D angularVelocityEstimate = new FrameVector3D();
    private final FrameVector3D angularAccelerationEstimate = new FrameVector3D();
    private final RigidBodyTransform imuTransform = new RigidBodyTransform();
    private final Twist imuTwist = new Twist();
    private final SixDoFJoint imuJoint;
    private final YoDouble orientationEstimationTime;
    private final YoFrameYawPitchRoll yoOrientation;
    private final YoFrameVector3D yoAngularVelocity;
    private final YoFrameVector3D yoAngularAcceleration;

    public ImuOrientationEstimator(double dt, YoRegistry parentRegistry) {
        this(dt, false, false, parentRegistry);
    }

    public ImuOrientationEstimator(double dt, boolean estimateAngularVelocityBias, boolean estimateLiearAccelerationBias, YoRegistry parentRegistry) {
        RigidBody elevator = new RigidBody("elevator", ReferenceFrame.getWorldFrame());
        this.imuJoint = new SixDoFJoint("imu_joint", (RigidBodyBasics)elevator);
        RigidBody imuBody = new RigidBody("imu_body", (JointBasics)this.imuJoint, 0.1, 0.1, 0.1, 1.0, (Tuple3DReadOnly)new Vector3D());
        MovingReferenceFrame imuFrame = this.imuJoint.getFrameAfterJoint();
        this.angularVelocitySensor = new AngularVelocitySensor("AngularVelocity", dt, (RigidBodyBasics)imuBody, (ReferenceFrame)imuFrame, estimateAngularVelocityBias, this.registry);
        this.linearVelocitySensor = new LinearVelocitySensor("LinearVelocity", dt, (RigidBodyBasics)imuBody, (ReferenceFrame)imuFrame, false, this.registry);
        this.linearAccelerationSensor = new LinearAccelerationSensor("LinearAcceleration", dt, (RigidBodyBasics)imuBody, (ReferenceFrame)imuFrame, estimateLiearAccelerationBias, this.registry);
        List<Sensor> sensors = Arrays.asList(this.angularVelocitySensor, this.linearVelocitySensor, this.linearAccelerationSensor);
        this.poseState = new PoseState(imuBody.getName(), dt, (ReferenceFrame)imuFrame, this.registry);
        RobotState robotState = new RobotState(this.poseState, Collections.emptyList());
        this.stateEstimator = new StateEstimator(sensors, robotState, this.registry);
        this.orientationEstimationTime = new YoDouble("OrientationEstimationTime", this.registry);
        this.yoOrientation = new YoFrameYawPitchRoll("EKFOrientation", ReferenceFrame.getWorldFrame(), this.registry);
        this.yoAngularVelocity = new YoFrameVector3D("EKFAngularVelocityInIMUFrame", (ReferenceFrame)imuFrame, parentRegistry);
        this.yoAngularAcceleration = new YoFrameVector3D("EKFAngularAccelerationInIMUFrame", (ReferenceFrame)imuFrame, parentRegistry);
        parentRegistry.addChild(this.registry);
    }

    public void update(Vector3DReadOnly angularVelocityMeasurement, Vector3DReadOnly linearAccelerationMeasurement) {
        long startTime = System.nanoTime();
        this.stateEstimator.predict();
        this.updateRobot();
        this.linearAccelerationSensor.setMeasurement(linearAccelerationMeasurement);
        this.angularVelocitySensor.setMeasurement(angularVelocityMeasurement);
        this.linearVelocitySensor.setMeasurement((Vector3DReadOnly)this.zeroLinearVelocityMeasurement);
        this.stateEstimator.correct();
        this.updateRobot();
        this.poseState.getOrientation(this.orientationEstimate);
        this.poseState.getAngularVelocity(this.angularVelocityEstimate);
        this.poseState.getAngularAcceleration(this.angularAccelerationEstimate);
        this.yoOrientation.set((FrameOrientation3DReadOnly)this.orientationEstimate);
        this.yoAngularVelocity.set((FrameTuple3DReadOnly)this.angularVelocityEstimate);
        this.yoAngularAcceleration.set((FrameTuple3DReadOnly)this.angularAccelerationEstimate);
        this.orientationEstimationTime.set(Conversions.nanosecondsToMilliseconds((double)(System.nanoTime() - startTime)));
    }

    public FrameQuaternionReadOnly getOrientationEstimate() {
        return this.orientationEstimate;
    }

    public FrameVector3DReadOnly getAngularVelocityEstimate() {
        return this.angularVelocityEstimate;
    }

    public FrameVector3DReadOnly getAngularAccelerationEstimate() {
        return this.angularAccelerationEstimate;
    }

    public void initialize(QuaternionReadOnly orientation) {
        this.imuTransform.setRotationAndZeroTranslation((Orientation3DReadOnly)orientation);
        this.imuTwist.setToZero((ReferenceFrame)this.imuJoint.getFrameAfterJoint(), (ReferenceFrame)this.imuJoint.getFrameBeforeJoint(), (ReferenceFrame)this.imuJoint.getFrameAfterJoint());
        this.poseState.initialize(this.imuTransform, (TwistReadOnly)this.imuTwist);
        this.linearAccelerationSensor.resetBias();
        this.angularVelocitySensor.resetBias();
    }

    private void updateRobot() {
        this.poseState.getTransform(this.imuTransform);
        this.imuJoint.setJointConfiguration((RigidBodyTransformReadOnly)this.imuTransform);
        this.poseState.getTwist(this.imuTwist);
        this.imuJoint.setJointTwist((TwistReadOnly)this.imuTwist);
        this.imuJoint.updateFramesRecursively();
    }
}

