/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter.sensor.implementations;

import java.util.ArrayList;
import java.util.List;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.ekf.filter.FilterTools;
import us.ihmc.ekf.filter.RobotState;
import us.ihmc.ekf.filter.sensor.Sensor;
import us.ihmc.ekf.filter.state.State;
import us.ihmc.ekf.filter.state.implementations.BiasState;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.algorithms.GeometricJacobianCalculator;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public abstract class BodyVelocitySensor
extends Sensor {
    private final FrameVector3D measurement;
    private final BiasState biasState;
    private final DoubleProvider variance;
    private final DMatrixRMaj jacobianMatrix = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj jacobianRelevantPart = new DMatrixRMaj(0, 0);
    private final GeometricJacobianCalculator robotJacobian = new GeometricJacobianCalculator();
    private final List<String> oneDofJointNames = new ArrayList<String>();
    private final DMatrixRMaj jacobian = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj stateVector = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj biasStateJacobian = new DMatrixRMaj(0, 0);
    private final double sqrtHz;
    private final String name;

    public BodyVelocitySensor(String prefix, double dt, RigidBodyBasics body, ReferenceFrame measurementFrame, boolean estimateBias, YoRegistry registry) {
        this(prefix, dt, body, measurementFrame, estimateBias, prefix, registry);
    }

    public BodyVelocitySensor(String prefix, double dt, RigidBodyBasics body, ReferenceFrame measurementFrame, boolean estimateBias, String parameterGroup, YoRegistry registry) {
        this(prefix, dt, body, measurementFrame, estimateBias, (DoubleProvider)FilterTools.findOrCreate(parameterGroup + "Variance", registry, 1.0), registry);
    }

    protected BodyVelocitySensor(String prefix, double dt, RigidBodyBasics body, ReferenceFrame measurementFrame, boolean estimateBias, DoubleProvider variance, YoRegistry registry) {
        this.sqrtHz = 1.0 / Math.sqrt(dt);
        this.variance = variance;
        this.name = prefix;
        this.measurement = new FrameVector3D(measurementFrame);
        this.robotJacobian.setKinematicChain((RigidBodyReadOnly)MultiBodySystemTools.getRootBody((RigidBodyBasics)body), (RigidBodyReadOnly)body);
        this.robotJacobian.setJacobianFrame(measurementFrame);
        List oneDofJoints = MultiBodySystemTools.filterJoints((List)this.robotJacobian.getJointsFromBaseToEndEffector(), OneDoFJointBasics.class);
        oneDofJoints.stream().forEach(joint -> this.oneDofJointNames.add(joint.getName()));
        if (estimateBias) {
            this.biasState = new BiasState(prefix, dt, registry);
            FilterTools.setIdentity((DMatrix1Row)this.biasStateJacobian, 3);
        } else {
            this.biasState = null;
        }
        int degreesOfFreedom = this.robotJacobian.getNumberOfDegreesOfFreedom();
        this.jacobianRelevantPart.reshape(this.getMeasurementSize(), degreesOfFreedom);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected abstract void packRelevantJacobianPart(DMatrix1Row var1, DMatrix1Row var2);

    @Override
    public State getSensorState() {
        return this.biasState == null ? super.getSensorState() : this.biasState;
    }

    @Override
    public void getMeasurementJacobian(DMatrix1Row jacobianToPack, RobotState robotState) {
        jacobianToPack.reshape(this.getMeasurementSize(), robotState.getSize());
        jacobianToPack.zero();
        this.robotJacobian.reset();
        this.jacobianMatrix.set((DMatrixD1)this.robotJacobian.getJacobianMatrix());
        this.packRelevantJacobianPart((DMatrix1Row)this.jacobianRelevantPart, (DMatrix1Row)this.jacobianMatrix);
        FilterTools.insertForVelocity(jacobianToPack, this.oneDofJointNames, (DMatrix1Row)this.jacobianRelevantPart, robotState);
        if (this.biasState != null) {
            int biasStartIndex = robotState.getStartIndex(this.biasState);
            CommonOps_DDRM.insert((DMatrix)this.biasStateJacobian, (DMatrix)jacobianToPack, (int)0, (int)biasStartIndex);
        }
    }

    @Override
    public void getResidual(DMatrix1Row residualToPack, RobotState robotState) {
        this.getMeasurementJacobian((DMatrix1Row)this.jacobian, robotState);
        residualToPack.reshape(this.getMeasurementSize(), 1);
        robotState.getStateVector((DMatrix1Row)this.stateVector);
        CommonOps_DDRM.mult((DMatrix1Row)this.jacobian, (DMatrix1Row)this.stateVector, (DMatrix1Row)residualToPack);
        residualToPack.set(0, this.measurement.getX() - residualToPack.get(0));
        residualToPack.set(1, this.measurement.getY() - residualToPack.get(1));
        residualToPack.set(2, this.measurement.getZ() - residualToPack.get(2));
    }

    @Override
    public void getRMatrix(DMatrix1Row matrixToPack) {
        matrixToPack.reshape(this.getMeasurementSize(), this.getMeasurementSize());
        CommonOps_DDRM.setIdentity((DMatrix1Row)matrixToPack);
        CommonOps_DDRM.scale((double)(this.variance.getValue() * this.sqrtHz), (DMatrixD1)matrixToPack);
    }

    public void setMeasurement(Vector3DReadOnly measurement) {
        this.measurement.set((Tuple3DReadOnly)measurement);
    }

    public void resetBias() {
        if (this.biasState != null) {
            this.biasState.reset();
        }
    }
}

