/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.ekf.filter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.mutable.MutableInt;
import us.ihmc.ekf.filter.RobotStateIndexProvider;
import us.ihmc.ekf.filter.state.ComposedState;
import us.ihmc.ekf.filter.state.implementations.JointState;
import us.ihmc.ekf.filter.state.implementations.PoseState;

public class RobotState
extends ComposedState
implements RobotStateIndexProvider {
    public static final double GRAVITY = -9.81;
    private final boolean isFloating;
    private final Map<String, JointState> jointStatesByName = new HashMap<String, JointState>();
    private final Map<String, MutableInt> jointIndecesByName = new HashMap<String, MutableInt>();

    public RobotState(PoseState poseState, List<JointState> jointStates) {
        super("RobotState");
        boolean bl = this.isFloating = poseState != null;
        if (this.isFloating) {
            this.addState(poseState);
        }
        for (JointState jointState : jointStates) {
            MutableInt jointStateStartIndex = new MutableInt(this.getSize());
            this.addState(jointState);
            String jointName = jointState.getJointName();
            this.jointStatesByName.put(jointName, jointState);
            this.jointIndecesByName.put(jointName, jointStateStartIndex);
        }
    }

    public JointState getJointState(String jointName) {
        return this.jointStatesByName.get(jointName);
    }

    @Override
    public int getJointStartIndex(String jointName) {
        return this.jointIndecesByName.get(jointName).intValue();
    }

    @Override
    public boolean isFloating() {
        return this.isFloating;
    }

    public double getGravity() {
        return -9.81;
    }
}

