/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.jni;

import dm.jdbc.driver.DBError;
import dm.jdbc.internal.conf.DmSvcConf;
import dm.jdbc.internal.parser.LVal;
import dm.jdbc.internal.parser.SQLProcessor;
import dm.jdbc.jni.MarkSocket;
import dm.jdbc.util.StringUtil;
import java.util.List;

public class MarkDll {
    public static final int SQL_TYPE_NULL = -2;
    public static final int SQL_TYPE_INVALID = -1;
    public static final int SQL_TYPE_CONNECT = 0;
    public static final int SQL_TYPE_SELECT = 1;
    public static final int SQL_TYPE_INSERT = 2;
    public static final int SQL_TYPE_UPDATE = 3;
    public static final int SQL_TYPE_DELETE = 4;
    public static final int SQL_TYPE_CREATE = 5;
    public static final int SQL_TYPE_ALTER = 6;
    public static final int SQL_TYPE_DROP = 7;
    public static final int SQL_TYPE_GRANT = 8;
    public static final int SQL_TYPE_REVOKE = 9;

    static {
        try {
            System.loadLibrary("dmutl");
            System.loadLibrary("dmelog");
            System.loadLibrary("dmos");
            System.loadLibrary("dmmem");
            System.loadLibrary("dmclientlex");
            System.loadLibrary("dmmark_client");
            if (StringUtil.isEmpty(DmSvcConf.GLOBAL.markConf) || MarkDll.initMarkEnv(DmSvcConf.GLOBAL.markConf) < 0) {
                DBError.throwRuntimeException(DBError.ECJDBC_INIT_SOCKET_MARK_FAILED.reason);
            }
        }
        catch (Throwable t2) {
            DBError.throwRuntimeException(DBError.ECJDBC_INIT_SOCKET_MARK_FAILED.reason, t2);
        }
    }

    public static final int getSqlType(String sql) {
        if (StringUtil.isEmpty(sql)) {
            return -2;
        }
        String first = "";
        try {
            List<LVal> lvalList = SQLProcessor.lexSkipWhitespace(sql, 1);
            LVal lVal = lvalList.get(0);
            first = lVal.value.toUpperCase();
        }
        catch (Exception exception) {
            return -1;
        }
        if (StringUtil.equals(first, "SELECT")) {
            return 1;
        }
        if (StringUtil.equals(first, "INSERT")) {
            return 2;
        }
        if (StringUtil.equals(first, "UPDATE")) {
            return 3;
        }
        if (StringUtil.equals(first, "DELETE")) {
            return 4;
        }
        if (StringUtil.equals(first, "CREATE")) {
            return 5;
        }
        if (StringUtil.equals(first, "REVOKE")) {
            return 9;
        }
        if (StringUtil.equals(first, "ALTER")) {
            return 6;
        }
        if (StringUtil.equals(first, "GRANT")) {
            return 8;
        }
        if (StringUtil.equals(first, "DROP")) {
            return 7;
        }
        return -1;
    }

    public static native int initMarkEnv(String var0);

    public static native int deinitMarkEnv();

    public static native int socket(MarkSocket var0, String var1, int var2);

    public static native int send(MarkSocket var0, byte[] var1, int var2);

    public static native int recv(MarkSocket var0, byte[] var1, int var2);

    public static native int close(MarkSocket var0);

    public static native int setSocketMark(MarkSocket var0, int var1, int var2, byte[] var3, int var4);

    public static native int checkMark(MarkSocket var0, byte[] var1, int var2);
}

