/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.dm.dmgeo2;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import org.geolatte.geom.Geometry;
import org.hibernate.spatial.dialect.dm.dmgeo2.DmStructDecoder;
import org.hibernate.spatial.dialect.dm.dmgeo2.DmStructEncoder;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.BasicBinder;
import org.hibernate.type.descriptor.sql.BasicExtractor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public class DmGeometryTypeDescriptor
implements SqlTypeDescriptor {
    private static final long serialVersionUID = 1479840434333719711L;
    private String geoModelType;

    public DmGeometryTypeDescriptor(String geoModelType) {
        this.geoModelType = geoModelType;
    }

    public int getSqlType() {
        return 2002;
    }

    public boolean canBeRemapped() {
        return false;
    }

    public <X> ValueBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
        final BasicBinder basicBinder = new BasicBinder<X>(javaTypeDescriptor, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, this.toStruct(value, options, st.getConnection()));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, (Object)this.toStruct(value, options, st.getConnection()));
            }

            private Struct toStruct(X value, WrapperOptions options, Connection connection) {
                Struct encoded = null;
                DmStructEncoder encoder = new DmStructEncoder();
                if (value instanceof org.locationtech.jts.geom.Geometry) {
                    org.locationtech.jts.geom.Geometry geometry = (org.locationtech.jts.geom.Geometry)this.getJavaDescriptor().unwrap(value, org.locationtech.jts.geom.Geometry.class, options);
                    encoded = encoder.encodeJts(geometry, connection);
                } else {
                    Geometry geometry = (Geometry)this.getJavaDescriptor().unwrap(value, Geometry.class, options);
                    encoded = encoder.encodeGeolatte(geometry, connection);
                }
                return encoded;
            }
        };
        return new ValueBinder<X>(){

            public void bind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                if (value == null) {
                    st.setNull(index, 12);
                } else {
                    basicBinder.bind(st, value, index, options);
                }
            }

            public void bind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                if (value == null) {
                    st.setNull(name, 12);
                } else {
                    basicBinder.bind(st, value, name, options);
                }
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            protected X doExtract(ResultSet rs, String name, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap(this.toGeometry(rs.getObject(name)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap(this.toGeometry(statement.getObject(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaDescriptor().wrap(this.toGeometry(statement.getObject(name)), options);
            }

            private <T> T toGeometry(Object object) {
                if (object == null) {
                    return null;
                }
                if (object instanceof Struct) {
                    DmStructDecoder decoder = new DmStructDecoder();
                    if (DmGeometryTypeDescriptor.this.geoModelType.equals("jts_geometry")) {
                        return (T)decoder.decodeJts((Struct)object);
                    }
                    return (T)decoder.decodeGeolatte((Struct)object);
                }
                throw new IllegalStateException("Object of type " + object.getClass().getCanonicalName() + " can not be handled as spatial value  by DM");
            }
        };
    }
}

