/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.CastFunction;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class DmDialect
extends Dialect {
    public DmDialect() {
        this.registerColumnType(-7, "bit");
        this.registerColumnType(16, "bit");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double");
        this.registerColumnType(2, "numeric($p,$s)");
        this.registerColumnType(7, "real");
        this.registerColumnType(3, "decimal($p,$s)");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-2, "binary($l)");
        this.registerColumnType(-3, "varbinary($l)");
        this.registerColumnType(-4, "image");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar($l)");
        this.registerColumnType(-1, "text");
        this.registerColumnType(2005, "clob");
        this.registerKeyword("last");
        this.registerKeyword("size");
        this.registerHibernateType(5, Hibernate.SHORT.getName());
        this.registerFunction("substring", (SQLFunction)new SQLFunctionTemplate((Type)Hibernate.STRING, "substring(?1, ?2, ?3)"));
        this.registerFunction("locate", (SQLFunction)new SQLFunctionTemplate((Type)Hibernate.INTEGER, "locate(?1, ?2, ?3)"));
        this.registerFunction("trim", (SQLFunction)new SQLFunctionTemplate((Type)Hibernate.STRING, "trim(?1 ?2 ?3 ?4)"));
        this.registerFunction("length", (SQLFunction)new StandardSQLFunction("length", (Type)Hibernate.INTEGER));
        this.registerFunction("bit_length", (SQLFunction)new StandardSQLFunction("bit_length", (Type)Hibernate.INTEGER));
        this.registerFunction("coalesce", (SQLFunction)new StandardSQLFunction("coalesce"));
        this.registerFunction("nullif", (SQLFunction)new StandardSQLFunction("nullif"));
        this.registerFunction("abs", (SQLFunction)new StandardSQLFunction("abs"));
        this.registerFunction("mod", (SQLFunction)new StandardSQLFunction("mod", (Type)Hibernate.LONG));
        this.registerFunction("sqrt", (SQLFunction)new StandardSQLFunction("sqrt", (Type)Hibernate.DOUBLE));
        this.registerFunction("upper", (SQLFunction)new StandardSQLFunction("upper"));
        this.registerFunction("lower", (SQLFunction)new StandardSQLFunction("lower"));
        this.registerFunction("cast", (SQLFunction)new CastFunction());
        this.registerFunction("extract", (SQLFunction)new SQLFunctionTemplate((Type)Hibernate.INTEGER, "extract(?1 ?2 ?3)"));
        this.registerFunction("second", (SQLFunction)new StandardSQLFunction("second", (Type)Hibernate.INTEGER));
        this.registerFunction("minute", (SQLFunction)new StandardSQLFunction("minute", (Type)Hibernate.INTEGER));
        this.registerFunction("hour", (SQLFunction)new StandardSQLFunction("hour", (Type)Hibernate.INTEGER));
        this.registerFunction("day", (SQLFunction)new StandardSQLFunction("day", (Type)Hibernate.INTEGER));
        this.registerFunction("month", (SQLFunction)new StandardSQLFunction("month", (Type)Hibernate.INTEGER));
        this.registerFunction("year", (SQLFunction)new StandardSQLFunction("year", (Type)Hibernate.INTEGER));
        this.registerFunction("str", (SQLFunction)new StandardSQLFunction("to_char", (Type)Hibernate.STRING));
        this.registerFunction("asin", (SQLFunction)new StandardSQLFunction("asin", (Type)Hibernate.DOUBLE));
        this.registerFunction("acos", (SQLFunction)new StandardSQLFunction("acos", (Type)Hibernate.DOUBLE));
        this.registerFunction("atan", (SQLFunction)new StandardSQLFunction("atan", (Type)Hibernate.DOUBLE));
        this.registerFunction("atan2", (SQLFunction)new StandardSQLFunction("atan2", (Type)Hibernate.DOUBLE));
        this.registerFunction("ceil", (SQLFunction)new StandardSQLFunction("ceil", (Type)Hibernate.INTEGER));
        this.registerFunction("ceiling", (SQLFunction)new StandardSQLFunction("ceiling", (Type)Hibernate.INTEGER));
        this.registerFunction("cos", (SQLFunction)new StandardSQLFunction("cos", (Type)Hibernate.DOUBLE));
        this.registerFunction("cot", (SQLFunction)new StandardSQLFunction("cot", (Type)Hibernate.DOUBLE));
        this.registerFunction("cosh", (SQLFunction)new StandardSQLFunction("cosh", (Type)Hibernate.DOUBLE));
        this.registerFunction("degrees", (SQLFunction)new StandardSQLFunction("degrees"));
        this.registerFunction("exp", (SQLFunction)new StandardSQLFunction("exp", (Type)Hibernate.DOUBLE));
        this.registerFunction("GREATEST", (SQLFunction)new StandardSQLFunction("GREATEST", (Type)Hibernate.DOUBLE));
        this.registerFunction("floor", (SQLFunction)new StandardSQLFunction("floor", (Type)Hibernate.INTEGER));
        this.registerFunction("ln", (SQLFunction)new StandardSQLFunction("ln", (Type)Hibernate.DOUBLE));
        this.registerFunction("log", (SQLFunction)new StandardSQLFunction("log", (Type)Hibernate.DOUBLE));
        this.registerFunction("log10", (SQLFunction)new StandardSQLFunction("log10", (Type)Hibernate.DOUBLE));
        this.registerFunction("pi", (SQLFunction)new NoArgSQLFunction("pi", (Type)Hibernate.DOUBLE));
        this.registerFunction("power", (SQLFunction)new StandardSQLFunction("power", (Type)Hibernate.DOUBLE));
        this.registerFunction("radians", (SQLFunction)new StandardSQLFunction("radians"));
        this.registerFunction("rand", (SQLFunction)new NoArgSQLFunction("rand", (Type)Hibernate.DOUBLE));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round"));
        this.registerFunction("sign", (SQLFunction)new StandardSQLFunction("sign", (Type)Hibernate.INTEGER));
        this.registerFunction("sin", (SQLFunction)new StandardSQLFunction("sin", (Type)Hibernate.DOUBLE));
        this.registerFunction("sinh", (SQLFunction)new StandardSQLFunction("sinh", (Type)Hibernate.DOUBLE));
        this.registerFunction("tan", (SQLFunction)new StandardSQLFunction("tan", (Type)Hibernate.DOUBLE));
        this.registerFunction("tanh", (SQLFunction)new StandardSQLFunction("tanh", (Type)Hibernate.DOUBLE));
        this.registerFunction("trunc", (SQLFunction)new StandardSQLFunction("trunc"));
        this.registerFunction("truncate", (SQLFunction)new StandardSQLFunction("truncate"));
        this.registerFunction("stddev", (SQLFunction)new StandardSQLFunction("stddev", (Type)Hibernate.DOUBLE));
        this.registerFunction("variance", (SQLFunction)new StandardSQLFunction("variance", (Type)Hibernate.DOUBLE));
        this.registerFunction("concat", (SQLFunction)new VarArgsSQLFunction((Type)Hibernate.STRING, "", "||", ""));
        this.registerFunction("ascii", (SQLFunction)new StandardSQLFunction("ascii", (Type)Hibernate.INTEGER));
        this.registerFunction("char", (SQLFunction)new StandardSQLFunction("char", (Type)Hibernate.CHARACTER));
        this.registerFunction("difference", (SQLFunction)new StandardSQLFunction("difference", (Type)Hibernate.INTEGER));
        this.registerFunction("char_length", (SQLFunction)new StandardSQLFunction("char_length", (Type)Hibernate.LONG));
        this.registerFunction("character_length", (SQLFunction)new StandardSQLFunction("character_length", (Type)Hibernate.LONG));
        this.registerFunction("chr", (SQLFunction)new StandardSQLFunction("chr", (Type)Hibernate.CHARACTER));
        this.registerFunction("initcap", (SQLFunction)new StandardSQLFunction("initcap", (Type)Hibernate.STRING));
        this.registerFunction("insert", (SQLFunction)new StandardSQLFunction("insert", (Type)Hibernate.STRING));
        this.registerFunction("insstr", (SQLFunction)new StandardSQLFunction("insstr", (Type)Hibernate.STRING));
        this.registerFunction("instr", (SQLFunction)new StandardSQLFunction("instr", (Type)Hibernate.LONG));
        this.registerFunction("instrb", (SQLFunction)new StandardSQLFunction("instrb", (Type)Hibernate.LONG));
        this.registerFunction("lcase", (SQLFunction)new StandardSQLFunction("lcase", (Type)Hibernate.STRING));
        this.registerFunction("left", (SQLFunction)new StandardSQLFunction("left", (Type)Hibernate.STRING));
        this.registerFunction("leftstr", (SQLFunction)new StandardSQLFunction("leftstr", (Type)Hibernate.STRING));
        this.registerFunction("len", (SQLFunction)new StandardSQLFunction("len", (Type)Hibernate.INTEGER));
        this.registerFunction("LENGTHB", (SQLFunction)new StandardSQLFunction("LENGTHB", (Type)Hibernate.INTEGER));
        this.registerFunction("octet_length", (SQLFunction)new StandardSQLFunction("octet_length", (Type)Hibernate.LONG));
        this.registerFunction("lpad", (SQLFunction)new StandardSQLFunction("lpad", (Type)Hibernate.STRING));
        this.registerFunction("ltrim", (SQLFunction)new StandardSQLFunction("ltrim", (Type)Hibernate.STRING));
        this.registerFunction("position", (SQLFunction)new StandardSQLFunction("position", (Type)Hibernate.INTEGER));
        this.registerFunction("INS", (SQLFunction)new StandardSQLFunction("INS", (Type)Hibernate.STRING));
        this.registerFunction("repeat", (SQLFunction)new StandardSQLFunction("repeat", (Type)Hibernate.STRING));
        this.registerFunction("REPLICATE", (SQLFunction)new StandardSQLFunction("REPLICATE", (Type)Hibernate.STRING));
        this.registerFunction("STUFF", (SQLFunction)new StandardSQLFunction("STUFF", (Type)Hibernate.STRING));
        this.registerFunction("repeatstr", (SQLFunction)new StandardSQLFunction("repeatstr", (Type)Hibernate.STRING));
        this.registerFunction("replace", (SQLFunction)new StandardSQLFunction("replace", (Type)Hibernate.STRING));
        this.registerFunction("reverse", (SQLFunction)new StandardSQLFunction("reverse", (Type)Hibernate.STRING));
        this.registerFunction("right", (SQLFunction)new StandardSQLFunction("right", (Type)Hibernate.STRING));
        this.registerFunction("rightstr", (SQLFunction)new StandardSQLFunction("rightstr", (Type)Hibernate.STRING));
        this.registerFunction("rpad", (SQLFunction)new StandardSQLFunction("rpad", (Type)Hibernate.STRING));
        this.registerFunction("TO_NUMBER", (SQLFunction)new StandardSQLFunction("TO_NUMBER"));
        this.registerFunction("rtrim", (SQLFunction)new StandardSQLFunction("rtrim", (Type)Hibernate.STRING));
        this.registerFunction("soundex", (SQLFunction)new StandardSQLFunction("soundex", (Type)Hibernate.STRING));
        this.registerFunction("space", (SQLFunction)new StandardSQLFunction("space", (Type)Hibernate.STRING));
        this.registerFunction("substr", (SQLFunction)new StandardSQLFunction("substr", (Type)Hibernate.STRING));
        this.registerFunction("substrb", (SQLFunction)new StandardSQLFunction("substrb", (Type)Hibernate.STRING));
        this.registerFunction("to_char", (SQLFunction)new StandardSQLFunction("to_char", (Type)Hibernate.STRING));
        this.registerFunction("STRPOSDEC", (SQLFunction)new StandardSQLFunction("STRPOSDEC", (Type)Hibernate.STRING));
        this.registerFunction("STRPOSINC", (SQLFunction)new StandardSQLFunction("STRPOSINC", (Type)Hibernate.STRING));
        this.registerFunction("VSIZE", (SQLFunction)new StandardSQLFunction("VSIZE", (Type)Hibernate.INTEGER));
        this.registerFunction("translate", (SQLFunction)new StandardSQLFunction("translate", (Type)Hibernate.STRING));
        this.registerFunction("ucase", (SQLFunction)new StandardSQLFunction("ucase", (Type)Hibernate.STRING));
        this.registerFunction("OVERLAPS", (SQLFunction)new StandardSQLFunction("OVERLAPS"));
        this.registerFunction("DATEPART", (SQLFunction)new StandardSQLFunction("DATEPART"));
        this.registerFunction("DATE_PART", (SQLFunction)new StandardSQLFunction("DATE_PART"));
        this.registerFunction("add_days", (SQLFunction)new StandardSQLFunction("add_days"));
        this.registerFunction("add_months", (SQLFunction)new StandardSQLFunction("add_months"));
        this.registerFunction("add_weeks", (SQLFunction)new StandardSQLFunction("add_weeks"));
        this.registerFunction("curdate", (SQLFunction)new NoArgSQLFunction("curdate", (Type)Hibernate.DATE));
        this.registerFunction("curtime", (SQLFunction)new NoArgSQLFunction("curtime", (Type)Hibernate.TIME));
        this.registerFunction("current_date", (SQLFunction)new NoArgSQLFunction("current_date", (Type)Hibernate.DATE));
        this.registerFunction("current_time", (SQLFunction)new NoArgSQLFunction("current_time", (Type)Hibernate.TIME));
        this.registerFunction("current_timestamp", (SQLFunction)new NoArgSQLFunction("current_timestamp", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("dateadd", (SQLFunction)new StandardSQLFunction("dateadd", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("CUR_TICK_TIME", (SQLFunction)new StandardSQLFunction("CUR_TICK_TIME"));
        this.registerFunction("datediff", (SQLFunction)new StandardSQLFunction("datediff", (Type)Hibernate.INTEGER));
        this.registerFunction("datepart", (SQLFunction)new StandardSQLFunction("datepart", (Type)Hibernate.INTEGER));
        this.registerFunction("dayname", (SQLFunction)new StandardSQLFunction("dayname", (Type)Hibernate.STRING));
        this.registerFunction("dayofmonth", (SQLFunction)new StandardSQLFunction("dayofmonth", (Type)Hibernate.INTEGER));
        this.registerFunction("dayofweek", (SQLFunction)new StandardSQLFunction("dayofweek", (Type)Hibernate.INTEGER));
        this.registerFunction("dayofyear", (SQLFunction)new StandardSQLFunction("dayofyear", (Type)Hibernate.INTEGER));
        this.registerFunction("days_between", (SQLFunction)new StandardSQLFunction("days_between", (Type)Hibernate.INTEGER));
        this.registerFunction("getdate", (SQLFunction)new StandardSQLFunction("getdate", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("LOCALTIMESTAMP", (SQLFunction)new StandardSQLFunction("LOCALTIMESTAMP"));
        this.registerFunction("NOW", (SQLFunction)new StandardSQLFunction("NOW"));
        this.registerFunction("last_day", (SQLFunction)new StandardSQLFunction("last_day"));
        this.registerFunction("month", (SQLFunction)new StandardSQLFunction("month", (Type)Hibernate.INTEGER));
        this.registerFunction("monthname", (SQLFunction)new StandardSQLFunction("monthname", (Type)Hibernate.STRING));
        this.registerFunction("months_between", (SQLFunction)new StandardSQLFunction("months_between"));
        this.registerFunction("GREATEST", (SQLFunction)new StandardSQLFunction("GREATEST", (Type)Hibernate.DATE));
        this.registerFunction("TO_DATETIME", (SQLFunction)new StandardSQLFunction("TO_DATETIME"));
        this.registerFunction("next_day", (SQLFunction)new StandardSQLFunction("next_day"));
        this.registerFunction("quarter", (SQLFunction)new StandardSQLFunction("quarter", (Type)Hibernate.INTEGER));
        this.registerFunction("round", (SQLFunction)new StandardSQLFunction("round"));
        this.registerFunction("timestampadd", (SQLFunction)new StandardSQLFunction("timestampadd", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("timestampdiff", (SQLFunction)new StandardSQLFunction("timestampdiff", (Type)Hibernate.INTEGER));
        this.registerFunction("BIGDATEDIFF", (SQLFunction)new StandardSQLFunction("BIGDATEDIFF", (Type)Hibernate.BIG_INTEGER));
        this.registerFunction("sysdate", (SQLFunction)new StandardSQLFunction("sysdate", (Type)Hibernate.TIME));
        this.registerFunction("LEAST", (SQLFunction)new StandardSQLFunction("LEAST"));
        this.registerFunction("trunc", (SQLFunction)new StandardSQLFunction("trunc"));
        this.registerFunction("week", (SQLFunction)new StandardSQLFunction("week", (Type)Hibernate.INTEGER));
        this.registerFunction("weekday", (SQLFunction)new StandardSQLFunction("weekday", (Type)Hibernate.INTEGER));
        this.registerFunction("weeks_between", (SQLFunction)new StandardSQLFunction("weeks_between", (Type)Hibernate.INTEGER));
        this.registerFunction("year", (SQLFunction)new StandardSQLFunction("year", (Type)Hibernate.INTEGER));
        this.registerFunction("years_between", (SQLFunction)new StandardSQLFunction("years_between", (Type)Hibernate.INTEGER));
        this.registerFunction("to_date", (SQLFunction)new StandardSQLFunction("to_date", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("systimestamp", (SQLFunction)new NoArgSQLFunction("systimestamp", (Type)Hibernate.TIMESTAMP));
        this.registerFunction("ifnull", (SQLFunction)new StandardSQLFunction("ifnull"));
        this.registerFunction("isnull", (SQLFunction)new StandardSQLFunction("isnull"));
        this.registerFunction("nvl", (SQLFunction)new StandardSQLFunction("nvl"));
        this.registerFunction("decode", (SQLFunction)new StandardSQLFunction("decode"));
        this.registerFunction("cur_database", (SQLFunction)new StandardSQLFunction("cur_database", (Type)Hibernate.STRING));
        this.registerFunction("page", (SQLFunction)new StandardSQLFunction("page", (Type)Hibernate.INTEGER));
        this.registerFunction("sessid", (SQLFunction)new StandardSQLFunction("sessid", (Type)Hibernate.LONG));
        this.registerFunction("uid", (SQLFunction)new StandardSQLFunction("uid", (Type)Hibernate.LONG));
        this.registerFunction("user", (SQLFunction)new StandardSQLFunction("user", (Type)Hibernate.STRING));
        this.registerFunction("vsize", (SQLFunction)new StandardSQLFunction("vsize", (Type)Hibernate.INTEGER));
        this.registerFunction("tabledef", (SQLFunction)new StandardSQLFunction("tabledef", (Type)Hibernate.STRING));
        this.getDefaultProperties().setProperty("hibernate.use_outer_join", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "0");
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public boolean supportsInsertSelectIdentity() {
        return false;
    }

    public boolean hasDataTypeInIdentityColumn() {
        return true;
    }

    public String getIdentitySelectString() throws MappingException {
        return "select scope_identity()";
    }

    public String appendIdentitySelectToInsert(String insertString) {
        return String.valueOf(insertString) + " select scope_identity()";
    }

    protected String getIdentityColumnString() throws MappingException {
        return "identity not null";
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSequenceNextValString(String sequenceName) throws MappingException {
        return "select " + sequenceName + ".nextval";
    }

    protected String getCreateSequenceString(String sequenceName) throws MappingException {
        return "create sequence " + sequenceName;
    }

    protected String getDropSequenceString(String sequenceName) throws MappingException {
        return "drop sequence " + sequenceName;
    }

    public String getSelectGUIDString() {
        return "select GUID()";
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return this.supportsLimit();
    }

    public boolean supportsVariableLimit() {
        return this.supportsLimit();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean bindLimitParametersFirst() {
        return false;
    }

    public boolean useMaxForLimit() {
        return false;
    }

    public String getLimitString(String query, int offset, int limit) {
        return this.getLimitString(query, offset > 0);
    }

    public String getLimitString(String query, boolean hasOffset) {
        query = query.trim();
        while (query.endsWith(";")) {
            query = query.substring(0, query.length() - 1);
        }
        boolean isForUpdate = false;
        if (query.toLowerCase().endsWith(" for update")) {
            query = query.substring(0, query.length() - 11);
            isForUpdate = true;
        }
        String pagingSelect = "";
        if (hasOffset) {
            pagingSelect = String.valueOf(pagingSelect) + query;
            pagingSelect = String.valueOf(pagingSelect) + " limit ? offset ? ";
        } else {
            pagingSelect = String.valueOf(pagingSelect) + query;
            pagingSelect = String.valueOf(pagingSelect) + " limit ? ";
        }
        if (isForUpdate) {
            pagingSelect = String.valueOf(pagingSelect) + " for update ";
        }
        return pagingSelect.toString();
    }

    public String getForUpdateString() {
        return " for update";
    }

    public boolean forUpdateOfColumns() {
        return true;
    }

    public boolean supportsOuterJoinForUpdate() {
        return true;
    }

    public String getForUpdateString(String aliases) {
        return String.valueOf(this.getForUpdateString()) + " of " + aliases;
    }

    public String getForUpdateNowaitString() {
        return String.valueOf(this.getForUpdateString()) + " nowait";
    }

    public String getForUpdateNowaitString(String aliases) {
        return String.valueOf(this.getForUpdateString()) + " of " + aliases + " nowait";
    }

    public String appendLockHint(LockMode mode, String tableName) {
        return tableName;
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String generateTemporaryTableName(String baseTableName) {
        return "##" + baseTableName;
    }

    public boolean dropTemporaryTableAfterUse() {
        return false;
    }

    public ResultSet getResultSet(CallableStatement ps) throws SQLException {
        boolean isResultSet = ps.execute();
        while (!isResultSet && ps.getUpdateCount() != -1) {
            isResultSet = ps.getMoreResults();
        }
        return ps.getResultSet();
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public String getCurrentTimestampSelectString() {
        return "select current_timestamp";
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public String toBooleanValueString(boolean bool) {
        return bool ? "1" : "0";
    }

    public char openQuote() {
        return '\"';
    }

    public char closeQuote() {
        return '\"';
    }

    public String getAddColumnString() {
        return "add column";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        String res = "";
        res = String.valueOf(res) + " add constraint ";
        res = String.valueOf(res) + constraintName;
        res = String.valueOf(res) + " foreign key (";
        res = String.valueOf(res) + StringHelper.join((String)", ", (String[])foreignKey);
        res = String.valueOf(res) + ") references ";
        res = String.valueOf(res) + referencedTable;
        if (!referencesPrimaryKey) {
            res = String.valueOf(res) + " (" + StringHelper.join((String)", ", (String[])primaryKey) + ')';
        }
        return res.toString();
    }

    public boolean supportsIfExistsBeforeTableName() {
        return false;
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public boolean supportsColumnCheck() {
        return true;
    }

    public boolean supportsTableCheck() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public boolean supportsNotNullUnique() {
        return true;
    }
}

