/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriterObject;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplMap;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Locale;

abstract class FieldWriterMap
extends FieldWriterObject {
    protected final Class<?> contentAs;
    protected Type contentAsFieldType;
    volatile ObjectWriter mapWriter;
    private final Type keyType;
    private final Type valueType;
    final boolean valueTypeRefDetect;
    volatile ObjectWriter valueWriter;

    protected FieldWriterMap(String name, int ordinal, long features, String format, Locale locale, String label, Type fieldType, Class fieldClass, Field field, Method method, Class<?> contentAs) {
        super(name, ordinal, features, format, locale, label, fieldType, fieldClass, field, method);
        ParameterizedType pt;
        Type[] actualTypeArguments;
        Object keyType = null;
        Object valueType = null;
        ParameterizedTypeImpl contentAsFieldType = null;
        if (fieldType instanceof ParameterizedType && (actualTypeArguments = (pt = (ParameterizedType)fieldType).getActualTypeArguments()).length == 2) {
            keyType = actualTypeArguments[0];
            valueType = actualTypeArguments[1];
        }
        if (keyType == null) {
            keyType = Object.class;
        }
        if (valueType == null) {
            valueType = Object.class;
        }
        if (contentAs != null) {
            contentAsFieldType = new ParameterizedTypeImpl(fieldClass, new Type[]{String.class, contentAs});
        }
        this.contentAs = contentAs;
        this.contentAsFieldType = contentAsFieldType;
        this.keyType = keyType;
        this.valueType = valueType;
        this.valueTypeRefDetect = !ObjectWriterProvider.isNotReferenceDetect(TypeUtils.getClass((Type)valueType));
    }

    @Override
    public ObjectWriter getObjectWriter(JSONWriter jsonWriter, Class valueClass) {
        Class<?> contentAs = this.contentAs;
        if (contentAs == null || !this.fieldClass.isAssignableFrom(valueClass)) {
            return super.getObjectWriter(jsonWriter, valueClass);
        }
        ObjectWriter valueWriter = this.valueWriter;
        if (valueWriter != null) {
            return valueWriter;
        }
        Type fieldType = this.fieldType;
        Class<?> valueType = this.valueType;
        long features = this.features;
        if (contentAs != null) {
            valueType = contentAs;
            fieldType = this.contentAsFieldType;
            features |= Long.MIN_VALUE;
        }
        this.mapWriter = valueWriter = new ObjectWriterImplMap(this.keyType, valueType, this.format, valueClass, fieldType, features);
        return valueWriter;
    }
}

