/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.support.csv.CSVWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.NumberUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;

final class CSVWriterUTF16
extends CSVWriter {
    final Writer out;
    final char[] chars;
    private static final int DOUBLE_QUOTE_2_UTF16 = 0x220022;

    CSVWriterUTF16(Writer out, ZoneId zoneId, CSVWriter.Feature ... features) {
        super(zoneId, features);
        this.out = out;
        this.chars = new char[524288];
    }

    void writeDirect(char[] bytes, int off, int len) {
        try {
            this.out.write(bytes, off, len);
        }
        catch (IOException e) {
            throw new JSONException("write csv error", e);
        }
    }

    @Override
    public void writeComma() {
        this.checkCapacity(1);
        this.chars[this.off++] = 44;
    }

    @Override
    protected void writeQuote() {
        this.checkCapacity(1);
        this.chars[this.off++] = 34;
    }

    @Override
    public void writeLine() {
        this.checkCapacity(1);
        this.chars[this.off++] = 10;
    }

    @Override
    public void writeBoolean(boolean v) {
        this.checkCapacity(5);
        this.off = IOUtils.putBoolean(this.chars, this.off, v);
    }

    @Override
    public void writeInt64(long longValue) {
        this.checkCapacity(20);
        this.off = IOUtils.writeInt64(this.chars, this.off, longValue);
    }

    @Override
    public void writeDateYYYMMDD10(int year, int month, int dayOfMonth) {
        this.checkCapacity(10);
        this.off = IOUtils.writeLocalDate(this.chars, this.off, year, month, dayOfMonth);
    }

    @Override
    public void writeDateTime19(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        this.checkCapacity(19);
        char[] chars = this.chars;
        int off = this.off;
        off = IOUtils.writeLocalDate(chars, off, year, month, dayOfMonth);
        chars[off] = 32;
        IOUtils.writeLocalTime(chars, off + 1, hour, minute, second);
        this.off = off + 9;
    }

    @Override
    public void writeString(String str) {
        char ch;
        int i;
        if (str == null || str.isEmpty()) {
            return;
        }
        int len = str.length();
        int escapeCount = 0;
        boolean comma = false;
        if (str.charAt(0) == '\"') {
            for (i = 0; i < len; ++i) {
                ch = str.charAt(i);
                if (ch != '\"') continue;
                ++escapeCount;
            }
        } else {
            for (i = 0; i < len; ++i) {
                ch = str.charAt(i);
                if (ch == ',') {
                    comma = true;
                    continue;
                }
                if (ch != '\"' && ch != '\n' && ch != '\r') continue;
                ++escapeCount;
            }
            if (!comma) {
                escapeCount = 0;
            }
        }
        if (escapeCount == 0 && !comma) {
            if (len + this.off >= this.chars.length) {
                this.flush();
                if (len > this.chars.length) {
                    try {
                        this.out.write(str);
                    }
                    catch (IOException e) {
                        throw new JSONException("write csv error", e);
                    }
                    return;
                }
            }
            str.getChars(0, len, this.chars, this.off);
            this.off += len;
            return;
        }
        this.checkCapacity(2 + len + escapeCount);
        char[] chars = this.chars;
        int max = chars.length - 2;
        int off = this.off;
        chars[off++] = 34;
        int i2 = 0;
        while (i2 < len) {
            char ch2;
            if ((ch2 = str.charAt(i2++)) == '\"') {
                IOUtils.putIntUnaligned(chars, off, 0x220022);
                off += 2;
            } else {
                chars[off++] = ch2;
            }
            if (off < max) continue;
            this.flush();
            off = this.off;
        }
        chars[off] = 34;
        this.off = off + 1;
    }

    @Override
    public void writeInt32(int intValue) {
        this.checkCapacity(11);
        this.off = IOUtils.writeInt32(this.chars, this.off, (long)intValue);
    }

    @Override
    public void writeDouble(double value) {
        this.checkCapacity(24);
        this.off = NumberUtils.writeDouble(this.chars, this.off, value, true);
    }

    @Override
    public void writeFloat(float value) {
        this.checkCapacity(15);
        this.off = NumberUtils.writeFloat(this.chars, this.off, value, true);
    }

    @Override
    public void flush() {
        try {
            this.out.write(this.chars, 0, this.off);
            this.off = 0;
            this.out.flush();
        }
        catch (IOException e) {
            throw new JSONException("write csv error", e);
        }
    }

    @Override
    public void writeString(byte[] utf8) {
        if (utf8 == null || utf8.length == 0) {
            return;
        }
        String str = new String(utf8, StandardCharsets.UTF_8);
        this.writeString(str);
    }

    @Override
    public void writeDecimal(BigDecimal value) {
        if (value == null) {
            return;
        }
        String str = value.toString();
        int strlen = str.length();
        this.checkCapacity(24);
        str.getChars(0, strlen, this.chars, this.off);
        this.off += strlen;
    }

    @Override
    public void writeDecimal(long unscaledVal, int scale) {
        if (scale == 0) {
            this.writeInt64(unscaledVal);
            return;
        }
        if (unscaledVal == Long.MIN_VALUE || scale >= 20 || scale < 0) {
            this.writeDecimal(BigDecimal.valueOf(unscaledVal, scale));
            return;
        }
        int off = this.off;
        char[] chars = this.chars;
        if (off + 24 > chars.length) {
            this.flush();
            off = 0;
        }
        this.off = IOUtils.writeDecimal(chars, off, unscaledVal, scale);
    }

    void writeRaw(char[] chars) {
        if (chars.length + this.off < this.chars.length) {
            System.arraycopy(chars, 0, this.chars, this.off, chars.length);
            this.off += chars.length;
        } else {
            this.flush();
            if (chars.length >= this.chars.length) {
                this.writeDirect(chars, 0, chars.length);
            } else {
                System.arraycopy(chars, 0, this.chars, this.off, chars.length);
                this.off += chars.length;
            }
        }
    }

    @Override
    public void writeLocalDateTime(LocalDateTime ldt) {
        if (ldt == null) {
            return;
        }
        int off = this.off;
        char[] chars = this.chars;
        if (off + 19 > chars.length) {
            this.flush();
            off = 0;
        }
        off = IOUtils.writeLocalDate(chars, off, ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth());
        chars[off++] = 32;
        this.off = IOUtils.writeLocalTime(chars, off, ldt.toLocalTime());
    }

    @Override
    protected void writeRaw(String str) {
        if (str == null || str.isEmpty()) {
            return;
        }
        this.checkCapacity(str.length());
        str.getChars(0, str.length(), this.chars, this.off);
        this.off += str.length();
    }

    void checkCapacity(int incr) {
        if (this.off + incr >= this.chars.length) {
            this.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.off > 0) {
            this.flush();
        }
        this.out.close();
    }

    public String toString() {
        if (this.out instanceof StringWriter) {
            this.flush();
            return this.out.toString();
        }
        return super.toString();
    }
}

