/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.csv;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.support.csv.CSVWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.NumberUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.ZoneId;

final class CSVWriterUTF8
extends CSVWriter {
    private static final short DOUBLE_QUOTE_2_LATIN1 = 8738;
    final OutputStream out;
    final Charset charset;
    final byte[] bytes;

    CSVWriterUTF8(OutputStream out, Charset charset, ZoneId zoneId, CSVWriter.Feature ... features) {
        super(zoneId, features);
        this.out = out;
        this.charset = charset;
        this.bytes = new byte[524288];
    }

    void writeDirect(byte[] bytes, int off, int len) {
        try {
            this.out.write(bytes, off, len);
        }
        catch (IOException e) {
            throw new JSONException("write csv error", e);
        }
    }

    @Override
    public void writeComma() {
        this.checkCapacity(1);
        this.bytes[this.off++] = 44;
    }

    @Override
    protected void writeQuote() {
        this.checkCapacity(1);
        this.bytes[this.off++] = 34;
    }

    @Override
    public void writeLine() {
        this.checkCapacity(1);
        this.bytes[this.off++] = 10;
    }

    @Override
    public void writeBoolean(boolean v) {
        this.checkCapacity(5);
        this.off = IOUtils.putBoolean(this.bytes, this.off, v);
    }

    @Override
    public void writeInt64(long longValue) {
        this.checkCapacity(20);
        this.off = IOUtils.writeInt64(this.bytes, this.off, longValue);
    }

    @Override
    public void writeDateYYYMMDD10(int year, int month, int dayOfMonth) {
        this.checkCapacity(10);
        this.off = IOUtils.writeLocalDate(this.bytes, this.off, year, month, dayOfMonth);
    }

    @Override
    public void writeDateTime19(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        this.checkCapacity(19);
        byte[] bytes = this.bytes;
        int off = this.off;
        off = IOUtils.writeLocalDate(bytes, off, year, month, dayOfMonth);
        bytes[off] = 32;
        IOUtils.writeLocalTime(bytes, off + 1, hour, minute, second);
        this.off = off + 9;
    }

    @Override
    public void writeString(String value) {
        byte[] bytes = JDKUtils.STRING_CODER != null && JDKUtils.STRING_VALUE != null && JDKUtils.STRING_CODER.applyAsInt(value) == JDKUtils.LATIN1.byteValue() ? JDKUtils.STRING_VALUE.apply(value) : value.getBytes(this.charset);
        this.writeString(bytes);
    }

    @Override
    public void writeInt32(int intValue) {
        this.checkCapacity(11);
        this.off = IOUtils.writeInt32(this.bytes, this.off, (long)intValue);
    }

    @Override
    public void writeDouble(double value) {
        this.checkCapacity(24);
        this.off = NumberUtils.writeDouble(this.bytes, this.off, value, true);
    }

    @Override
    public void writeFloat(float value) {
        this.checkCapacity(15);
        this.off = NumberUtils.writeFloat(this.bytes, this.off, value, true);
    }

    @Override
    public void flush() {
        try {
            this.out.write(this.bytes, 0, this.off);
            this.off = 0;
            this.out.flush();
        }
        catch (IOException e) {
            throw new JSONException("write csv error", e);
        }
    }

    @Override
    public void writeString(byte[] utf8) {
        if (utf8 == null || utf8.length == 0) {
            return;
        }
        int len = utf8.length;
        int escapeCount = 0;
        boolean comma = false;
        if (utf8[0] == 34) {
            for (byte ch : utf8) {
                if (ch != 34) continue;
                ++escapeCount;
            }
        } else {
            for (byte ch : utf8) {
                if (ch == 44) {
                    comma = true;
                    continue;
                }
                if (ch != 34 && ch != 10 && ch != 13) continue;
                ++escapeCount;
            }
            if (!comma) {
                escapeCount = 0;
            }
        }
        if (escapeCount == 0 && !comma) {
            this.writeRaw(utf8);
            return;
        }
        this.checkCapacity(2 + len + escapeCount);
        byte[] bytes = this.bytes;
        int max = bytes.length - 2;
        int off = this.off;
        bytes[off++] = 34;
        for (byte ch : utf8) {
            if (ch == 34) {
                IOUtils.putShortUnaligned(bytes, off, (short)8738);
                off += 2;
            } else {
                bytes[off++] = ch;
            }
            if (off < max) continue;
            this.flush();
            off = this.off;
        }
        bytes[off++] = 34;
        this.off = off;
    }

    @Override
    public void writeDecimal(BigDecimal value) {
        if (value == null) {
            return;
        }
        String str = value.toString();
        int strlen = str.length();
        this.checkCapacity(24);
        str.getBytes(0, strlen, this.bytes, this.off);
        this.off += strlen;
    }

    @Override
    public void writeDecimal(long unscaledVal, int scale) {
        if (scale == 0) {
            this.writeInt64(unscaledVal);
            return;
        }
        if (unscaledVal == Long.MIN_VALUE || scale >= 20 || scale < 0) {
            this.writeDecimal(BigDecimal.valueOf(unscaledVal, scale));
            return;
        }
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 24 > bytes.length) {
            this.flush();
            off = 0;
        }
        this.off = IOUtils.writeDecimal(bytes, off, unscaledVal, scale);
    }

    private void writeRaw(byte[] strBytes) {
        if (strBytes.length + this.off < this.bytes.length) {
            System.arraycopy(strBytes, 0, this.bytes, this.off, strBytes.length);
            this.off += strBytes.length;
        } else {
            this.flush();
            if (strBytes.length >= this.bytes.length) {
                this.writeDirect(strBytes, 0, strBytes.length);
            } else {
                System.arraycopy(strBytes, 0, this.bytes, this.off, strBytes.length);
                this.off += strBytes.length;
            }
        }
    }

    @Override
    protected void writeRaw(String str) {
        if (str == null || str.isEmpty()) {
            return;
        }
        byte[] strBytes = str.getBytes(this.charset);
        this.writeRaw(strBytes);
    }

    @Override
    public void writeLocalDateTime(LocalDateTime ldt) {
        if (ldt == null) {
            return;
        }
        int off = this.off;
        byte[] bytes = this.bytes;
        if (off + 19 > bytes.length) {
            this.flush();
            off = 0;
        }
        off = IOUtils.writeLocalDate(bytes, off, ldt.getYear(), ldt.getMonthValue(), ldt.getDayOfMonth());
        bytes[off++] = 32;
        this.off = IOUtils.writeLocalTime(bytes, off, ldt.toLocalTime());
    }

    void checkCapacity(int incr) {
        if (this.off + incr >= this.bytes.length) {
            this.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.off > 0) {
            this.flush();
        }
        this.out.close();
    }

    public String toString() {
        if (this.out instanceof ByteArrayOutputStream) {
            this.flush();
            byte[] strBytes = ((ByteArrayOutputStream)this.out).toByteArray();
            return new String(strBytes, StandardCharsets.UTF_8);
        }
        return super.toString();
    }
}

