/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
 * This source file is part of the Cangjie project, licensed under Apache-2.0
 * with Runtime Library Exception.
 *
 * See https://cangjie-lang.cn/pages/LICENSE for license information.
 */

#ifndef DECLAREFUNCTION
#define DECLAREFUNCTION

DECLAREFUNCTION0(EVP_sm4_cbc, EVP_CIPHER*)
DECLAREFUNCTION0(EVP_sm4_ecb, EVP_CIPHER*)
DECLAREFUNCTION0(EVP_sm4_cfb, EVP_CIPHER*)
DECLAREFUNCTION0(EVP_sm4_ofb, EVP_CIPHER*)
DECLAREFUNCTION0(EVP_sm4_ctr, EVP_CIPHER*)
DECLAREFUNCTION5(
    EVP_EncryptInit_ex, int, EVP_CIPHER_CTX*, const EVP_CIPHER*, ENGINE*, const unsigned char*, const unsigned char*)
DECLAREFUNCTION5(EVP_EncryptUpdate, int, EVP_CIPHER_CTX*, unsigned char*, int*, const unsigned char*, int)
DECLAREFUNCTION3(EVP_EncryptFinal_ex, int, EVP_CIPHER_CTX*, unsigned char*, int*)
DECLAREFUNCTION2(EVP_CIPHER_CTX_set_padding, int, EVP_CIPHER_CTX*, int)
DECLAREFUNCTION1(EVP_CIPHER_free, void, EVP_CIPHER*)
DECLAREFUNCTION3(EVP_CIPHER_fetch, EVP_CIPHER*, void*, const char*, const char*)
DECLAREFUNCTION1(EVP_CIPHER_get_block_size, int, EVP_CIPHER*)
DECLAREFUNCTION4(EVP_CIPHER_CTX_ctrl, int, EVP_CIPHER_CTX*, int, int, void*)

DECLAREFUNCTION3(EVP_PKEY_CTX_set1_id, int, EVP_PKEY_CTX*, void*, size_t)
DECLAREFUNCTION5(EVP_DigestVerifyInit, int, EVP_MD_CTX*, EVP_PKEY_CTX**, const EVP_MD*, ENGINE*, EVP_PKEY*)
DECLAREFUNCTION3(EVP_DigestVerifyUpdate, int, EVP_PKEY_CTX*, void*, size_t)
DECLAREFUNCTION3(EVP_DigestVerifyFinal, int, EVP_MD_CTX*, const unsigned char*, size_t)
DECLAREFUNCTION0(EVP_MD_CTX_new, EVP_MD_CTX*)
DECLAREFUNCTION1(EVP_MD_CTX_free, void, EVP_MD_CTX*)
DECLAREFUNCTION2(EVP_MD_CTX_set_pkey_ctx, void, EVP_MD_CTX*, EVP_PKEY_CTX*)
DECLAREFUNCTION5(EVP_DigestSignInit, int, EVP_MD_CTX*, EVP_PKEY_CTX**, const EVP_MD*, ENGINE*, EVP_PKEY*)
DECLAREFUNCTION3(EVP_DigestSignUpdate, int, EVP_MD_CTX*, const void*, size_t)
DECLAREFUNCTION3(EVP_DigestSignFinal, int, EVP_MD_CTX*, unsigned char*, size_t*)
DECLAREFUNCTION2(EVP_PKEY_keygen, int, EVP_PKEY_CTX*, EVP_PKEY**)
DECLAREFUNCTION1(EVP_PKEY_keygen_init, int, EVP_PKEY_CTX*)
DECLAREFUNCTION1(EVP_PKEY_paramgen_init, int, EVP_PKEY_CTX*)

DECLAREFUNCTION0(EVP_sm3, const EVP_MD*)
DECLAREFUNCTION0(EVP_MD_CTX_new, EVP_MD_CTX*)
DECLAREFUNCTION3(EVP_DigestInit_ex, int, EVP_MD_CTX*, const EVP_MD*, ENGINE*)
DECLAREFUNCTION3(EVP_DigestUpdate, int, EVP_MD_CTX*, const char*, size_t)
DECLAREFUNCTION3(EVP_DigestFinal_ex, int, EVP_MD_CTX*, unsigned char*, unsigned int*)
DECLAREFUNCTION1(EVP_MD_CTX_free, void, EVP_MD_CTX*)
DECLAREFUNCTION1(EVP_MD_CTX_reset, int, EVP_MD_CTX*)
DECLAREFUNCTION3(SHA1, unsigned char*, char*, int32_t, char*)
DECLAREFUNCTION2(RAND_priv_bytes, int, unsigned char*, int)
DECLAREFUNCTION2(RAND_bytes, int, unsigned char*, int)
DECLAREFUNCTION4(d2i_KeyParams, EVP_PKEY*, int, EVP_PKEY**, const unsigned char**, long)
DECLAREFUNCTION1(X509_PUBKEY_free, void, X509_PUBKEY*)
DECLAREFUNCTION3(d2i_X509_PUBKEY, X509_PUBKEY*, void*, const unsigned char**, long)
DECLAREFUNCTION1(SSL_CTX_check_private_key, int, const SSL_CTX*)
DECLAREFUNCTION2(SSL_CTX_use_PrivateKey, int, SSL_CTX*, EVP_PKEY*)
DECLAREFUNCTION8(EVP_BytesToKey, int, const EVP_CIPHER*, const EVP_MD*, const unsigned char*, const unsigned char*, int,
    int, unsigned char*, unsigned char*)
DECLAREFUNCTION7(i2d_PKCS8PrivateKey_bio, int, BIO*, const EVP_PKEY*, const EVP_CIPHER*, char*, int, void*, void*)
DECLAREFUNCTION4(d2i_PKCS8PrivateKey_bio, EVP_PKEY*, BIO*, EVP_PKEY**, void*, void*)
DECLAREFUNCTION2(OPENSSL_cleanse, void, void*, size_t)
DECLAREFUNCTION1(EVP_CIPHER_CTX_free, void, EVP_CIPHER_CTX*)
DECLAREFUNCTION3(EVP_DecryptFinal_ex, int, EVP_CIPHER_CTX*, unsigned char*, int*)
DECLAREFUNCTION5(EVP_DecryptUpdate, int, EVP_CIPHER_CTX*, unsigned char*, int*, const unsigned char*, int)
DECLAREFUNCTION5(
    EVP_DecryptInit_ex, int, EVP_CIPHER_CTX*, const EVP_CIPHER*, ENGINE*, const unsigned char*, const unsigned char*)
DECLAREFUNCTION0(EVP_CIPHER_CTX_new, EVP_CIPHER_CTX*)
DECLAREFUNCTION1(EVP_get_cipherbyname, const EVP_CIPHER*, const char*)
DECLAREFUNCTION1(PKCS8_PRIV_KEY_INFO_free, void, void*)
DECLAREFUNCTION2(i2d_PKCS8_bio, int, BIO*, const X509_SIG*)
DECLAREFUNCTION4(PKCS8_set0_pbe, X509_SIG*, const char*, int, PKCS8_PRIV_KEY_INFO*, X509_ALGOR*)
DECLAREFUNCTION6(PKCS5_pbe2_set_iv, X509_ALGOR*, const EVP_CIPHER*, int, unsigned char*, int, unsigned char*, int)
DECLAREFUNCTION0(EVP_aes_256_cbc, void*)
DECLAREFUNCTION1(EVP_PKEY2PKCS8, PKCS8_PRIV_KEY_INFO*, const EVP_PKEY*)
DECLAREFUNCTION1(X509_SIG_free, void, void*)
DECLAREFUNCTION4(X509_ALGOR_get0, void, const void**, int*, const void**, const void*)
DECLAREFUNCTION3(X509_SIG_get0, void, const void*, const void**, const void**)
DECLAREFUNCTION2(d2i_PKCS8_bio, X509_SIG*, BIO*, X509_SIG*)
DECLAREFUNCTION3(BIO_read, int, BIO*, void*, int)
DECLAREFUNCTION2(PEM_write_bio_X509, int, BIO*, X509*)
DECLAREFUNCTION0(X509_REQ_new, X509_REQ*)
DECLAREFUNCTION1(ASN1_BIT_STRING_free, void, void*)
DECLAREFUNCTION2(i2d_X509_NAME, int, void*, unsigned char**)
DECLAREFUNCTION3(d2i_X509_NAME, void*, void**, const unsigned char**, long)
DECLAREFUNCTION3(X509_REQ_sign, int, X509_REQ*, EVP_PKEY*, const EVP_MD*)
DECLAREFUNCTION2(X509_REQ_set_pubkey, int, X509_REQ*, EVP_PKEY*)
DECLAREFUNCTION2(X509_REQ_set_subject_name, int, X509_REQ*, const X509_NAME*)
DECLAREFUNCTION1(OPENSSL_sk_num, int, void*)
DECLAREFUNCTION2(i2d_X509_REQ, int, void*, unsigned char**)
DECLAREFUNCTION7(X509_NAME_add_entry_by_txt, int, X509_NAME*, char*, int, const unsigned char*, int, int, int)
DECLAREFUNCTION1(X509_NAME_free, void, X509_NAME*)
DECLAREFUNCTION0(X509_NAME_new, X509_NAME*)
DECLAREFUNCTION2(X509_REQ_add_extensions, int, X509_REQ*, const STACK_OF(X509_EXTENSION) *)
DECLAREFUNCTION0(OPENSSL_sk_new_null, void*)
DECLAREFUNCTION3(X509V3_EXT_i2d, X509_EXTENSION*, int, int, void*)
DECLAREFUNCTION2(OPENSSL_sk_push, int, void*, void*)
DECLAREFUNCTION6(a2i_GENERAL_NAME, void*, void*, const void*, X509V3_CTX*, int, const char*, int)
DECLAREFUNCTION1(X509_REQ_free, void, void*)
DECLAREFUNCTIONCB2(OPENSSL_sk_pop_free, void, void* arg1, void (*arg2)(void*))
DECLAREFUNCTION1(X509_REQ_get_extensions, STACK_OF(X509_EXTENSION) *, X509_REQ*)
DECLAREFUNCTION1(X509V3_EXT_d2i, void*, X509_EXTENSION*)
DECLAREFUNCTION3(d2i_X509_REQ, X509_REQ*, X509_REQ**, const unsigned char**, long)
DECLAREFUNCTION1(X509_EXTENSION_get_object, ASN1_OBJECT*, X509_EXTENSION*)
DECLAREFUNCTION1(X509_STORE_free, void, X509_STORE*)
DECLAREFUNCTION1(X509_STORE_CTX_free, void, X509_STORE_CTX*)
DECLAREFUNCTION1(X509_verify_cert, int, X509_STORE_CTX*)
DECLAREFUNCTION4(X509_STORE_CTX_init, int, X509_STORE_CTX*, X509_STORE*, X509*, STACK_OF(X509) *)
DECLAREFUNCTION0(X509_STORE_CTX_new, X509_STORE_CTX*)
DECLAREFUNCTION0(X509_STORE_new, X509_STORE*)
DECLAREFUNCTION2(X509_STORE_add_cert, int, X509_STORE*, X509*)
DECLAREFUNCTION1(OBJ_obj2nid, int, const ASN1_OBJECT*)
DECLAREFUNCTION4(X509_get_ext_d2i, void*, const X509*, int, int*, int*)
DECLAREFUNCTION3(d2i_X509, X509*, X509**, const unsigned char**, long)
DECLAREFUNCTION1(ASN1_STRING_get0_data, const unsigned char*, const ASN1_STRING*)
DECLAREFUNCTION1(ASN1_STRING_length, int, const ASN1_STRING*)
DECLAREFUNCTION2(i2d_X509, int, void*, unsigned char**)
DECLAREFUNCTION3(d2i_AutoPrivateKey, EVP_PKEY*, EVP_PKEY**, const unsigned char**, long)
DECLAREFUNCTION1(X509_free, void, void*)
DECLAREFUNCTION3(X509_sign, int, X509*, EVP_PKEY*, const EVP_MD*)
DECLAREFUNCTION2(X509_set_pubkey, int, X509*, EVP_PKEY*)
DECLAREFUNCTION2(X509_set_issuer_name, int, X509*, const X509_NAME*)
DECLAREFUNCTION2(X509_set_subject_name, int, X509*, const X509_NAME*)
DECLAREFUNCTION2(X509_set1_notAfter, int, X509*, const ASN1_TIME*)
DECLAREFUNCTION2(X509_set1_notBefore, int, X509*, const ASN1_TIME*)
DECLAREFUNCTION1(ASN1_TIME_free, void, ASN1_TIME*)
DECLAREFUNCTION0(ASN1_TIME_new, ASN1_TIME*)
DECLAREFUNCTION2(ASN1_TIME_set_string, int, ASN1_TIME*, const char*)
DECLAREFUNCTION2(X509_set_serialNumber, int, X509*, ASN1_INTEGER*)
DECLAREFUNCTION2(BN_to_ASN1_INTEGER, ASN1_INTEGER*, const BIGNUM*, ASN1_INTEGER*)
DECLAREFUNCTION1(ASN1_INTEGER_free, void, ASN1_INTEGER*)
DECLAREFUNCTION2(BN_hex2bn, int, BIGNUM**, const char*)
DECLAREFUNCTION0(BN_new, BIGNUM*)
DECLAREFUNCTION0(ASN1_INTEGER_new, ASN1_INTEGER*)
DECLAREFUNCTION2(X509_set_version, int, X509*, long)
DECLAREFUNCTION0(X509_new, X509*)
DECLAREFUNCTION1(X509_EXTENSION_free, void, X509_EXTENSION*)
DECLAREFUNCTION3(X509_add_ext, int, X509*, X509_EXTENSION*, int)
DECLAREFUNCTION4(X509V3_EXT_conf_nid, X509_EXTENSION*, void*, X509V3_CTX*, int, const char*)
DECLAREFUNCTION1(BIO_free, int, BIO*)
DECLAREFUNCTION0(ERR_peek_error, unsigned long)
DECLAREFUNCTION1(ERR_reason_error_string, const char*, unsigned long)
DECLAREFUNCTION0(ERR_get_error, unsigned long)
DECLAREFUNCTION0(ERR_clear_error, char*)
DECLAREFUNCTION1(BIO_vfree, char*, void*)
DECLAREFUNCTION1(EVP_PKEY_get_bits, int, EVP_PKEY*)
DECLAREFUNCTION3(BIO_write, int, BIO*, const void*, int)
DECLAREFUNCTION2(BIO_puts, int, BIO*, const char*)
DECLAREFUNCTION3(CRYPTO_malloc, void*, size_t, const char*, int)
DECLAREFUNCTION0(EVP_md5, const EVP_MD*)
DECLAREFUNCTION0(EVP_sha1, const EVP_MD*)
DECLAREFUNCTION0(EVP_sha224, const EVP_MD*)
DECLAREFUNCTION0(EVP_sha256, const EVP_MD*)
DECLAREFUNCTION0(EVP_sha384, const EVP_MD*)
DECLAREFUNCTION0(EVP_sha512, const EVP_MD*)
DECLAREFUNCTION2(EVP_PKEY_CTX_set_rsa_padding, int, EVP_PKEY_CTX*, int)
DECLAREFUNCTION2(EVP_PKEY_CTX_set_signature_md, int, EVP_PKEY_CTX*, const EVP_MD*)
DECLAREFUNCTION2(EVP_PKEY_CTX_set_rsa_pss_saltlen, int, EVP_PKEY_CTX*, int)
DECLAREFUNCTION2(i2d_PrivateKey, int, const EVP_PKEY*, unsigned char**)
DECLAREFUNCTION4(d2i_PrivateKey, EVP_PKEY*, int, EVP_PKEY**, const unsigned char**, long)
DECLAREFUNCTION3(d2i_PUBKEY, EVP_PKEY*, EVP_PKEY**, const unsigned char**, long)
DECLAREFUNCTION2(i2d_PUBKEY, int, const EVP_PKEY*, unsigned char**)
DECLAREFUNCTION1(EVP_PKEY_encrypt_init, int, EVP_PKEY_CTX*)
DECLAREFUNCTION5(EVP_PKEY_encrypt, int, EVP_PKEY_CTX*, unsigned char*, size_t*, const unsigned char*, size_t)
DECLAREFUNCTION1(EVP_PKEY_decrypt_init, int, EVP_PKEY_CTX*)
DECLAREFUNCTION5(EVP_PKEY_decrypt, int, EVP_PKEY_CTX*, unsigned char*, size_t*, const unsigned char*, size_t)
DECLAREFUNCTION1(EVP_PKEY_sign_init, int, EVP_PKEY_CTX*)
DECLAREFUNCTION5(EVP_PKEY_sign, int, EVP_PKEY_CTX*, unsigned char*, size_t*, const unsigned char*, size_t)
DECLAREFUNCTION1(EVP_PKEY_verify_init, int, EVP_PKEY_CTX*)
DECLAREFUNCTION5(EVP_PKEY_verify, int, EVP_PKEY_CTX*, const unsigned char*, size_t, const unsigned char*, size_t)
DECLAREFUNCTION1(EVP_PKEY_get_size, int, const EVP_PKEY*)
DECLAREFUNCTION2(EVP_PKEY_CTX_new_id, EVP_PKEY_CTX*, int, ENGINE*)
DECLAREFUNCTION2(EVP_PKEY_CTX_new, EVP_PKEY_CTX*, EVP_PKEY*, ENGINE*)
DECLAREFUNCTION1(EVP_PKEY_free, void, EVP_PKEY*)
DECLAREFUNCTION1(EVP_PKEY_CTX_free, void, EVP_PKEY_CTX*)
DECLAREFUNCTION1(EVP_PKEY_keygen_init, int, EVP_PKEY_CTX*)
DECLAREFUNCTION2(EVP_PKEY_generate, int, EVP_PKEY_CTX*, EVP_PKEY**)
DECLAREFUNCTION1(BN_free, void, BIGNUM*)
DECLAREFUNCTION3(BN_bin2bn, BIGNUM*, const unsigned char*, int, BIGNUM*)
DECLAREFUNCTION2(EVP_PKEY_CTX_set1_rsa_keygen_pubexp, int, EVP_PKEY_CTX*, BIGNUM*)
DECLAREFUNCTION2(EVP_PKEY_CTX_set_rsa_keygen_bits, int, EVP_PKEY_CTX*, int)
DECLAREFUNCTION2(EVP_PKEY_CTX_set_ec_paramgen_curve_nid, int, EVP_PKEY_CTX*, int)
DECLAREFUNCTION1(EVP_PKEY_get_base_id, int, EVP_PKEY*)
DECLAREFUNCTION2(EVP_PKEY_CTX_set_rsa_oaep_md, int, EVP_PKEY_CTX*, const EVP_MD*)
DECLAREFUNCTION2(EVP_PKEY_CTX_set_rsa_mgf1_md, int, EVP_PKEY_CTX*, const EVP_MD*)
DECLAREFUNCTION3(EVP_PKEY_CTX_set0_rsa_oaep_label, int, EVP_PKEY_CTX*, char*, int)
DECLAREFUNCTION3(OPENSSL_strlcpy, size_t, char*, const char*, size_t)
DECLAREFUNCTION0(HMAC_CTX_new, HMAC_CTX*)
DECLAREFUNCTION1(EVP_get_digestbyname, const EVP_MD*, char*)
DECLAREFUNCTION5(HMAC_Init_ex, int, HMAC_CTX*, const void*, int, const EVP_MD*, ENGINE*)
DECLAREFUNCTION1(MD5_Init, int, MD5_CTX*)
DECLAREFUNCTION3(MD5_Update, int, MD5_CTX*, const void*, size_t)
DECLAREFUNCTION2(MD5_Final, int, unsigned char*, MD5_CTX*)
DECLAREFUNCTION1(SHA1_Init, int, SHA_CTX*)
DECLAREFUNCTION3(SHA1_Update, int, SHA_CTX*, const void*, size_t)
DECLAREFUNCTION2(SHA1_Final, int, unsigned char*, SHA_CTX*)
DECLAREFUNCTION1(SHA224_Init, int, SHA256_CTX*)
DECLAREFUNCTION3(SHA224_Update, int, SHA256_CTX*, const void*, size_t)
DECLAREFUNCTION2(SHA224_Final, int, unsigned char*, SHA256_CTX*)
DECLAREFUNCTION1(SHA256_Init, int, SHA256_CTX*)
DECLAREFUNCTION3(SHA256_Update, int, SHA256_CTX*, const void*, size_t)
DECLAREFUNCTION2(SHA256_Final, int, unsigned char*, SHA256_CTX*)
DECLAREFUNCTION1(SHA384_Init, int, SHA512_CTX*)
DECLAREFUNCTION3(SHA384_Update, int, SHA512_CTX*, const void*, size_t)
DECLAREFUNCTION2(SHA384_Final, int, unsigned char*, SHA512_CTX*)
DECLAREFUNCTION1(SHA512_Init, int, SHA512_CTX*)
DECLAREFUNCTION3(SHA512_Update, int, SHA512_CTX*, const void*, size_t)
DECLAREFUNCTION2(SHA512_Final, int, unsigned char*, SHA512_CTX*)
DECLAREFUNCTION3(HMAC_Update, int, HMAC_CTX*, const unsigned char*, size_t)
DECLAREFUNCTION3(HMAC_Final, int, HMAC_CTX*, unsigned char*, unsigned int*)
DECLAREFUNCTION1(HMAC_CTX_free, void, HMAC_CTX*)

/*----------------------------------------------------------------------------*/

DECLAREFUNCTION3(SSL_CTX_set_alpn_protos, int, SSL_CTX*, const unsigned char*, unsigned int)
DECLAREFUNCTION3(SSL_get0_alpn_selected, void, const SSL*, const unsigned char**, unsigned int*)
DECLAREFUNCTION6(CRYPTO_get_ex_new_index, int, int, long, void*, CRYPTO_EX_new*, CRYPTO_EX_dup*, CRYPTO_EX_free*)
DECLAREFUNCTION1(SSL_get_SSL_CTX, SSL_CTX*, const SSL*)
DECLAREFUNCTION3(SSL_CTX_set_ex_data, int, SSL_CTX*, int, void*)
DECLAREFUNCTION2(SSL_CTX_get_ex_data, void*, const SSL_CTX*, int)
DECLAREFUNCTION3(SSL_CTX_set_alpn_select_cb, void, SSL_CTX*, SSL_CTX_alpn_select_cb_func, void*)
DECLAREFUNCTION6(SSL_select_next_proto, int, unsigned char**, unsigned char*, const unsigned char*, unsigned int,
    const unsigned char*, unsigned int)
DECLAREFUNCTION2(SSL_CTX_set_cipher_list, int, SSL_CTX*, const char*)
DECLAREFUNCTION2(SSL_CTX_set_ciphersuites, int, SSL_CTX*, const char*)
DECLAREFUNCTION1(SSL_get0_verified_chain, STACK_OF(X509) *, const void*)
DECLAREFUNCTION1(SSL_CIPHER_get_name, const char*, const SSL_CIPHER*)
DECLAREFUNCTION2(OPENSSL_sk_value, void*, void*, int)
DECLAREFUNCTION1(SSL_get_current_cipher, SSL_CIPHER*, const SSL*)
DECLAREFUNCTION0(TLS_client_method, SSL_METHOD*)
DECLAREFUNCTION0(TLS_server_method, SSL_METHOD*)
DECLAREFUNCTION1(SSL_CTX_new, SSL_CTX*, const SSL_METHOD*)
DECLAREFUNCTION1(SSL_CTX_get_ciphers, STACK_OF(SSL_CIPHER) *, const SSL_CTX*)
DECLAREFUNCTION1(SSL_CTX_free, void, SSL_CTX*)
DECLAREFUNCTION2(SSL_get_servername, const char*, const SSL*, const int)
DECLAREFUNCTION1(SSL_get_version, const char*, const SSL*)
DECLAREFUNCTION2(PEM_read_bio_Parameters, EVP_PKEY*, BIO*, EVP_PKEY**)
DECLAREFUNCTION2(SSL_CTX_set0_tmp_dh_pkey, int, SSL_CTX*, EVP_PKEY*)
DECLAREFUNCTION1(BIO_new, BIO*, const BIO_METHOD*)
DECLAREFUNCTION0(BIO_s_mem, BIO_METHOD*)
DECLAREFUNCTION2(SSL_set_session, int, SSL*, SSL_SESSION*)
DECLAREFUNCTION1(SSL_SESSION_free, void, SSL_SESSION*)
DECLAREFUNCTION2(i2d_SSL_SESSION, int, SSL_SESSION*, unsigned char**)
DECLAREFUNCTION3(d2i_SSL_SESSION, SSL_SESSION*, SSL_SESSION**, const unsigned char**, long)
DECLAREFUNCTION2(SSL_SESSION_get0_id_context, const unsigned char*, const SSL_SESSION*, unsigned int*)
DECLAREFUNCTION3(SSL_SESSION_set1_id_context, int, SSL_SESSION*, const unsigned char*, unsigned int)
DECLAREFUNCTION1(SSL_SESSION_is_resumable, int, const SSL_SESSION*)
DECLAREFUNCTION2(SSL_CTX_add_session, int, SSL_CTX*, SSL_SESSION*)
DECLAREFUNCTION3(SSL_CTX_set_session_id_context, int, SSL_CTX*, const unsigned char*, unsigned int)
DECLAREFUNCTION2(BIO_set_init, void, BIO*, int)
DECLAREFUNCTION1(BIO_get_data, void*, BIO*)
DECLAREFUNCTION2(BIO_set_data, void, BIO*, void*)
DECLAREFUNCTION2(BIO_set_flags, void, BIO*, int)
DECLAREFUNCTION2(BIO_set_retry_reason, void, BIO*, int)
DECLAREFUNCTION0(BIO_get_new_index, int)
DECLAREFUNCTION2(BIO_meth_new, BIO_METHOD*, int, const char*)
DECLAREFUNCTIONCB2(BIO_meth_set_read, int, BIO_METHOD* arg1, int (*arg2)(BIO*, char*, int))
DECLAREFUNCTIONCB2(BIO_meth_set_puts, int, BIO_METHOD* arg1, int (*arg2)(BIO*, const char*))
DECLAREFUNCTIONCB2(BIO_meth_set_write, int, BIO_METHOD* arg1, int (*arg2)(BIO*, const char*, int))
DECLAREFUNCTIONCB2(BIO_meth_set_ctrl, int, BIO_METHOD* arg1, long (*arg2)(BIO*, int, long, void*))
DECLAREFUNCTIONCB2(BIO_meth_set_create, int, BIO_METHOD* arg1, int (*arg2)(BIO*))
DECLAREFUNCTIONCB2(BIO_meth_set_destroy, int, BIO_METHOD* arg1, int (*arg2)(BIO*))
DECLAREFUNCTION1(BIO_meth_free, void, BIO_METHOD*)
DECLAREFUNCTION4(PEM_read_bio_X509, X509*, BIO*, X509**, pem_password_cb*, void*)
DECLAREFUNCTION1(SSL_CTX_get_cert_store, X509_STORE*, const SSL_CTX*)
DECLAREFUNCTION2(SSL_CTX_use_certificate, int, SSL_CTX*, X509*)
DECLAREFUNCTION1(X509_STORE_CTX_get0_cert, X509*, const X509_STORE_CTX*)
DECLAREFUNCTION1(X509_chain_up_ref, STACK_OF(X509) *, STACK_OF(X509) *)
DECLAREFUNCTION1(X509_up_ref, int, X509*)
DECLAREFUNCTION2(X509_STORE_CTX_set0_verified_chain, void, X509_STORE_CTX*, STACK_OF(X509) *)
DECLAREFUNCTION2(X509_STORE_CTX_set_error, void, X509_STORE_CTX*, int)
DECLAREFUNCTIONCB3(
    SSL_CTX_set_cert_verify_callback, void, SSL_CTX* arg1, int (*arg2)(X509_STORE_CTX*, void*), void* arg3)
DECLAREFUNCTIONCB3(SSL_CTX_set_verify, void, SSL_CTX* arg1, int arg2, int (*arg3)(int, X509_STORE_CTX*))
DECLAREFUNCTION3(SSL_set_ex_data, int, SSL*, int, void*)
DECLAREFUNCTION2(SSL_get_ex_data, void*, const SSL*, int)
DECLAREFUNCTION1(SSL_alert_desc_string_long, const char*, int)
DECLAREFUNCTION1(SSL_alert_type_string, const char*, int)
DECLAREFUNCTION1(SSL_get_rbio, BIO*, SSL*)
DECLAREFUNCTION1(SSL_get_wbio, BIO*, SSL*)
DECLAREFUNCTION1(SSL_get_shutdown, int, const SSL*)
DECLAREFUNCTION1(SSL_shutdown, int, SSL*)
DECLAREFUNCTION3(SSL_read, int, SSL*, void*, int)
DECLAREFUNCTION2(SSL_get_error, int, const SSL*, int)
DECLAREFUNCTION3(SSL_write, int, SSL*, const void*, int)
DECLAREFUNCTION2(SSL_CTX_set_options, long, SSL_CTX*, uint64_t)
DECLAREFUNCTIONCB2(SSL_CTX_set_info_callback, void, SSL_CTX* arg1, void (*arg2)(const SSL*, int, int))
DECLAREFUNCTIONCB2(SSL_CTX_set_keylog_callback, void, SSL_CTX* arg1, void (*arg2)(const SSL*, const char*))
DECLAREFUNCTION1(SSL_CTX_set_default_verify_paths, int, SSL_CTX*)
DECLAREFUNCTION1(SSL_new, SSL*, SSL_CTX*)
DECLAREFUNCTION1(SSL_free, void, SSL*)
DECLAREFUNCTION1(SSL_is_server, int, const SSL*)
DECLAREFUNCTION1(SSL_do_handshake, int, SSL*)
DECLAREFUNCTION3(SSL_set_bio, void, SSL*, BIO*, BIO*)
DECLAREFUNCTION1(SSL_set_accept_state, void, SSL*)
DECLAREFUNCTION1(SSL_set_connect_state, void, SSL*)
DECLAREFUNCTION1(SSL_session_reused, int, const SSL*)
DECLAREFUNCTION1(SSL_get_session, SSL_SESSION*, const SSL*)
DECLAREFUNCTION1(SSL_SESSION_up_ref, int, SSL_SESSION*)
DECLAREFUNCTION2(SSL_SESSION_get_id, const unsigned char*, const SSL_SESSION*, unsigned int*)
DECLAREFUNCTION1(OPENSSL_cipher_name, const char*, const char*)
DECLAREFUNCTIONCB2(SSL_CTX_sess_set_new_cb, void, SSL_CTX* arg1, int(arg2)(SSL*, SSL_SESSION*))
DECLAREFUNCTIONCB2(SSL_CTX_sess_set_remove_cb, void, SSL_CTX* arg1, void(arg2)(SSL_CTX*, SSL_SESSION*))
DECLAREFUNCTIONCB2(
    SSL_CTX_sess_set_get_cb, void, SSL_CTX* arg1, SSL_SESSION*(arg2)(SSL*, const unsigned char*, int, int*))
DECLAREFUNCTION1(X509_STORE_CTX_get0_untrusted, STACK_OF(X509) *, const X509_STORE_CTX*)
DECLAREFUNCTION2(SSL_CTX_set_security_level, void, SSL_CTX*, int)
DECLAREFUNCTION0(OPENSSL_init, void)
DECLAREFUNCTION1(OPENSSL_sk_free, void, void*)
DECLAREFUNCTION3(OPENSSL_sk_insert, int, void*, const void*, int)

#endif