/*
 * Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
 * This source file is part of the Cangjie project, licensed under Apache-2.0
 * with Runtime Library Exception.
 *
 * See https://cangjie-lang.cn/pages/LICENSE for license information.
 */

#ifndef DEFINEFUNCTION
#define DEFINEFUNCTION

DEFINEFUNCTION0(EVP_sm4_cbc, NULL, EVP_CIPHER*)
DEFINEFUNCTION0(EVP_sm4_ecb, NULL, EVP_CIPHER*)
DEFINEFUNCTION0(EVP_sm4_cfb, NULL, EVP_CIPHER*)
DEFINEFUNCTION0(EVP_sm4_ofb, NULL, EVP_CIPHER*)
DEFINEFUNCTION0(EVP_sm4_ctr, NULL, EVP_CIPHER*)

DEFINEFUNCTION5(
    EVP_EncryptInit_ex, 0, int, EVP_CIPHER_CTX*, const EVP_CIPHER*, ENGINE*, const unsigned char*, const unsigned char*)
DEFINEFUNCTION5(EVP_EncryptUpdate, 0, int, EVP_CIPHER_CTX*, unsigned char*, int*, const unsigned char*, int)
DEFINEFUNCTION3(EVP_EncryptFinal_ex, 0, int, EVP_CIPHER_CTX*, unsigned char*, int*)
DEFINEFUNCTION2(EVP_CIPHER_CTX_set_padding, 0, int, EVP_CIPHER_CTX*, int)
DEFINEFUNCTION1(EVP_CIPHER_free, , void, EVP_CIPHER*)
DEFINEFUNCTION3(EVP_CIPHER_fetch, NULL, EVP_CIPHER*, void*, const char*, const char*)
DEFINEFUNCTION1(EVP_CIPHER_get_block_size, 0, int, EVP_CIPHER*)
DEFINEFUNCTION4(EVP_CIPHER_CTX_ctrl, 0, int, EVP_CIPHER_CTX*, int, int, void*)

DEFINEFUNCTION3(EVP_PKEY_CTX_set1_id, 0, int, EVP_PKEY_CTX*, void*, size_t)
DEFINEFUNCTION5(EVP_DigestVerifyInit, 0, int, EVP_MD_CTX*, EVP_PKEY_CTX**, const EVP_MD*, ENGINE*, EVP_PKEY*)
DEFINEFUNCTION3(EVP_DigestVerifyUpdate, 0, int, EVP_PKEY_CTX*, void*, size_t)
DEFINEFUNCTION3(EVP_DigestVerifyFinal, 0, int, EVP_MD_CTX*, const unsigned char*, size_t)
DEFINEFUNCTION2(EVP_MD_CTX_set_pkey_ctx, , void, EVP_MD_CTX*, EVP_PKEY_CTX*)
DEFINEFUNCTION5(EVP_DigestSignInit, 0, int, EVP_MD_CTX*, EVP_PKEY_CTX**, const EVP_MD*, ENGINE*, EVP_PKEY*)
DEFINEFUNCTION3(EVP_DigestSignUpdate, 0, int, EVP_MD_CTX*, const void*, size_t)
DEFINEFUNCTION3(EVP_DigestSignFinal, 0, int, EVP_MD_CTX*, unsigned char*, size_t*)
DEFINEFUNCTION2(EVP_PKEY_keygen, 0, int, EVP_PKEY_CTX*, EVP_PKEY**)
DEFINEFUNCTION1(EVP_PKEY_paramgen_init, 0, int, EVP_PKEY_CTX*)
DEFINEFUNCTION0(EVP_sm3, NULL, const EVP_MD*)
DEFINEFUNCTION0(EVP_MD_CTX_new, NULL, EVP_MD_CTX*)
DEFINEFUNCTION3(EVP_DigestInit_ex, 0, int, EVP_MD_CTX*, const EVP_MD*, ENGINE*)
DEFINEFUNCTION3(EVP_DigestUpdate, 0, int, EVP_MD_CTX*, const char*, size_t)
DEFINEFUNCTION3(EVP_DigestFinal_ex, 0, int, EVP_MD_CTX*, unsigned char*, unsigned int*)
DEFINEFUNCTION1(EVP_MD_CTX_free, , void, EVP_MD_CTX*)
DEFINEFUNCTION1(EVP_MD_CTX_reset, 0, int, EVP_MD_CTX*)
DEFINEFUNCTION3(SHA1, NULL, unsigned char*, char*, int32_t, char*)
DEFINEFUNCTION2(RAND_priv_bytes, -1, int, unsigned char*, int)
DEFINEFUNCTION2(RAND_bytes, -1, int, unsigned char*, int)
DEFINEFUNCTION4(d2i_KeyParams, NULL, EVP_PKEY*, int, EVP_PKEY**, const unsigned char**, long)
DEFINEFUNCTION1(X509_PUBKEY_free, , void, X509_PUBKEY*)
DEFINEFUNCTION3(d2i_X509_PUBKEY, NULL, X509_PUBKEY*, void*, const unsigned char**, long)
DEFINEFUNCTION1(SSL_CTX_check_private_key, 0, int, const SSL_CTX*)
DEFINEFUNCTION2(SSL_CTX_use_PrivateKey, -1, int, SSL_CTX*, EVP_PKEY*)
DEFINEFUNCTION8(EVP_BytesToKey, 0, int, const EVP_CIPHER*, const EVP_MD*, const unsigned char*, const unsigned char*,
    int, int, unsigned char*, unsigned char*)
DEFINEFUNCTION7(i2d_PKCS8PrivateKey_bio, 0, int, BIO*, const EVP_PKEY*, const EVP_CIPHER*, char*, int, void*, void*)
DEFINEFUNCTION4(d2i_PKCS8PrivateKey_bio, NULL, EVP_PKEY*, BIO*, EVP_PKEY**, void*, void*)
DEFINEFUNCTION2(OPENSSL_cleanse, , void, void*, size_t)
DEFINEFUNCTION1(EVP_CIPHER_CTX_free, , void, EVP_CIPHER_CTX*)
DEFINEFUNCTION3(EVP_DecryptFinal_ex, 0, int, EVP_CIPHER_CTX*, unsigned char*, int*)
DEFINEFUNCTION5(EVP_DecryptUpdate, 0, int, EVP_CIPHER_CTX*, unsigned char*, int*, const unsigned char*, int)
DEFINEFUNCTION5(
    EVP_DecryptInit_ex, 0, int, EVP_CIPHER_CTX*, const EVP_CIPHER*, ENGINE*, const unsigned char*, const unsigned char*)
DEFINEFUNCTION0(EVP_CIPHER_CTX_new, NULL, EVP_CIPHER_CTX*)
DEFINEFUNCTION1(EVP_get_cipherbyname, NULL, const EVP_CIPHER*, const char*)
DEFINEFUNCTION1(PKCS8_PRIV_KEY_INFO_free, , void, void*)
DEFINEFUNCTION2(i2d_PKCS8_bio, 0, int, BIO*, const X509_SIG*)
DEFINEFUNCTION4(PKCS8_set0_pbe, NULL, X509_SIG*, const char*, int, PKCS8_PRIV_KEY_INFO*, X509_ALGOR*)
DEFINEFUNCTION6(PKCS5_pbe2_set_iv, NULL, X509_ALGOR*, const EVP_CIPHER*, int, unsigned char*, int, unsigned char*, int)
DEFINEFUNCTION0(EVP_aes_256_cbc, NULL, void*)
DEFINEFUNCTION1(EVP_PKEY2PKCS8, NULL, PKCS8_PRIV_KEY_INFO*, const EVP_PKEY*)
DEFINEFUNCTION1(X509_SIG_free, , void, void*)
DEFINEFUNCTION4(X509_ALGOR_get0, , void, const void**, int*, const void**, const void*)
DEFINEFUNCTION3(X509_SIG_get0, , void, const void*, const void**, const void**)
DEFINEFUNCTION2(d2i_PKCS8_bio, NULL, X509_SIG*, BIO*, X509_SIG*)
DEFINEFUNCTION3(BIO_read, 0, int, BIO*, void*, int)
DEFINEFUNCTION2(PEM_write_bio_X509, 0, int, BIO*, X509*)
DEFINEFUNCTION0(X509_REQ_new, NULL, X509_REQ*)
DEFINEFUNCTION1(ASN1_BIT_STRING_free, , void, void*)
DEFINEFUNCTION2(OPENSSL_sk_value, NULL, void*, void*, int)
DEFINEFUNCTION2(i2d_X509_NAME, 0, int, void*, unsigned char**)
DEFINEFUNCTION3(d2i_X509_NAME, NULL, void*, void**, const unsigned char**, long)
DEFINEFUNCTION3(X509_REQ_sign, 0, int, X509_REQ*, EVP_PKEY*, const EVP_MD*)
DEFINEFUNCTION2(X509_REQ_set_pubkey, 0, int, X509_REQ*, EVP_PKEY*)
DEFINEFUNCTION2(X509_REQ_set_subject_name, 0, int, X509_REQ*, const X509_NAME*)
DEFINEFUNCTION2(i2d_X509_REQ, 0, int, void*, unsigned char**)
DEFINEFUNCTION7(X509_NAME_add_entry_by_txt, 0, int, X509_NAME*, char*, int, const unsigned char*, int, int, int)
DEFINEFUNCTION1(X509_NAME_free, , void, X509_NAME*)
DEFINEFUNCTION0(X509_NAME_new, NULL, X509_NAME*)
DEFINEFUNCTION2(X509_REQ_add_extensions, 0, int, X509_REQ*, const STACK_OF(X509_EXTENSION) *)
DEFINEFUNCTION3(X509V3_EXT_i2d, NULL, X509_EXTENSION*, int, int, void*)
DEFINEFUNCTION2(OPENSSL_sk_push, 0, int, void*, void*)
DEFINEFUNCTION6(a2i_GENERAL_NAME, NULL, void*, void*, const void*, X509V3_CTX*, int, const char*, int)
DEFINEFUNCTION1(X509_REQ_free, , void, void*)
DEFINEFUNCTIONCB2(OPENSSL_sk_pop_free, , void, void* arg1, void (*arg2)(void*))
DEFINEFUNCTION1(X509_REQ_get_extensions, NULL, STACK_OF(X509_EXTENSION) *, X509_REQ*)
DEFINEFUNCTION1(X509V3_EXT_d2i, NULL, void*, X509_EXTENSION*)
DEFINEFUNCTION3(d2i_X509_REQ, NULL, X509_REQ*, X509_REQ**, const unsigned char**, long)
DEFINEFUNCTION1(X509_EXTENSION_get_object, NULL, ASN1_OBJECT*, X509_EXTENSION*)
DEFINEFUNCTION1(X509_STORE_free, , void, X509_STORE*)
DEFINEFUNCTION1(X509_STORE_CTX_free, , void, X509_STORE_CTX*)
DEFINEFUNCTION1(X509_verify_cert, 0, int, X509_STORE_CTX*)
DEFINEFUNCTION4(X509_STORE_CTX_init, 0, int, X509_STORE_CTX*, X509_STORE*, X509*, STACK_OF(X509) *)
DEFINEFUNCTION0(X509_STORE_CTX_new, NULL, X509_STORE_CTX*)
DEFINEFUNCTION0(X509_STORE_new, NULL, X509_STORE*)
DEFINEFUNCTION2(X509_STORE_add_cert, 0, int, X509_STORE*, X509*)
DEFINEFUNCTION1(OBJ_obj2nid, 0, int, const ASN1_OBJECT*)
DEFINEFUNCTION4(X509_get_ext_d2i, NULL, void*, const X509*, int, int*, int*)
DEFINEFUNCTION3(d2i_X509, NULL, X509*, X509**, const unsigned char**, long)
DEFINEFUNCTION1(ASN1_STRING_get0_data, NULL, const unsigned char*, const ASN1_STRING*)
DEFINEFUNCTION1(ASN1_STRING_length, 0, int, const ASN1_STRING*)
DEFINEFUNCTION2(i2d_X509, 0, int, void*, unsigned char**)
DEFINEFUNCTION3(d2i_AutoPrivateKey, NULL, EVP_PKEY*, EVP_PKEY**, const unsigned char**, long)
DEFINEFUNCTION1(X509_free, , void, void*)
DEFINEFUNCTION3(X509_sign, 0, int, X509*, EVP_PKEY*, const EVP_MD*)
DEFINEFUNCTION2(X509_set_pubkey, 0, int, X509*, EVP_PKEY*)
DEFINEFUNCTION2(X509_set_issuer_name, 0, int, X509*, const X509_NAME*)
DEFINEFUNCTION2(X509_set_subject_name, 0, int, X509*, const X509_NAME*)
DEFINEFUNCTION2(X509_set1_notAfter, 0, int, X509*, const ASN1_TIME*)
DEFINEFUNCTION2(X509_set1_notBefore, 0, int, X509*, const ASN1_TIME*)
DEFINEFUNCTION1(ASN1_TIME_free, , void, ASN1_TIME*)
DEFINEFUNCTION0(ASN1_TIME_new, NULL, ASN1_TIME*)
DEFINEFUNCTION2(ASN1_TIME_set_string, 0, int, ASN1_TIME*, const char*)
DEFINEFUNCTION2(X509_set_serialNumber, 0, int, X509*, ASN1_INTEGER*)
DEFINEFUNCTION2(BN_to_ASN1_INTEGER, NULL, ASN1_INTEGER*, const BIGNUM*, ASN1_INTEGER*)
DEFINEFUNCTION1(ASN1_INTEGER_free, , void, ASN1_INTEGER*)
DEFINEFUNCTION2(BN_hex2bn, 0, int, BIGNUM**, const char*)
DEFINEFUNCTION0(BN_new, NULL, BIGNUM*)
DEFINEFUNCTION0(ASN1_INTEGER_new, NULL, ASN1_INTEGER*)
DEFINEFUNCTION2(X509_set_version, 0, int, X509*, long)
DEFINEFUNCTION0(X509_new, NULL, X509*)
DEFINEFUNCTION1(X509_EXTENSION_free, , void, X509_EXTENSION*)
DEFINEFUNCTION3(X509_add_ext, 0, int, X509*, X509_EXTENSION*, int)
DEFINEFUNCTION4(X509V3_EXT_conf_nid, NULL, X509_EXTENSION*, void*, X509V3_CTX*, int, const char*)
DEFINEFUNCTION1(BIO_free, 0, int, BIO*)
DEFINEFUNCTION0(ERR_peek_error, 0, unsigned long)
DEFINEFUNCTION1(ERR_reason_error_string, NULL, const char*, unsigned long)
DEFINEFUNCTION0(ERR_get_error, 0, unsigned long)
DEFINEFUNCTION0(ERR_clear_error, NULL, char*)
DEFINEFUNCTION1(BIO_vfree, NULL, char*, void*)
DEFINEFUNCTION1(EVP_PKEY_get_bits, 0, int, EVP_PKEY*)
DEFINEFUNCTION3(BIO_write, 0, int, BIO*, const void*, int)
DEFINEFUNCTION2(BIO_puts, 0, int, BIO*, const char*)
DEFINEFUNCTION3(CRYPTO_malloc, NULL, void*, size_t, const char*, int)
DEFINEFUNCTION0(EVP_md5, NULL, const EVP_MD*)
DEFINEFUNCTION0(EVP_sha1, NULL, const EVP_MD*)
DEFINEFUNCTION0(EVP_sha224, NULL, const EVP_MD*)
DEFINEFUNCTION0(EVP_sha256, NULL, const EVP_MD*)
DEFINEFUNCTION0(EVP_sha384, NULL, const EVP_MD*)
DEFINEFUNCTION0(EVP_sha512, NULL, const EVP_MD*)
DEFINEFUNCTION2(EVP_PKEY_CTX_set_rsa_padding, 0, int, EVP_PKEY_CTX*, int)
DEFINEFUNCTION2(EVP_PKEY_CTX_set_signature_md, 0, int, EVP_PKEY_CTX*, const EVP_MD*)
DEFINEFUNCTION2(EVP_PKEY_CTX_set_rsa_pss_saltlen, 0, int, EVP_PKEY_CTX*, int)
DEFINEFUNCTION2(i2d_PrivateKey, 0, int, const EVP_PKEY*, unsigned char**)
DEFINEFUNCTION4(d2i_PrivateKey, NULL, EVP_PKEY*, int, EVP_PKEY**, const unsigned char**, long)
DEFINEFUNCTION3(d2i_PUBKEY, NULL, EVP_PKEY*, EVP_PKEY**, const unsigned char**, long)
DEFINEFUNCTION2(i2d_PUBKEY, 0, int, const EVP_PKEY*, unsigned char**)
DEFINEFUNCTION1(EVP_PKEY_encrypt_init, 0, int, EVP_PKEY_CTX*)
DEFINEFUNCTION5(EVP_PKEY_encrypt, 0, int, EVP_PKEY_CTX*, unsigned char*, size_t*, const unsigned char*, size_t)
DEFINEFUNCTION1(EVP_PKEY_decrypt_init, 0, int, EVP_PKEY_CTX*)
DEFINEFUNCTION5(EVP_PKEY_decrypt, 0, int, EVP_PKEY_CTX*, unsigned char*, size_t*, const unsigned char*, size_t)
DEFINEFUNCTION1(EVP_PKEY_sign_init, 0, int, EVP_PKEY_CTX*)
DEFINEFUNCTION5(EVP_PKEY_sign, 0, int, EVP_PKEY_CTX*, unsigned char*, size_t*, const unsigned char*, size_t)
DEFINEFUNCTION1(EVP_PKEY_verify_init, 0, int, EVP_PKEY_CTX*)
DEFINEFUNCTION5(EVP_PKEY_verify, 0, int, EVP_PKEY_CTX*, const unsigned char*, size_t, const unsigned char*, size_t)
DEFINEFUNCTION1(EVP_PKEY_get_size, 0, int, const EVP_PKEY*)
DEFINEFUNCTION2(EVP_PKEY_CTX_new_id, NULL, EVP_PKEY_CTX*, int, ENGINE*)
DEFINEFUNCTION2(EVP_PKEY_CTX_new, NULL, EVP_PKEY_CTX*, EVP_PKEY*, ENGINE*)
DEFINEFUNCTION1(EVP_PKEY_free, , void, EVP_PKEY*)
DEFINEFUNCTION1(EVP_PKEY_CTX_free, , void, EVP_PKEY_CTX*)
DEFINEFUNCTION1(EVP_PKEY_keygen_init, 0, int, EVP_PKEY_CTX*)
DEFINEFUNCTION2(EVP_PKEY_generate, 0, int, EVP_PKEY_CTX*, EVP_PKEY**)
DEFINEFUNCTION1(BN_free, , void, BIGNUM*)
DEFINEFUNCTION3(BN_bin2bn, NULL, BIGNUM*, const unsigned char*, int, BIGNUM*)
DEFINEFUNCTION2(EVP_PKEY_CTX_set1_rsa_keygen_pubexp, 0, int, EVP_PKEY_CTX*, BIGNUM*)
DEFINEFUNCTION2(EVP_PKEY_CTX_set_rsa_keygen_bits, 0, int, EVP_PKEY_CTX*, int)
DEFINEFUNCTION2(EVP_PKEY_CTX_set_ec_paramgen_curve_nid, 0, int, EVP_PKEY_CTX*, int)
DEFINEFUNCTION1(EVP_PKEY_get_base_id, 0, int, EVP_PKEY*)
DEFINEFUNCTION2(EVP_PKEY_CTX_set_rsa_oaep_md, 0, int, EVP_PKEY_CTX*, const EVP_MD*)
DEFINEFUNCTION2(EVP_PKEY_CTX_set_rsa_mgf1_md, 0, int, EVP_PKEY_CTX*, const EVP_MD*)
DEFINEFUNCTION3(EVP_PKEY_CTX_set0_rsa_oaep_label, 0, int, EVP_PKEY_CTX*, char*, int)
DEFINEFUNCTION3(OPENSSL_strlcpy, 0, size_t, char*, const char*, size_t)
DEFINEFUNCTION0(HMAC_CTX_new, NULL, HMAC_CTX*)
DEFINEFUNCTION1(EVP_get_digestbyname, NULL, const EVP_MD*, char*)
DEFINEFUNCTION5(HMAC_Init_ex, 0, int, HMAC_CTX*, const void*, int, const EVP_MD*, ENGINE*)
DEFINEFUNCTION1(MD5_Init, 0, int, MD5_CTX*)
DEFINEFUNCTION3(MD5_Update, 0, int, MD5_CTX*, const void*, size_t)
DEFINEFUNCTION2(MD5_Final, 0, int, unsigned char*, MD5_CTX*)
DEFINEFUNCTION1(SHA1_Init, 0, int, SHA_CTX*)
DEFINEFUNCTION3(SHA1_Update, 0, int, SHA_CTX*, const void*, size_t)
DEFINEFUNCTION2(SHA1_Final, 0, int, unsigned char*, SHA_CTX*)
DEFINEFUNCTION1(SHA224_Init, 0, int, SHA256_CTX*)
DEFINEFUNCTION3(SHA224_Update, 0, int, SHA256_CTX*, const void*, size_t)
DEFINEFUNCTION2(SHA224_Final, 0, int, unsigned char*, SHA256_CTX*)
DEFINEFUNCTION1(SHA256_Init, 0, int, SHA256_CTX*)
DEFINEFUNCTION3(SHA256_Update, 0, int, SHA256_CTX*, const void*, size_t)
DEFINEFUNCTION2(SHA256_Final, 0, int, unsigned char*, SHA256_CTX*)
DEFINEFUNCTION1(SHA384_Init, 0, int, SHA512_CTX*)
DEFINEFUNCTION3(SHA384_Update, 0, int, SHA512_CTX*, const void*, size_t)
DEFINEFUNCTION2(SHA384_Final, 0, int, unsigned char*, SHA512_CTX*)
DEFINEFUNCTION1(SHA512_Init, 0, int, SHA512_CTX*)
DEFINEFUNCTION3(SHA512_Update, 0, int, SHA512_CTX*, const void*, size_t)
DEFINEFUNCTION2(SHA512_Final, 0, int, unsigned char*, SHA512_CTX*)
DEFINEFUNCTION3(HMAC_Update, 0, int, HMAC_CTX*, const unsigned char*, size_t)
DEFINEFUNCTION3(HMAC_Final, 0, int, HMAC_CTX*, unsigned char*, unsigned int*)
DEFINEFUNCTION1(HMAC_CTX_free, , void, HMAC_CTX*)

/*----------------------------------------------------------------------------*/

DEFINEFUNCTION3(SSL_CTX_set_alpn_protos, -1, int, SSL_CTX*, const unsigned char*, unsigned int)
DEFINEFUNCTION3(SSL_get0_alpn_selected, , void, const SSL*, const unsigned char**, unsigned int*)
DEFINEFUNCTION6(CRYPTO_get_ex_new_index, -1, int, int, long, void*, CRYPTO_EX_new*, CRYPTO_EX_dup*, CRYPTO_EX_free*)
DEFINEFUNCTION1(SSL_get_SSL_CTX, NULL, SSL_CTX*, const SSL*)
DEFINEFUNCTION3(SSL_CTX_set_ex_data, 0, int, SSL_CTX*, int, void*)
DEFINEFUNCTION2(SSL_CTX_get_ex_data, NULL, void*, const SSL_CTX*, int)
DEFINEFUNCTION3(SSL_CTX_set_alpn_select_cb, , void, SSL_CTX*, SSL_CTX_alpn_select_cb_func, void*)
DEFINEFUNCTION6(SSL_select_next_proto, -1, int, unsigned char**, unsigned char*, const unsigned char*, unsigned int,
    const unsigned char*, unsigned int)
DEFINEFUNCTION2(SSL_CTX_set_cipher_list, -1, int, SSL_CTX*, const char*)
DEFINEFUNCTION2(SSL_CTX_set_ciphersuites, -1, int, SSL_CTX*, const char*)
DEFINEFUNCTION1(SSL_get0_verified_chain, NULL, STACK_OF(X509) *, const void*)
DEFINEFUNCTION1(SSL_CIPHER_get_name, NULL, const char*, const SSL_CIPHER*)
DEFINEFUNCTION1(SSL_get_current_cipher, NULL, SSL_CIPHER*, const SSL*)
DEFINEFUNCTION0(TLS_client_method, NULL, SSL_METHOD*)
DEFINEFUNCTION0(TLS_server_method, NULL, SSL_METHOD*)
DEFINEFUNCTION1(SSL_CTX_new, NULL, SSL_CTX*, const SSL_METHOD*)
DEFINEFUNCTION1(SSL_CTX_get_ciphers, NULL, STACK_OF(SSL_CIPHER) *, const SSL_CTX*)
DEFINEFUNCTION1(OPENSSL_sk_num, -1, int, void*)
DEFINEFUNCTION1(SSL_CTX_free, , void, SSL_CTX*)
DEFINEFUNCTION2(SSL_get_servername, NULL, const char*, const SSL*, const int)
DEFINEFUNCTION1(SSL_get_version, NULL, const char*, const SSL*)
DEFINEFUNCTION2(PEM_read_bio_Parameters, NULL, EVP_PKEY*, BIO*, EVP_PKEY**)
DEFINEFUNCTION2(SSL_CTX_set0_tmp_dh_pkey, -1, int, SSL_CTX*, EVP_PKEY*)
DEFINEFUNCTION1(BIO_new, NULL, BIO*, const BIO_METHOD*)
DEFINEFUNCTION0(BIO_s_mem, NULL, BIO_METHOD*)
DEFINEFUNCTION2(SSL_set_session, 0, int, SSL*, SSL_SESSION*)
DEFINEFUNCTION1(SSL_SESSION_free, , void, SSL_SESSION*)
DEFINEFUNCTION2(i2d_SSL_SESSION, 0, int, SSL_SESSION*, unsigned char**)
DEFINEFUNCTION3(d2i_SSL_SESSION, NULL, SSL_SESSION*, SSL_SESSION**, const unsigned char**, long)
DEFINEFUNCTION2(SSL_SESSION_get0_id_context, NULL, const unsigned char*, const SSL_SESSION*, unsigned int*)
DEFINEFUNCTION3(SSL_SESSION_set1_id_context, 0, int, SSL_SESSION*, const unsigned char*, unsigned int)
DEFINEFUNCTION1(SSL_SESSION_is_resumable, 0, int, const SSL_SESSION*)
DEFINEFUNCTION2(SSL_CTX_add_session, 0, int, SSL_CTX*, SSL_SESSION*)
DEFINEFUNCTION3(SSL_CTX_set_session_id_context, 0, int, SSL_CTX*, const unsigned char*, unsigned int)
DEFINEFUNCTION2(BIO_set_init, , void, BIO*, int)
DEFINEFUNCTION1(BIO_get_data, NULL, void*, BIO*)
DEFINEFUNCTION2(BIO_set_data, , void, BIO*, void*)
DEFINEFUNCTION2(BIO_set_flags, , void, BIO*, int)
DEFINEFUNCTION2(BIO_set_retry_reason, , void, BIO*, int)
DEFINEFUNCTION0(BIO_get_new_index, -1, int)
DEFINEFUNCTION2(BIO_meth_new, NULL, BIO_METHOD*, int, const char*)
DEFINEFUNCTIONCB2(BIO_meth_set_read, 0, int, BIO_METHOD* arg1, int (*arg2)(BIO*, char*, int))
DEFINEFUNCTIONCB2(BIO_meth_set_puts, 0, int, BIO_METHOD* arg1, int (*arg2)(BIO*, const char*))
DEFINEFUNCTIONCB2(BIO_meth_set_write, 0, int, BIO_METHOD* arg1, int (*arg2)(BIO*, const char*, int))
DEFINEFUNCTIONCB2(BIO_meth_set_ctrl, 0, int, BIO_METHOD* arg1, long (*arg2)(BIO*, int, long, void*))
DEFINEFUNCTIONCB2(BIO_meth_set_create, 0, int, BIO_METHOD* arg1, int (*arg2)(BIO*))
DEFINEFUNCTIONCB2(BIO_meth_set_destroy, 0, int, BIO_METHOD* arg1, int (*arg2)(BIO*))
DEFINEFUNCTION1(BIO_meth_free, , void, BIO_METHOD*)
DEFINEFUNCTION4(PEM_read_bio_X509, NULL, X509*, BIO*, X509**, pem_password_cb*, void*)
DEFINEFUNCTION1(SSL_CTX_get_cert_store, NULL, X509_STORE*, const SSL_CTX*)
DEFINEFUNCTION2(SSL_CTX_use_certificate, 0, int, SSL_CTX*, X509*)
DEFINEFUNCTION1(X509_STORE_CTX_get0_cert, NULL, X509*, const X509_STORE_CTX*)
DEFINEFUNCTION1(X509_chain_up_ref, NULL, STACK_OF(X509) *, STACK_OF(X509) *)
DEFINEFUNCTION1(X509_up_ref, 0, int, X509*)
DEFINEFUNCTION2(X509_STORE_CTX_set0_verified_chain, , void, X509_STORE_CTX*, STACK_OF(X509) *)
DEFINEFUNCTION2(X509_STORE_CTX_set_error, , void, X509_STORE_CTX*, int)
DEFINEFUNCTIONCB3(
    SSL_CTX_set_cert_verify_callback, , void, SSL_CTX* arg1, int (*arg2)(X509_STORE_CTX*, void*), void* arg3)
DEFINEFUNCTIONCB3(SSL_CTX_set_verify, , void, SSL_CTX* arg1, int arg2, int (*arg3)(int, X509_STORE_CTX*))
DEFINEFUNCTION3(SSL_set_ex_data, -1, int, SSL*, int, void*)
DEFINEFUNCTION2(SSL_get_ex_data, NULL, void*, const SSL*, int)
DEFINEFUNCTION1(SSL_alert_desc_string_long, NULL, const char*, int)
DEFINEFUNCTION1(SSL_alert_type_string, NULL, const char*, int)
DEFINEFUNCTION1(SSL_get_rbio, NULL, BIO*, SSL*)
DEFINEFUNCTION1(SSL_get_wbio, NULL, BIO*, SSL*)
DEFINEFUNCTION1(SSL_get_shutdown, 0, int, const SSL*)
DEFINEFUNCTION1(SSL_shutdown, 0, int, SSL*)
DEFINEFUNCTION3(SSL_read, 0, int, SSL*, void*, int)
DEFINEFUNCTION2(SSL_get_error, 0, int, const SSL*, int)
DEFINEFUNCTION3(SSL_write, 0, int, SSL*, const void*, int)
DEFINEFUNCTION2(SSL_CTX_set_options, 0, long, SSL_CTX*, uint64_t)
DEFINEFUNCTIONCB2(SSL_CTX_set_info_callback, , void, SSL_CTX* arg1, void (*arg2)(const SSL*, int, int))
DEFINEFUNCTIONCB2(SSL_CTX_set_keylog_callback, , void, SSL_CTX* arg1, void (*arg2)(const SSL*, const char*))
DEFINEFUNCTION1(SSL_CTX_set_default_verify_paths, 0, int, SSL_CTX*)
DEFINEFUNCTION1(SSL_new, NULL, SSL*, SSL_CTX*)
DEFINEFUNCTION1(SSL_free, , void, SSL*)
DEFINEFUNCTION1(SSL_is_server, 0, int, const SSL*)
DEFINEFUNCTION1(SSL_do_handshake, 0, int, SSL*)
DEFINEFUNCTION3(SSL_set_bio, , void, SSL*, BIO*, BIO*)
DEFINEFUNCTION1(SSL_set_accept_state, , void, SSL*)
DEFINEFUNCTION1(SSL_set_connect_state, , void, SSL*)
DEFINEFUNCTION1(SSL_session_reused, 0, int, const SSL*)
DEFINEFUNCTION1(SSL_get_session, NULL, SSL_SESSION*, const SSL*)
DEFINEFUNCTION1(SSL_SESSION_up_ref, 0, int, SSL_SESSION*)
DEFINEFUNCTION2(SSL_SESSION_get_id, NULL, const unsigned char*, const SSL_SESSION*, unsigned int*)
DEFINEFUNCTION1(OPENSSL_cipher_name, NULL, const char*, const char*)
DEFINEFUNCTIONCB2(SSL_CTX_sess_set_new_cb, , void, SSL_CTX* arg1, int(arg2)(SSL*, SSL_SESSION*))
DEFINEFUNCTIONCB2(SSL_CTX_sess_set_remove_cb, , void, SSL_CTX* arg1, void(arg2)(SSL_CTX*, SSL_SESSION*))
DEFINEFUNCTIONCB2(
    SSL_CTX_sess_set_get_cb, , void, SSL_CTX* arg1, SSL_SESSION*(arg2)(SSL*, const unsigned char*, int, int*))
DEFINEFUNCTION1(X509_STORE_CTX_get0_untrusted, NULL, STACK_OF(X509) *, const X509_STORE_CTX*)
DEFINEFUNCTION2(SSL_CTX_set_security_level, , void, SSL_CTX*, int)
DEFINEFUNCTION0(OPENSSL_init, , void)
DEFINEFUNCTION1(OPENSSL_sk_free, , void, void*)
DEFINEFUNCTION3(OPENSSL_sk_insert, 0, int, void*, const void*, int)
DEFINEFUNCTION0(OPENSSL_sk_new_null, NULL, void*)

#endif