- [Cangjie Programming Language Standard Library API](std_en/std_module_overview.md)
    - [std.core](std_en/core/core_package_overview.md)
        - [Functions](std_en/core/core_package_api/core_package_funcs.md)
        - [Type Aliases](std_en/core/core_package_api/core_package_types.md)
        - [Built-in Types](std_en/core/core_package_api/core_package_intrinsics.md)
        - [Interfaces](std_en/core/core_package_api/core_package_interfaces.md)
        - [Classes](std_en/core/core_package_api/core_package_classes.md)
        - [Enums](std_en/core/core_package_api/core_package_enums.md)
        - [Structs](std_en/core/core_package_api/core_package_structs.md)
        - [Exception Classes](std_en/core/core_package_api/core_package_exceptions.md)
        - [Tutorial Examples]()
            - [Cangjie Concurrent Programming Example](std_en/core/core_samples/core_spawn_sample.md)
            - [CString Interoperability with C Code Example](std_en/core/core_samples/core_cstring_sample.md)
    - [std.argopt](std_en/argopt/argopt_package_overview.md)
        - [Functions](std_en/argopt/argopt_package_api/argopt_package_function.md)
        - [Classes](std_en/argopt/argopt_package_api/argopt_package_classes.md)
        - [Enums](std_en/argopt/argopt_package_api/argopt_package_enums.md)
        - [Structs](std_en/argopt/argopt_package_api/argopt_package_struct.md)
        - [Exception Classes](std_en/argopt/argopt_package_api/argopt_package_exception.md)
        - [Tutorial Examples]()
            - [Command-line Argument Parsing](std_en/argopt/argopt_samples/argument_parse.md)
            - [Long Command-line Argument Parsing <sup>(deprecated)</sup>](std_en/argopt/argopt_samples/long_argument_parse.md)
            - [Short Command-line Argument Parsing <sup>(deprecated)</sup>](std_en/argopt/argopt_samples/short_argument_parse.md)
    - [std.ast](std_en/ast/ast_package_overview.md)
        - [Functions](std_en/ast/ast_package_api/ast_package_funcs.md)
        - [Interfaces](std_en/ast/ast_package_api/ast_package_interfaces.md)
        - [Classes](std_en/ast/ast_package_api/ast_package_classes.md)
        - [Enums](std_en/ast/ast_package_api/ast_package_enums.md)
        - [Structs](std_en/ast/ast_package_api/ast_package_structs.md)
        - [Exception Classes](std_en/ast/ast_package_api/ast_package_exceptions.md)
        - [Tutorial Examples]()
            - [Macro With Context](std_en/ast/ast_samples/context.md)
            - [Syntax Tree Node Printing](std_en/ast/ast_samples/dump.md)
            - [AST Object Manipulation Example](std_en/ast/ast_samples/operate.md)
            - [Parsing Cangjie Source Code into AST Objects Example](std_en/ast/ast_samples/parse.md)
            - [Custom Error Reporting Interface](std_en/ast/ast_samples/report.md)
            - [Custom Visitor Function for AST Traversal Example](std_en/ast/ast_samples/traverse.md)
    - [std.binary](std_en/binary/binary_package_overview.md)
        - [Interfaces](std_en/binary/binary_package_api/binary_package_interfaces.md)
    - [std.collection](std_en/collection/collection_package_overview.md)
        - [Functions](std_en/collection/collection_package_api/collection_package_function.md)
        - [Interfaces](std_en/collection/collection_package_api/collection_package_interface.md)
        - [Classes](std_en/collection/collection_package_api/collection_package_class.md)
        - [Exception Classes](std_en/collection/collection_package_api/collection_package_exception.md)
        - [Tutorial Examples]()
            - [ArrayList add Function](std_en/collection/collection_package_samples/sample_arraylist_add.md)
            - [ArrayList get/set Functions](std_en/collection/collection_package_samples/sample_arraylist_get_set.md)
            - [ArrayList remove/clear/slice Functions](std_en/collection/collection_package_samples/sample_arraylist_remove_clear_slice.md)
            - [HashMap get/add/contains Functions](std_en/collection/collection_package_samples/sample_hashmap_get_add_contains.md)
            - [HashMap add/remove/clear Functions](std_en/collection/collection_package_samples/sample_hashmap_add_remove_clear.md)
            - [HashSet add/iterator/remove Functions](std_en/collection/collection_package_samples/sample_hashset_add_iterator_remove.md)
            - [TreeSet add/iterator/remove Functions](std_en/collection/collection_package_samples/sample_treeset_add_iterator_remove.md)
            - [Iterator Operation Functions](std_en/collection/collection_package_samples/sample_iterator.md)
    - [std.collection.concurrent](std_en/collection_concurrent/collection_concurrent_package_overview.md)
        - [Type Aliases](std_en/collection_concurrent/collection_concurrent_package_api/collection_concurrent_types.md)
        - [Interfaces](std_en/collection_concurrent/collection_concurrent_package_api/collection_concurrent_interface.md)
        - [Classes](std_en/collection_concurrent/collection_concurrent_package_api/collection_concurrent_class.md)
        - [Tutorial Examples]()
            - [ConcurrentHashMap Usage Example](std_en/collection_concurrent/collection_concurrent_samples/sample_concurrenthashmap.md)
            - [ConcurrentLinkedQueue Usage Example](std_en/collection_concurrent/collection_concurrent_samples/sample_concurrent_linked_queue.md)
    - [std.console](std_en/console/console_package_overview.md)
        - [Classes](std_en/console/console_package_api/console_package_class.md)
        - [Tutorial Examples]()
            - [Console Example](std_en/console/console_samples/console_sample.md)
    - [std.convert](std_en/convert/convert_package_overview.md)
        - [Interfaces](std_en/convert/convert_package_api/convert_package_interfaces.md)
        - [Tutorial Examples]()
            - [Convert Usage Example](std_en/convert/convert_samples/convert_samples.md)
    - [std.crypto.cipher](std_en/crypto/cipher/cipher_package_overview.md)
        - [Interfaces](std_en/crypto/cipher/cipher_package_api/cipher_package_interfaces.md)
    - [std.crypto.digest](std_en/crypto/digest/digest_package_overview.md)
        - [Functions](std_en/crypto/digest/digest_package_api/digest_package_funcs.md)
        - [Interfaces](std_en/crypto/digest/digest_package_api/digest_package_interfaces.md)
    - [std.database.sql](std_en/database_sql/database_sql_package_overview.md)
        - [Interfaces](std_en/database_sql/database_sql_package_api/database_sql_package_interfaces.md)
        - [Classes](std_en/database_sql/database_sql_package_api/database_sql_package_classes.md)
        - [Enums](std_en/database_sql/database_sql_package_api/database_sql_package_enums.md)
        - [Exception Classes](std_en/database_sql/database_sql_package_api/database_sql_package_exceptions.md)
        - [Tutorial Examples]()
            - [Database Connection Acquisition Example](std_en/database_sql/database_sql_samples/db_get_connection.md)
            - [Table Deletion/Creation Example](std_en/database_sql/database_sql_samples/db_modify_table.md)
            - [Database Operation Execution Example](std_en/database_sql/database_sql_samples/db_operations.md)
            - [Transaction Control Statement Execution Example](std_en/database_sql/database_sql_samples/db_transactions.md)
    - [std.deriving](std_en/deriving/deriving_package_overview.md)
        - [Macros](std_en/deriving/deriving_package_api/deriving_package_macros.md)
        - [Tutorial Examples]()
            - [Deriving Example](std_en/deriving/deriving_samples/deriving_user_guide.md)
    - [std.env](std_en/env/env_package_overview.md)
        - [Functions](std_en/env/env_package_api/env_package_funcs.md)
        - [Classes](std_en/env/env_package_api/env_package_classes.md)
        - [Exception Classes](std_en/env/env_package_api/env_package_exceptions.md)
        - [Tutorial Examples]()
            - [Environment Example](std_en/env/env_samples/env_sample.md)
    - [std.fs](std_en/fs/fs_package_overview.md)
        - [Functions](std_en/fs/fs_package_api/fs_package_funcs.md)
        - [Classes](std_en/fs/fs_package_api/fs_package_classes.md)
        - [Enums](std_en/fs/fs_package_api/fs_package_enums.md)
        - [Structs](std_en/fs/fs_package_api/fs_package_structs.md)
        - [Exception Classes](std_en/fs/fs_package_api/fs_package_exceptions.md)
        - [Tutorial Examples]()
            - [Directory Example](std_en/fs/fs_samples/directory_samples.md)
            - [File Example](std_en/fs/fs_samples/file_samples.md)
            - [FileInfo Example](std_en/fs/fs_samples/fileinfo_samples.md)
            - [Path Example](std_en/fs/fs_samples/path_samples.md)
    - [std.io](std_en/io/io_package_overview.md)
        - [Functions](std_en/io/io_package_api/io_package_funcs.md)
        - [Interfaces](std_en/io/io_package_api/io_package_interfaces.md)
        - [Classes](std_en/io/io_package_api/io_package_classes.md)
        - [Enums](std_en/io/io_package_api/io_package_enums.md)
        - [Exception Classes](std_en/io/io_package_api/io_package_exceptions.md)
        - [Tutorial Examples]()
            - [BufferedInputStream Example](std_en/io/io_samples/buffered_input_stream.md)
            - [BufferedOutputStream Example](std_en/io/io_samples/buffered_output_stream.md)
            - [ByteBuffer Example](std_en/io/io_samples/byte_buffer.md)
            - [ChainedInputStream Example](std_en/io/io_samples/chained_input_stream.md)
            - [MultiOutputStream Example](std_en/io/io_samples/multi_output_stream.md)
            - [StringReader Example](std_en/io/io_samples/string_reader.md)
            - [StringWriter Example](std_en/io/io_samples/string_writer.md)
    - [std.math](std_en/math/math_package_overview.md)
        - [Interfaces](std_en/math/math_package_api/math_package_interfaces.md)
        - [Functions](std_en/math/math_package_api/math_package_funcs.md)
        - [Enums](std_en/math/math_package_api/math_package_enums.md)
        - [Tutorial Examples]()
            - [Basic Math Operations Example](std_en/math/math_samples/math_basic_operation.md)
    - [std.math.numeric](std_en/math_numeric/math_numeric_package_overview.md)
        - [Functions](std_en/math_numeric/math_numeric_package_api/math_numeric_package_funcs.md)
        - [Enums](std_en/math_numeric/math_numeric_package_api/math_numeric_package_enums.md)
        - [Structs](std_en/math_numeric/math_numeric_package_api/math_numeric_package_structs.md)
        - [Tutorial Examples]()
            - [BigInt Basic Arithmetic Operations Example](std_en/math_numeric/math_numeric_samples/bigInt_basic_arithmetic.md)
            - [BigInt Basic Properties Example](std_en/math_numeric/math_numeric_samples/bigInt_basic_prop.md)
            - [BigInt Comparison Operations Example](std_en/math_numeric/math_numeric_samples/bigInt_compare_opration.md)
            - [Decimal Basic Arithmetic Operations Example](std_en/math_numeric/math_numeric_samples/decimal_basic_arithmetic.md)
            - [Decimal Basic Properties Example](std_en/math_numeric/math_numeric_samples/decimal_basic_prop.md)
            - [Decimal Comparison Operations Example](std_en/math_numeric/math_numeric_samples/decimal_compare_opration.md)
    - [std.net](std_en/net/net_package_overview.md)
        - [Interfaces](std_en/net/net_package_api/net_package_interfaces.md)
        - [Classes](std_en/net/net_package_api/net_package_classes.md)
        - [Enums](std_en/net/net_package_api/net_package_enums.md)
        - [Structs](std_en/net/net_package_api/net_package_structs.md)
        - [Exception Classes](std_en/net/net_package_api/net_package_exceptions.md)
        - [Tutorial Examples]()
            - [Property Configuration Usage Example](std_en/net/net_samples/socket_option.md)
            - [TCP Usage Example](std_en/net/net_samples/tcp.md)
            - [UDP Usage Example](std_en/net/net_samples/udp.md)
            - [UNIX Usage Example](std_en/net/net_samples/unix.md)
            - [UnixDatagram Usage Example](std_en/net/net_samples/unix_datagram.md)
    - [std.objectpool](std_en/objectpool/objectpool_package_overview.md)
        - [Classes](std_en/objectpool/objectpool_package_api/objectpool_package_classes.md)
    - [std.overflow](std_en/overflow/overflow_package_overview.md)```markdown
        - [Interfaces](std_en/overflow/overflow_package_api/overflow_package_interfaces.md)
        - [Exception Classes](std_en/overflow/overflow_package_api/overflow_package_exceptions.md)
        - [Tutorial Examples]()
            - [Example of `Option` Strategy](std_en/overflow/overflow_samples/option.md)
            - [Example of Saturating Strategy](std_en/overflow/overflow_samples/saturating.md)
            - [Example of Exception-Throwing Strategy](std_en/overflow/overflow_samples/throwing.md)
            - [Example of Wrapping Strategy](std_en/overflow/overflow_samples/wrapping.md)
    - [std.posix](std_en/posix/posix_package_overview.md)
        - [Variables & Constants](std_en/posix/posix_package_api/posix_package_constants_vars.md)
        - [Functions](std_en/posix/posix_package_api/posix_package_funcs.md)
        - [Tutorial Examples]()
            - [File Content Operations](std_en/posix/posix_samples/posix_get_file_content_samples.md)
            - [File Information Operations](std_en/posix/posix_samples/posix_get_file_info_samples.md)
            - [Retrieving System Information](std_en/posix/posix_samples/posix_get_os_envinfo_samples.md)
            - [Process-Related Operations](std_en/posix/posix_samples/posix_process_samples.md)
    - [std.process](std_en/process/process_package_overview.md)
        - [Functions](std_en/process/process_package_api/process_package_funcs.md)
        - [Classes](std_en/process/process_package_api/process_package_classes.md)
        - [Enums](std_en/process/process_package_api/process_package_enums.md)
        - [Exception Classes](std_en/process/process_package_api/process_package_exceptions.md)
        - [Tutorial Examples]()
            - [General Process Operations](std_en/process/process_samples/process_sample.md)
            - [Subprocess Operations](std_en/process/process_samples/process_subprocess_sample.md)
    - [std.random](std_en/random/random_package_overview.md)
        - [Classes](std_en/random/random_package_api/random_package_classes.md)
    - [std.ref](std_en/ref/ref_package_overview.md)
        - [Classes](std_en/ref/ref_package_api/ref_package_classes.md)
        - [Enums](std_en/ref/ref_package_api/ref_package_enums.md)
        - [Tutorial Examples]()
            - [WeakRef for Caching](std_en/ref/ref_samples/weakref_in_cache.md)
    - [std.reflect](std_en/reflect/reflect_package_overview.md)
        - [Functions](std_en/reflect/reflect_package_api/reflect_package_funcs.md)
        - [Type Aliases](std_en/reflect/reflect_package_api/reflect_package_types.md)
        - [Classes](std_en/reflect/reflect_package_api/reflect_package_classes.md)
        - [Enums](std_en/reflect/reflect_package_api/reflect_package_enums.md)
        - [Exception Classes](std_en/reflect/reflect_package_api/reflect_package_exceptions.md)
        - [Tutorial Examples]()
            - [Annotation Usage](std_en/reflect/reflect_samples/annotation.md)
            - [Dynamic Loading Usage](std_en/reflect/reflect_samples/dynload.md)
            - [MemberInfo Usage](std_en/reflect/reflect_samples/memberInfo.md)
            - [TypeInfo Usage](std_en/reflect/reflect_samples/typeInfo.md)
    - [std.regex](std_en/regex/regex_package_overview.md)
        - [Classes](std_en/regex/regex_package_api/regex_package_classes.md)
        - [Enums](std_en/regex/regex_package_api/regex_package_enums.md)
        - [Structs](std_en/regex/regex_package_api/regex_package_structs.md)
        - [Exception Classes](std_en/regex/regex_package_api/regex_package_exceptions.md)
        - [Tutorial Examples]()
            - [Regex Example](std_en/regex/regex_samples/regex_sample.md)
    - [std.runtime](std_en/runtime/runtime_package_overview.md)
        - [Functions](std_en/runtime/runtime_package_api/runtime_package_funcs.md)
        - [Structs](std_en/runtime/runtime_package_api/runtime_package_structs.md)
    - [std.sort](std_en/sort/sort_package_overview.md)
        - [Functions](std_en/sort/sort_package_api/sort_package_funcs.md)
        - [Interfaces](std_en/sort/sort_package_api/sort_package_interfaces.md)
        - [Tutorial Examples]()
            - [Sorting Arrays](std_en/sort/sort_samples/sort_sample_array.md)
    - [std.sync](std_en/sync/sync_package_overview.md)
        - [Variables & Constants](std_en/sync/sync_package_api/sync_package_constants_vars.md)
        - [Interfaces](std_en/sync/sync_package_api/sync_package_interfaces.md)
        - [Classes](std_en/sync/sync_package_api/sync_package_classes.md)
        - [Enums](std_en/sync/sync_package_api/sync_package_enums.md)
        - [Structs](std_en/sync/sync_package_api/sync_package_structs.md)
        - [Exception Classes](std_en/sync/sync_package_api/sync_package_exceptions.md)
        - [Tutorial Examples]()
            - [Examples](std_en/sync/sync_samples/sync_samples.md)
    - [std.time](std_en/time/time_package_overview.md)
        - [Classes](std_en/time/time_package_api/time_package_classes.md)
        - [Enums](std_en/time/time_package_api/time_package_enums.md)
        - [Structs](std_en/time/time_package_api/time_package_structs.md)
        - [Exception Classes](std_en/time/time_package_api/time_package_exceptions.md)
        - [Tutorial Examples]()
            - [DateTime Comparison](std_en/time/time_samples/datetime_compare.md)
            - [DateTime and String Conversion](std_en/time/time_samples/datetime_parse.md)
            - [Retrieving DateTime Information](std_en/time/time_samples/datetime_prop.md)
            - [Local Time in Different Timezones](std_en/time/time_samples/datetime_tz.md)
            - [Timing with MonoTime](std_en/time/time_samples/monotime_test.md)
    - [std.unicode](std_en/unicode/unicode_package_overview.md)
        - [Interfaces](std_en/unicode/unicode_package_api/unicode_package_interfaces.md)
        - [Enums](std_en/unicode/unicode_package_api/unicode_package_enums.md)
    - [std.unittest](std_en/unittest/unittest_package_overview.md)
        - [Functions](std_en/unittest/unittest_package_api/unittest_package_functions.md)
        - [Type Aliases](std_en/unittest/unittest_package_api/unittest_package_types.md)
        - [Interfaces](std_en/unittest/unittest_package_api/unittest_package_interfaces.md)
        - [Classes](std_en/unittest/unittest_package_api/unittest_package_classes.md)
        - [Enums](std_en/unittest/unittest_package_api/unittest_package_enums.md)
        - [Structs](std_en/unittest/unittest_package_api/unittest_package_structs.md)
        - [Exception Classes](std_en/unittest/unittest_package_api/unittest_package_exceptions.md)
        - [Tutorial Examples]()
            - [Quick Start](std_en/unittest/unittest_samples/unittest_getting_started.md)
            - [Basic Concepts](std_en/unittest/unittest_samples/unittest_basics.md)
            - [Parameterized Tests](std_en/unittest/unittest_samples/unittest_parameterized_tests.md)
            - [Dynamic Tests](std_en/unittest/unittest_samples/unittest_dynamic_tests.md)
            - [Test Templates](std_en/unittest/unittest_samples/unittest_test_templates.md)
            - [Benchmarking](std_en/unittest/unittest_samples/unittest_benchmarks.md)
    - [std.unittest.mock](std_en/unittest_mock/unittest_mock_package_overview.md)
        - [Functions](std_en/unittest_mock/unittest_mock_package_api/unittest_mock_package_functions.md)
        - [Interfaces](std_en/unittest_mock/unittest_mock_package_api/unittest_mock_package_interfaces.md)
        - [Classes](std_en/unittest_mock/unittest_mock_package_api/unittest_mock_package_classes.md)
        - [Enums](std_en/unittest_mock/unittest_mock_package_api/unittest_mock_package_enums.md)
        - [Exception Classes](std_en/unittest_mock/unittest_mock_package_api/unittest_mock_package_exceptions.md)
        - [Tutorial Examples]()
            - [Quick Start](std_en/unittest_mock/unittest_mock_samples/mock_framework_getting_started.md)
            - [Basic Concepts](std_en/unittest_mock/unittest_mock_samples/mock_framework_basics.md)
            - [Stubs](std_en/unittest_mock/unittest_mock_samples/mock_framework_stubs.md)
            - [Verification](std_en/unittest_mock/unittest_mock_samples/mock_framework_verification.md)
    - [std.unittest.mock.mockmacro](std_en/unittest_mock_mockmacro/unittest_mock_mockmacro_package_overview.md)
        - [Macros](std_en/unittest_mock_mockmacro/unittest_mock_mockmacro_package_api/unittest_mock_mockmacro_package_macros.md)
    - [std.unittest.testmacro](std_en/unittest_testmacro/unittest_testmacro_package_overview.md)
        - [Macros](std_en/unittest_testmacro/unittest_testmacro_package_api/unittest_testmacro_package_macros.md)
    - [std.unittest.common](std_en/unittest_common/unittest_common_package_overview.md)
        - [Functions](std_en/unittest_common/unittest_common_package_api/unittest_common_package_functions.md)
        - [Interfaces](std_en/unittest_common/unittest_common_package_api/unittest_common_package_interfaces.md)
        - [Classes](std_en/unittest_common/unittest_common_package_api/unittest_common_package_classes.md)
        - [Enums](std_en/unittest_common/unittest_common_package_api/unittest_common_package_enums.md)
        - [Structs](std_en/unittest_common/unittest_common_package_api/unittest_common_package_structs.md)
        - [Exception Classes](std_en/unittest_common/unittest_common_package_api/unittest_common_package_exceptions.md)
    - [std.unittest.diff](std_en/unittest_diff/unittest_diff_package_overview.md)
        - [Interfaces](std_en/unittest_diff/unittest_diff_package_api/unittest_diff_package_interfaces.md)
    - [std.unittest.prop_test](std_en/unittest_prop_test/unittest_prop_test_package_overview.md)
        - [Functions](std_en/unittest_prop_test/unittest_prop_test_package_api/unittest_prop_test_package_functions.md)
        - [Interfaces](std_en/unittest_prop_test/unittest_prop_test_package_api/unittest_prop_test_package_interfaces.md)
        - [Classes](std_en/unittest_prop_test/unittest_prop_test_package_api/unittest_prop_test_package_classes.md)
        - [Structs](std_en/unittest_prop_test/unittest_prop_test_package_api/unittest_prop_test_package_structs.md)