# std.posix

## Functionality Overview

The posix package primarily adapts POSIX system interfaces.

This package provides cross-platform unified operation capabilities, currently supporting Linux, macOS, and Windows platforms.

> **Note:**
>
> All contents of this package will be deprecated in future versions.

## API List

### Functions

| Function Name | Description | Supported Platforms |
| ------------ | ------------ | ----------- |
| [open(String, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-openstring-int32-deprecated) | Opens a file and returns a new file descriptor, or `-1` on failure. | `Linux` `Windows` `macOS` |
| [open(String, Int32, UInt32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-openstring-int32-uint32-deprecated) | Opens a file and returns a new file descriptor, or `-1` on failure. | `Linux` `Windows` `macOS` |
| [access(String, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-accessstring-int32-deprecated) | Checks file permissions, returns `0` if permitted, otherwise `-1`. | `Linux` `Windows` `macOS` |
| [chdir(String) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-chdirstring-deprecated) | Changes the current working directory of the calling process via specified path. | `Linux` `Windows` `macOS` |
| [chmod(String, UInt32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-chmodstring-uint32-deprecated) | Modifies file access permissions. | `Linux` `Windows` `macOS` |
| [chown(String, UInt32, UInt32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-chownstring-uint32-uint32-deprecated) | Changes file ownership and group ownership. | `Linux` `macOS` |
| [close(Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-closeint32-deprecated) | Closes a file, triggering data write-back to disk and releasing file resources. | `Linux` `Windows` `macOS` |
| [creat(String, UInt32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-creatstring-uint32-deprecated) | Creates a file and returns its file descriptor, or `-1` on failure. | `Linux` `Windows` `macOS` |
| [dup(Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-dupint32-deprecated) | Duplicates the file descriptor specified by old `fd` parameter and returns it. | `Linux` `Windows` `macOS` |
| [dup2(Int32, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-dupint32-int32-deprecated) | Duplicates the file descriptor specified by `oldfd` parameter and returns it via `newfd` parameter. | `Linux` `Windows` `macOS` |
| [faccessat(Int32, String, Int32, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-faccessatint32-string-int32-int32-deprecated) | Checks permissions for the file referenced by `fd`, returns `0` if permitted, otherwise `-1`. | `Linux` `macOS` |
| [fchdir(Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-fchdirint32-deprecated) | Changes the current working directory of the calling process via file descriptor. | `Linux` `macOS` |
| [fchmod(Int32, UInt32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-fchmodint32-uint32-deprecated) | Modifies the file access permissions corresponding to the file descriptor. | `Linux` `Windows` `macOS` |
| [fchmodat(Int32, String, UInt32, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-fchmodatint32-string-uint32-int32-deprecated) | Modifies the file access permissions corresponding to the file descriptor. | `Linux` `Windows` `macOS` |
| [fchown(Int32, UInt32, UInt32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-fchownint32-uint32-uint32-deprecated) | Modifies the owner and group ownership of the file corresponding to `fd`. | `Linux` `macOS` |
| [fchownat(Int32, String, UInt32, UInt32, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-fchownatint32-string-uint32-uint32-int32-deprecated) | Modifies the owner and group ownership of the file corresponding to the file descriptor. | `Linux` `macOS` |
| [getcwd() <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-getcwd-deprecated) | Retrieves the absolute path of the current working directory of the executing process. | `Linux` `Windows` `macOS` |
| [getgid() <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-getgid-deprecated) | Retrieves the group `ID`. | `Linux` `macOS` |
| [getgroups(Int32, CPointer\<UInt32>) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-getgroupsint32-cpointeruint32-deprecated) | Retrieves the supplementary group IDs of the current user. | `Linux` `macOS` |
| [gethostname() <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-gethostname-deprecated) | Retrieves the hostname, typically the name of the host on a `TCP/IP` network. | `Linux` `macOS` |
| [getlogin() <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-getlogin-deprecated) | Retrieves the current login name. | `Linux` `macOS` |
| [getos() <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-getos-deprecated) | Retrieves `Linux` system information from the `/proc/version` file. | `Linux` |
| [getpgid(Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-getpgidint32-deprecated) | Retrieves the `PGID` of the process specified by `pid`. If `pid` is zero, returns the process `ID` of the calling process. | `Linux` `macOS` |
| [getpgrp() <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-getpgrp-deprecated) | Retrieves the parent process `ID` of the calling process. | `Linux` `macOS` |
| [getpid() <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-getpid-deprecated) | Retrieves the process `ID (PID)` of the calling process. | `Linux` `Windows` `macOS` |
| [getppid() <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-getppid-deprecated) | Retrieves the parent process `ID` of the calling process. | `Linux` `macOS` |
| [getuid() <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-getuid-deprecated) | Retrieves the real user `ID` of the calling process. | `Linux` `macOS` |
| [isBlk(String) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-isblkstring-deprecated) | Checks if the input object is a block device and returns a boolean value. | `Linux` `Windows` `macOS` |
| [isChr(String) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-ischrstring-deprecated) | Checks if the input object is a character device and returns a boolean value. | `Linux` `Windows` `macOS` |
| [isDir(String) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-isdirstring-deprecated) | Checks if the input object is a directory and returns a boolean value. | `Linux` `Windows` `macOS` |
| [isFIFO(String) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-isfifostring-deprecated) | Checks if the input object is a `FIFO` file and returns a boolean value. | `Linux` `macOS` |
| [isLnk(String) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-islnkstring-deprecated) | Checks if the input object is a symbolic link and returns a boolean value. | `Linux` `macOS` |
| [isReg(String) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-isregstring-deprecated) | Checks if the input object is a regular file and returns a boolean value. | `Linux` `Windows` `macOS` |
| [isSock(String) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-issockstring-deprecated) | Checks if the input object is a socket file and returns a boolean value. | `Linux` `macOS` |
| [isType(String, UInt32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-istypestring-uint32-deprecated) | Checks if the file matches the specified mode. | `Linux` `macOS` |
| [isatty(Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-isattyint32-deprecated) | Tests whether the file descriptor refers to a terminal. Returns `true` on success, otherwise `false`. | `Linux` `Windows` `macOS` |
| [kill(Int32, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-killint32-int32-deprecated) | The system call can be used to send any signal to any process group or process. | `Linux` `macOS` |
| [killpg(Int32, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-killpgint32-int32-deprecated) | Sends the signal `sig` to the process group `pgrp`. If `pgrp` is `0`, killpg() sends the signal to the process group of the calling process. | `Linux` `macOS` |
| [lchown(String, UInt32, UInt32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-lchownstring-uint32-uint32-deprecated) | Modifies the owner and group ownership of the symbolic link itself. | `Linux` `macOS` |
| [link(String, String) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-linkstring-string-deprecated) | Creates a link to an existing file. A file can have multiple directory entries pointing to its `i-node`. | `Linux` `macOS` |
| [linkat(Int32, String, Int32, String, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-linkatint32-string-int32-string-int32-deprecated) | Creates a file link relative to directory file descriptors. | `Linux` `macOS` |
| [lseek(Int32, Int64, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-lseekint32-int64-int32-deprecated) | When reading or writing a file, the read/write position is adjusted accordingly. | `Linux` `Windows` `macOS` |
```| [nice(Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-niceint32-deprecated) | Changes the priority of the current thread. | `Linux` `macOS` |
| [open64(String, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-openstring-int32-deprecated) | Opens a file and returns a new file descriptor for it, or `-1` on failure. | `Linux` |
| [open64(String, Int32, UInt32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-openstring-int32-uint32-deprecated) | Opens a file and returns a new file descriptor for it, or `-1` on failure. | `Linux` |
| [openat(Int32, String, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-openatint32-string-int32-deprecated) | Opens a file and returns a new file descriptor for it, or `-1` on failure. | `Linux` `macOS` |
| [openat(Int32, String, Int32, UInt32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-openatint32-string-int32-uint32-deprecated) | Opens a file and returns a new file descriptor for it, or `-1` on failure. | `Linux` `macOS` |
| [openat64(Int32, String, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-openatint32-string-int32-deprecated) | Opens a file and returns a new file descriptor for it, or `-1` on failure. | `Linux` `macOS` |
| [openat64(Int32, String, Int32, UInt32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-openatint32-string-int32-uint32-deprecated) | Opens a file and returns a new file descriptor for it, or `-1` on failure. | `Linux` `macOS` |
| [pread(Int32, CPointer\<UInt8>, UIntNative, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-preadint32-cpointeruint8-uintnative-int32-deprecated) | Transfers `nbyte` bytes from the file pointed to by `fd` into the memory pointed to by `buffer`. | `Linux` `macOS` |
| [pwrite(Int32, CPointer\<UInt8>, UIntNative, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-pwriteint32-cpointeruint8-uintnative-int32-deprecated) | Writes `nbyte` bytes from the memory pointed to by `buffer` into the file pointed to by `fd` starting at the specified offset. | `Linux` `macOS` |
| [read(Int32, CPointer\<UInt8>, UIntNative) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-readint32-cpointeruint8-uintnative-deprecated) | Transfers `nbyte` bytes from the file pointed to by `fd` into the memory pointed to by `buffer`. | `Linux` `Windows` `macOS` |
| [remove(String) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-removestring-deprecated) | Deletes a file or directory. | `Linux` `Windows` `macOS` |
| [rename(String, String) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-renamestring-string-deprecated) | Renames a file, moving it between directories if necessary. | `Linux` `Windows` `macOS` |
| [renameat(Int32, String, Int32, String) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-renameatint32-string-int32-string-deprecated) | Renames a file, moving it between directories if necessary. | `Linux` `macOS` |
| [setgid(UInt32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-setgiduint32-deprecated) | Sets the effective group `ID` of the calling process, requires appropriate privileges. | `Linux` `macOS` |
| [sethostname(String) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-sethostnamestring-deprecated) | Sets the hostname, can only be called by the superuser. | `Linux` `macOS` |
| [setpgid(Int32, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-setpgidint32-int32-deprecated) | Sets the group `ID` specified by parameter `pid` to the group `ID` specified by parameter `pgrp`. | `Linux` `macOS` |
| [setpgrp() <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-setpgrp-deprecated) | Sets the group `ID` of the current process to its process `ID`, equivalent to calling setpgid(0, 0). | `Linux` `macOS` |
| [setuid(UInt32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-setuiduint32-deprecated) | Sets the effective user `ID` of the calling process, requires appropriate privileges. | `Linux` `macOS` |
| [symlink(String, String) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-symlinkstring-string-deprecated) | Creates a symbolic link named `symPath` pointing to the file specified by `path`. | `Linux` `macOS` |
| [symlinkat(String, Int32, String) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-symlinkatstring-int32-string-deprecated) | Creates a symbolic link named `symPath` pointing to the file specified by `path` and `fd`. | `Linux` `macOS` |
| [ttyname(Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-ttynameint32-deprecated) | Returns the terminal name. | `Linux` `Windows` `macOS` |
| [umask(UInt32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-umaskuint32-deprecated) | Sets the permission mask. | `Linux` `Windows` `macOS` |
| [unlink(String) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-unlinkstring-deprecated) | Deletes a file from the filesystem. | `Linux` `macOS` |
| [unlinkat(Int32, String, Int32) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-unlinkatint32-string-int32-deprecated) | Deletes a file from the filesystem. | `Linux` `macOS` |
| [write(Int32, CPointer\<UInt8>, UIntNative) <sup>(deprecated)</sup>](./posix_package_api/posix_package_funcs.md#func-writeint32-cpointeruint8-uintnative-deprecated) | Writes `nbyte` bytes from the memory pointed to by `buffer` into the file pointed to by `fd`. | `Linux` `Windows` `macOS` |

### Constants

| Constant Name | Functionality | Supported Platforms |
| ------------ | ------------ | ----------- |
| [AT_EMPTY_PATH <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-at_empty_path-deprecated) | Represents the file descriptor returned for an empty path (i.e., when no file or directory is specified) in the file system. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` `Windows` |
| [AT_REMOVEDIR <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-at_removedir-deprecated) | If the `AT_REMOVEDIR` flag is specified, performs an operation equivalent to `rmdir(2)` on `pathname`. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` `Windows` `macOS` |
| [O_CLOEXEC <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-o_cloexec-deprecated) | This flag is essential in certain multithreaded programs. Using a separate `fcntl(2)` `F_SETFD` operation to set the `FD_CLOEXEC` flag is insufficient to avoid race conditions when one thread opens a file descriptor while another thread executes `fork(2)` followed by `execve(2)`. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` `macOS` |
| [O_DIRECTORY <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-o_directory-deprecated) | If the file specified by `pathname` is not a directory, the file opening fails. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` `macOS` |
| [O_CREAT <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-o_creat-deprecated) | Automatically creates the file if it does not exist. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` `Windows` `macOS` |
| [O_DSYNC <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-o_dsync-deprecated) | Each write operation waits for physical `I/O` to complete, but does not wait for file attribute updates if the write operation does not affect reading the newly written data. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` `macOS` |
| [O_EXCL <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-o_excl-deprecated) | When combined with `O_CREAT`, this directive checks if the file exists. If the file does not exist, it is created; otherwise, the file opening fails. Additionally, if both `O_CREAT` and `O_EXCL` are set and the file to be opened is a symbolic link, the file opening fails. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` `Windows` `macOS` |
| [O_NOCTTY <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-o_noctty-deprecated) | If the file to be opened is a terminal device, it will not become the controlling terminal for this process. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` `macOS` |
| [O_NOFOLLOW <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-o_nofollow-deprecated) | If the file specified by `pathname` is a symbolic link, the file opening fails. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` `macOS` |
| [O_NONBLOCK <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-o_nonblock-deprecated) | Opens the file in non-blocking mode, meaning `I/O` operations will not cause the calling process to wait. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` `macOS` |
| [O_SYNC <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-o_sync-deprecated) | Opens the file synchronously. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` `macOS` |
| [O_RDONLY <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-o_rdonly-deprecated) | Opens the file in read-only mode. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` `Windows` `macOS` |
| [O_RDWR <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-o_rdwr-deprecated) | Opens the file in read-write mode. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` `Windows` `macOS` |
| [O_WRONLY <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-o_wronly-deprecated) | Opens the file in write-only mode. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` `Windows` `macOS` |
| [O_APPEND <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-o_append-deprecated) | When reading or writing the file, data is moved from the end of the file. That is, written data is appended to the end of the file. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` `Windows` `macOS` |
| [O_RSYNC <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-o_rsync-deprecated) | This flag affects only read operations and must be used in combination with `O_SYNC` or `O_DSYNC`. If necessary, it causes the read call to block until the data being read (and possibly metadata) is flushed to disk. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` |
| [O_TRUNC <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-o_trunc-deprecated) | If the file exists and is opened for writing, this flag truncates the file length to 0, erasing any previously stored data. Applicable functions: `open`, `open64`, `openat`, `openat64`. Belongs to function parameter `oflag`. | `Linux` `Windows` `macOS` |
| [R_OK <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-r_ok-deprecated) | Tests for read permission on the file. Applicable functions: `access`, `faccessat`. Belongs to function parameter `mode`. | `Linux` `Windows` `macOS` |
| [W_OK <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-w_ok-deprecated) | Tests for write permission on the file. Applicable functions: `access`, `faccessat`. Belongs to function parameter `mode`. | `Linux` `Windows` `macOS` |
| [X_OK <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-x_ok-deprecated) | Tests for execute permission on the file. Applicable functions: `access`, `faccessat`. Belongs to function parameter `mode`. | `Linux` `Windows` `macOS` |
| [F_OK <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-f_ok-deprecated) | Tests for the existence of the file. Applicable functions: `access`, `faccessat`. Belongs to function parameter `mode`. | `Linux` `Windows` `macOS` |
| [SEEK_SET <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-seek_set-deprecated) | The offset parameter specifies the new read/write position. Applicable function: `lseek`. Belongs to function parameter `whence`. | `Linux` `Windows` `macOS` |
| [SEEK_CUR <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-seek_cur-deprecated) | Adds the offset to the current read or write position. Applicable function: `lseek`. Belongs to function parameter `whence`. | `Linux` `Windows` `macOS` |
| [SEEK_END <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-seek_end-deprecated) | Sets the read/write position to the end of the file and adds the offset. Applicable function: `lseek`. Belongs to function parameter `whence`. | `Linux` `Windows` `macOS` |
| [SIGABRT <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigabrt-deprecated) | Abnormal termination. Default action: terminate. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGBUS <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigbus-deprecated) | Hardware fault. Default action: terminate. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGFPE <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigfpe-deprecated) | Arithmetic error. Default action: terminate. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGKILL <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigkill-deprecated) | Termination. Default action: terminate. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGCONT <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigcont-deprecated) | Continues a paused process. Default action: continue or ignore. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGHUP <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sighup-deprecated) | Connection disconnected. Default action: terminate. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
```| [SIGINT <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigint-deprecated) | Terminal interrupt character, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGQUIT <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigquit-deprecated) | Terminal quit character, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGILL <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigill-deprecated) | Illegal hardware instruction, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGTRAP <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigtrap-deprecated) | Hardware fault, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGIOT <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigiot-deprecated) | Hardware fault, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGIO <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigio-deprecated) | Asynchronous `IO`, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGPIPE <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigpipe-deprecated) | Write to pipe with no readers, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGALRM <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigalrm-deprecated) | Timer expired, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGPWR <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigpwr-deprecated) | Power failure/restart, invalid system call, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` |
| [SIGSEGV <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigsegv-deprecated) | Invalid memory reference, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGSTOP <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigstop-deprecated) | Stop process, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGTERM <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigterm-deprecated) | Termination signal, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGSTKFLT <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigstkflt-deprecated) | Coprocessor stack fault, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` |
| [SIGCHLD <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigchld-deprecated) | Child process status changed, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGTSTP <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigtstp-deprecated) | Terminal stop signal, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGTTIN <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigttin-deprecated) | Background read from control `tty`, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGTTOU <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigttou-deprecated) | Background write to control `tty`, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGURG <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigurg-deprecated) | Urgent condition (socket), default action ignored. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGUSR1 <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigusr1-deprecated) | User-defined signal 1, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGUSR2 <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigusr2-deprecated) | User-defined signal 2, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGVTALRM <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigvtalrm-deprecated) | Virtual timer expired, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGPROF <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigprof-deprecated) | Profiling timer expired, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGWINCH <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigwinch-deprecated) | Terminal window size changed, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGXCPU <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigxcpu-deprecated) | `CPU` time limit exceeded, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [SIGXFSZ <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-sigxfsz-deprecated) | File size limit exceeded, default action terminates. Applicable functions: `kill`, `killpg`. Belongs to function parameter `sig`. | `Linux` `Windows` `macOS` |
| [S_IRUSR <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_irusr-deprecated) | File owner has read permission. Applicable functions: `open`, `open64`, `openat`, `openat64`, `chmod(mode)`, `fchmod(mode)`, `fchmodat(mode)`, `creat`. Belongs to function parameter `flag`. | `Linux` `Windows` `macOS` |
| [S_IWUSR <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_iwusr-deprecated) | File owner has write permission. Applicable functions: `open`, `open64`, `openat`, `openat64`, `chmod(mode)`, `fchmod(mode)`, `fchmodat(mode)`, `creat`. Belongs to function parameter `flag`. | `Linux` `Windows` `macOS` |
| [S_IRGRP <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_iwgrp-deprecated) | File group has read permission. Applicable functions: `open`, `open64`, `openat`, `openat64`, `chmod(mode)`, `fchmod(mode)`, `fchmodat(mode)`, `creat`. Belongs to function parameter `flag`. | `Linux` `Windows` `macOS` |
| [S_IWGRP <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_iwgrp-deprecated) | File group has write permission. Applicable functions: `open`, `open64`, `openat`, `openat64`, `chmod(mode)`, `fchmod(mode)`, `fchmodat(mode)`, `creat`. Belongs to function parameter `flag`. | `Linux` `Windows` `macOS` |
| [S_IFREG <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_ifreg-deprecated) | File type is regular file. Applicable function: `isType`. Belongs to function parameter `mode`. | `Linux` `Windows` `macOS` || [S_IFBLK <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_ifblk-deprecated) | File type is block device, applicable to function `isType`, belongs to function parameter `mode`. | `Linux` `Windows` `macOS` |
| [S_IFDIR <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_ifdir-deprecated) | File type is directory, applicable to function `isType`, belongs to function parameter `mode`. | `Linux` `Windows` `macOS` |
| [S_IFCHR <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_ifchr-deprecated) | File type is character device, applicable to function `isType`, belongs to function parameter `mode`. | `Linux` `Windows` `macOS` |
| [S_IFIFO <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_ififo-deprecated) | File type is `FIFO`, applicable to function `isType`, belongs to function parameter `mode`. | `Linux` `Windows` `macOS` |
| [S_IFLNK <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_iflnk-deprecated) | File type is symbolic link, applicable to function `isType`, belongs to function parameter `mode`. | `Linux` `Windows` `macOS` |
| [S_IFSOCK <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_ifsock-deprecated) | File type is socket, applicable to function `isType`, belongs to function parameter `mode`. | `Linux` `Windows` `macOS` |
| [S_IROTH <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_iroth-deprecated) | Indicates other users have read permission on the file, applicable to functions `open`, `open64`, `openat`, `openat64`, `chmod(mode)`, `fchmod(mode)`, `fchmodat(mode)`, `creat`, belongs to function parameter `flag`. | `Linux` `Windows` `macOS` |
| [S_IRWXG <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_irwxg-deprecated) | Indicates file group has read, write, and execute permissions, applicable to functions `open`, `open64`, `openat`, `openat64`, `chmod(mode)`, `fchmod(mode)`, `fchmodat(mode)`, `creat`, belongs to function parameter `flag`. | `Linux` `Windows` `macOS` |
| [S_IRWXU <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_irwxu-deprecated) | Indicates file owner has read, write, and execute permissions, applicable to functions `open`, `open64`, `openat`, `openat64`, `chmod(mode)`, `fchmod(mode)`, `fchmodat(mode)`, `creat`, belongs to function parameter `flag`. | `Linux` `Windows` `macOS` |
| [S_IWOTH <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_iwoth-deprecated) | Indicates other users have write permission on the file, applicable to functions `open`, `open64`, `openat`, `openat64`, `chmod(mode)`, `fchmod(mode)`, `fchmodat(mode)`, `creat`, belongs to function parameter `flag`. | `Linux` `Windows` `macOS` |
| [S_IXOTH <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_ixoth-deprecated) | Indicates other users have execute permission on the file, applicable to functions `open`, `open64`, `openat`, `openat64`, `chmod(mode)`, `fchmod(mode)`, `fchmodat(mode)`, `creat`, belongs to function parameter `flag`. | `Linux` `Windows` `macOS` |
| [S_IRWXO <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_irwxo-deprecated) | Indicates other users have read, write, and execute permissions on the file, applicable to functions `open`, `open64`, `openat`, `openat64`, `chmod(mode)`, `fchmod(mode)`, `fchmodat(mode)`, `creat`, belongs to function parameter `flag`. | `Linux` `Windows` `macOS` |
| [S_IXGRP <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_ixgrp-deprecated) | Indicates file group has execute permission, applicable to functions `open`, `open64`, `openat`, `openat64`, `chmod(mode)`, `fchmod(mode)`, `fchmodat(mode)`, `creat`, belongs to function parameter `flag`. | `Linux` `Windows` `macOS` |
| [S_IXUSR <sup>(deprecated)</sup>](./posix_package_api/posix_package_constants_vars.md#const-s_ixusr-deprecated) | Indicates file owner has execute permission, applicable to functions `open`, `open64`, `openat`, `openat64`, `chmod(mode)`, `fchmod(mode)`, `fchmodat(mode)`, `creat`, belongs to function parameter `flag`. | `Linux` `Windows` `macOS` |