// Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
// This source file is part of the Cangjie project, licensed under Apache-2.0
// with Runtime Library Exception.
//
// See https://cangjie-lang.cn/pages/LICENSE for license information.
#ifdef ACCESS_LEVEL
ACCESS_LEVEL(PUBLIC, Public)
ACCESS_LEVEL(PROTECTED, Protected)
ACCESS_LEVEL(INTERNAL, Internal)
#endif

#ifdef ACCESS_MODIFIER
ACCESS_MODIFIER(PUBLIC, Public)
ACCESS_MODIFIER(PROTECTED, Protected)
ACCESS_MODIFIER(INTERNAL, Internal)
ACCESS_MODIFIER(PRIVATE, Private)
#endif

#ifdef BUILTIN_TYPE
BUILTIN_TYPE(ARRAY, Array)
BUILTIN_TYPE(VARRAY, VArray)
BUILTIN_TYPE(POINTER, CPointer)
BUILTIN_TYPE(CSTRING, CString)
BUILTIN_TYPE(CFUNC, CFunc)
#endif

#ifdef OVERFLOW_STRATEGY
OVERFLOW_STRATEGY(NA, NA)
OVERFLOW_STRATEGY(CHECKED, Checked)
OVERFLOW_STRATEGY(WRAPPING, Wrapping)
OVERFLOW_STRATEGY(THROWING, Throwing)
OVERFLOW_STRATEGY(SATURATING, Saturating)
#endif

#ifdef TYPE_KIND
TYPE_KIND(TYPE_UNIT, Unit)
TYPE_KIND(TYPE_INT8, Int8)
TYPE_KIND(TYPE_INT16, Int16)
TYPE_KIND(TYPE_INT32, Int32)
TYPE_KIND(TYPE_INT64, Int64)
TYPE_KIND(TYPE_INT_NATIVE, IntNative)
TYPE_KIND(TYPE_UINT8, UInt8)
TYPE_KIND(TYPE_UINT16, UInt16)
TYPE_KIND(TYPE_UINT32, UInt32)
TYPE_KIND(TYPE_UINT64, UInt64)
TYPE_KIND(TYPE_UINT_NATIVE, UIntNative)
TYPE_KIND(TYPE_FLOAT16, Float16)
TYPE_KIND(TYPE_FLOAT32, Float32)
TYPE_KIND(TYPE_FLOAT64, Float64)
TYPE_KIND(TYPE_RUNE, Rune)
TYPE_KIND(TYPE_NOTHING, Nothing)
TYPE_KIND(TYPE_BOOLEAN, Bool)
TYPE_KIND(TYPE_TUPLE, Tuple)
TYPE_KIND(TYPE_ENUM, Enum)
TYPE_KIND(TYPE_FUNC, Func)
TYPE_KIND(TYPE_STRUCT, Struct)
TYPE_KIND(TYPE_ARRAY, Array)
TYPE_KIND(TYPE_VARRAY, VArray)
TYPE_KIND(TYPE_POINTER, CPointer)
TYPE_KIND(TYPE_CSTRING, CString)
TYPE_KIND(TYPE_CLASS, Class)
TYPE_KIND(TYPE_INTERFACE, Interface)
TYPE_KIND(TYPE, Type)
TYPE_KIND(TYPE_GENERICS, Generic)
#endif

#ifdef OPERATOR_KIND
OPERATOR_KIND(ILLEGAL, NA)
OPERATOR_KIND(LPAREN, Call)
OPERATOR_KIND(LSQUARE, Index)
OPERATOR_KIND(NOT, Not)
OPERATOR_KIND(SUB, Subtract)
OPERATOR_KIND(EXP, Power)
OPERATOR_KIND(MUL, Multiply)
OPERATOR_KIND(DIV, Divide)
OPERATOR_KIND(MOD, Remainder)
OPERATOR_KIND(ADD, Add)
OPERATOR_KIND(LSHIFT, BitLeftShift)
OPERATOR_KIND(RSHIFT, BitRightShift)
OPERATOR_KIND(LT, LT)
OPERATOR_KIND(LE, LE)
OPERATOR_KIND(GT, GT)
OPERATOR_KIND(GE, GE)
OPERATOR_KIND(EQUAL, Equal)
OPERATOR_KIND(NOTEQ, NotEqual)
OPERATOR_KIND(BITAND, BitAnd)
OPERATOR_KIND(BITXOR, BitXor)
OPERATOR_KIND(BITOR, BitOr)
OPERATOR_KIND(INCR, PostInc)
OPERATOR_KIND(DECR, PostDec)
OPERATOR_KIND(IS, Is)
OPERATOR_KIND(AS, As)
OPERATOR_KIND(AND, LogicAnd)
OPERATOR_KIND(OR, LogicOr)
OPERATOR_KIND(COALESCING, Coalescing)
OPERATOR_KIND(PIPELINE, Pipeline)
OPERATOR_KIND(COMPOSITION, Composition)
OPERATOR_KIND(ASSIGN, Assign)
OPERATOR_KIND(EXP_ASSIGN, PowerAssign)
OPERATOR_KIND(MUL_ASSIGN, MultiplyAssign)
OPERATOR_KIND(DIV_ASSIGN, DivideAssign)
OPERATOR_KIND(MOD_ASSIGN, RemainderAssign)
OPERATOR_KIND(ADD_ASSIGN, AddAssign)
OPERATOR_KIND(SUB_ASSIGN, SubtractAssign)
OPERATOR_KIND(LSHIFT_ASSIGN, LeftShiftAssign)
OPERATOR_KIND(RSHIFT_ASSIGN, RightShiftAssign)
OPERATOR_KIND(BITAND_ASSIGN, BitAndAssign)
OPERATOR_KIND(BITXOR_ASSIGN, BitXorAssign)
OPERATOR_KIND(BITOR_ASSIGN, BitOrAssign)
OPERATOR_KIND(AND_ASSIGN, LogicAndAssign)
OPERATOR_KIND(OR_ASSIGN, LogicOrAssign)
#endif

#ifdef CALL_KIND
CALL_KIND(CALL_INVALID, NA)
CALL_KIND(CALL_DECLARED_FUNCTION, CallDeclaredFunction)
CALL_KIND(CALL_OBJECT_CREATION, CallObjectCreation)
CALL_KIND(CALL_FUNCTION_PTR, CallStructCreation)
CALL_KIND(CALL_STRUCT_CREATION, CallSuperFunction)
CALL_KIND(CALL_SUPER_FUNCTION, CallVariadicFunction)
CALL_KIND(CALL_VARIADIC_FUNCTION, CallFunctionPtr)
CALL_KIND(CALL_ANNOTATION, CallAnnotation)
CALL_KIND(CALL_BUILTIN_FUNCTION, CallBuiltinFunction)
CALL_KIND(CALL_INTRINSIC_FUNCTION, CallIntrinsicFunction)
#endif

#ifdef LIT_CONST_KIND
LIT_CONST_KIND(INTEGER, Integer)
LIT_CONST_KIND(RUNE_BYTE, RuneByte)
LIT_CONST_KIND(FLOAT, Float)
LIT_CONST_KIND(RUNE, Rune)
LIT_CONST_KIND(STRING, String)
LIT_CONST_KIND(JSTRING, JString)
LIT_CONST_KIND(BOOL, Bool)
LIT_CONST_KIND(UNIT, Unit)
#endif

#ifdef STRING_KIND
STRING_KIND(NORMAL, Normal)
STRING_KIND(JSTRING, JString)
STRING_KIND(MULTILINE, MultiLine)
STRING_KIND(MULTILINE_RAW, MultiLineRaw)
#endif

#ifdef FOR_IN_KIND
FOR_IN_KIND(FORIN_INVALID, NA)
FOR_IN_KIND(FORIN_RANGE, Range)
FOR_IN_KIND(FORIN_STRING, String)
FOR_IN_KIND(FORIN_ITER, Iterator)
#endif
