// Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
// This source file is part of the Cangjie project, licensed under Apache-2.0
// with Runtime Library Exception.
//
// See https://cangjie-lang.cn/pages/LICENSE for license information.

/**
 * @file
 *
 * This file lists library options to be passed to linker, which is included by headers.
 */

#ifdef CJNATIVE_STD_OPTIONS
// Must be linux.
CJNATIVE_STD_OPTIONS("-lcangjie-runtime")
#endif

#ifdef CJNATIVE_DARWIN_BASIC_OPTIONS
CJNATIVE_DARWIN_BASIC_OPTIONS("-lboundscheck")
CJNATIVE_DARWIN_BASIC_OPTIONS("-lSystem")
#endif

#ifdef CJNATIVE_GNU_LINUX_BASIC_OPTIONS
CJNATIVE_GNU_LINUX_BASIC_OPTIONS("-lboundscheck")
CJNATIVE_GNU_LINUX_BASIC_OPTIONS("-lm")
CJNATIVE_GNU_LINUX_BASIC_OPTIONS("-lc")
#endif

#ifdef CJNATIVE_STATIC_LINK_BASIC_OPTIONS
CJNATIVE_STATIC_LINK_BASIC_OPTIONS("-lstdc++")
CJNATIVE_STATIC_LINK_BASIC_OPTIONS("-lpthread")
CJNATIVE_STATIC_LINK_BASIC_OPTIONS("-ldl")
CJNATIVE_STATIC_LINK_BASIC_OPTIONS("-lm")
CJNATIVE_STATIC_LINK_BASIC_OPTIONS("-lc")
#endif

#ifdef CJNATIVE_WINDOWS_BASIC_OPTIONS
#ifndef _MSC_VER
CJNATIVE_WINDOWS_BASIC_OPTIONS("-lboundscheck")
CJNATIVE_WINDOWS_BASIC_OPTIONS("-lm")
// libssp is used when stack protector related options is on, such as -fstack-protector-all.
// When linking statically, libssp_nonshared.a should be linked against first, then libssp.a.
CJNATIVE_WINDOWS_BASIC_OPTIONS("-lmsvcrt")
CJNATIVE_WINDOWS_BASIC_OPTIONS("-lmingw32")
CJNATIVE_WINDOWS_BASIC_OPTIONS("-lmoldname")
CJNATIVE_WINDOWS_BASIC_OPTIONS("-lmingwex")
// Don't delete the repeated libs below! The order below is same as the linker commands generated by MinGW gcc.
// It's intended to repeat linking them multiple times to resolve all symbols.
CJNATIVE_WINDOWS_BASIC_OPTIONS("-lmingw32")
CJNATIVE_WINDOWS_BASIC_OPTIONS("-lmsvcrt")
CJNATIVE_WINDOWS_BASIC_OPTIONS("-lpthread")
CJNATIVE_WINDOWS_BASIC_OPTIONS("-ladvapi32")
CJNATIVE_WINDOWS_BASIC_OPTIONS("-lshell32")
CJNATIVE_WINDOWS_BASIC_OPTIONS("-luser32")
CJNATIVE_WINDOWS_BASIC_OPTIONS("-lkernel32")
CJNATIVE_WINDOWS_BASIC_OPTIONS("-lmingw32")
CJNATIVE_WINDOWS_BASIC_OPTIONS("-lmoldname")
CJNATIVE_WINDOWS_BASIC_OPTIONS("-lmingwex")
CJNATIVE_WINDOWS_BASIC_OPTIONS("-lmsvcrt")
#else
CJNATIVE_WINDOWS_BASIC_OPTIONS("-lmsvcrt")
#endif
#endif

// If C code is introduced in the standard library,
// please add the name of the corresponding CFFI library for the static library here.
#ifdef CJNATIVE_LTO_CSTD_FFI_OPTIONS
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-core.a", "libcangjie-std-coreFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-ast.a", "libcangjie-std-astFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-convert.a", "libcangjie-std-convertFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-fs.a", "libcangjie-std-fsFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-console.a", "libcangjie-std-envFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-math.a", "libcangjie-std-mathFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-time.a", "libcangjie-std-timeFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-posix.a", "libcangjie-std-posixFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-process.a", "libcangjie-std-processFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-env.a", "libcangjie-std-envFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-random.a", "libcangjie-std-randomFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-net.a", "libcangjie-std-netFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-objectpool.a", "libcangjie-std-objectpoolFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-unittest.a", "libcangjie-std-unittestFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-regex.a", "libcangjie-std-regexFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-collection.concurrent.a", "libcangjie-std-collection.concurrentFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-dynamicLoader-openssl.a", "libcangjie-dynamicLoader-opensslFFI.a")
CJNATIVE_LTO_CSTD_FFI_OPTIONS("libcangjie-std-runtime.a", "libcangjie-std-runtimeFFI.a")
#endif
