/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import io.flutter.embedding.engine.dart.DartExecutor;
import io.flutter.plugin.common.JSONMethodCodec;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TextInputChannel {
    private static final String TAG = "TextInputChannel";
    @NonNull
    public final MethodChannel channel;
    @Nullable
    private TextInputMethodHandler textInputMethodHandler;
    private final MethodChannel.MethodCallHandler parsingMethodHandler = new MethodChannel.MethodCallHandler(){

        @Override
        public void onMethodCall(@NonNull MethodCall call, @NonNull MethodChannel.Result result) {
            if (TextInputChannel.this.textInputMethodHandler == null) {
                return;
            }
            String method = call.method;
            Object args = call.arguments;
            Log.v(TextInputChannel.TAG, "Received '" + method + "' message.");
            switch (method) {
                case "TextInput.show": {
                    TextInputChannel.this.textInputMethodHandler.show();
                    result.success(null);
                    break;
                }
                case "TextInput.hide": {
                    TextInputChannel.this.textInputMethodHandler.hide();
                    result.success(null);
                    break;
                }
                case "TextInput.setClient": {
                    try {
                        JSONArray argumentList = (JSONArray)args;
                        int textInputClientId = argumentList.getInt(0);
                        JSONObject jsonConfiguration = argumentList.getJSONObject(1);
                        TextInputChannel.this.textInputMethodHandler.setClient(textInputClientId, Configuration.fromJson(jsonConfiguration));
                        result.success(null);
                    }
                    catch (NoSuchFieldException | JSONException exception) {
                        result.error("error", exception.getMessage(), null);
                    }
                    break;
                }
                case "TextInput.requestAutofill": {
                    TextInputChannel.this.textInputMethodHandler.requestAutofill();
                    result.success(null);
                    break;
                }
                case "TextInput.setPlatformViewClient": {
                    int id2 = (Integer)args;
                    TextInputChannel.this.textInputMethodHandler.setPlatformViewClient(id2);
                    break;
                }
                case "TextInput.setEditingState": {
                    try {
                        JSONObject editingState = (JSONObject)args;
                        TextInputChannel.this.textInputMethodHandler.setEditingState(TextEditState.fromJson(editingState));
                        result.success(null);
                    }
                    catch (JSONException exception) {
                        result.error("error", exception.getMessage(), null);
                    }
                    break;
                }
                case "TextInput.setEditableSizeAndTransform": {
                    try {
                        JSONObject arguments = (JSONObject)args;
                        double width = arguments.getDouble("width");
                        double height = arguments.getDouble("height");
                        JSONArray jsonMatrix = arguments.getJSONArray("transform");
                        double[] matrix = new double[16];
                        for (int i = 0; i < 16; ++i) {
                            matrix[i] = jsonMatrix.getDouble(i);
                        }
                        TextInputChannel.this.textInputMethodHandler.setEditableSizeAndTransform(width, height, matrix);
                    }
                    catch (JSONException exception) {
                        result.error("error", exception.getMessage(), null);
                    }
                    break;
                }
                case "TextInput.clearClient": {
                    TextInputChannel.this.textInputMethodHandler.clearClient();
                    result.success(null);
                    break;
                }
                case "TextInput.sendAppPrivateCommand": {
                    try {
                        JSONObject arguments = (JSONObject)args;
                        String action = arguments.getString("action");
                        String data = arguments.getString("data");
                        Bundle bundle = null;
                        if (data != null && !data.isEmpty()) {
                            bundle = new Bundle();
                            bundle.putString("data", data);
                        }
                        TextInputChannel.this.textInputMethodHandler.sendAppPrivateCommand(action, bundle);
                        result.success(null);
                    }
                    catch (JSONException exception) {
                        result.error("error", exception.getMessage(), null);
                    }
                    break;
                }
                case "TextInput.finishAutofillContext": {
                    TextInputChannel.this.textInputMethodHandler.finishAutofillContext((Boolean)args);
                    result.success(null);
                    break;
                }
                default: {
                    result.notImplemented();
                }
            }
        }
    };

    public TextInputChannel(@NonNull DartExecutor dartExecutor) {
        this.channel = new MethodChannel(dartExecutor, "flutter/textinput", JSONMethodCodec.INSTANCE);
        this.channel.setMethodCallHandler(this.parsingMethodHandler);
    }

    public void requestExistingInputState() {
        this.channel.invokeMethod("TextInputClient.requestExistingInputState", null);
    }

    private static HashMap<Object, Object> createEditingStateJSON(String text, int selectionStart, int selectionEnd, int composingStart, int composingEnd) {
        HashMap<Object, Object> state = new HashMap<Object, Object>();
        state.put("text", text);
        state.put("selectionBase", selectionStart);
        state.put("selectionExtent", selectionEnd);
        state.put("composingBase", composingStart);
        state.put("composingExtent", composingEnd);
        return state;
    }

    public void updateEditingState(int inputClientId, String text, int selectionStart, int selectionEnd, int composingStart, int composingEnd) {
        Log.v(TAG, "Sending message to update editing state: \nText: " + text + "\nSelection start: " + selectionStart + "\nSelection end: " + selectionEnd + "\nComposing start: " + composingStart + "\nComposing end: " + composingEnd);
        HashMap<Object, Object> state = TextInputChannel.createEditingStateJSON(text, selectionStart, selectionEnd, composingStart, composingEnd);
        this.channel.invokeMethod("TextInputClient.updateEditingState", Arrays.asList(inputClientId, state));
    }

    public void updateEditingStateWithTag(int inputClientId, HashMap<String, TextEditState> editStates) {
        Log.v(TAG, "Sending message to update editing state for " + String.valueOf(editStates.size()) + " field(s).");
        HashMap<String, HashMap<Object, Object>> json = new HashMap<String, HashMap<Object, Object>>();
        for (Map.Entry<String, TextEditState> element : editStates.entrySet()) {
            TextEditState state = element.getValue();
            json.put(element.getKey(), TextInputChannel.createEditingStateJSON(state.text, state.selectionStart, state.selectionEnd, -1, -1));
        }
        this.channel.invokeMethod("TextInputClient.updateEditingStateWithTag", Arrays.asList(inputClientId, json));
    }

    public void newline(int inputClientId) {
        Log.v(TAG, "Sending 'newline' message.");
        this.channel.invokeMethod("TextInputClient.performAction", Arrays.asList(inputClientId, "TextInputAction.newline"));
    }

    public void go(int inputClientId) {
        Log.v(TAG, "Sending 'go' message.");
        this.channel.invokeMethod("TextInputClient.performAction", Arrays.asList(inputClientId, "TextInputAction.go"));
    }

    public void search(int inputClientId) {
        Log.v(TAG, "Sending 'search' message.");
        this.channel.invokeMethod("TextInputClient.performAction", Arrays.asList(inputClientId, "TextInputAction.search"));
    }

    public void send(int inputClientId) {
        Log.v(TAG, "Sending 'send' message.");
        this.channel.invokeMethod("TextInputClient.performAction", Arrays.asList(inputClientId, "TextInputAction.send"));
    }

    public void done(int inputClientId) {
        Log.v(TAG, "Sending 'done' message.");
        this.channel.invokeMethod("TextInputClient.performAction", Arrays.asList(inputClientId, "TextInputAction.done"));
    }

    public void next(int inputClientId) {
        Log.v(TAG, "Sending 'next' message.");
        this.channel.invokeMethod("TextInputClient.performAction", Arrays.asList(inputClientId, "TextInputAction.next"));
    }

    public void previous(int inputClientId) {
        Log.v(TAG, "Sending 'previous' message.");
        this.channel.invokeMethod("TextInputClient.performAction", Arrays.asList(inputClientId, "TextInputAction.previous"));
    }

    public void unspecifiedAction(int inputClientId) {
        Log.v(TAG, "Sending 'unspecified' message.");
        this.channel.invokeMethod("TextInputClient.performAction", Arrays.asList(inputClientId, "TextInputAction.unspecified"));
    }

    public void performPrivateCommand(int inputClientId, String action, Bundle data) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("action", action);
        if (data != null) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            Set keySet = data.keySet();
            for (String key : keySet) {
                Object value = data.get(key);
                if (value instanceof byte[]) {
                    dataMap.put(key, data.getByteArray(key));
                    continue;
                }
                if (value instanceof Byte) {
                    dataMap.put(key, data.getByte(key));
                    continue;
                }
                if (value instanceof char[]) {
                    dataMap.put(key, data.getCharArray(key));
                    continue;
                }
                if (value instanceof Character) {
                    dataMap.put(key, Character.valueOf(data.getChar(key)));
                    continue;
                }
                if (value instanceof CharSequence[]) {
                    dataMap.put(key, data.getCharSequenceArray(key));
                    continue;
                }
                if (value instanceof CharSequence) {
                    dataMap.put(key, data.getCharSequence(key));
                    continue;
                }
                if (value instanceof float[]) {
                    dataMap.put(key, data.getFloatArray(key));
                    continue;
                }
                if (!(value instanceof Float)) continue;
                dataMap.put(key, Float.valueOf(data.getFloat(key)));
            }
            json.put("data", dataMap);
        }
        this.channel.invokeMethod("TextInputClient.performPrivateCommand", Arrays.asList(inputClientId, json));
    }

    public void setTextInputMethodHandler(@Nullable TextInputMethodHandler textInputMethodHandler) {
        this.textInputMethodHandler = textInputMethodHandler;
    }

    public static class TextEditState {
        @NonNull
        public final String text;
        public final int selectionStart;
        public final int selectionEnd;

        public static TextEditState fromJson(@NonNull JSONObject textEditState) throws JSONException {
            return new TextEditState(textEditState.getString("text"), textEditState.getInt("selectionBase"), textEditState.getInt("selectionExtent"));
        }

        public TextEditState(@NonNull String text, int selectionStart, int selectionEnd) {
            this.text = text;
            this.selectionStart = selectionStart;
            this.selectionEnd = selectionEnd;
        }
    }

    public static enum TextCapitalization {
        CHARACTERS("TextCapitalization.characters"),
        WORDS("TextCapitalization.words"),
        SENTENCES("TextCapitalization.sentences"),
        NONE("TextCapitalization.none");

        @NonNull
        private final String encodedName;

        static TextCapitalization fromValue(@NonNull String encodedName) throws NoSuchFieldException {
            for (TextCapitalization textCapitalization : TextCapitalization.values()) {
                if (!textCapitalization.encodedName.equals(encodedName)) continue;
                return textCapitalization;
            }
            throw new NoSuchFieldException("No such TextCapitalization: " + encodedName);
        }

        private TextCapitalization(String encodedName) {
            this.encodedName = encodedName;
        }
    }

    public static enum TextInputType {
        TEXT("TextInputType.text"),
        DATETIME("TextInputType.datetime"),
        NAME("TextInputType.name"),
        POSTAL_ADDRESS("TextInputType.address"),
        NUMBER("TextInputType.number"),
        PHONE("TextInputType.phone"),
        MULTILINE("TextInputType.multiline"),
        EMAIL_ADDRESS("TextInputType.emailAddress"),
        URL("TextInputType.url"),
        VISIBLE_PASSWORD("TextInputType.visiblePassword");

        @NonNull
        private final String encodedName;

        static TextInputType fromValue(@NonNull String encodedName) throws NoSuchFieldException {
            for (TextInputType textInputType : TextInputType.values()) {
                if (!textInputType.encodedName.equals(encodedName)) continue;
                return textInputType;
            }
            throw new NoSuchFieldException("No such TextInputType: " + encodedName);
        }

        private TextInputType(String encodedName) {
            this.encodedName = encodedName;
        }
    }

    public static class InputType {
        @NonNull
        public final TextInputType type;
        public final boolean isSigned;
        public final boolean isDecimal;

        @NonNull
        public static InputType fromJson(@NonNull JSONObject json) throws JSONException, NoSuchFieldException {
            return new InputType(TextInputType.fromValue(json.getString("name")), json.optBoolean("signed", false), json.optBoolean("decimal", false));
        }

        public InputType(@NonNull TextInputType type, boolean isSigned, boolean isDecimal) {
            this.type = type;
            this.isSigned = isSigned;
            this.isDecimal = isDecimal;
        }
    }

    public static class Configuration {
        public final boolean obscureText;
        public final boolean autocorrect;
        public final boolean enableSuggestions;
        @NonNull
        public final TextCapitalization textCapitalization;
        @NonNull
        public final InputType inputType;
        @Nullable
        public final Integer inputAction;
        @Nullable
        public final String actionLabel;
        @Nullable
        public final Autofill autofill;
        @Nullable
        public final Configuration[] fields;

        public static Configuration fromJson(@NonNull JSONObject json) throws JSONException, NoSuchFieldException {
            String inputActionName = json.getString("inputAction");
            if (inputActionName == null) {
                throw new JSONException("Configuration JSON missing 'inputAction' property.");
            }
            Configuration[] fields = null;
            if (!json.isNull("fields")) {
                JSONArray jsonFields = json.getJSONArray("fields");
                fields = new Configuration[jsonFields.length()];
                for (int i = 0; i < fields.length; ++i) {
                    fields[i] = Configuration.fromJson(jsonFields.getJSONObject(i));
                }
            }
            Integer inputAction = Configuration.inputActionFromTextInputAction(inputActionName);
            return new Configuration(json.optBoolean("obscureText"), json.optBoolean("autocorrect", true), json.optBoolean("enableSuggestions"), TextCapitalization.fromValue(json.getString("textCapitalization")), InputType.fromJson(json.getJSONObject("inputType")), inputAction, json.isNull("actionLabel") ? null : json.getString("actionLabel"), json.isNull("autofill") ? null : Autofill.fromJson(json.getJSONObject("autofill")), fields);
        }

        @NonNull
        private static Integer inputActionFromTextInputAction(@NonNull String inputAction) {
            switch (inputAction) {
                case "TextInputAction.newline": {
                    return 1;
                }
                case "TextInputAction.none": {
                    return 1;
                }
                case "TextInputAction.unspecified": {
                    return 0;
                }
                case "TextInputAction.done": {
                    return 6;
                }
                case "TextInputAction.go": {
                    return 2;
                }
                case "TextInputAction.search": {
                    return 3;
                }
                case "TextInputAction.send": {
                    return 4;
                }
                case "TextInputAction.next": {
                    return 5;
                }
                case "TextInputAction.previous": {
                    return 7;
                }
            }
            return 0;
        }

        public Configuration(boolean obscureText, boolean autocorrect, boolean enableSuggestions, @NonNull TextCapitalization textCapitalization, @NonNull InputType inputType, @Nullable Integer inputAction, @Nullable String actionLabel, @Nullable Autofill autofill, @Nullable Configuration[] fields) {
            this.obscureText = obscureText;
            this.autocorrect = autocorrect;
            this.enableSuggestions = enableSuggestions;
            this.textCapitalization = textCapitalization;
            this.inputType = inputType;
            this.inputAction = inputAction;
            this.actionLabel = actionLabel;
            this.autofill = autofill;
            this.fields = fields;
        }

        public static class Autofill {
            public final String uniqueIdentifier;
            public final String[] hints;
            public final TextEditState editState;

            public static Autofill fromJson(@NonNull JSONObject json) throws JSONException, NoSuchFieldException {
                String uniqueIdentifier = json.getString("uniqueIdentifier");
                JSONArray hints = json.getJSONArray("hints");
                JSONObject editingState = json.getJSONObject("editingValue");
                String[] hintList = new String[hints.length()];
                for (int i = 0; i < hintList.length; ++i) {
                    hintList[i] = Autofill.translateAutofillHint(hints.getString(i));
                }
                return new Autofill(uniqueIdentifier, hintList, TextEditState.fromJson(editingState));
            }

            @NonNull
            private static String translateAutofillHint(@NonNull String hint) {
                if (Build.VERSION.SDK_INT < 26) {
                    return hint;
                }
                switch (hint) {
                    case "addressCity": {
                        return "addressLocality";
                    }
                    case "addressState": {
                        return "addressRegion";
                    }
                    case "birthday": {
                        return "birthDateFull";
                    }
                    case "birthdayDay": {
                        return "birthDateDay";
                    }
                    case "birthdayMonth": {
                        return "birthDateMonth";
                    }
                    case "birthdayYear": {
                        return "birthDateYear";
                    }
                    case "countryName": {
                        return "addressCountry";
                    }
                    case "creditCardExpirationDate": {
                        return "creditCardExpirationDate";
                    }
                    case "creditCardExpirationDay": {
                        return "creditCardExpirationDay";
                    }
                    case "creditCardExpirationMonth": {
                        return "creditCardExpirationMonth";
                    }
                    case "creditCardExpirationYear": {
                        return "creditCardExpirationYear";
                    }
                    case "creditCardNumber": {
                        return "creditCardNumber";
                    }
                    case "creditCardSecurityCode": {
                        return "creditCardSecurityCode";
                    }
                    case "email": {
                        return "emailAddress";
                    }
                    case "familyName": {
                        return "personFamilyName";
                    }
                    case "fullStreetAddress": {
                        return "streetAddress";
                    }
                    case "gender": {
                        return "gender";
                    }
                    case "givenName": {
                        return "personGivenName";
                    }
                    case "middleInitial": {
                        return "personMiddleInitial";
                    }
                    case "middleName": {
                        return "personMiddleName";
                    }
                    case "name": {
                        return "personName";
                    }
                    case "namePrefix": {
                        return "personNamePrefix";
                    }
                    case "nameSuffix": {
                        return "personNameSuffix";
                    }
                    case "newPassword": {
                        return "newPassword";
                    }
                    case "newUsername": {
                        return "newUsername";
                    }
                    case "oneTimeCode": {
                        return "smsOTPCode";
                    }
                    case "password": {
                        return "password";
                    }
                    case "postalAddress": {
                        return "postalAddress";
                    }
                    case "postalAddressExtended": {
                        return "extendedAddress";
                    }
                    case "postalAddressExtendedPostalCode": {
                        return "extendedPostalCode";
                    }
                    case "postalCode": {
                        return "postalCode";
                    }
                    case "telephoneNumber": {
                        return "phoneNumber";
                    }
                    case "telephoneNumberCountryCode": {
                        return "phoneCountryCode";
                    }
                    case "telephoneNumberDevice": {
                        return "phoneNumberDevice";
                    }
                    case "telephoneNumberNational": {
                        return "phoneNational";
                    }
                    case "username": {
                        return "username";
                    }
                }
                return hint;
            }

            public Autofill(@NonNull String uniqueIdentifier, @NonNull String[] hints, @NonNull TextEditState editingState) {
                this.uniqueIdentifier = uniqueIdentifier;
                this.hints = hints;
                this.editState = editingState;
            }
        }
    }

    public static interface TextInputMethodHandler {
        public void show();

        public void hide();

        public void requestAutofill();

        public void finishAutofillContext(boolean var1);

        public void setClient(int var1, @NonNull Configuration var2);

        public void setPlatformViewClient(int var1);

        public void setEditableSizeAndTransform(double var1, double var3, double[] var5);

        public void setEditingState(@NonNull TextEditState var1);

        public void clearClient();

        public void sendAppPrivateCommand(String var1, Bundle var2);
    }
}

