/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.systemchannels;

import android.os.Build;
import android.view.InputDevice;
import android.view.KeyEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.flutter.Log;
import io.flutter.plugin.common.BasicMessageChannel;
import io.flutter.plugin.common.BinaryMessenger;
import io.flutter.plugin.common.JSONMessageCodec;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class KeyEventChannel {
    private static final String TAG = "KeyEventChannel";
    private EventResponseHandler eventResponseHandler;
    @NonNull
    public final BasicMessageChannel<Object> channel;

    public void setEventResponseHandler(EventResponseHandler handler) {
        this.eventResponseHandler = handler;
    }

    public KeyEventChannel(@NonNull BinaryMessenger binaryMessenger) {
        this.channel = new BasicMessageChannel<Object>(binaryMessenger, "flutter/keyevent", JSONMessageCodec.INSTANCE);
    }

    BasicMessageChannel.Reply<Object> createReplyHandler(long eventId) {
        return message -> {
            if (this.eventResponseHandler == null) {
                return;
            }
            try {
                if (message == null) {
                    this.eventResponseHandler.onKeyEventNotHandled(eventId);
                    return;
                }
                JSONObject annotatedEvent = (JSONObject)message;
                boolean handled = annotatedEvent.getBoolean("handled");
                if (handled) {
                    this.eventResponseHandler.onKeyEventHandled(eventId);
                } else {
                    this.eventResponseHandler.onKeyEventNotHandled(eventId);
                }
            }
            catch (JSONException e) {
                Log.e(TAG, "Unable to unpack JSON message: " + (Object)((Object)e));
                this.eventResponseHandler.onKeyEventNotHandled(eventId);
            }
        };
    }

    public void keyUp(@NonNull FlutterKeyEvent keyEvent) {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("type", "keyup");
        message.put("keymap", "android");
        this.encodeKeyEvent(keyEvent, message);
        this.channel.send(message, this.createReplyHandler(keyEvent.eventId));
    }

    public void keyDown(@NonNull FlutterKeyEvent keyEvent) {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("type", "keydown");
        message.put("keymap", "android");
        this.encodeKeyEvent(keyEvent, message);
        this.channel.send(message, this.createReplyHandler(keyEvent.eventId));
    }

    private void encodeKeyEvent(@NonNull FlutterKeyEvent event, @NonNull Map<String, Object> message) {
        message.put("flags", event.flags);
        message.put("plainCodePoint", event.plainCodePoint);
        message.put("codePoint", event.codePoint);
        message.put("keyCode", event.keyCode);
        message.put("scanCode", event.scanCode);
        message.put("metaState", event.metaState);
        if (event.complexCharacter != null) {
            message.put("character", event.complexCharacter.toString());
        }
        message.put("source", event.source);
        message.put("vendorId", event.vendorId);
        message.put("productId", event.productId);
        message.put("deviceId", event.deviceId);
        message.put("repeatCount", event.repeatCount);
    }

    public static class FlutterKeyEvent {
        public final int deviceId;
        public final int flags;
        public final int plainCodePoint;
        public final int codePoint;
        public final int keyCode;
        @Nullable
        public final Character complexCharacter;
        public final int scanCode;
        public final int metaState;
        public final int source;
        public final int vendorId;
        public final int productId;
        public final int repeatCount;
        public final long eventId;

        public FlutterKeyEvent(@NonNull KeyEvent androidKeyEvent, long eventId) {
            this(androidKeyEvent, null, eventId);
        }

        public FlutterKeyEvent(@NonNull KeyEvent androidKeyEvent, @Nullable Character complexCharacter, long eventId) {
            this(androidKeyEvent.getDeviceId(), androidKeyEvent.getFlags(), androidKeyEvent.getUnicodeChar(0), androidKeyEvent.getUnicodeChar(), androidKeyEvent.getKeyCode(), complexCharacter, androidKeyEvent.getScanCode(), androidKeyEvent.getMetaState(), androidKeyEvent.getSource(), androidKeyEvent.getRepeatCount(), eventId);
        }

        public FlutterKeyEvent(int deviceId, int flags, int plainCodePoint, int codePoint, int keyCode, @Nullable Character complexCharacter, int scanCode, int metaState, int source, int repeatCount, long eventId) {
            this.deviceId = deviceId;
            this.flags = flags;
            this.plainCodePoint = plainCodePoint;
            this.codePoint = codePoint;
            this.keyCode = keyCode;
            this.complexCharacter = complexCharacter;
            this.scanCode = scanCode;
            this.metaState = metaState;
            this.source = source;
            this.repeatCount = repeatCount;
            this.eventId = eventId;
            InputDevice device = InputDevice.getDevice((int)deviceId);
            if (device != null) {
                if (Build.VERSION.SDK_INT >= 19) {
                    this.vendorId = device.getVendorId();
                    this.productId = device.getProductId();
                } else {
                    this.vendorId = 0;
                    this.productId = 0;
                }
            } else {
                this.vendorId = 0;
                this.productId = 0;
            }
        }
    }

    public static interface EventResponseHandler {
        public void onKeyEventHandled(long var1);

        public void onKeyEventNotHandled(long var1);
    }
}

