<p align="center">
  Web compilers for users of <a href="https://pub.dev/packages/build"><code>package:build</code></a>.
  <br>
  <a href="https://travis-ci.org/dart-lang/build">
    <img src="https://travis-ci.org/dart-lang/build.svg?branch=master" alt="Build Status" />
  </a>
  <a href="https://github.com/dart-lang/build/labels/package%3A%20build_web_compilers">
    <img src="https://img.shields.io/github/issues-raw/dart-lang/build/package%3A%20build_web_compilers.svg" alt="Issues related to build_web_compilers" />
  </a>
  <a href="https://pub.dev/packages/build_web_compilers">
    <img src="https://img.shields.io/pub/v/build_web_compilers.svg" alt="Pub Package Version" />
  </a>
  <a href="https://pub.dev/documentation/build_web_compilers/latest">
    <img src="https://img.shields.io/badge/dartdocs-latest-blue.svg" alt="Latest Dartdocs" />
  </a>
  <a href="https://gitter.im/dart-lang/build">
    <img src="https://badges.gitter.im/dart-lang/build.svg" alt="Join the chat on Gitter" />
  </a>
</p>

* [Installation](#installation)
* [Usage](#usage)
* [Configuration](#configuration)
* [Manual Usage](#manual-usage)

## Installation

This package is intended to be used as a [development dependency][] for users
of [`package:build`][] who want to run code in a browser. Simply add the
following to your `pubspec.yaml`:

```yaml
dev_dependencies:
  build_web_compilers:
```

## Usage

If you are using the autogenerated build script (going through
`pub run build_runner <command>` instead of handwriting a `build.dart` file),
then all you need is the `dev_dependency` listed above.

## Configuration

By default, the `dartdevc` compiler will be used, which is the Dart Development
Compiler.

If you would like to opt into `dart2js` you will need to add a `build.yaml`
file, which should look roughly like the following:

```yaml
targets:
  $default:
    builders:
      build_web_compilers|entrypoint:
        # These are globs for the entrypoints you want to compile.
        generate_for:
        - test/**.browser_test.dart
        - web/**.dart
        options:
          compiler: dart2js
          # List any dart2js specific args here, or omit it.
          dart2js_args:
          - -O2
```

## Manual Usage

If you are using a custom build script, you will need to add the following
builder applications to what you already have, almost certainly at the end of
the list (unless you need to post-process the js files).

```dart
[
    apply(
        'build_web_compilers|ddc',
        [
        (_) => new ModuleBuilder(),
        (_) => new UnlinkedSummaryBuilder(),
        (_) => new LinkedSummaryBuilder(),
        (_) => new DevCompilerBuilder()
        ],
        toAllPackages(),
        // Recommended, but not required. This makes it so only modules that are
        // imported by entrypoints get compiled.
        isOptional: true,
        hideOutput: true),
    apply('build_web_compilers|entrypoint',
        // You can also use `WebCompiler.Dart2Js`. If you don't care about
        // dartdevc at all you may also omit the previous builder application
        // entirely.
        [(_) => new WebEntrypointBuilder(WebCompiler.DartDevc)], toRoot(),
        hideOutput: true,
        // These globs should match your entrypoints only.
        defaultGenerateFor: const InputSet(
            include: const ['web/**', 'test/**.browser_test.dart'])),
]
```

[development dependency]: https://dart.dev/tools/pub/dependencies#dev-dependencies
[`package:build`]: https://pub.dev/packages/build
