/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.plugin.mouse;

import android.annotation.TargetApi;
import android.view.PointerIcon;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import io.flutter.embedding.engine.systemchannels.MouseCursorChannel;
import java.util.HashMap;

@TargetApi(value=24)
@RequiresApi(value=24)
public class MouseCursorPlugin {
    @NonNull
    private final MouseCursorViewDelegate mView;
    @NonNull
    private final MouseCursorChannel mouseCursorChannel;
    @NonNull
    private static HashMap<String, Integer> systemCursorConstants;

    public MouseCursorPlugin(@NonNull MouseCursorViewDelegate view, @NonNull MouseCursorChannel mouseCursorChannel) {
        this.mView = view;
        this.mouseCursorChannel = mouseCursorChannel;
        mouseCursorChannel.setMethodHandler(new MouseCursorChannel.MouseCursorMethodHandler(){

            @Override
            public void activateSystemCursor(@NonNull String kind) {
                MouseCursorPlugin.this.mView.setPointerIcon(MouseCursorPlugin.this.resolveSystemCursor(kind));
            }
        });
    }

    private PointerIcon resolveSystemCursor(@NonNull String kind) {
        if (systemCursorConstants == null) {
            systemCursorConstants = new HashMap<String, Integer>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("none", 0);
                    this.put("click", 1002);
                    this.put("text", 1008);
                    this.put("grab", 1020);
                    this.put("grabbing", 1021);
                    this.put("horizontalDoubleArrow", 1014);
                    this.put("verticalDoubleArrow", 1015);
                }
            };
        }
        int cursorConstant = systemCursorConstants.getOrDefault(kind, 1000);
        return this.mView.getSystemPointerIcon(cursorConstant);
    }

    public void destroy() {
        this.mouseCursorChannel.setMethodHandler(null);
    }

    public static interface MouseCursorViewDelegate {
        public PointerIcon getSystemPointerIcon(int var1);

        public void setPointerIcon(@NonNull PointerIcon var1);
    }
}

