// Copyright (c) 2016, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

library fasta.builder;

export '../identifiers.dart'
    show
        Identifier,
        InitializedIdentifier,
        QualifiedName,
        deprecated_extractToken,
        flattenName;

export '../scope.dart' show AccessErrorBuilder, Scope, ScopeBuilder;

export 'builtin_type_builder.dart' show BuiltinTypeBuilder;

export 'class_builder.dart' show ClassBuilder;

export 'constructor_reference_builder.dart' show ConstructorReferenceBuilder;

export 'declaration.dart' show Builder;

export 'dynamic_type_builder.dart' show DynamicTypeBuilder;

export 'enum_builder.dart' show EnumBuilder, EnumConstantInfo;

export 'field_builder.dart' show FieldBuilder;

export 'formal_parameter_builder.dart' show FormalParameterBuilder;

export 'procedure_builder.dart'
    show
        FunctionBuilder,
        ConstructorBuilder,
        ProcedureBuilder,
        RedirectingFactoryBuilder;

export 'function_type_builder.dart' show FunctionTypeBuilder;

export 'invalid_type_builder.dart' show InvalidTypeBuilder;

export 'library_builder.dart' show LibraryBuilder;

export 'member_builder.dart' show MemberBuilder;

export 'metadata_builder.dart' show MetadataBuilder;

export 'mixin_application_builder.dart' show MixinApplicationBuilder;

export 'modifier_builder.dart' show ModifierBuilder;

export 'name_iterator.dart' show NameIterator;

export 'named_type_builder.dart' show NamedTypeBuilder;

export 'nullability_builder.dart' show NullabilityBuilder;

export 'prefix_builder.dart' show PrefixBuilder;

export 'type_alias_builder.dart' show TypeAliasBuilder;

export 'type_builder.dart' show TypeBuilder;

export 'type_declaration_builder.dart' show TypeDeclarationBuilder;

export 'type_variable_builder.dart' show TypeVariableBuilder;

export 'unresolved_type.dart' show UnresolvedType;

export 'void_type_builder.dart' show VoidTypeBuilder;
