// Copyright (c) 2016, the Dart project authors.
// Please see the AUTHORS file
// for details. All rights reserved. Use of this source
// code is governed by a
// BSD-style license that can be found in the LICENSE file.

/// Test data for compact number formatting.
///
/// DO NOT EDIT. This file is autogenerated by script.  See
/// i18n/tools:dart_compact_number_test_data

/// WARNING: These tests are NOT consistent with ICU. Compact number formatting
/// has changed, needing some more involved Dart code changes to determine
/// significant digits and decimal digits. Manual edits were made to pair up
/// CLDR ver. 35 formats with old digit handling.

// MANUAL EDIT TO SUPPRESS WARNINGS IN GENERATED CODE
// ignore_for_file: prefer_single_quotes

/// The test data. A map, keyed by locale name, whose values
/// are a list of [basic, shortform, longform] formatted data
/// for different numbers.
Map<String, List<List<String>>> compactNumberTestData = {
  "af": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 k", "4,3 duisend"],
    ["54321", "54 k", "54 duisend"],
    ["654321", "654 k", "654 duisend"],
    ["7654321", "7,7 m", "7,7 miljoen"],
    ["87654321", "88 m", "88 miljoen"],
    ["987654321", "988 m", "988 miljoen"],
    ["1087654321", "1,1 mjd", "1,1 miljard"],
    ["11987654321", "12 mjd", "12 miljard"],
    ["129987654321", "130 mjd", "130 miljard"],
    ["1398987654321", "1,4 bn", "1,4 biljoen"],
    ["14987987654321", "15 bn", "15 biljoen"],
    ["159876987654321", "160 bn", "160 biljoen"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 duisend"],
    ["99999", "100 k", "100 duisend"],
    ["99999", "100 k", "100 duisend"],
    ["999999", "1 m", "1 miljoen"],
    ["9999999", "10 m", "10 miljoen"],
    ["99999999", "100 m", "100 miljoen"],
    ["9994", "10 k", "10 duisend"],
    ["99944", "100 k", "100 duisend"],
    ["999444", "999 k", "999 duisend"],
    ["9994444", "10 m", "10 miljoen"],
    ["999444444", "999 m", "999 miljoen"],
    ["9994444444", "10 mjd", "10 miljard"],
  ],
  "am": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 ሺ", "4.3 ሺ"],
    ["54321", "54 ሺ", "54 ሺ"],
    ["654321", "654 ሺ", "654 ሺ"],
    ["7654321", "7.7 ሜትር", "7.7 ሚሊዮን"],
    ["87654321", "88 ሜትር", "88 ሚሊዮን"],
    ["987654321", "988ሜ", "988 ሚሊዮን"],
    ["1087654321", "1.1 ቢ", "1.1 ቢሊዮን"],
    ["11987654321", "12 ቢ", "12 ቢሊዮን"],
    ["129987654321", "130 ቢ", "130 ቢሊዮን"],
    ["1398987654321", "1.4 ት", "1.4 ትሪሊዮን"],
    ["14987987654321", "15 ት", "15 ትሪሊዮን"],
    ["159876987654321", "160 ት", "160 ትሪሊዮን"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ሺ", "10 ሺ"],
    ["99999", "100 ሺ", "100 ሺ"],
    ["99999", "100 ሺ", "100 ሺ"],
    ["999999", "1 ሜትር", "1 ሚሊዮን"],
    ["9999999", "10 ሜትር", "10 ሚሊዮን"],
    ["99999999", "100ሜ", "100 ሚሊዮን"],
    ["9994", "10 ሺ", "10 ሺ"],
    ["99944", "100 ሺ", "100 ሺ"],
    ["999444", "999 ሺ", "999 ሺ"],
    ["9994444", "10 ሜትር", "10 ሚሊዮን"],
    ["999444444", "999ሜ", "999 ሚሊዮን"],
    ["9994444444", "10 ቢ", "10 ቢሊዮን"],
  ],
  "ar": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 ألف", "4.3 ألف"],
    ["54321", "54 ألف", "54 ألف"],
    ["654321", "654 ألف", "654 ألف"],
    ["7654321", "7.7 مليون", "7.7 مليون"],
    ["87654321", "88 مليون", "88 مليون"],
    ["987654321", "988 مليون", "988 مليون"],
    ["1087654321", "1.1 مليار", "1.1 مليار"],
    ["11987654321", "12 مليار", "12 مليار"],
    ["129987654321", "130 مليار", "130 مليار"],
    ["1398987654321", "1.4 ترليون", "1.4 ترليون"],
    ["14987987654321", "15 ترليون", "15 ترليون"],
    ["159876987654321", "160 ترليون", "160 ترليون"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ألف", "10 ألف"],
    ["99999", "100 ألف", "100 ألف"],
    ["99999", "100 ألف", "100 ألف"],
    ["999999", "1 مليون", "1 مليون"],
    ["9999999", "10 مليون", "10 ملايين"],
    ["99999999", "100 مليون", "100 مليون"],
    ["9994", "10 ألف", "10 ألف"],
    ["99944", "100 ألف", "100 ألف"],
    ["999444", "999 ألف", "999 ألف"],
    ["9994444", "10 مليون", "10 ملايين"],
    ["999444444", "999 مليون", "999 مليون"],
    ["9994444444", "10 مليار", "10 مليار"],
  ],
  "ar_DZ": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 ألف", "4,3 ألف"],
    ["54321", "54 ألف", "54 ألف"],
    ["654321", "654 ألف", "654 ألف"],
    ["7654321", "7,7 مليون", "7,7 مليون"],
    ["87654321", "88 مليون", "88 مليون"],
    ["987654321", "988 مليون", "988 مليون"],
    ["1087654321", "1,1 مليار", "1,1 مليار"],
    ["11987654321", "12 مليار", "12 مليار"],
    ["129987654321", "130 مليار", "130 مليار"],
    ["1398987654321", "1,4 ترليون", "1,4 ترليون"],
    ["14987987654321", "15 ترليون", "15 ترليون"],
    ["159876987654321", "160 ترليون", "160 ترليون"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ألف", "10 ألف"],
    ["99999", "100 ألف", "100 ألف"],
    ["99999", "100 ألف", "100 ألف"],
    ["999999", "1 مليون", "1 مليون"],
    ["9999999", "10 مليون", "10 ملايين"],
    ["99999999", "100 مليون", "100 مليون"],
    ["9994", "10 ألف", "10 ألف"],
    ["99944", "100 ألف", "100 ألف"],
    ["999444", "999 ألف", "999 ألف"],
    ["9994444", "10 مليون", "10 ملايين"],
    ["999444444", "999 مليون", "999 مليون"],
    ["9994444444", "10 مليار", "10 مليار"],
  ],
  "ar_EG": [
    ["1", "١", "١"],
    ["21", "٢١", "٢١"],
    ["321", "٣٢١", "٣٢١"],
    ["4321", "٤٫٣ ألف", "٤٫٣ ألف"],
    ["54321", "٥٤ ألف", "٥٤ ألف"],
    ["654321", "٦٥٤ ألف", "٦٥٤ ألف"],
    ["7654321", "٧٫٧ مليون", "٧٫٧ مليون"],
    ["87654321", "٨٨ مليون", "٨٨ مليون"],
    ["987654321", "٩٨٨ مليون", "٩٨٨ مليون"],
    ["1087654321", "١٫١ مليار", "١٫١ مليار"],
    ["11987654321", "١٢ مليار", "١٢ مليار"],
    ["129987654321", "١٣٠ مليار", "١٣٠ مليار"],
    ["1398987654321", "١٫٤ ترليون", "١٫٤ ترليون"],
    ["14987987654321", "١٥ ترليون", "١٥ ترليون"],
    ["159876987654321", "١٦٠ ترليون", "١٦٠ ترليون"],
    ["9", "٩", "٩"],
    ["99", "٩٩", "٩٩"],
    ["999", "٩٩٩", "٩٩٩"],
    ["9999", "١٠ ألف", "١٠ ألف"],
    ["99999", "١٠٠ ألف", "١٠٠ ألف"],
    ["99999", "١٠٠ ألف", "١٠٠ ألف"],
    ["999999", "١ مليون", "١ مليون"],
    ["9999999", "١٠ مليون", "١٠ ملايين"],
    ["99999999", "١٠٠ مليون", "١٠٠ مليون"],
    ["9994", "١٠ ألف", "١٠ ألف"],
    ["99944", "١٠٠ ألف", "١٠٠ ألف"],
    ["999444", "٩٩٩ ألف", "٩٩٩ ألف"],
    ["9994444", "١٠ مليون", "١٠ ملايين"],
    ["999444444", "٩٩٩ مليون", "٩٩٩ مليون"],
    ["9994444444", "١٠ مليار", "١٠ مليار"],
  ],
  "az": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3K", "4,3 min"],
    ["54321", "54K", "54 min"],
    ["654321", "654K", "654 min"],
    ["7654321", "7,7M", "7,7 milyon"],
    ["87654321", "88M", "88 milyon"],
    ["987654321", "988M", "988 milyon"],
    ["1087654321", "1,1G", "1,1 milyard"],
    ["11987654321", "12G", "12 milyard"],
    ["129987654321", "130G", "130 milyard"],
    ["1398987654321", "1,4T", "1,4 trilyon"],
    ["14987987654321", "15T", "15 trilyon"],
    ["159876987654321", "160T", "160 trilyon"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 min"],
    ["99999", "100K", "100 min"],
    ["99999", "100K", "100 min"],
    ["999999", "1M", "1 milyon"],
    ["9999999", "10M", "10 milyon"],
    ["99999999", "100M", "100 milyon"],
    ["9994", "10K", "10 min"],
    ["99944", "100K", "100 min"],
    ["999444", "999K", "999 min"],
    ["9994444", "10M", "10 milyon"],
    ["999444444", "999M", "999 milyon"],
    ["9994444444", "10G", "10 milyard"],
  ],
  "be": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 тыс.", "4,3 тысячы"],
    ["54321", "54 тыс.", "54 тысячы"],
    ["654321", "654 тыс.", "654 тысячы"],
    ["7654321", "7,7 млн", "7,7 мільёна"],
    ["87654321", "88 млн", "88 мільёнаў"],
    ["987654321", "988 млн", "988 мільёнаў"],
    ["1087654321", "1,1 млрд", "1,1 мільярда"],
    ["11987654321", "12 млрд", "12 мільярдаў"],
    ["129987654321", "130 млрд", "130 мільярдаў"],
    ["1398987654321", "1,4 трлн", "1,4 трыльёна"],
    ["14987987654321", "15 трлн", "15 трыльёнаў"],
    ["159876987654321", "160 трлн", "160 трыльёнаў"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 тыс.", "10 тысяч"],
    ["99999", "100 тыс.", "100 тысяч"],
    ["99999", "100 тыс.", "100 тысяч"],
    ["999999", "1 млн", "1 мільён"],
    ["9999999", "10 млн", "10 мільёнаў"],
    ["99999999", "100 млн", "100 мільёнаў"],
    ["9994", "10 тыс.", "10 тысяч"],
    ["99944", "100 тыс.", "100 тысяч"],
    ["999444", "999 тыс.", "999 тысяч"],
    ["9994444", "10 млн", "10 мільёнаў"],
    ["999444444", "999 млн", "999 мільёнаў"],
    ["9994444444", "10 млрд", "10 мільярдаў"],
  ],
  "bg": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 хил.", "4,3 хиляди"],
    ["54321", "54 хил.", "54 хиляди"],
    ["654321", "654 хил.", "654 хиляди"],
    ["7654321", "7,7 млн.", "7,7 милиона"],
    ["87654321", "88 млн.", "88 милиона"],
    ["987654321", "988 млн.", "988 милиона"],
    ["1087654321", "1,1 млрд.", "1,1 милиарда"],
    ["11987654321", "12 млрд.", "12 милиарда"],
    ["129987654321", "130 млрд.", "130 милиарда"],
    ["1398987654321", "1,4 трлн.", "1,4 трилиона"],
    ["14987987654321", "15 трлн.", "15 трилиона"],
    ["159876987654321", "160 трлн.", "160 трилиона"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 хил.", "10 хиляди"],
    ["99999", "100 хил.", "100 хиляди"],
    ["99999", "100 хил.", "100 хиляди"],
    ["999999", "1 млн.", "1 милион"],
    ["9999999", "10 млн.", "10 милиона"],
    ["99999999", "100 млн.", "100 милиона"],
    ["9994", "10 хил.", "10 хиляди"],
    ["99944", "100 хил.", "100 хиляди"],
    ["999444", "999 хил.", "999 хиляди"],
    ["9994444", "10 млн.", "10 милиона"],
    ["999444444", "999 млн.", "999 милиона"],
    ["9994444444", "10 млрд.", "10 милиарда"],
  ],
  "bn": [
    ["1", "১", "১"],
    ["21", "২১", "২১"],
    ["321", "৩২১", "৩২১"],
    ["4321", "৪.৩ হা", "৪.৩ হাজার"],
    ["54321", "৫৪ হা", "৫৪ হাজার"],
    ["654321", "৬.৫ লা", "৬.৫ লাখ"],
    ["7654321", "৭৭ লা", "৭৭ লাখ"],
    ["87654321", "৮.৮ কো", "৮.৮ কোটি"],
    ["987654321", "৯৯ কো", "৯৯ কোটি"],
    ["1087654321", "১০৯ কো", "১০৯ কোটি"],
    ["11987654321", "১১৯৯ কো", "১১৯৯ কোটি"],
    ["129987654321", "১২,৯৯৯ কো", "১২,৯৯৯ কোটি"],
    ["1398987654321", "১.৪ লা.কো.", "১.৪ লাখ কোটি"],
    ["14987987654321", "১৫ লা.কো.", "১৫ লাখ কোটি"],
    ["159876987654321", "১৬০ লা.কো.", "১৬০ লাখ কোটি"],
    ["9", "৯", "৯"],
    ["99", "৯৯", "৯৯"],
    ["999", "৯৯৯", "৯৯৯"],
    ["9999", "১০ হা", "১০ হাজার"],
    ["99999", "১ লা", "১ লাখ"],
    ["99999", "১ লা", "১ লাখ"],
    ["999999", "১০ লা", "১০ লাখ"],
    ["9999999", "১ কো", "১ কোটি"],
    ["99999999", "১০ কো", "১০ কোটি"],
    ["9994", "১০ হা", "১০ হাজার"],
    ["99944", "১ লা", "১ লাখ"],
    ["999444", "১০ লা", "১০ লাখ"],
    ["9994444", "১ কো", "১ কোটি"],
    ["999444444", "১০০ কো", "১০০ কোটি"],
    ["9994444444", "৯৯৯ কো", "৯৯৯ কোটি"],
  ],
  "br": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3k", "4,3 miliad"],
    ["54321", "54k", "54 miliad"],
    ["654321", "654k", "654 miliad"],
    ["7654321", "7,7M", "7,7 milion"],
    ["87654321", "88M", "88 milion"],
    ["987654321", "988M", "988 milion"],
    ["1087654321", "1,1G", "1,1 miliard"],
    ["11987654321", "12G", "12 miliard"],
    ["129987654321", "130G", "130 miliard"],
    ["1398987654321", "1,4T", "1,4 bilion"],
    ["14987987654321", "15T", "15 bilion"],
    ["159876987654321", "160T", "160 bilion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10k", "10 miliad"],
    ["99999", "100k", "100 miliad"],
    ["99999", "100k", "100 miliad"],
    ["999999", "1M", "1 milion"],
    ["9999999", "10M", "10 milion"],
    ["99999999", "100M", "100 milion"],
    ["9994", "10k", "10 miliad"],
    ["99944", "100k", "100 miliad"],
    ["999444", "999k", "999 miliad"],
    ["9994444", "10M", "10 milion"],
    ["999444444", "999M", "999 milion"],
    ["9994444444", "10G", "10 miliard"],
  ],
  "bs": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 hilj.", "4,3 hiljade"],
    ["54321", "54 hilj.", "54 hiljade"],
    ["654321", "654 hilj.", "654 hiljade"],
    ["7654321", "7,7 mil.", "7,7 miliona"],
    ["87654321", "88 mil.", "88 miliona"],
    ["987654321", "988 mil.", "988 miliona"],
    ["1087654321", "1,1 mlr.", "1,1 milijarda"],
    ["11987654321", "12 mlr.", "12 milijardi"],
    ["129987654321", "130 mlr.", "130 milijardi"],
    ["1398987654321", "1,4 bil.", "1,4 biliona"],
    ["14987987654321", "15 bil.", "15 biliona"],
    ["159876987654321", "160 bil.", "160 biliona"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 hilj.", "10 hiljada"],
    ["99999", "100 hilj.", "100 hiljada"],
    ["99999", "100 hilj.", "100 hiljada"],
    ["999999", "1 mil.", "1 milion"],
    ["9999999", "10 mil.", "10 miliona"],
    ["99999999", "100 mil.", "100 miliona"],
    ["9994", "10 hilj.", "10 hiljada"],
    ["99944", "100 hilj.", "100 hiljada"],
    ["999444", "999 hilj.", "999 hiljada"],
    ["9994444", "10 mil.", "10 miliona"],
    ["999444444", "999 mil.", "999 miliona"],
    ["9994444444", "10 mlr.", "10 milijardi"],
  ],
  "ca": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3m", "4,3 milers"],
    ["54321", "54m", "54 milers"],
    ["654321", "654m", "654 milers"],
    ["7654321", "7,7 M", "7,7 milions"],
    ["87654321", "88 M", "88 milions"],
    ["987654321", "988 M", "988 milions"],
    ["1087654321", "1088 M", "1,1 milers de milions"],
    ["11987654321", "12mM", "12 milers de milions"],
    ["129987654321", "130mM", "130 milers de milions"],
    ["1398987654321", "1,4 B", "1,4 bilions"],
    ["14987987654321", "15 B", "15 bilions"],
    ["159876987654321", "160 B", "160 bilions"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10m", "10 milers"],
    ["99999", "100m", "100 milers"],
    ["99999", "100m", "100 milers"],
    ["999999", "1 M", "1 milió"],
    ["9999999", "10 M", "10 milions"],
    ["99999999", "100 M", "100 milions"],
    ["9994", "10m", "10 milers"],
    ["99944", "100m", "100 milers"],
    ["999444", "999m", "999 milers"],
    ["9994444", "10 M", "10 milions"],
    ["999444444", "999 M", "999 milions"],
    ["9994444444", "9994 M", "10 milers de milions"],
  ],
  "chr": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 ᎢᏯᎦᏴᎵ"],
    ["54321", "54K", "54 ᎢᏯᎦᏴᎵ"],
    ["654321", "654K", "654 ᎢᏯᎦᏴᎵ"],
    ["7654321", "7.7M", "7.7 ᎢᏳᏆᏗᏅᏛ"],
    ["87654321", "88M", "88 ᎢᏳᏆᏗᏅᏛ"],
    ["987654321", "988M", "988 ᎢᏳᏆᏗᏅᏛ"],
    ["1087654321", "1.1B", "1.1 ᎢᏯᏔᎳᏗᏅᏛ"],
    ["11987654321", "12B", "12 ᎢᏯᏔᎳᏗᏅᏛ"],
    ["129987654321", "130B", "130 ᎢᏯᏔᎳᏗᏅᏛ"],
    ["1398987654321", "1.4T", "1.4 ᎢᏯᏦᎠᏗᏅᏛ"],
    ["14987987654321", "15T", "15 ᎢᏯᏦᎠᏗᏅᏛ"],
    ["159876987654321", "160T", "160 ᎢᏯᏦᎠᏗᏅᏛ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 ᎢᏯᎦᏴᎵ"],
    ["99999", "100K", "100 ᎢᏯᎦᏴᎵ"],
    ["99999", "100K", "100 ᎢᏯᎦᏴᎵ"],
    ["999999", "1M", "1 ᎢᏳᏆᏗᏅᏛ"],
    ["9999999", "10M", "10 ᎢᏳᏆᏗᏅᏛ"],
    ["99999999", "100M", "100 ᎢᏳᏆᏗᏅᏛ"],
    ["9994", "10K", "10 ᎢᏯᎦᏴᎵ"],
    ["99944", "100K", "100 ᎢᏯᎦᏴᎵ"],
    ["999444", "999K", "999 ᎢᏯᎦᏴᎵ"],
    ["9994444", "10M", "10 ᎢᏳᏆᏗᏅᏛ"],
    ["999444444", "999M", "999 ᎢᏳᏆᏗᏅᏛ"],
    ["9994444444", "10B", "10 ᎢᏯᏔᎳᏗᏅᏛ"],
  ],
  "cs": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tis.", "4,3 tisíce"],
    ["54321", "54 tis.", "54 tisíc"],
    ["654321", "654 tis.", "654 tisíc"],
    ["7654321", "7,7 mil.", "7,7 milionu"],
    ["87654321", "88 mil.", "88 milionů"],
    ["987654321", "988 mil.", "988 milionů"],
    ["1087654321", "1,1 mld.", "1,1 miliardy"],
    ["11987654321", "12 mld.", "12 miliard"],
    ["129987654321", "130 mld.", "130 miliard"],
    ["1398987654321", "1,4 bil.", "1,4 bilionu"],
    ["14987987654321", "15 bil.", "15 bilionů"],
    ["159876987654321", "160 bil.", "160 bilionů"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tis.", "10 tisíc"],
    ["99999", "100 tis.", "100 tisíc"],
    ["99999", "100 tis.", "100 tisíc"],
    ["999999", "1 mil.", "1 milion"],
    ["9999999", "10 mil.", "10 milionů"],
    ["99999999", "100 mil.", "100 milionů"],
    ["9994", "10 tis.", "10 tisíc"],
    ["99944", "100 tis.", "100 tisíc"],
    ["999444", "999 tis.", "999 tisíc"],
    ["9994444", "10 mil.", "10 milionů"],
    ["999444444", "999 mil.", "999 milionů"],
    ["9994444444", "10 mld.", "10 miliard"],
  ],
  "cy": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 mil"],
    ["54321", "54K", "54 mil"],
    ["654321", "654K", "654 mil"],
    ["7654321", "7.7M", "7.7 miliwn"],
    ["87654321", "88M", "88 miliwn"],
    ["987654321", "988M", "988 miliwn"],
    ["1087654321", "1.1B", "1.1 biliwn"],
    ["11987654321", "12B", "12 biliwn"],
    ["129987654321", "130B", "130 biliwn"],
    ["1398987654321", "1.4T", "1.4 triliwn"],
    ["14987987654321", "15T", "15 triliwn"],
    ["159876987654321", "160T", "160 triliwn"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 mil"],
    ["99999", "100K", "100 mil"],
    ["99999", "100K", "100 mil"],
    ["999999", "1M", "1 miliwn"],
    ["9999999", "10M", "10 miliwn"],
    ["99999999", "100M", "100 miliwn"],
    ["9994", "10K", "10 mil"],
    ["99944", "100K", "100 mil"],
    ["999444", "999K", "999 mil"],
    ["9994444", "10M", "10 miliwn"],
    ["999444444", "999M", "999 miliwn"],
    ["9994444444", "10B", "10 biliwn"],
  ],
  "da": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 t", "4,3 tusind"],
    ["54321", "54 t", "54 tusind"],
    ["654321", "654 t", "654 tusind"],
    ["7654321", "7,7 mio.", "7,7 millioner"],
    ["87654321", "88 mio.", "88 millioner"],
    ["987654321", "988 mio.", "988 millioner"],
    ["1087654321", "1,1 mia.", "1,1 milliard"],
    ["11987654321", "12 mia.", "12 milliarder"],
    ["129987654321", "130 mia.", "130 milliarder"],
    ["1398987654321", "1,4 bio.", "1,4 billion"],
    ["14987987654321", "15 bio.", "15 billioner"],
    ["159876987654321", "160 bio.", "160 billioner"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 t", "10 tusind"],
    ["99999", "100 t", "100 tusind"],
    ["99999", "100 t", "100 tusind"],
    ["999999", "1 mio.", "1 million"],
    ["9999999", "10 mio.", "10 millioner"],
    ["99999999", "100 mio.", "100 millioner"],
    ["9994", "10 t", "10 tusind"],
    ["99944", "100 t", "100 tusind"],
    ["999444", "999 t", "999 tusind"],
    ["9994444", "10 mio.", "10 millioner"],
    ["999444444", "999 mio.", "999 millioner"],
    ["9994444444", "10 mia.", "10 milliarder"],
  ],
  "de": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4,3 Tausend"],
    ["54321", "54.321", "54 Tausend"],
    ["654321", "654.321", "654 Tausend"],
    ["7654321", "7,7 Mio.", "7,7 Millionen"],
    ["87654321", "88 Mio.", "88 Millionen"],
    ["987654321", "988 Mio.", "988 Millionen"],
    ["1087654321", "1,1 Mrd.", "1,1 Milliarden"],
    ["11987654321", "12 Mrd.", "12 Milliarden"],
    ["129987654321", "130 Mrd.", "130 Milliarden"],
    ["1398987654321", "1,4 Bio.", "1,4 Billionen"],
    ["14987987654321", "15 Bio.", "15 Billionen"],
    ["159876987654321", "160 Bio.", "160 Billionen"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "10 Tausend"],
    ["99999", "99.999", "100 Tausend"],
    ["99999", "99.999", "100 Tausend"],
    ["999999", "999.999", "1 Million"],
    ["9999999", "10 Mio.", "10 Millionen"],
    ["99999999", "100 Mio.", "100 Millionen"],
    ["9994", "9994", "10 Tausend"],
    ["99944", "99.944", "100 Tausend"],
    ["999444", "999.444", "999 Tausend"],
    ["9994444", "10 Mio.", "10 Millionen"],
    ["999444444", "999 Mio.", "999 Millionen"],
    ["9994444444", "10 Mrd.", "10 Milliarden"],
  ],
  "de_AT": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4,3 Tausend"],
    ["54321", "54 321", "54 Tausend"],
    ["654321", "654 321", "654 Tausend"],
    ["7654321", "7,7 Mio.", "7,7 Millionen"],
    ["87654321", "88 Mio.", "88 Millionen"],
    ["987654321", "988 Mio.", "988 Millionen"],
    ["1087654321", "1,1 Mrd.", "1,1 Milliarden"],
    ["11987654321", "12 Mrd.", "12 Milliarden"],
    ["129987654321", "130 Mrd.", "130 Milliarden"],
    ["1398987654321", "1,4 Bio.", "1,4 Billionen"],
    ["14987987654321", "15 Bio.", "15 Billionen"],
    ["159876987654321", "160 Bio.", "160 Billionen"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "10 Tausend"],
    ["99999", "99 999", "100 Tausend"],
    ["99999", "99 999", "100 Tausend"],
    ["999999", "999 999", "1 Million"],
    ["9999999", "10 Mio.", "10 Millionen"],
    ["99999999", "100 Mio.", "100 Millionen"],
    ["9994", "9994", "10 Tausend"],
    ["99944", "99 944", "100 Tausend"],
    ["999444", "999 444", "999 Tausend"],
    ["9994444", "10 Mio.", "10 Millionen"],
    ["999444444", "999 Mio.", "999 Millionen"],
    ["9994444444", "10 Mrd.", "10 Milliarden"],
  ],
  "de_CH": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4.3 Tausend"],
    ["54321", "54’321", "54 Tausend"],
    ["654321", "654’321", "654 Tausend"],
    ["7654321", "7.7 Mio.", "7.7 Millionen"],
    ["87654321", "88 Mio.", "88 Millionen"],
    ["987654321", "988 Mio.", "988 Millionen"],
    ["1087654321", "1.1 Mrd.", "1.1 Milliarden"],
    ["11987654321", "12 Mrd.", "12 Milliarden"],
    ["129987654321", "130 Mrd.", "130 Milliarden"],
    ["1398987654321", "1.4 Bio.", "1.4 Billionen"],
    ["14987987654321", "15 Bio.", "15 Billionen"],
    ["159876987654321", "160 Bio.", "160 Billionen"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "10 Tausend"],
    ["99999", "99’999", "100 Tausend"],
    ["99999", "99’999", "100 Tausend"],
    ["999999", "999’999", "1 Million"],
    ["9999999", "10 Mio.", "10 Millionen"],
    ["99999999", "100 Mio.", "100 Millionen"],
    ["9994", "9994", "10 Tausend"],
    ["99944", "99’944", "100 Tausend"],
    ["999444", "999’444", "999 Tausend"],
    ["9994444", "10 Mio.", "10 Millionen"],
    ["999444444", "999 Mio.", "999 Millionen"],
    ["9994444444", "10 Mrd.", "10 Milliarden"],
  ],
  "el": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 χιλ.", "4,3 χιλιάδες"],
    ["54321", "54 χιλ.", "54 χιλιάδες"],
    ["654321", "654 χιλ.", "654 χιλιάδες"],
    ["7654321", "7,7 εκ.", "7,7 εκατομμύρια"],
    ["87654321", "88 εκ.", "88 εκατομμύρια"],
    ["987654321", "988 εκ.", "988 εκατομμύρια"],
    ["1087654321", "1,1 δισ.", "1,1 δισεκατομμύρια"],
    ["11987654321", "12 δισ.", "12 δισεκατομμύρια"],
    ["129987654321", "130 δισ.", "130 δισεκατομμύρια"],
    ["1398987654321", "1,4 τρισ.", "1,4 τρισεκατομμύρια"],
    ["14987987654321", "15 τρισ.", "15 τρισεκατομμύρια"],
    ["159876987654321", "160 τρισ.", "160 τρισεκατομμύρια"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 χιλ.", "10 χιλιάδες"],
    ["99999", "100 χιλ.", "100 χιλιάδες"],
    ["99999", "100 χιλ.", "100 χιλιάδες"],
    ["999999", "1 εκ.", "1 εκατομμύριο"],
    ["9999999", "10 εκ.", "10 εκατομμύρια"],
    ["99999999", "100 εκ.", "100 εκατομμύρια"],
    ["9994", "10 χιλ.", "10 χιλιάδες"],
    ["99944", "100 χιλ.", "100 χιλιάδες"],
    ["999444", "999 χιλ.", "999 χιλιάδες"],
    ["9994444", "10 εκ.", "10 εκατομμύρια"],
    ["999444444", "999 εκ.", "999 εκατομμύρια"],
    ["9994444444", "10 δισ.", "10 δισεκατομμύρια"],
  ],
  "en": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
  ],
  "en_AU": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
  ],
  "en_CA": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
  ],
  "en_GB": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
  ],
  "en_IE": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
  ],
  "en_IN": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
  ],
  "en_SG": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
  ],
  "en_US": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
  ],
  "en_ZA": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3K", "4,3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7,7M", "7,7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1,1B", "1,1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1,4T", "1,4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
  ],
  "es": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 mil", "4,3 mil"],
    ["54321", "54 mil", "54 mil"],
    ["654321", "654 mil", "654 mil"],
    ["7654321", "7,7 M", "7,7 millones"],
    ["87654321", "88 M", "88 millones"],
    ["987654321", "988 M", "988 millones"],
    ["1087654321", "1088 M", "1,1 mil millones"],
    ["11987654321", "12 mil M", "12 mil millones"],
    ["129987654321", "130 mil M", "130 mil millones"],
    ["1398987654321", "1,4 B", "1,4 billones"],
    ["14987987654321", "15 B", "15 billones"],
    ["159876987654321", "160 B", "160 billones"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mil", "10 mil"],
    ["99999", "100 mil", "100 mil"],
    ["99999", "100 mil", "100 mil"],
    ["999999", "1 M", "1 millón"],
    ["9999999", "10 M", "10 millones"],
    ["99999999", "100 M", "100 millones"],
    ["9994", "10 mil", "10 mil"],
    ["99944", "100 mil", "100 mil"],
    ["999444", "999 mil", "999 mil"],
    ["9994444", "10 M", "10 millones"],
    ["999444444", "999 M", "999 millones"],
    ["9994444444", "9994 M", "10 mil millones"],
  ],
  "es_419": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 K", "4.3 mil"],
    ["54321", "54 k", "54 mil"],
    ["654321", "654 k", "654 mil"],
    ["7654321", "7.7 M", "7.7 millones"],
    ["87654321", "88 M", "88 millones"],
    ["987654321", "988 M", "988 millones"],
    ["1087654321", "1.1k M", "1.1 mil millones"],
    ["11987654321", "12k M", "12 mil millones"],
    ["129987654321", "130k M", "130 mil millones"],
    ["1398987654321", "1.4 B", "1.4 billón"],
    ["14987987654321", "15 B", "15 billones"],
    ["159876987654321", "160 B", "160 billones"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 mil"],
    ["99999", "100 k", "100 mil"],
    ["99999", "100 k", "100 mil"],
    ["999999", "1 M", "1 millón"],
    ["9999999", "10 M", "10 millones"],
    ["99999999", "100 M", "100 millones"],
    ["9994", "10 k", "10 mil"],
    ["99944", "100 k", "100 mil"],
    ["999444", "999 k", "999 mil"],
    ["9994444", "10 M", "10 millones"],
    ["999444444", "999 M", "999 millones"],
    ["9994444444", "10k M", "10 mil millones"],
  ],
  "es_ES": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 mil", "4,3 mil"],
    ["54321", "54 mil", "54 mil"],
    ["654321", "654 mil", "654 mil"],
    ["7654321", "7,7 M", "7,7 millones"],
    ["87654321", "88 M", "88 millones"],
    ["987654321", "988 M", "988 millones"],
    ["1087654321", "1088 M", "1,1 mil millones"],
    ["11987654321", "12 mil M", "12 mil millones"],
    ["129987654321", "130 mil M", "130 mil millones"],
    ["1398987654321", "1,4 B", "1,4 billones"],
    ["14987987654321", "15 B", "15 billones"],
    ["159876987654321", "160 B", "160 billones"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mil", "10 mil"],
    ["99999", "100 mil", "100 mil"],
    ["99999", "100 mil", "100 mil"],
    ["999999", "1 M", "1 millón"],
    ["9999999", "10 M", "10 millones"],
    ["99999999", "100 M", "100 millones"],
    ["9994", "10 mil", "10 mil"],
    ["99944", "100 mil", "100 mil"],
    ["999444", "999 mil", "999 mil"],
    ["9994444", "10 M", "10 millones"],
    ["999444444", "999 M", "999 millones"],
    ["9994444444", "9994 M", "10 mil millones"],
  ],
  "es_MX": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 k", "4.3 mil"],
    ["54321", "54 k", "54 mil"],
    ["654321", "654 k", "654 mil"],
    ["7654321", "7.7 M", "7.7 millones"],
    ["87654321", "88 M", "88 millones"],
    ["987654321", "988 M", "988 millones"],
    ["1087654321", "1088 M", "1.1 mil millones"],
    ["11987654321", "12 mil M", "12 mil millones"],
    ["129987654321", "130 mil M", "130 mil millones"],
    ["1398987654321", "1.4 B", "1.4 billones"],
    ["14987987654321", "15 B", "15 billones"],
    ["159876987654321", "160 B", "160 billones"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 mil"],
    ["99999", "100 k", "100 mil"],
    ["99999", "100 k", "100 mil"],
    ["999999", "1 M", "1 millón"],
    ["9999999", "10 M", "10 millones"],
    ["99999999", "100 M", "100 millones"],
    ["9994", "10 k", "10 mil"],
    ["99944", "100 k", "100 mil"],
    ["999444", "999 k", "999 mil"],
    ["9994444", "10 M", "10 millones"],
    ["999444444", "999 M", "999 millones"],
    ["9994444444", "9994 M", "10 mil millones"],
  ],
  "es_US": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 K", "4.3 mil"],
    ["54321", "54 K", "54 mil"],
    ["654321", "654 K", "654 mil"],
    ["7654321", "7.7 M", "7.7 millones"],
    ["87654321", "88 M", "88 millones"],
    ["987654321", "988 M", "988 millones"],
    ["1087654321", "1.1 B", "1.1 billones"],
    ["11987654321", "12 B", "12 billones"],
    ["129987654321", "130 B", "130 billones"],
    ["1398987654321", "1.4 T", "1.4 trillones"],
    ["14987987654321", "15 T", "15 trillones"],
    ["159876987654321", "160 T", "160 trillones"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 K", "10 mil"],
    ["99999", "100 K", "100 mil"],
    ["99999", "100 K", "100 mil"],
    ["999999", "1 M", "1 millón"],
    ["9999999", "10 M", "10 millones"],
    ["99999999", "100 M", "100 millones"],
    ["9994", "10 K", "10 mil"],
    ["99944", "100 K", "100 mil"],
    ["999444", "999 K", "999 mil"],
    ["9994444", "10 M", "10 millones"],
    ["999444444", "999 M", "999 millones"],
    ["9994444444", "10 B", "10 billones"],
  ],
  "et": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tuh", "4,3 tuhat"],
    ["54321", "54 tuh", "54 tuhat"],
    ["654321", "654 tuh", "654 tuhat"],
    ["7654321", "7,7 mln", "7,7 miljonit"],
    ["87654321", "88 mln", "88 miljonit"],
    ["987654321", "988 mln", "988 miljonit"],
    ["1087654321", "1,1 mld", "1,1 miljardit"],
    ["11987654321", "12 mld", "12 miljardit"],
    ["129987654321", "130 mld", "130 miljardit"],
    ["1398987654321", "1,4 trl", "1,4 triljonit"],
    ["14987987654321", "15 trl", "15 triljonit"],
    ["159876987654321", "160 trl", "160 triljonit"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tuh", "10 tuhat"],
    ["99999", "100 tuh", "100 tuhat"],
    ["99999", "100 tuh", "100 tuhat"],
    ["999999", "1 mln", "1 miljon"],
    ["9999999", "10 mln", "10 miljonit"],
    ["99999999", "100 mln", "100 miljonit"],
    ["9994", "10 tuh", "10 tuhat"],
    ["99944", "100 tuh", "100 tuhat"],
    ["999444", "999 tuh", "999 tuhat"],
    ["9994444", "10 mln", "10 miljonit"],
    ["999444444", "999 mln", "999 miljonit"],
    ["9994444444", "10 mld", "10 miljardit"],
  ],
  "eu": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4321"],
    ["54321", "54.321", "54.321"],
    ["654321", "654.321", "654.321"],
    ["7654321", "7,7 M", "7,7 milioi"],
    ["87654321", "88 M", "88 milioi"],
    ["987654321", "988 M", "988 milioi"],
    ["1087654321", "1088 M", "1088 milioi"],
    ["11987654321", "11.988 M", "11.988 milioi"],
    ["129987654321", "129.988 M", "129.988 milioi"],
    ["1398987654321", "1,4 B", "1,4 bilioi"],
    ["14987987654321", "15 B", "15 bilioi"],
    ["159876987654321", "160 B", "160 bilioi"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "9999"],
    ["99999", "99.999", "99.999"],
    ["99999", "99.999", "99.999"],
    ["999999", "999.999", "999.999"],
    ["9999999", "10 M", "10 milioi"],
    ["99999999", "100 M", "100 milioi"],
    ["9994", "9994", "9994"],
    ["99944", "99.944", "99.944"],
    ["999444", "999.444", "999.444"],
    ["9994444", "10 M", "10 milioi"],
    ["999444444", "999 M", "999 milioi"],
    ["9994444444", "9994 M", "9994 milioi"],
  ],
  "fa": [
    ["1", "۱", "۱"],
    ["21", "۲۱", "۲۱"],
    ["321", "۳۲۱", "۳۲۱"],
    ["4321", "۴٫۳ هزار", "۴٫۳ هزار"],
    ["54321", "۵۴ هزار", "۵۴ هزار"],
    ["654321", "۶۵۴ هزار", "۶۵۴ هزار"],
    ["7654321", "۷٫۷ میلیون", "۷٫۷ میلیون"],
    ["87654321", "۸۸ میلیون", "۸۸ میلیون"],
    ["987654321", "۹۸۸ م", "۹۸۸ میلیون"],
    ["1087654321", "۱٫۱ م", "۱٫۱ میلیارد"],
    ["11987654321", "۱۲ م", "۱۲ میلیارد"],
    ["129987654321", "۱۳۰ میلیارد", "۱۳۰ میلیارد"],
    ["1398987654321", "۱٫۴ تریلیون", "۱٫۴ هزارمیلیارد"],
    ["14987987654321", "۱۵ ت", "۱۵ هزارمیلیارد"],
    ["159876987654321", "۱۶۰ ت", "۱۶۰ هزارمیلیارد"],
    ["9", "۹", "۹"],
    ["99", "۹۹", "۹۹"],
    ["999", "۹۹۹", "۹۹۹"],
    ["9999", "۱۰ هزار", "۱۰ هزار"],
    ["99999", "۱۰۰ هزار", "۱۰۰ هزار"],
    ["99999", "۱۰۰ هزار", "۱۰۰ هزار"],
    ["999999", "۱ میلیون", "۱ میلیون"],
    ["9999999", "۱۰ میلیون", "۱۰ میلیون"],
    ["99999999", "۱۰۰ م", "۱۰۰ میلیون"],
    ["9994", "۱۰ هزار", "۱۰ هزار"],
    ["99944", "۱۰۰ هزار", "۱۰۰ هزار"],
    ["999444", "۹۹۹ هزار", "۹۹۹ هزار"],
    ["9994444", "۱۰ میلیون", "۱۰ میلیون"],
    ["999444444", "۹۹۹ م", "۹۹۹ میلیون"],
    ["9994444444", "۱۰ م", "۱۰ میلیارد"],
  ],
  "fi": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 t.", "4,3 tuhatta"],
    ["54321", "54 t.", "54 tuhatta"],
    ["654321", "654 t.", "654 tuhatta"],
    ["7654321", "7,7 milj.", "7,7 miljoonaa"],
    ["87654321", "88 milj.", "88 miljoonaa"],
    ["987654321", "988 milj.", "988 miljoonaa"],
    ["1087654321", "1,1 mrd.", "1,1 miljardia"],
    ["11987654321", "12 mrd.", "12 miljardia"],
    ["129987654321", "130 mrd.", "130 miljardia"],
    ["1398987654321", "1,4 bilj.", "1,4 biljoonaa"],
    ["14987987654321", "15 bilj.", "15 biljoonaa"],
    ["159876987654321", "160 bilj.", "160 biljoonaa"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 t.", "10 tuhatta"],
    ["99999", "100 t.", "100 tuhatta"],
    ["99999", "100 t.", "100 tuhatta"],
    ["999999", "1 milj.", "1 miljoona"],
    ["9999999", "10 milj.", "10 miljoonaa"],
    ["99999999", "100 milj.", "100 miljoonaa"],
    ["9994", "10 t.", "10 tuhatta"],
    ["99944", "100 t.", "100 tuhatta"],
    ["999444", "999 t.", "999 tuhatta"],
    ["9994444", "10 milj.", "10 miljoonaa"],
    ["999444444", "999 milj.", "999 miljoonaa"],
    ["9994444444", "10 mrd.", "10 miljardia"],
  ],
  "fil": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 libo"],
    ["54321", "54K", "54 na libo"],
    ["654321", "654K", "654 na libo"],
    ["7654321", "7.7M", "7.7 milyon"],
    ["87654321", "88M", "88 milyon"],
    ["987654321", "988M", "988 milyon"],
    ["1087654321", "1.1B", "1.1 bilyon"],
    ["11987654321", "12B", "12 bilyon"],
    ["129987654321", "130B", "130 bilyon"],
    ["1398987654321", "1.4T", "1.4 na trilyon"],
    ["14987987654321", "15T", "15 trilyon"],
    ["159876987654321", "160T", "160 trilyon"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 libo"],
    ["99999", "100K", "100 libo"],
    ["99999", "100K", "100 libo"],
    ["999999", "1M", "1 milyon"],
    ["9999999", "10M", "10 milyon"],
    ["99999999", "100M", "100 milyon"],
    ["9994", "10K", "10 libo"],
    ["99944", "100K", "100 libo"],
    ["999444", "999K", "999 na libo"],
    ["9994444", "10M", "10 milyon"],
    ["999444444", "999M", "999 na milyon"],
    ["9994444444", "10B", "10 bilyon"],
  ],
  "fr": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 k", "4,3 mille"],
    ["54321", "54 k", "54 mille"],
    ["654321", "654 k", "654 mille"],
    ["7654321", "7,7 M", "7,7 millions"],
    ["87654321", "88 M", "88 millions"],
    ["987654321", "988 M", "988 millions"],
    ["1087654321", "1,1 Md", "1,1 milliard"],
    ["11987654321", "12 Md", "12 milliards"],
    ["129987654321", "130 Md", "130 milliards"],
    ["1398987654321", "1,4 Bn", "1,4 billion"],
    ["14987987654321", "15 Bn", "15 billions"],
    ["159876987654321", "160 Bn", "160 billions"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 mille"],
    ["99999", "100 k", "100 mille"],
    ["99999", "100 k", "100 mille"],
    ["999999", "1 M", "1 million"],
    ["9999999", "10 M", "10 millions"],
    ["99999999", "100 M", "100 millions"],
    ["9994", "10 k", "10 mille"],
    ["99944", "100 k", "100 mille"],
    ["999444", "999 k", "999 mille"],
    ["9994444", "10 M", "10 millions"],
    ["999444444", "999 M", "999 millions"],
    ["9994444444", "10 Md", "10 milliards"],
  ],
  "fr_CA": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 k", "4,3 mille"],
    ["54321", "54 k", "54 mille"],
    ["654321", "654 k", "654 mille"],
    ["7654321", "7,7 M", "7,7 millions"],
    ["87654321", "88 M", "88 millions"],
    ["987654321", "988 M", "988 millions"],
    ["1087654321", "1,1 G", "1,1 milliard"],
    ["11987654321", "12 G", "12 milliards"],
    ["129987654321", "130 G", "130 milliards"],
    ["1398987654321", "1,4 T", "1,4 billion"],
    ["14987987654321", "15 T", "15 billions"],
    ["159876987654321", "160 T", "160 billions"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 mille"],
    ["99999", "100 k", "100 mille"],
    ["99999", "100 k", "100 mille"],
    ["999999", "1 M", "1 million"],
    ["9999999", "10 M", "10 millions"],
    ["99999999", "100 M", "100 millions"],
    ["9994", "10 k", "10 mille"],
    ["99944", "100 k", "100 mille"],
    ["999444", "999 k", "999 mille"],
    ["9994444", "10 M", "10 millions"],
    ["999444444", "999 M", "999 millions"],
    ["9994444444", "10 G", "10 milliards"],
  ],
  "ga": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3k", "4.3 míle"],
    ["54321", "54k", "54 míle"],
    ["654321", "654k", "654 míle"],
    ["7654321", "7.7M", "7.7 milliún"],
    ["87654321", "88M", "88 milliún"],
    ["987654321", "988M", "988 milliún"],
    ["1087654321", "1.1B", "1.1 billiún"],
    ["11987654321", "12B", "12 billiún"],
    ["129987654321", "130B", "130 billiún"],
    ["1398987654321", "1.4T", "1.4 trilliún"],
    ["14987987654321", "15T", "15 trilliún"],
    ["159876987654321", "160T", "160 trilliún"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10k", "10 míle"],
    ["99999", "100k", "100 míle"],
    ["99999", "100k", "100 míle"],
    ["999999", "1M", "1 mhilliún"],
    ["9999999", "10M", "10 milliún"],
    ["99999999", "100M", "100 milliún"],
    ["9994", "10k", "10 míle"],
    ["99944", "100k", "100 míle"],
    ["999444", "999k", "999 míle"],
    ["9994444", "10M", "10 milliún"],
    ["999444444", "999M", "999 milliún"],
    ["9994444444", "10B", "10 mbilliún"],
  ],
  "gl": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4321"],
    ["54321", "54.321", "54.321"],
    ["654321", "654.321", "654.321"],
    ["7654321", "7,7 M", "7,7 millóns"],
    ["87654321", "88 M", "88 millóns"],
    ["987654321", "988 M", "988 millóns"],
    ["1087654321", "1.087.654.321", "1.087.654.321"],
    ["11987654321", "11.987.654.321", "11.987.654.321"],
    ["129987654321", "129.987.654.321", "129.987.654.321"],
    ["1398987654321", "1,4 B", "1,4 billóns"],
    ["14987987654321", "15 B", "15 billóns"],
    ["159876987654321", "160 B", "160 billóns"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "9999"],
    ["99999", "99.999", "99.999"],
    ["99999", "99.999", "99.999"],
    ["999999", "999.999", "999.999"],
    ["9999999", "10 M", "10 millóns"],
    ["99999999", "100 M", "100 millóns"],
    ["9994", "9994", "9994"],
    ["99944", "99.944", "99.944"],
    ["999444", "999.444", "999.444"],
    ["9994444", "10 M", "10 millóns"],
    ["999444444", "999 M", "999 millóns"],
    ["9994444444", "9.994.444.444", "9.994.444.444"],
  ],
  "gsw": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 Tsg.", "4.3 Tuusig"],
    ["54321", "54 Tsg.", "54 Tuusig"],
    ["654321", "654 Tsg.", "654 Tuusig"],
    ["7654321", "7.7 Mio.", "7.7 Millioone"],
    ["87654321", "88 Mio.", "88 Millioone"],
    ["987654321", "988 Mio.", "988 Millioone"],
    ["1087654321", "1.1 Mrd.", "1.1 Milliarde"],
    ["11987654321", "12 Mrd.", "12 Milliarde"],
    ["129987654321", "130 Mrd.", "130 Milliarde"],
    ["1398987654321", "1.4 Bio.", "1.4 Billioone"],
    ["14987987654321", "15 Bio.", "15 Billioone"],
    ["159876987654321", "160 Bio.", "160 Billioone"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 Tsg.", "10 Tuusig"],
    ["99999", "100 Tsg.", "100 Tuusig"],
    ["99999", "100 Tsg.", "100 Tuusig"],
    ["999999", "1 Mio.", "1 Millioon"],
    ["9999999", "10 Mio.", "10 Millioone"],
    ["99999999", "100 Mio.", "100 Millioone"],
    ["9994", "10 Tsg.", "10 Tuusig"],
    ["99944", "100 Tsg.", "100 Tuusig"],
    ["999444", "999 Tsg.", "999 Tuusig"],
    ["9994444", "10 Mio.", "10 Millioone"],
    ["999444444", "999 Mio.", "999 Millioone"],
    ["9994444444", "10 Mrd.", "10 Milliarde"],
  ],
  "gu": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 હજાર", "4.3 હજાર"],
    ["54321", "54 હજાર", "54 હજાર"],
    ["654321", "6.5 લાખ", "6.5 લાખ"],
    ["7654321", "77 લાખ", "77 લાખ"],
    ["87654321", "8.8 કરોડ", "8.8 કરોડ"],
    ["987654321", "99 કરોડ", "99 કરોડ"],
    ["1087654321", "1.1 અબજ", "1.1 અબજ"],
    ["11987654321", "12 અબજ", "12 અબજ"],
    ["129987654321", "1.3 નિખર્વ", "1.3 નિખર્વ"],
    ["1398987654321", "1.4 મહાપદ્મ", "1.4 મહાપદ્મ"],
    ["14987987654321", "1.5 શંકુ", "1.5 શંકુ"],
    ["159876987654321", "1.6 જલધિ", "1.6 જલધિ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 હજાર", "10 હજાર"],
    ["99999", "1 લાખ", "1 લાખ"],
    ["99999", "1 લાખ", "1 લાખ"],
    ["999999", "10 લાખ", "10 લાખ"],
    ["9999999", "1 કરોડ", "1 કરોડ"],
    ["99999999", "10 કરોડ", "10 કરોડ"],
    ["9994", "10 હજાર", "10 હજાર"],
    ["99944", "1 લાખ", "1 લાખ"],
    ["999444", "10 લાખ", "10 લાખ"],
    ["9994444", "1 કરોડ", "1 કરોડ"],
    ["999444444", "1 અબજ", "1 અબજ"],
    ["9994444444", "10 અબજ", "10 અબજ"],
  ],
  "haw": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3K"],
    ["54321", "54K", "54K"],
    ["654321", "654K", "654K"],
    ["7654321", "7.7M", "7.7M"],
    ["87654321", "88M", "88M"],
    ["987654321", "988M", "988M"],
    ["1087654321", "1.1G", "1.1G"],
    ["11987654321", "12G", "12G"],
    ["129987654321", "130G", "130G"],
    ["1398987654321", "1.4T", "1.4T"],
    ["14987987654321", "15T", "15T"],
    ["159876987654321", "160T", "160T"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10K"],
    ["99999", "100K", "100K"],
    ["99999", "100K", "100K"],
    ["999999", "1M", "1M"],
    ["9999999", "10M", "10M"],
    ["99999999", "100M", "100M"],
    ["9994", "10K", "10K"],
    ["99944", "100K", "100K"],
    ["999444", "999K", "999K"],
    ["9994444", "10M", "10M"],
    ["999444444", "999M", "999M"],
    ["9994444444", "10G", "10G"],
  ],
  "he": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "‏4.3 אלף"],
    ["54321", "54K", "‏54 אלף"],
    ["654321", "654K", "‏654 אלף"],
    ["7654321", "7.7M", "‏7.7 מיליון"],
    ["87654321", "88M", "‏88 מיליון"],
    ["987654321", "988M", "‏988 מיליון"],
    ["1087654321", "1.1B", "‏1.1 מיליארד"],
    ["11987654321", "12B", "‏12 מיליארד"],
    ["129987654321", "130B", "‏130 מיליארד"],
    ["1398987654321", "1.4T", "‏1.4 טריליון"],
    ["14987987654321", "15T", "‏15 טריליון"],
    ["159876987654321", "160T", "‏160 טריליון"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "‏10 אלף"],
    ["99999", "100K", "‏100 אלף"],
    ["99999", "100K", "‏100 אלף"],
    ["999999", "1M", "‏1 מיליון"],
    ["9999999", "10M", "‏10 מיליון"],
    ["99999999", "100M", "‏100 מיליון"],
    ["9994", "10K", "‏10 אלף"],
    ["99944", "100K", "‏100 אלף"],
    ["999444", "999K", "‏999 אלף"],
    ["9994444", "10M", "‏10 מיליון"],
    ["999444444", "999M", "‏999 מיליון"],
    ["9994444444", "10B", "‏10 מיליארד"],
  ],
  "hi": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 हज़ार", "4.3 हज़ार"],
    ["54321", "54 हज़ार", "54 हज़ार"],
    ["654321", "6.5 लाख", "6.5 लाख"],
    ["7654321", "77 लाख", "77 लाख"],
    ["87654321", "8.8 क॰", "8.8 करोड़"],
    ["987654321", "99 क॰", "99 करोड़"],
    ["1087654321", "1.1 अ॰", "1.1 अरब"],
    ["11987654321", "12 अ॰", "12 अरब"],
    ["129987654321", "1.3 ख॰", "1.3 खरब"],
    ["1398987654321", "14 ख॰", "14 खरब"],
    ["14987987654321", "1.5 नील", "150 खरब"],
    ["159876987654321", "16 नील", "1599 खरब"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 हज़ार", "10 हज़ार"],
    ["99999", "1 लाख", "1 लाख"],
    ["99999", "1 लाख", "1 लाख"],
    ["999999", "10 लाख", "10 लाख"],
    ["9999999", "1 क॰", "1 करोड़"],
    ["99999999", "10 क॰", "10 करोड़"],
    ["9994", "10 हज़ार", "10 हज़ार"],
    ["99944", "1 लाख", "1 लाख"],
    ["999444", "10 लाख", "10 लाख"],
    ["9994444", "1 क॰", "1 करोड़"],
    ["999444444", "1 अ॰", "1 अरब"],
    ["9994444444", "10 अ॰", "10 अरब"],
  ],
  "hr": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tis.", "4,3 tisuće"],
    ["54321", "54 tis.", "54 tisuće"],
    ["654321", "654 tis.", "654 tisuće"],
    ["7654321", "7,7 mil.", "7,7 milijuna"],
    ["87654321", "88 mil.", "88 milijuna"],
    ["987654321", "988 mil.", "988 milijuna"],
    ["1087654321", "1,1 mlr.", "1,1 milijarda"],
    ["11987654321", "12 mlr.", "12 milijardi"],
    ["129987654321", "130 mlr.", "130 milijardi"],
    ["1398987654321", "1,4 bil.", "1,4 bilijuna"],
    ["14987987654321", "15 bil.", "15 bilijuna"],
    ["159876987654321", "160 bil.", "160 bilijuna"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tis.", "10 tisuća"],
    ["99999", "100 tis.", "100 tisuća"],
    ["99999", "100 tis.", "100 tisuća"],
    ["999999", "1 mil.", "1 milijun"],
    ["9999999", "10 mil.", "10 milijuna"],
    ["99999999", "100 mil.", "100 milijuna"],
    ["9994", "10 tis.", "10 tisuća"],
    ["99944", "100 tis.", "100 tisuća"],
    ["999444", "999 tis.", "999 tisuća"],
    ["9994444", "10 mil.", "10 milijuna"],
    ["999444444", "999 mil.", "999 milijuna"],
    ["9994444444", "10 mlr.", "10 milijardi"],
  ],
  "hu": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 E", "4,3 ezer"],
    ["54321", "54 E", "54 ezer"],
    ["654321", "654 E", "654 ezer"],
    ["7654321", "7,7 M", "7,7 millió"],
    ["87654321", "88 M", "88 millió"],
    ["987654321", "988 M", "988 millió"],
    ["1087654321", "1,1 Mrd", "1,1 milliárd"],
    ["11987654321", "12 Mrd", "12 milliárd"],
    ["129987654321", "130 Mrd", "130 milliárd"],
    ["1398987654321", "1,4 B", "1,4 billió"],
    ["14987987654321", "15 B", "15 billió"],
    ["159876987654321", "160 B", "160 billió"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 E", "10 ezer"],
    ["99999", "100 E", "100 ezer"],
    ["99999", "100 E", "100 ezer"],
    ["999999", "1 M", "1 millió"],
    ["9999999", "10 M", "10 millió"],
    ["99999999", "100 M", "100 millió"],
    ["9994", "10 E", "10 ezer"],
    ["99944", "100 E", "100 ezer"],
    ["999444", "999 E", "999 ezer"],
    ["9994444", "10 M", "10 millió"],
    ["999444444", "999 M", "999 millió"],
    ["9994444444", "10 Mrd", "10 milliárd"],
  ],
  "hy": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 հզր", "4,3 հազար"],
    ["54321", "54 հզր", "54 հազար"],
    ["654321", "654 հզր", "654 հազար"],
    ["7654321", "7,7 մլն", "7,7 միլիոն"],
    ["87654321", "88 մլն", "88 միլիոն"],
    ["987654321", "988 մլն", "988 միլիոն"],
    ["1087654321", "1,1 մլրդ", "1,1 միլիարդ"],
    ["11987654321", "12 մլրդ", "12 միլիարդ"],
    ["129987654321", "130 մլրդ", "130 միլիարդ"],
    ["1398987654321", "1,4 տրլն", "1,4 տրիլիոն"],
    ["14987987654321", "15 տրլն", "15 տրիլիոն"],
    ["159876987654321", "160 տրլն", "160 տրիլիոն"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 հզր", "10 հազար"],
    ["99999", "100 հզր", "100 հազար"],
    ["99999", "100 հզր", "100 հազար"],
    ["999999", "1 մլն", "1 միլիոն"],
    ["9999999", "10 մլն", "10 միլիոն"],
    ["99999999", "100 մլն", "100 միլիոն"],
    ["9994", "10 հզր", "10 հազար"],
    ["99944", "100 հզր", "100 հազար"],
    ["999444", "999 հզր", "999 հազար"],
    ["9994444", "10 մլն", "10 միլիոն"],
    ["999444444", "999 մլն", "999 միլիոն"],
    ["9994444444", "10 մլրդ", "10 միլիարդ"],
  ],
  "id": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 rb", "4,3 ribu"],
    ["54321", "54 rb", "54 ribu"],
    ["654321", "654 rb", "654 ribu"],
    ["7654321", "7,7 jt", "7,7 juta"],
    ["87654321", "88 jt", "88 juta"],
    ["987654321", "988 jt", "988 juta"],
    ["1087654321", "1,1 M", "1,1 miliar"],
    ["11987654321", "12 M", "12 miliar"],
    ["129987654321", "130 M", "130 miliar"],
    ["1398987654321", "1,4 T", "1,4 triliun"],
    ["14987987654321", "15 T", "15 triliun"],
    ["159876987654321", "160 T", "160 triliun"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 rb", "10 ribu"],
    ["99999", "100 rb", "100 ribu"],
    ["99999", "100 rb", "100 ribu"],
    ["999999", "1 jt", "1 juta"],
    ["9999999", "10 jt", "10 juta"],
    ["99999999", "100 jt", "100 juta"],
    ["9994", "10 rb", "10 ribu"],
    ["99944", "100 rb", "100 ribu"],
    ["999444", "999 rb", "999 ribu"],
    ["9994444", "10 jt", "10 juta"],
    ["999444444", "999 jt", "999 juta"],
    ["9994444444", "10 M", "10 miliar"],
  ],
  "in": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 rb", "4,3 ribu"],
    ["54321", "54 rb", "54 ribu"],
    ["654321", "654 rb", "654 ribu"],
    ["7654321", "7,7 jt", "7,7 juta"],
    ["87654321", "88 jt", "88 juta"],
    ["987654321", "988 jt", "988 juta"],
    ["1087654321", "1,1 M", "1,1 miliar"],
    ["11987654321", "12 M", "12 miliar"],
    ["129987654321", "130 M", "130 miliar"],
    ["1398987654321", "1,4 T", "1,4 triliun"],
    ["14987987654321", "15 T", "15 triliun"],
    ["159876987654321", "160 T", "160 triliun"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 rb", "10 ribu"],
    ["99999", "100 rb", "100 ribu"],
    ["99999", "100 rb", "100 ribu"],
    ["999999", "1 jt", "1 juta"],
    ["9999999", "10 jt", "10 juta"],
    ["99999999", "100 jt", "100 juta"],
    ["9994", "10 rb", "10 ribu"],
    ["99944", "100 rb", "100 ribu"],
    ["999444", "999 rb", "999 ribu"],
    ["9994444", "10 jt", "10 juta"],
    ["999444444", "999 jt", "999 juta"],
    ["9994444444", "10 M", "10 miliar"],
  ],
  "is": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 þ.", "4,3 þúsund"],
    ["54321", "54 þ.", "54 þúsund"],
    ["654321", "654 þ.", "654 þúsund"],
    ["7654321", "7,7 m.", "7,7 milljón"],
    ["87654321", "88 m.", "88 milljónir"],
    ["987654321", "988 m.", "988 milljónir"],
    ["1087654321", "1,1 ma.", "1,1 milljarður"],
    ["11987654321", "12 ma.", "12 milljarðar"],
    ["129987654321", "130 ma.", "130 milljarðar"],
    ["1398987654321", "1,4 bn", "1,4 billjón"],
    ["14987987654321", "15 bn", "15 billjónir"],
    ["159876987654321", "160 bn", "160 billjónir"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 þ.", "10 þúsund"],
    ["99999", "100 þ.", "100 þúsund"],
    ["99999", "100 þ.", "100 þúsund"],
    ["999999", "1 m.", "1 milljón"],
    ["9999999", "10 m.", "10 milljónir"],
    ["99999999", "100 m.", "100 milljónir"],
    ["9994", "10 þ.", "10 þúsund"],
    ["99944", "100 þ.", "100 þúsund"],
    ["999444", "999 þ.", "999 þúsund"],
    ["9994444", "10 m.", "10 milljónir"],
    ["999444444", "999 m.", "999 milljónir"],
    ["9994444444", "10 ma.", "10 milljarðar"],
  ],
  "it": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4,3 mila"],
    ["54321", "54.321", "54 mila"],
    ["654321", "654.321", "654 mila"],
    ["7654321", "7,7 Mln", "7,7 milioni"],
    ["87654321", "88 Mln", "88 milioni"],
    ["987654321", "988 Mln", "988 milioni"],
    ["1087654321", "1,1 Mrd", "1,1 miliardi"],
    ["11987654321", "12 Mrd", "12 miliardi"],
    ["129987654321", "130 Mrd", "130 miliardi"],
    ["1398987654321", "1,4 Bln", "1,4 mila miliardi"],
    ["14987987654321", "15 Bln", "15 mila miliardi"],
    ["159876987654321", "160 Bln", "160 mila miliardi"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "10 mila"],
    ["99999", "99.999", "100 mila"],
    ["99999", "99.999", "100 mila"],
    ["999999", "999.999", "1 milione"],
    ["9999999", "10 Mln", "10 milioni"],
    ["99999999", "100 Mln", "100 milioni"],
    ["9994", "9994", "10 mila"],
    ["99944", "99.944", "100 mila"],
    ["999444", "999.444", "999 mila"],
    ["9994444", "10 Mln", "10 milioni"],
    ["999444444", "999 Mln", "999 milioni"],
    ["9994444444", "10 Mrd", "10 miliardi"],
  ],
  "iw": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "‏4.3 אלף"],
    ["54321", "54K", "‏54 אלף"],
    ["654321", "654K", "‏654 אלף"],
    ["7654321", "7.7M", "‏7.7 מיליון"],
    ["87654321", "88M", "‏88 מיליון"],
    ["987654321", "988M", "‏988 מיליון"],
    ["1087654321", "1.1B", "‏1.1 מיליארד"],
    ["11987654321", "12B", "‏12 מיליארד"],
    ["129987654321", "130B", "‏130 מיליארד"],
    ["1398987654321", "1.4T", "‏1.4 טריליון"],
    ["14987987654321", "15T", "‏15 טריליון"],
    ["159876987654321", "160T", "‏160 טריליון"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "‏10 אלף"],
    ["99999", "100K", "‏100 אלף"],
    ["99999", "100K", "‏100 אלף"],
    ["999999", "1M", "‏1 מיליון"],
    ["9999999", "10M", "‏10 מיליון"],
    ["99999999", "100M", "‏100 מיליון"],
    ["9994", "10K", "‏10 אלף"],
    ["99944", "100K", "‏100 אלף"],
    ["999444", "999K", "‏999 אלף"],
    ["9994444", "10M", "‏10 מיליון"],
    ["999444444", "999M", "‏999 מיליון"],
    ["9994444444", "10B", "‏10 מיליארד"],
  ],
  "ja": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4321"],
    ["54321", "5.4万", "5.4万"],
    ["654321", "65万", "65万"],
    ["7654321", "765万", "765万"],
    ["87654321", "8765万", "8765万"],
    ["987654321", "9.9億", "9.9億"],
    ["1087654321", "11億", "11億"],
    ["11987654321", "120億", "120億"],
    ["129987654321", "1300億", "1300億"],
    ["1398987654321", "1.4兆", "1.4兆"],
    ["14987987654321", "15兆", "15兆"],
    ["159876987654321", "160兆", "160兆"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "9999"],
    ["99999", "10万", "10万"],
    ["99999", "10万", "10万"],
    ["999999", "100万", "100万"],
    ["9999999", "1000万", "1000万"],
    ["99999999", "1億", "1億"],
    ["9994", "9994", "9994"],
    ["99944", "10万", "10万"],
    ["999444", "100万", "100万"],
    ["9994444", "999万", "999万"],
    ["999444444", "10億", "10億"],
    ["9994444444", "100億", "100億"],
  ],
  "ka": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 ათ.", "4,3 ათასი"],
    ["54321", "54 ათ.", "54 ათასი"],
    ["654321", "654 ათ.", "654 ათასი"],
    ["7654321", "7,7 მლნ.", "7,7 მილიონი"],
    ["87654321", "88 მლნ.", "88 მილიონი"],
    ["987654321", "988 მლნ.", "988 მილიონი"],
    ["1087654321", "1,1 მლრდ.", "1,1 მილიარდი"],
    ["11987654321", "12 მლრდ.", "12 მილიარდი"],
    ["129987654321", "130 მლრ.", "130 მილიარდი"],
    ["1398987654321", "1,4 ტრლ.", "1,4 ტრილიონი"],
    ["14987987654321", "15 ტრლ.", "15 ტრილიონი"],
    ["159876987654321", "160 ტრლ.", "160 ტრილიონი"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ათ.", "10 ათასი"],
    ["99999", "100 ათ.", "100 ათასი"],
    ["99999", "100 ათ.", "100 ათასი"],
    ["999999", "1 მლნ.", "1 მილიონი"],
    ["9999999", "10 მლნ.", "10 მილიონი"],
    ["99999999", "100 მლნ.", "100 მილიონი"],
    ["9994", "10 ათ.", "10 ათასი"],
    ["99944", "100 ათ.", "100 ათასი"],
    ["999444", "999 ათ.", "999 ათასი"],
    ["9994444", "10 მლნ.", "10 მილიონი"],
    ["999444444", "999 მლნ.", "999 მილიონი"],
    ["9994444444", "10 მლრდ.", "10 მილიარდი"],
  ],
  "kk": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 мың", "4,3 мың"],
    ["54321", "54 мың", "54 мың"],
    ["654321", "654 м.", "654 мың"],
    ["7654321", "7,7 млн", "7,7 миллион"],
    ["87654321", "88 млн", "88 миллион"],
    ["987654321", "988 млн", "988 миллион"],
    ["1087654321", "1,1 млрд", "1,1 миллиард"],
    ["11987654321", "12 млрд", "12 миллиард"],
    ["129987654321", "130 млрд", "130 миллиард"],
    ["1398987654321", "1,4 трлн", "1,4 триллион"],
    ["14987987654321", "15 трлн", "15 триллион"],
    ["159876987654321", "160 трлн", "160 триллион"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 мың", "10 мың"],
    ["99999", "100 м.", "100 мың"],
    ["99999", "100 м.", "100 мың"],
    ["999999", "1 млн", "1 миллион"],
    ["9999999", "10 млн", "10 миллион"],
    ["99999999", "100 млн", "100 миллион"],
    ["9994", "10 мың", "10 мың"],
    ["99944", "100 м.", "100 мың"],
    ["999444", "999 м.", "999 мың"],
    ["9994444", "10 млн", "10 миллион"],
    ["999444444", "999 млн", "999 миллион"],
    ["9994444444", "10 млрд", "10 миллиард"],
  ],
  "km": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3ពាន់", "4,3 ពាន់"],
    ["54321", "54 ពាន់", "54 ពាន់"],
    ["654321", "654 ពាន់", "654ពាន់"],
    ["7654321", "7,7 លាន", "7,7 លាន"],
    ["87654321", "88 លាន", "88 លាន"],
    ["987654321", "988 លាន", "988 លាន"],
    ["1087654321", "1,1 ប៊ីលាន", "1,1 ប៊ីលាន"],
    ["11987654321", "12 ប៊ីលាន", "12 ប៊ីលាន"],
    ["129987654321", "130 ប៊ីលាន", "130 ប៊ីលាន"],
    ["1398987654321", "1,4 ទ្រីលាន", "1,4 ទ្រីលាន"],
    ["14987987654321", "15 ទ្រីលាន", "15 ទ្រីលាន"],
    ["159876987654321", "160 ទ្រីលាន", "160 ទ្រីលាន"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ពាន់", "10 ពាន់"],
    ["99999", "100 ពាន់", "100ពាន់"],
    ["99999", "100 ពាន់", "100ពាន់"],
    ["999999", "1 លាន", "1 លាន"],
    ["9999999", "10 លាន", "10 លាន"],
    ["99999999", "100 លាន", "100 លាន"],
    ["9994", "10 ពាន់", "10 ពាន់"],
    ["99944", "100 ពាន់", "100ពាន់"],
    ["999444", "999 ពាន់", "999ពាន់"],
    ["9994444", "10 លាន", "10 លាន"],
    ["999444444", "999 លាន", "999 លាន"],
    ["9994444444", "10 ប៊ីលាន", "10 ប៊ីលាន"],
  ],
  "kn": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3ಸಾ", "4.3 ಸಾವಿರ"],
    ["54321", "54ಸಾ", "54 ಸಾವಿರ"],
    ["654321", "654ಸಾ", "654 ಸಾವಿರ"],
    ["7654321", "7.7ಮಿ", "7.7 ಮಿಲಿಯನ್"],
    ["87654321", "88ಮಿ", "88 ಮಿಲಿಯನ್"],
    ["987654321", "988ಮಿ", "988 ಮಿಲಿಯನ್"],
    ["1087654321", "1.1ಬಿ", "1.1 ಬಿಲಿಯನ್"],
    ["11987654321", "12ಬಿ", "12 ಬಿಲಿಯನ್"],
    ["129987654321", "130ಬಿ", "130 ಬಿಲಿಯನ್"],
    ["1398987654321", "1.4ಟ್ರಿ", "1.4 ಟ್ರಿಲಿಯನ್‌"],
    ["14987987654321", "15ಟ್ರಿ", "15 ಟ್ರಿಲಿಯನ್‌"],
    ["159876987654321", "160ಟ್ರಿ", "160 ಟ್ರಿಲಿಯನ್‌"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10ಸಾ", "10 ಸಾವಿರ"],
    ["99999", "100ಸಾ", "100 ಸಾವಿರ"],
    ["99999", "100ಸಾ", "100 ಸಾವಿರ"],
    ["999999", "1ಮಿ", "1 ಮಿಲಿಯನ್"],
    ["9999999", "10ಮಿ", "10 ಮಿಲಿಯನ್"],
    ["99999999", "100ಮಿ", "100 ಮಿಲಿಯನ್"],
    ["9994", "10ಸಾ", "10 ಸಾವಿರ"],
    ["99944", "100ಸಾ", "100 ಸಾವಿರ"],
    ["999444", "999ಸಾ", "999 ಸಾವಿರ"],
    ["9994444", "10ಮಿ", "10 ಮಿಲಿಯನ್"],
    ["999444444", "999ಮಿ", "999 ಮಿಲಿಯನ್"],
    ["9994444444", "10ಬಿ", "10 ಬಿಲಿಯನ್"],
  ],
  "ko": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3천", "4.3천"],
    ["54321", "5.4만", "5.4만"],
    ["654321", "65만", "65만"],
    ["7654321", "765만", "765만"],
    ["87654321", "8765만", "8765만"],
    ["987654321", "9.9억", "9.9억"],
    ["1087654321", "11억", "11억"],
    ["11987654321", "120억", "120억"],
    ["129987654321", "1300억", "1300억"],
    ["1398987654321", "1.4조", "1.4조"],
    ["14987987654321", "15조", "15조"],
    ["159876987654321", "160조", "160조"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "1만", "1만"],
    ["99999", "10만", "10만"],
    ["99999", "10만", "10만"],
    ["999999", "100만", "100만"],
    ["9999999", "1000만", "1000만"],
    ["99999999", "1억", "1억"],
    ["9994", "1만", "1만"],
    ["99944", "10만", "10만"],
    ["999444", "100만", "100만"],
    ["9994444", "999만", "999만"],
    ["999444444", "10억", "10억"],
    ["9994444444", "100억", "100억"],
  ],
  "ky": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 миң", "4,3 миң"],
    ["54321", "54 миң", "54 миң"],
    ["654321", "654 миң", "654 миң"],
    ["7654321", "7,7 млн", "7,7 миллион"],
    ["87654321", "88 млн", "88 миллион"],
    ["987654321", "988 млн", "988 миллион"],
    ["1087654321", "1,1 млд", "1,1 миллиард"],
    ["11987654321", "12 млд", "12 миллиард"],
    ["129987654321", "130 млд", "130 миллиард"],
    ["1398987654321", "1,4 трлн", "1,4 триллион"],
    ["14987987654321", "15 трлн", "15 триллион"],
    ["159876987654321", "160 трлн", "160 триллион"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 миң", "10 миң"],
    ["99999", "100 миң", "100 миң"],
    ["99999", "100 миң", "100 миң"],
    ["999999", "1 млн", "1 миллион"],
    ["9999999", "10 млн", "10 миллион"],
    ["99999999", "100 млн", "100 миллион"],
    ["9994", "10 миң", "10 миң"],
    ["99944", "100 миң", "100 миң"],
    ["999444", "999 миң", "999 миң"],
    ["9994444", "10 млн", "10 миллион"],
    ["999444444", "999 млн", "999 миллион"],
    ["9994444444", "10 млд", "10 миллиард"],
  ],
  "ln": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3K", "4,3K"],
    ["54321", "54K", "54K"],
    ["654321", "654K", "654K"],
    ["7654321", "7,7M", "7,7M"],
    ["87654321", "88M", "88M"],
    ["987654321", "988M", "988M"],
    ["1087654321", "1,1G", "1,1G"],
    ["11987654321", "12G", "12G"],
    ["129987654321", "130G", "130G"],
    ["1398987654321", "1,4T", "1,4T"],
    ["14987987654321", "15T", "15T"],
    ["159876987654321", "160T", "160T"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10K"],
    ["99999", "100K", "100K"],
    ["99999", "100K", "100K"],
    ["999999", "1M", "1M"],
    ["9999999", "10M", "10M"],
    ["99999999", "100M", "100M"],
    ["9994", "10K", "10K"],
    ["99944", "100K", "100K"],
    ["999444", "999K", "999K"],
    ["9994444", "10M", "10M"],
    ["999444444", "999M", "999M"],
    ["9994444444", "10G", "10G"],
  ],
  "lo": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 ພັນ", "4,3 ພັນ"],
    ["54321", "54 ພັນ", "54 ພັນ"],
    ["654321", "654 ກີບ", "6,5 ແສນ"],
    ["7654321", "7,7 ລ້ານ", "7,7 ລ້ານ"],
    ["87654321", "88 ລ້ານ", "88 ລ້ານ"],
    ["987654321", "988 ລ້ານ", "988 ລ້ານ"],
    ["1087654321", "1,1 ຕື້", "1,1 ຕື້"],
    ["11987654321", "12 ຕື້", "12 ຕື້"],
    ["129987654321", "130 ຕື້", "130 ຕື້"],
    ["1398987654321", "1,4 ລ້ານລ້ານ", "1,4 ລ້ານລ້ານ"],
    ["14987987654321", "15ລລ", "15 ລ້ານລ້ານ"],
    ["159876987654321", "160ລລ", "160 ລ້ານລ້ານ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ພັນ", "10 ພັນ"],
    ["99999", "100 ກີບ", "1 ແສນ"],
    ["99999", "100 ກີບ", "1 ແສນ"],
    ["999999", "1 ລ້ານ", "1 ລ້ານ"],
    ["9999999", "10 ລ້ານ", "10 ລ້ານ"],
    ["99999999", "100 ລ້ານ", "100 ລ້ານ"],
    ["9994", "10 ພັນ", "10 ພັນ"],
    ["99944", "100 ກີບ", "1 ແສນ"],
    ["999444", "999 ກີບ", "1 ລ້ານ"],
    ["9994444", "10 ລ້ານ", "10 ລ້ານ"],
    ["999444444", "999 ລ້ານ", "999 ລ້ານ"],
    ["9994444444", "10 ຕື້", "10 ຕື້"],
  ],
  "lt": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tūkst.", "4,3 tūkstančio"],
    ["54321", "54 tūkst.", "54 tūkstančiai"],
    ["654321", "654 tūkst.", "654 tūkstančiai"],
    ["7654321", "7,7 mln.", "7,7 milijono"],
    ["87654321", "88 mln.", "88 milijonai"],
    ["987654321", "988 mln.", "988 milijonai"],
    ["1087654321", "1,1 mlrd.", "1,1 milijardo"],
    ["11987654321", "12 mlrd.", "12 milijardų"],
    ["129987654321", "130 mlrd.", "130 milijardų"],
    ["1398987654321", "1,4 trln.", "1,4 trilijono"],
    ["14987987654321", "15 trln.", "15 trilijonų"],
    ["159876987654321", "160 trln.", "160 trilijonų"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tūkst.", "10 tūkstančių"],
    ["99999", "100 tūkst.", "100 tūkstančių"],
    ["99999", "100 tūkst.", "100 tūkstančių"],
    ["999999", "1 mln.", "1 milijonas"],
    ["9999999", "10 mln.", "10 milijonų"],
    ["99999999", "100 mln.", "100 milijonų"],
    ["9994", "10 tūkst.", "10 tūkstančių"],
    ["99944", "100 tūkst.", "100 tūkstančių"],
    ["999444", "999 tūkst.", "999 tūkstančiai"],
    ["9994444", "10 mln.", "10 milijonų"],
    ["999444444", "999 mln.", "999 milijonai"],
    ["9994444444", "10 mlrd.", "10 milijardų"],
  ],
  "lv": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tūkst.", "4,3 tūkstoši"],
    ["54321", "54 tūkst.", "54 tūkstoši"],
    ["654321", "654 tūkst.", "654 tūkstoši"],
    ["7654321", "7,7 milj.", "7,7 miljoni"],
    ["87654321", "88 milj.", "88 miljoni"],
    ["987654321", "988 milj.", "988 miljoni"],
    ["1087654321", "1,1 mljrd.", "1,1 miljards"],
    ["11987654321", "12 mljrd.", "12 miljardi"],
    ["129987654321", "130 mljrd.", "130 miljardi"],
    ["1398987654321", "1,4 trilj.", "1,4 triljoni"],
    ["14987987654321", "15 trilj.", "15 triljoni"],
    ["159876987654321", "160 trilj.", "160 triljoni"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tūkst.", "10 tūkstoši"],
    ["99999", "100 tūkst.", "100 tūkstoši"],
    ["99999", "100 tūkst.", "100 tūkstoši"],
    ["999999", "1 milj.", "1 miljons"],
    ["9999999", "10 milj.", "10 miljoni"],
    ["99999999", "100 milj.", "100 miljoni"],
    ["9994", "10 tūkst.", "10 tūkstoši"],
    ["99944", "100 tūkst.", "100 tūkstoši"],
    ["999444", "999 tūkst.", "999 tūkstoši"],
    ["9994444", "10 milj.", "10 miljoni"],
    ["999444444", "999 milj.", "999 miljoni"],
    ["9994444444", "10 mljrd.", "10 miljardi"],
  ],
  "mk": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 илј.", "4,3 илјади"],
    ["54321", "54 илј.", "54 илјади"],
    ["654321", "654 илј.", "654 илјади"],
    ["7654321", "7,7 мил.", "7,7 милиони"],
    ["87654321", "88 мил.", "88 милиони"],
    ["987654321", "988 М", "988 милиони"],
    ["1087654321", "1,1 милј.", "1,1 милијарда"],
    ["11987654321", "12 милј.", "12 милијарди"],
    ["129987654321", "130 ми.", "130 милијарди"],
    ["1398987654321", "1,4 бил.", "1,4 билиони"],
    ["14987987654321", "15 бил.", "15 билиони"],
    ["159876987654321", "160 бил.", "160 билиони"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 илј.", "10 илјади"],
    ["99999", "100 илј.", "100 илјади"],
    ["99999", "100 илј.", "100 илјади"],
    ["999999", "1 мил.", "1 милион"],
    ["9999999", "10 мил.", "10 милиони"],
    ["99999999", "100 М", "100 милиони"],
    ["9994", "10 илј.", "10 илјади"],
    ["99944", "100 илј.", "100 илјади"],
    ["999444", "999 илј.", "999 илјади"],
    ["9994444", "10 мил.", "10 милиони"],
    ["999444444", "999 М", "999 милиони"],
    ["9994444444", "10 милј.", "10 милијарди"],
  ],
  "ml": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 ആയിരം"],
    ["54321", "54K", "54 ആയിരം"],
    ["654321", "654K", "654 ആയിരം"],
    ["7654321", "7.7M", "7.7 ദശലക്ഷം"],
    ["87654321", "88M", "88 ദശലക്ഷം"],
    ["987654321", "988M", "988 ദശലക്ഷം"],
    ["1087654321", "1.1B", "1.1 ലക്ഷം കോടി"],
    ["11987654321", "12B", "12 ലക്ഷം കോടി"],
    ["129987654321", "130B", "130 ലക്ഷം കോടി"],
    ["1398987654321", "1.4T", "1.4 ട്രില്യൺ"],
    ["14987987654321", "15T", "15 ട്രില്യൺ"],
    ["159876987654321", "160T", "160 ട്രില്യൺ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 ആയിരം"],
    ["99999", "100K", "100 ആയിരം"],
    ["99999", "100K", "100 ആയിരം"],
    ["999999", "1M", "1 ദശലക്ഷം"],
    ["9999999", "10M", "10 ദശലക്ഷം"],
    ["99999999", "100M", "100 ദശലക്ഷം"],
    ["9994", "10K", "10 ആയിരം"],
    ["99944", "100K", "100 ആയിരം"],
    ["999444", "999K", "999 ആയിരം"],
    ["9994444", "10M", "10 ദശലക്ഷം"],
    ["999444444", "999M", "999 ദശലക്ഷം"],
    ["9994444444", "10B", "10 ലക്ഷം കോടി"],
  ],
  "mn": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 мянга", "4.3 мянга"],
    ["54321", "54 мянга", "54 мянга"],
    ["654321", "654 мянга", "654 мянга"],
    ["7654321", "7.7 сая", "7.7 сая"],
    ["87654321", "88 сая", "88 сая"],
    ["987654321", "988 сая", "988 сая"],
    ["1087654321", "1.1 тэрбум", "1.1 тэрбум"],
    ["11987654321", "12 тэрбум", "12 тэрбум"],
    ["129987654321", "130Т", "130 тэрбум"],
    ["1398987654321", "1.4ИН", "1.4 их наяд"],
    ["14987987654321", "15ИН", "15 их наяд"],
    ["159876987654321", "160ИН", "160 их наяд"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 мянга", "10 мянга"],
    ["99999", "100 мянга", "100 мянга"],
    ["99999", "100 мянга", "100 мянга"],
    ["999999", "1 сая", "1 сая"],
    ["9999999", "10 сая", "10 сая"],
    ["99999999", "100 сая", "100 сая"],
    ["9994", "10 мянга", "10 мянга"],
    ["99944", "100 мянга", "100 мянга"],
    ["999444", "999 мянга", "999 мянга"],
    ["9994444", "10 сая", "10 сая"],
    ["999444444", "999 сая", "999 сая"],
    ["9994444444", "10 тэрбум", "10 тэрбум"],
  ],
  "mr": [
    ["1", "१", "१"],
    ["21", "२१", "२१"],
    ["321", "३२१", "३२१"],
    ["4321", "४.३ ह", "४.३ हजार"],
    ["54321", "५४ ह", "५४ हजार"],
    ["654321", "६.५ लाख", "६.५ लाख"],
    ["7654321", "७७ लाख", "७७ लाख"],
    ["87654321", "८.८ कोटी", "८.८ कोटी"],
    ["987654321", "९९ कोटी", "९९ कोटी"],
    ["1087654321", "१.१ अब्ज", "१.१ अब्ज"],
    ["11987654321", "१२ अब्ज", "१२ अब्ज"],
    ["129987654321", "१.३ खर्व", "१.३ खर्व"],
    ["1398987654321", "१४ खर्व", "१४ खर्व"],
    ["14987987654321", "१.५ पद्म", "१.५ पद्म"],
    ["159876987654321", "१६ पद्म", "१६ पद्म"],
    ["9", "९", "९"],
    ["99", "९९", "९९"],
    ["999", "९९९", "९९९"],
    ["9999", "१० ह", "१० हजार"],
    ["99999", "१ लाख", "१ लाख"],
    ["99999", "१ लाख", "१ लाख"],
    ["999999", "१० लाख", "१० लाख"],
    ["9999999", "१ कोटी", "१ कोटी"],
    ["99999999", "१० कोटी", "१० कोटी"],
    ["9994", "१० ह", "१० हजार"],
    ["99944", "१ लाख", "१ लाख"],
    ["999444", "१० लाख", "१० लाख"],
    ["9994444", "१ कोटी", "१ कोटी"],
    ["999444444", "१ अब्ज", "१ अब्ज"],
    ["9994444444", "१० अब्ज", "१० अब्ज"],
  ],
  "ms": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 ribu"],
    ["54321", "54K", "54 ribu"],
    ["654321", "654K", "654 ribu"],
    ["7654321", "7.7J", "7.7 juta"],
    ["87654321", "88J", "88 juta"],
    ["987654321", "988J", "988 juta"],
    ["1087654321", "1.1B", "1.1 bilion"],
    ["11987654321", "12B", "12 bilion"],
    ["129987654321", "130B", "130 bilion"],
    ["1398987654321", "1.4T", "1.4 trilion"],
    ["14987987654321", "15T", "15 trilion"],
    ["159876987654321", "160T", "160 trilion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 ribu"],
    ["99999", "100K", "100 ribu"],
    ["99999", "100K", "100 ribu"],
    ["999999", "1J", "1 juta"],
    ["9999999", "10J", "10 juta"],
    ["99999999", "100J", "100 juta"],
    ["9994", "10K", "10 ribu"],
    ["99944", "100K", "100 ribu"],
    ["999444", "999K", "999 ribu"],
    ["9994444", "10J", "10 juta"],
    ["999444444", "999J", "999 juta"],
    ["9994444444", "10B", "10 bilion"],
  ],
  "mt": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3K"],
    ["54321", "54K", "54K"],
    ["654321", "654K", "654K"],
    ["7654321", "7.7M", "7.7M"],
    ["87654321", "88M", "88M"],
    ["987654321", "988M", "988M"],
    ["1087654321", "1.1G", "1.1G"],
    ["11987654321", "12G", "12G"],
    ["129987654321", "130G", "130G"],
    ["1398987654321", "1.4T", "1.4T"],
    ["14987987654321", "15T", "15T"],
    ["159876987654321", "160T", "160T"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10K"],
    ["99999", "100K", "100K"],
    ["99999", "100K", "100K"],
    ["999999", "1M", "1M"],
    ["9999999", "10M", "10M"],
    ["99999999", "100M", "100M"],
    ["9994", "10K", "10K"],
    ["99944", "100K", "100K"],
    ["999444", "999K", "999K"],
    ["9994444", "10M", "10M"],
    ["999444444", "999M", "999M"],
    ["9994444444", "10G", "10G"],
  ],
  "my": [
    ["1", "၁", "၁"],
    ["21", "၂၁", "၂၁"],
    ["321", "၃၂၁", "၃၂၁"],
    ["4321", "၄.၃ထောင်", "၄.၃ထောင်"],
    ["54321", "၅.၄သောင်း", "၅.၄သောင်း"],
    ["654321", "၆.၅သိန်း", "၆.၅သိန်း"],
    ["7654321", "၇.၇သန်း", "၇.၇သန်း"],
    ["87654321", "၈.၈ကုဋေ", "၈.၈ကုဋေ"],
    ["987654321", "၉၉ကုဋေ", "၉၉ကုဋေ"],
    ["1087654321", "ကုဋေ၁၀၉", "ကုဋေ၁၀၉"],
    ["11987654321", "ကုဋေ၁.၂ထ", "ကုဋေ၁၁၉၉"],
    ["129987654321", "ကုဋေ၁.၃သ", "ကုဋေ၁.၃သောင်း"],
    ["1398987654321", "ဋေ၁.၄သိန်း", "ကုဋေ၁.၄သိန်း"],
    ["14987987654321", "ဋေ၁.၅သန်း", "ကုဋေ၁.၅သန်း"],
    ["159876987654321", "၁.၆ကောဋိ", "၁.၆ကောဋိ"],
    ["9", "၉", "၉"],
    ["99", "၉၉", "၉၉"],
    ["999", "၉၉၉", "၉၉၉"],
    ["9999", "၁သောင်း", "၁သောင်း"],
    ["99999", "၁သိန်း", "၁သိန်း"],
    ["99999", "၁သိန်း", "၁သိန်း"],
    ["999999", "၁သန်း", "၁သန်း"],
    ["9999999", "၁ကုဋေ", "၁ကုဋေ"],
    ["99999999", "၁၀ကုဋေ", "၁၀ကုဋေ"],
    ["9994", "၁သောင်း", "၁သောင်း"],
    ["99944", "၁သိန်း", "၁သိန်း"],
    ["999444", "၁သန်း", "၁သန်း"],
    ["9994444", "၁ကုဋေ", "၁ကုဋေ"],
    ["999444444", "ကုဋေ၁၀၀", "ကုဋေ၁၀၀"],
    ["9994444444", "ကုဋေ၉၉၉", "ကုဋေ၉၉၉"],
  ],
  "nb": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3k", "4,3 tusen"],
    ["54321", "54k", "54 tusen"],
    ["654321", "654k", "654 tusen"],
    ["7654321", "7,7 mill.", "7,7 millioner"],
    ["87654321", "88 mill.", "88 millioner"],
    ["987654321", "988 mill.", "988 millioner"],
    ["1087654321", "1,1 mrd.", "1,1 milliarder"],
    ["11987654321", "12 mrd.", "12 milliarder"],
    ["129987654321", "130 mrd.", "130 milliarder"],
    ["1398987654321", "1,4 bill.", "1,4 billioner"],
    ["14987987654321", "15 bill.", "15 billioner"],
    ["159876987654321", "160 bill.", "160 billioner"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10k", "10 tusen"],
    ["99999", "100k", "100 tusen"],
    ["99999", "100k", "100 tusen"],
    ["999999", "1 mill.", "1 million"],
    ["9999999", "10 mill.", "10 millioner"],
    ["99999999", "100 mill.", "100 millioner"],
    ["9994", "10k", "10 tusen"],
    ["99944", "100k", "100 tusen"],
    ["999444", "999k", "999 tusen"],
    ["9994444", "10 mill.", "10 millioner"],
    ["999444444", "999 mill.", "999 millioner"],
    ["9994444444", "10 mrd.", "10 milliarder"],
  ],
  "ne": [
    ["1", "१", "१"],
    ["21", "२१", "२१"],
    ["321", "३२१", "३२१"],
    ["4321", "४.३ हजार", "४.३ हजार"],
    ["54321", "५४ हजार", "५४ हजार"],
    ["654321", "६.५ लाख", "६.५ लाख"],
    ["7654321", "७७ लाख", "७.७ करोड"],
    ["87654321", "८.८ करोड", "८८ करोड"],
    ["987654321", "९९ करोड", "९८८ करोड"],
    ["1087654321", "१.१ अरब", "१.१ अरब"],
    ["11987654321", "१२ अरब", "१२ अरब"],
    ["129987654321", "१.३ खरब", "१३० अरब"],
    ["1398987654321", "१४ खरब", "१४ खरब"],
    ["14987987654321", "१.५ शंख", "१.५ शंख"],
    ["159876987654321", "१६ शंख", "१६ शंख"],
    ["9", "९", "९"],
    ["99", "९९", "९९"],
    ["999", "९९९", "९९९"],
    ["9999", "१० हजार", "१० हजार"],
    ["99999", "१ लाख", "१ लाख"],
    ["99999", "१ लाख", "१ लाख"],
    ["999999", "१० लाख", "१ करोड"],
    ["9999999", "१ करोड", "१० करोड"],
    ["99999999", "१० करोड", "१०० करोड"],
    ["9994", "१० हजार", "१० हजार"],
    ["99944", "१ लाख", "१ लाख"],
    ["999444", "१० लाख", "१ करोड"],
    ["9994444", "१ करोड", "१० करोड"],
    ["999444444", "१ अरब", "९९९ करोड"],
    ["9994444444", "१० अरब", "१० अरब"],
  ],
  "nl": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3K", "4,3 duizend"],
    ["54321", "54K", "54 duizend"],
    ["654321", "654K", "654 duizend"],
    ["7654321", "7,7 mln.", "7,7 miljoen"],
    ["87654321", "88 mln.", "88 miljoen"],
    ["987654321", "988 mln.", "988 miljoen"],
    ["1087654321", "1,1 mld.", "1,1 miljard"],
    ["11987654321", "12 mld.", "12 miljard"],
    ["129987654321", "130 mld.", "130 miljard"],
    ["1398987654321", "1,4 bln.", "1,4 biljoen"],
    ["14987987654321", "15 bln.", "15 biljoen"],
    ["159876987654321", "160 bln.", "160 biljoen"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 duizend"],
    ["99999", "100K", "100 duizend"],
    ["99999", "100K", "100 duizend"],
    ["999999", "1 mln.", "1 miljoen"],
    ["9999999", "10 mln.", "10 miljoen"],
    ["99999999", "100 mln.", "100 miljoen"],
    ["9994", "10K", "10 duizend"],
    ["99944", "100K", "100 duizend"],
    ["999444", "999K", "999 duizend"],
    ["9994444", "10 mln.", "10 miljoen"],
    ["999444444", "999 mln.", "999 miljoen"],
    ["9994444444", "10 mld.", "10 miljard"],
  ],
  "no": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3k", "4,3 tusen"],
    ["54321", "54k", "54 tusen"],
    ["654321", "654k", "654 tusen"],
    ["7654321", "7,7 mill.", "7,7 millioner"],
    ["87654321", "88 mill.", "88 millioner"],
    ["987654321", "988 mill.", "988 millioner"],
    ["1087654321", "1,1 mrd.", "1,1 milliarder"],
    ["11987654321", "12 mrd.", "12 milliarder"],
    ["129987654321", "130 mrd.", "130 milliarder"],
    ["1398987654321", "1,4 bill.", "1,4 billioner"],
    ["14987987654321", "15 bill.", "15 billioner"],
    ["159876987654321", "160 bill.", "160 billioner"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10k", "10 tusen"],
    ["99999", "100k", "100 tusen"],
    ["99999", "100k", "100 tusen"],
    ["999999", "1 mill.", "1 million"],
    ["9999999", "10 mill.", "10 millioner"],
    ["99999999", "100 mill.", "100 millioner"],
    ["9994", "10k", "10 tusen"],
    ["99944", "100k", "100 tusen"],
    ["999444", "999k", "999 tusen"],
    ["9994444", "10 mill.", "10 millioner"],
    ["999444444", "999 mill.", "999 millioner"],
    ["9994444444", "10 mrd.", "10 milliarder"],
  ],
  "no_NO": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3k", "4,3 tusen"],
    ["54321", "54k", "54 tusen"],
    ["654321", "654k", "654 tusen"],
    ["7654321", "7,7 mill.", "7,7 millioner"],
    ["87654321", "88 mill.", "88 millioner"],
    ["987654321", "988 mill.", "988 millioner"],
    ["1087654321", "1,1 mrd.", "1,1 milliarder"],
    ["11987654321", "12 mrd.", "12 milliarder"],
    ["129987654321", "130 mrd.", "130 milliarder"],
    ["1398987654321", "1,4 bill.", "1,4 billioner"],
    ["14987987654321", "15 bill.", "15 billioner"],
    ["159876987654321", "160 bill.", "160 billioner"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10k", "10 tusen"],
    ["99999", "100k", "100 tusen"],
    ["99999", "100k", "100 tusen"],
    ["999999", "1 mill.", "1 million"],
    ["9999999", "10 mill.", "10 millioner"],
    ["99999999", "100 mill.", "100 millioner"],
    ["9994", "10k", "10 tusen"],
    ["99944", "100k", "100 tusen"],
    ["999444", "999k", "999 tusen"],
    ["9994444", "10 mill.", "10 millioner"],
    ["999444444", "999 mill.", "999 millioner"],
    ["9994444444", "10 mrd.", "10 milliarder"],
  ],
  "or": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3ହ", "4.3 ହଜାର"],
    ["54321", "54ହ", "54 ହଜାର"],
    ["654321", "654ହ", "654 ହଜାର"],
    ["7654321", "7.7ନି", "7.7 ନିୟୁତ"],
    ["87654321", "88ନି", "88 ନିୟୁତ"],
    ["987654321", "988ନି", "988 ନିୟୁତ"],
    ["1087654321", "1.1ବି", "1.1 ଶହକୋଟି"],
    ["11987654321", "12ବି", "12 ଶହକୋଟି"],
    ["129987654321", "130ବି", "130 ଶହକୋଟି"],
    ["1398987654321", "1.4ଟ୍ରି", "1.4 ଲକ୍ଷକୋଟି"],
    ["14987987654321", "15ଟ୍ରି", "15 ଲକ୍ଷକୋଟି"],
    ["159876987654321", "160ଟ୍ରି", "160 ଲକ୍ଷକୋଟି"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10ହ", "10 ହଜାର"],
    ["99999", "100ହ", "100 ହଜାର"],
    ["99999", "100ହ", "100 ହଜାର"],
    ["999999", "1ନି", "1 ନିୟୁତ"],
    ["9999999", "10ନି", "10 ନିୟୁତ"],
    ["99999999", "100ନି", "100 ନିୟୁତ"],
    ["9994", "10ହ", "10 ହଜାର"],
    ["99944", "100ହ", "100 ହଜାର"],
    ["999444", "999ହ", "999 ହଜାର"],
    ["9994444", "10ନି", "10 ନିୟୁତ"],
    ["999444444", "999ନି", "999 ନିୟୁତ"],
    ["9994444444", "10ବି", "10 ଶହକୋଟି"],
  ],
  "pa": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 ਹਜ਼ਾਰ", "4.3 ਹਜ਼ਾਰ"],
    ["54321", "54 ਹਜ਼ਾਰ", "54 ਹਜ਼ਾਰ"],
    ["654321", "6.5 ਲੱਖ", "6.5 ਲੱਖ"],
    ["7654321", "77 ਲੱਖ", "77 ਲੱਖ"],
    ["87654321", "8.8 ਕਰੋੜ", "8.8 ਕਰੋੜ"],
    ["987654321", "99 ਕਰੋੜ", "99 ਕਰੋੜ"],
    ["1087654321", "1.1 ਅਰਬ", "1.1 ਅਰਬ"],
    ["11987654321", "12 ਅਰਬ", "12 ਅਰਬ"],
    ["129987654321", "1.3 ਖਰਬ", "1.3 ਖਰਬ"],
    ["1398987654321", "14 ਖਰਬ", "14 ਖਰਬ"],
    ["14987987654321", "1.5 ਨੀਲ", "1.5 ਨੀਲ"],
    ["159876987654321", "16 ਨੀਲ", "16 ਨੀਲ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ਹਜ਼ਾਰ", "10 ਹਜ਼ਾਰ"],
    ["99999", "1 ਲੱਖ", "1 ਲੱਖ"],
    ["99999", "1 ਲੱਖ", "1 ਲੱਖ"],
    ["999999", "10 ਲੱਖ", "10 ਲੱਖ"],
    ["9999999", "1 ਕਰੋੜ", "1 ਕਰੋੜ"],
    ["99999999", "10 ਕਰੋੜ", "10 ਕਰੋੜ"],
    ["9994", "10 ਹਜ਼ਾਰ", "10 ਹਜ਼ਾਰ"],
    ["99944", "1 ਲੱਖ", "1 ਲੱਖ"],
    ["999444", "10 ਲੱਖ", "10 ਲੱਖ"],
    ["9994444", "1 ਕਰੋੜ", "1 ਕਰੋੜ"],
    ["999444444", "1 ਅਰਬ", "1 ਅਰਬ"],
    ["9994444444", "10 ਅਰਬ", "10 ਅਰਬ"],
  ],
  "pl": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tys.", "4,3 tysiąca"],
    ["54321", "54 tys.", "54 tysiące"],
    ["654321", "654 tys.", "654 tysiące"],
    ["7654321", "7,7 mln", "7,7 miliona"],
    ["87654321", "88 mln", "88 milionów"],
    ["987654321", "988 mln", "988 milionów"],
    ["1087654321", "1,1 mld", "1,1 miliarda"],
    ["11987654321", "12 mld", "12 miliardów"],
    ["129987654321", "130 mld", "130 miliardów"],
    ["1398987654321", "1,4 bln", "1,4 biliona"],
    ["14987987654321", "15 bln", "15 bilionów"],
    ["159876987654321", "160 bln", "160 bilionów"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tys.", "10 tysięcy"],
    ["99999", "100 tys.", "100 tysięcy"],
    ["99999", "100 tys.", "100 tysięcy"],
    ["999999", "1 mln", "1 milion"],
    ["9999999", "10 mln", "10 milionów"],
    ["99999999", "100 mln", "100 milionów"],
    ["9994", "10 tys.", "10 tysięcy"],
    ["99944", "100 tys.", "100 tysięcy"],
    ["999444", "999 tys.", "999 tysięcy"],
    ["9994444", "10 mln", "10 milionów"],
    ["999444444", "999 mln", "999 milionów"],
    ["9994444444", "10 mld", "10 miliardów"],
  ],
  "pt": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 mil", "4,3 mil"],
    ["54321", "54 mil", "54 mil"],
    ["654321", "654 mil", "654 mil"],
    ["7654321", "7,7 mi", "7,7 milhões"],
    ["87654321", "88 mi", "88 milhões"],
    ["987654321", "988 mi", "988 milhões"],
    ["1087654321", "1,1 bi", "1,1 bilhão"],
    ["11987654321", "12 bi", "12 bilhões"],
    ["129987654321", "130 bi", "130 bilhões"],
    ["1398987654321", "1,4 tri", "1,4 trilhão"],
    ["14987987654321", "15 tri", "15 trilhões"],
    ["159876987654321", "160 tri", "160 trilhões"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mil", "10 mil"],
    ["99999", "100 mil", "100 mil"],
    ["99999", "100 mil", "100 mil"],
    ["999999", "1 mi", "1 milhão"],
    ["9999999", "10 mi", "10 milhões"],
    ["99999999", "100 mi", "100 milhões"],
    ["9994", "10 mil", "10 mil"],
    ["99944", "100 mil", "100 mil"],
    ["999444", "999 mil", "999 mil"],
    ["9994444", "10 mi", "10 milhões"],
    ["999444444", "999 mi", "999 milhões"],
    ["9994444444", "10 bi", "10 bilhões"],
  ],
  "pt_BR": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 mil", "4,3 mil"],
    ["54321", "54 mil", "54 mil"],
    ["654321", "654 mil", "654 mil"],
    ["7654321", "7,7 mi", "7,7 milhões"],
    ["87654321", "88 mi", "88 milhões"],
    ["987654321", "988 mi", "988 milhões"],
    ["1087654321", "1,1 bi", "1,1 bilhão"],
    ["11987654321", "12 bi", "12 bilhões"],
    ["129987654321", "130 bi", "130 bilhões"],
    ["1398987654321", "1,4 tri", "1,4 trilhão"],
    ["14987987654321", "15 tri", "15 trilhões"],
    ["159876987654321", "160 tri", "160 trilhões"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mil", "10 mil"],
    ["99999", "100 mil", "100 mil"],
    ["99999", "100 mil", "100 mil"],
    ["999999", "1 mi", "1 milhão"],
    ["9999999", "10 mi", "10 milhões"],
    ["99999999", "100 mi", "100 milhões"],
    ["9994", "10 mil", "10 mil"],
    ["99944", "100 mil", "100 mil"],
    ["999444", "999 mil", "999 mil"],
    ["9994444", "10 mi", "10 milhões"],
    ["999444444", "999 mi", "999 milhões"],
    ["9994444444", "10 bi", "10 bilhões"],
  ],
  "pt_PT": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 mil", "4,3 mil"],
    ["54321", "54 mil", "54 mil"],
    ["654321", "654 mil", "654 mil"],
    ["7654321", "7,7 M", "7,7 milhões"],
    ["87654321", "88 M", "88 milhões"],
    ["987654321", "988 M", "988 milhões"],
    ["1087654321", "1,1 mM", "1,1 mil milhões"],
    ["11987654321", "12 mM", "12 mil milhões"],
    ["129987654321", "130 mM", "130 mil milhões"],
    ["1398987654321", "1,4 Bi", "1,4 biliões"],
    ["14987987654321", "15 Bi", "15 biliões"],
    ["159876987654321", "160 Bi", "160 biliões"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mil", "10 mil"],
    ["99999", "100 mil", "100 mil"],
    ["99999", "100 mil", "100 mil"],
    ["999999", "1 M", "1 milhão"],
    ["9999999", "10 M", "10 milhões"],
    ["99999999", "100 M", "100 milhões"],
    ["9994", "10 mil", "10 mil"],
    ["99944", "100 mil", "100 mil"],
    ["999444", "999 mil", "999 mil"],
    ["9994444", "10 M", "10 milhões"],
    ["999444444", "999 M", "999 milhões"],
    ["9994444444", "10 mM", "10 mil milhões"],
  ],
  "ro": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 K", "4,3 mii"],
    ["54321", "54 K", "54 de mii"],
    ["654321", "654 K", "654 de mii"],
    ["7654321", "7,7 mil.", "7,7 milioane"],
    ["87654321", "88 mil.", "88 de milioane"],
    ["987654321", "988 mil.", "988 de milioane"],
    ["1087654321", "1,1 mld.", "1,1 miliarde"],
    ["11987654321", "12 mld.", "12 miliarde"],
    ["129987654321", "130 mld.", "130 de miliarde"],
    ["1398987654321", "1,4 tril.", "1,4 trilioane"],
    ["14987987654321", "15 tril.", "15 trilioane"],
    ["159876987654321", "160 tril.", "160 de trilioane"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 K", "10 mii"],
    ["99999", "100 K", "100 de mii"],
    ["99999", "100 K", "100 de mii"],
    ["999999", "1 mil.", "1 milion"],
    ["9999999", "10 mil.", "10 milioane"],
    ["99999999", "100 mil.", "100 de milioane"],
    ["9994", "10 K", "10 mii"],
    ["99944", "100 K", "100 de mii"],
    ["999444", "999 K", "999 de mii"],
    ["9994444", "10 mil.", "10 milioane"],
    ["999444444", "999 mil.", "999 de milioane"],
    ["9994444444", "10 mld.", "10 miliarde"],
  ],
  "ru": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 тыс.", "4,3 тысячи"],
    ["54321", "54 тыс.", "54 тысячи"],
    ["654321", "654 тыс.", "654 тысячи"],
    ["7654321", "7,7 млн", "7,7 миллиона"],
    ["87654321", "88 млн", "88 миллионов"],
    ["987654321", "988 млн", "988 миллионов"],
    ["1087654321", "1,1 млрд", "1,1 миллиарда"],
    ["11987654321", "12 млрд", "12 миллиардов"],
    ["129987654321", "130 млрд", "130 миллиардов"],
    ["1398987654321", "1,4 трлн", "1,4 триллиона"],
    ["14987987654321", "15 трлн", "15 триллионов"],
    ["159876987654321", "160 трлн", "160 триллионов"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 тыс.", "10 тысяч"],
    ["99999", "100 тыс.", "100 тысяч"],
    ["99999", "100 тыс.", "100 тысяч"],
    ["999999", "1 млн", "1 миллион"],
    ["9999999", "10 млн", "10 миллионов"],
    ["99999999", "100 млн", "100 миллионов"],
    ["9994", "10 тыс.", "10 тысяч"],
    ["99944", "100 тыс.", "100 тысяч"],
    ["999444", "999 тыс.", "999 тысяч"],
    ["9994444", "10 млн", "10 миллионов"],
    ["999444444", "999 млн", "999 миллионов"],
    ["9994444444", "10 млрд", "10 миллиардов"],
  ],
  "si": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "ද4.3", "දහස 4.3"],
    ["54321", "ද54", "දහස 54"],
    ["654321", "ද654", "දහස 654"],
    ["7654321", "මි7.7", "මිලියන 7.7"],
    ["87654321", "මි88", "මිලියන 88"],
    ["987654321", "මි988", "මිලියන 988"],
    ["1087654321", "බි1.1", "බිලියන 1.1"],
    ["11987654321", "බි12", "බිලියන 12"],
    ["129987654321", "බි130", "බිලියන 130"],
    ["1398987654321", "ට්‍රි1.4", "ට්‍රිලියන 1.4"],
    ["14987987654321", "ට්‍රි15", "ට්‍රිලියන 15"],
    ["159876987654321", "ට්‍රි160", "ට්‍රිලියන 160"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "ද10", "දහස 10"],
    ["99999", "ද100", "දහස 100"],
    ["99999", "ද100", "දහස 100"],
    ["999999", "මි1", "මිලියන 1"],
    ["9999999", "මි10", "මිලියන 10"],
    ["99999999", "මි100", "මිලියන 100"],
    ["9994", "ද10", "දහස 10"],
    ["99944", "ද100", "දහස 100"],
    ["999444", "ද999", "දහස 999"],
    ["9994444", "මි10", "මිලියන 10"],
    ["999444444", "මි999", "මිලියන 999"],
    ["9994444444", "බි10", "බිලියන 10"],
  ],
  "sk": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tis.", "4,3 tisíca"],
    ["54321", "54 tis.", "54 tisíc"],
    ["654321", "654 tis.", "654 tisíc"],
    ["7654321", "7,7 mil.", "7,7 milióna"],
    ["87654321", "88 mil.", "88 miliónov"],
    ["987654321", "988 mil.", "988 miliónov"],
    ["1087654321", "1,1 mld.", "1,1 miliardy"],
    ["11987654321", "12 mld.", "12 miliárd"],
    ["129987654321", "130 mld.", "130 miliárd"],
    ["1398987654321", "1,4 bil.", "1,4 bilióna"],
    ["14987987654321", "15 bil.", "15 biliónov"],
    ["159876987654321", "160 bil.", "160 biliónov"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tis.", "10 tisíc"],
    ["99999", "100 tis.", "100 tisíc"],
    ["99999", "100 tis.", "100 tisíc"],
    ["999999", "1 mil.", "1 milión"],
    ["9999999", "10 mil.", "10 miliónov"],
    ["99999999", "100 mil.", "100 miliónov"],
    ["9994", "10 tis.", "10 tisíc"],
    ["99944", "100 tis.", "100 tisíc"],
    ["999444", "999 tis.", "999 tisíc"],
    ["9994444", "10 mil.", "10 miliónov"],
    ["999444444", "999 mil.", "999 miliónov"],
    ["9994444444", "10 mld.", "10 miliárd"],
  ],
  "sl": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tis.", "4,3 tisoč"],
    ["54321", "54 tis.", "54 tisoč"],
    ["654321", "654 tis.", "654 tisoč"],
    ["7654321", "7,7 mio.", "7,7 milijone"],
    ["87654321", "88 mio.", "88 milijonov"],
    ["987654321", "988 mio.", "988 milijonov"],
    ["1087654321", "1,1 mrd.", "1,1 milijarde"],
    ["11987654321", "12 mrd.", "12 milijard"],
    ["129987654321", "130 mrd.", "130 milijard"],
    ["1398987654321", "1,4 bil.", "1,4 bilijoni"],
    ["14987987654321", "15 bil.", "15 bilijonov"],
    ["159876987654321", "160 bil.", "160 bilijonov"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tis.", "10 tisoč"],
    ["99999", "100 tis.", "100 tisoč"],
    ["99999", "100 tis.", "100 tisoč"],
    ["999999", "1 mio.", "1 milijon"],
    ["9999999", "10 mio.", "10 milijonov"],
    ["99999999", "100 mio.", "100 milijonov"],
    ["9994", "10 tis.", "10 tisoč"],
    ["99944", "100 tis.", "100 tisoč"],
    ["999444", "999 tis.", "999 tisoč"],
    ["9994444", "10 mio.", "10 milijonov"],
    ["999444444", "999 mio.", "999 milijonov"],
    ["9994444444", "10 mrd.", "10 milijard"],
  ],
  "sq": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 mijë", "4,3 mijë"],
    ["54321", "54 mijë", "54 mijë"],
    ["654321", "654 mijë", "654 mijë"],
    ["7654321", "7,7 mln", "7,7 milion"],
    ["87654321", "88 mln", "88 milion"],
    ["987654321", "988 mln", "988 milion"],
    ["1087654321", "1,1 mld", "1,1 miliard"],
    ["11987654321", "12 mld", "12 miliard"],
    ["129987654321", "130 mld", "130 miliard"],
    ["1398987654321", "1,4 bln", "1,4 bilion"],
    ["14987987654321", "15 bln", "15 bilion"],
    ["159876987654321", "160 bln", "160 bilion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 mijë", "10 mijë"],
    ["99999", "100 mijë", "100 mijë"],
    ["99999", "100 mijë", "100 mijë"],
    ["999999", "1 mln", "1 milion"],
    ["9999999", "10 mln", "10 milion"],
    ["99999999", "100 mln", "100 milion"],
    ["9994", "10 mijë", "10 mijë"],
    ["99944", "100 mijë", "100 mijë"],
    ["999444", "999 mijë", "999 mijë"],
    ["9994444", "10 mln", "10 milion"],
    ["999444444", "999 mln", "999 milion"],
    ["9994444444", "10 mld", "10 miliard"],
  ],
  "sr": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 хиљ.", "4,3 хиљаде"],
    ["54321", "54 хиљ.", "54 хиљаде"],
    ["654321", "654 хиљ.", "654 хиљаде"],
    ["7654321", "7,7 мил.", "7,7 милиона"],
    ["87654321", "88 мил.", "88 милиона"],
    ["987654321", "988 мил.", "988 милиона"],
    ["1087654321", "1,1 млрд.", "1,1 милијарда"],
    ["11987654321", "12 млрд.", "12 милијарди"],
    ["129987654321", "130 млрд.", "130 милијарди"],
    ["1398987654321", "1,4 бил.", "1,4 билиона"],
    ["14987987654321", "15 бил.", "15 билиона"],
    ["159876987654321", "160 бил.", "160 билиона"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 хиљ.", "10 хиљада"],
    ["99999", "100 хиљ.", "100 хиљада"],
    ["99999", "100 хиљ.", "100 хиљада"],
    ["999999", "1 мил.", "1 милион"],
    ["9999999", "10 мил.", "10 милиона"],
    ["99999999", "100 мил.", "100 милиона"],
    ["9994", "10 хиљ.", "10 хиљада"],
    ["99944", "100 хиљ.", "100 хиљада"],
    ["999444", "999 хиљ.", "999 хиљада"],
    ["9994444", "10 мил.", "10 милиона"],
    ["999444444", "999 мил.", "999 милиона"],
    ["9994444444", "10 млрд.", "10 милијарди"],
  ],
  "sr_Latn": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 hilj.", "4,3 hiljade"],
    ["54321", "54 hilj.", "54 hiljade"],
    ["654321", "654 hilj.", "654 hiljade"],
    ["7654321", "7,7 mil.", "7,7 miliona"],
    ["87654321", "88 mil.", "88 miliona"],
    ["987654321", "988 mil.", "988 miliona"],
    ["1087654321", "1,1 mlrd.", "1,1 milijarda"],
    ["11987654321", "12 mlrd.", "12 milijardi"],
    ["129987654321", "130 mlrd.", "130 milijardi"],
    ["1398987654321", "1,4 bil.", "1,4 biliona"],
    ["14987987654321", "15 bil.", "15 biliona"],
    ["159876987654321", "160 bil.", "160 biliona"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 hilj.", "10 hiljada"],
    ["99999", "100 hilj.", "100 hiljada"],
    ["99999", "100 hilj.", "100 hiljada"],
    ["999999", "1 mil.", "1 milion"],
    ["9999999", "10 mil.", "10 miliona"],
    ["99999999", "100 mil.", "100 miliona"],
    ["9994", "10 hilj.", "10 hiljada"],
    ["99944", "100 hilj.", "100 hiljada"],
    ["999444", "999 hilj.", "999 hiljada"],
    ["9994444", "10 mil.", "10 miliona"],
    ["999444444", "999 mil.", "999 miliona"],
    ["9994444444", "10 mlrd.", "10 milijardi"],
  ],
  "sv": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 tn", "4,3 tusen"],
    ["54321", "54 tn", "54 tusen"],
    ["654321", "654 tn", "654 tusen"],
    ["7654321", "7,7 mn", "7,7 miljoner"],
    ["87654321", "88 mn", "88 miljoner"],
    ["987654321", "988 mn", "988 miljoner"],
    ["1087654321", "1,1 md", "1,1 miljarder"],
    ["11987654321", "12 md", "12 miljarder"],
    ["129987654321", "130 md", "130 miljarder"],
    ["1398987654321", "1,4 bn", "1,4 biljoner"],
    ["14987987654321", "15 bn", "15 biljoner"],
    ["159876987654321", "160 bn", "160 biljoner"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 tn", "10 tusen"],
    ["99999", "100 tn", "100 tusen"],
    ["99999", "100 tn", "100 tusen"],
    ["999999", "1 mn", "1 miljon"],
    ["9999999", "10 mn", "10 miljoner"],
    ["99999999", "100 mn", "100 miljoner"],
    ["9994", "10 tn", "10 tusen"],
    ["99944", "100 tn", "100 tusen"],
    ["999444", "999 tn", "999 tusen"],
    ["9994444", "10 mn", "10 miljoner"],
    ["999444444", "999 mn", "999 miljoner"],
    ["9994444444", "10 md", "10 miljarder"],
  ],
  "sw": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "elfu 4.3", "elfu 4.3"],
    ["54321", "elfu 54", "elfu 54"],
    ["654321", "elfu 654", "elfu 654"],
    ["7654321", "7.7M", "milioni 7.7"],
    ["87654321", "88M", "milioni 88"],
    ["987654321", "988M", "milioni 988"],
    ["1087654321", "1.1B", "bilioni 1.1"],
    ["11987654321", "12B", "bilioni 12"],
    ["129987654321", "130B", "bilioni 130"],
    ["1398987654321", "1.4T", "trilioni 1.4"],
    ["14987987654321", "15T", "trilioni 15"],
    ["159876987654321", "160T", "trilioni 160"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "elfu 10", "elfu 10"],
    ["99999", "elfu 100", "elfu 100"],
    ["99999", "elfu 100", "elfu 100"],
    ["999999", "1M", "milioni 1"],
    ["9999999", "10M", "milioni 10"],
    ["99999999", "100M", "milioni 100"],
    ["9994", "elfu 10", "elfu 10"],
    ["99944", "elfu 100", "elfu 100"],
    ["999444", "elfu 999", "elfu 999"],
    ["9994444", "10M", "milioni 10"],
    ["999444444", "999M", "milioni 999"],
    ["9994444444", "10B", "bilioni 10"],
  ],
  "ta": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3ஆ", "4.3 ஆயிரம்"],
    ["54321", "54ஆ", "54 ஆயிரம்"],
    ["654321", "654ஆ", "654 ஆயிரம்"],
    ["7654321", "7.7மி", "7.7 மில்லியன்"],
    ["87654321", "88மி", "88 மில்லியன்"],
    ["987654321", "988மி", "988 மில்லியன்"],
    ["1087654321", "1.1பி", "1.1 பில்லியன்"],
    ["11987654321", "12பி", "12 பில்லியன்"],
    ["129987654321", "130பி", "130 பில்லியன்"],
    ["1398987654321", "1.4டி", "1.4 டிரில்லியன்"],
    ["14987987654321", "15டி", "15 டிரில்லியன்"],
    ["159876987654321", "160டி", "160 டிரில்லியன்"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10ஆ", "10 ஆயிரம்"],
    ["99999", "100ஆ", "100 ஆயிரம்"],
    ["99999", "100ஆ", "100 ஆயிரம்"],
    ["999999", "1மி", "1 மில்லியன்"],
    ["9999999", "10மி", "10 மில்லியன்"],
    ["99999999", "100மி", "100 மில்லியன்"],
    ["9994", "10ஆ", "10 ஆயிரம்"],
    ["99944", "100ஆ", "100 ஆயிரம்"],
    ["999444", "999ஆ", "999 ஆயிரம்"],
    ["9994444", "10மி", "10 மில்லியன்"],
    ["999444444", "999மி", "999 மில்லியன்"],
    ["9994444444", "10பி", "10 பில்லியன்"],
  ],
  "te": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3వే", "4.3 వేలు"],
    ["54321", "54వే", "54 వేలు"],
    ["654321", "654వే", "654 వేలు"],
    ["7654321", "7.7మి", "7.7 మిలియన్లు"],
    ["87654321", "88మి", "88 మిలియన్లు"],
    ["987654321", "988మి", "988 మిలియన్లు"],
    ["1087654321", "1.1బి", "1.1 బిలియన్లు"],
    ["11987654321", "12బి", "12 బిలియన్లు"],
    ["129987654321", "130బి", "130 బిలియన్లు"],
    ["1398987654321", "1.4ట్రి", "1.4 ట్రిలియన్లు"],
    ["14987987654321", "15ట్రి", "15 ట్రిలియన్లు"],
    ["159876987654321", "160ట్రి", "160 ట్రిలియన్లు"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10వే", "10 వేలు"],
    ["99999", "100వే", "100 వేలు"],
    ["99999", "100వే", "100 వేలు"],
    ["999999", "1మి", "1 మిలియన్"],
    ["9999999", "10మి", "10 మిలియన్లు"],
    ["99999999", "100మి", "100 మిలియన్లు"],
    ["9994", "10వే", "10 వేలు"],
    ["99944", "100వే", "100 వేలు"],
    ["999444", "999వే", "999 వేలు"],
    ["9994444", "10మి", "10 మిలియన్లు"],
    ["999444444", "999మి", "999 మిలియన్లు"],
    ["9994444444", "10బి", "10 బిలియన్లు"],
  ],
  "th": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 พัน"],
    ["54321", "54K", "5.4 หมื่น"],
    ["654321", "654K", "6.5 แสน"],
    ["7654321", "7.7M", "7.7 ล้าน"],
    ["87654321", "88M", "88 ล้าน"],
    ["987654321", "988M", "988 ล้าน"],
    ["1087654321", "1.1B", "1.1 พันล้าน"],
    ["11987654321", "12B", "1.2 หมื่นล้าน"],
    ["129987654321", "130B", "1.3 แสนล้าน"],
    ["1398987654321", "1.4T", "1.4 ล้านล้าน"],
    ["14987987654321", "15T", "15 ล้านล้าน"],
    ["159876987654321", "160T", "160 ล้านล้าน"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "1 หมื่น"],
    ["99999", "100K", "1 แสน"],
    ["99999", "100K", "1 แสน"],
    ["999999", "1M", "1 ล้าน"],
    ["9999999", "10M", "10 ล้าน"],
    ["99999999", "100M", "100 ล้าน"],
    ["9994", "10K", "1 หมื่น"],
    ["99944", "100K", "1 แสน"],
    ["999444", "999K", "1 ล้าน"],
    ["9994444", "10M", "10 ล้าน"],
    ["999444444", "999M", "999 ล้าน"],
    ["9994444444", "10B", "1 หมื่นล้าน"],
  ],
  "tl": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 libo"],
    ["54321", "54K", "54 na libo"],
    ["654321", "654K", "654 na libo"],
    ["7654321", "7.7M", "7.7 milyon"],
    ["87654321", "88M", "88 milyon"],
    ["987654321", "988M", "988 milyon"],
    ["1087654321", "1.1B", "1.1 bilyon"],
    ["11987654321", "12B", "12 bilyon"],
    ["129987654321", "130B", "130 bilyon"],
    ["1398987654321", "1.4T", "1.4 na trilyon"],
    ["14987987654321", "15T", "15 trilyon"],
    ["159876987654321", "160T", "160 trilyon"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 libo"],
    ["99999", "100K", "100 libo"],
    ["99999", "100K", "100 libo"],
    ["999999", "1M", "1 milyon"],
    ["9999999", "10M", "10 milyon"],
    ["99999999", "100M", "100 milyon"],
    ["9994", "10K", "10 libo"],
    ["99944", "100K", "100 libo"],
    ["999444", "999K", "999 na libo"],
    ["9994444", "10M", "10 milyon"],
    ["999444444", "999M", "999 na milyon"],
    ["9994444444", "10B", "10 bilyon"],
  ],
  "tr": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 B", "4,3 bin"],
    ["54321", "54 B", "54 bin"],
    ["654321", "654 B", "654 bin"],
    ["7654321", "7,7 Mn", "7,7 milyon"],
    ["87654321", "88 Mn", "88 milyon"],
    ["987654321", "988 Mn", "988 milyon"],
    ["1087654321", "1,1 Mr", "1,1 milyar"],
    ["11987654321", "12 Mr", "12 milyar"],
    ["129987654321", "130 Mr", "130 milyar"],
    ["1398987654321", "1,4 Tn", "1,4 trilyon"],
    ["14987987654321", "15 Tn", "15 trilyon"],
    ["159876987654321", "160 Tn", "160 trilyon"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 B", "10 bin"],
    ["99999", "100 B", "100 bin"],
    ["99999", "100 B", "100 bin"],
    ["999999", "1 Mn", "1 milyon"],
    ["9999999", "10 Mn", "10 milyon"],
    ["99999999", "100 Mn", "100 milyon"],
    ["9994", "10 B", "10 bin"],
    ["99944", "100 B", "100 bin"],
    ["999444", "999 B", "999 bin"],
    ["9994444", "10 Mn", "10 milyon"],
    ["999444444", "999 Mn", "999 milyon"],
    ["9994444444", "10 Mr", "10 milyar"],
  ],
  "uk": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 тис.", "4,3 тисячі"],
    ["54321", "54 тис.", "54 тисячі"],
    ["654321", "654 тис.", "654 тисячі"],
    ["7654321", "7,7 млн", "7,7 мільйона"],
    ["87654321", "88 млн", "88 мільйонів"],
    ["987654321", "988 млн", "988 мільйонів"],
    ["1087654321", "1,1 млрд", "1,1 мільярда"],
    ["11987654321", "12 млрд", "12 мільярдів"],
    ["129987654321", "130 млрд", "130 мільярдів"],
    ["1398987654321", "1,4 трлн", "1,4 трильйона"],
    ["14987987654321", "15 трлн", "15 трильйонів"],
    ["159876987654321", "160 трлн", "160 трильйонів"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 тис.", "10 тисяч"],
    ["99999", "100 тис.", "100 тисяч"],
    ["99999", "100 тис.", "100 тисяч"],
    ["999999", "1 млн", "1 мільйон"],
    ["9999999", "10 млн", "10 мільйонів"],
    ["99999999", "100 млн", "100 мільйонів"],
    ["9994", "10 тис.", "10 тисяч"],
    ["99944", "100 тис.", "100 тисяч"],
    ["999444", "999 тис.", "999 тисяч"],
    ["9994444", "10 млн", "10 мільйонів"],
    ["999444444", "999 млн", "999 мільйонів"],
    ["9994444444", "10 млрд", "10 мільярдів"],
  ],
  "ur": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3 ہزار", "4.3 ہزار"],
    ["54321", "54 ہزار", "54 ہزار"],
    ["654321", "6.5 لاکھ", "6.5 لاکھ"],
    ["7654321", "77 لاکھ", "77 لاکھ"],
    ["87654321", "8.8 کروڑ", "8.8 کروڑ"],
    ["987654321", "99 کروڑ", "99 کروڑ"],
    ["1087654321", "1.1 ارب", "1.1 ارب"],
    ["11987654321", "12 ارب", "12 ارب"],
    ["129987654321", "1.3 کھرب", "1.3 کھرب"],
    ["1398987654321", "14 کھرب", "14 کھرب"],
    ["14987987654321", "15 ٹریلین", "15 ٹریلین"],
    ["159876987654321", "160 ٹریلین", "160 ٹریلین"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ہزار", "10 ہزار"],
    ["99999", "1 لاکھ", "1 لاکھ"],
    ["99999", "1 لاکھ", "1 لاکھ"],
    ["999999", "10 لاکھ", "10 لاکھ"],
    ["9999999", "1 کروڑ", "1 کروڑ"],
    ["99999999", "10 کروڑ", "10 کروڑ"],
    ["9994", "10 ہزار", "10 ہزار"],
    ["99944", "1 لاکھ", "1 لاکھ"],
    ["999444", "10 لاکھ", "10 لاکھ"],
    ["9994444", "1 کروڑ", "1 کروڑ"],
    ["999444444", "1 ارب", "1 ارب"],
    ["9994444444", "10 ارب", "10 ارب"],
  ],
  "uz": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 ming", "4,3 ming"],
    ["54321", "54 ming", "54 ming"],
    ["654321", "654 ming", "654 ming"],
    ["7654321", "7,7 mln", "7,7 million"],
    ["87654321", "88 mln", "88 million"],
    ["987654321", "988 mln", "988 million"],
    ["1087654321", "1,1 mlrd", "1,1 milliard"],
    ["11987654321", "12 mlrd", "12 milliard"],
    ["129987654321", "130 mlrd", "130 milliard"],
    ["1398987654321", "1,4 trln", "1,4 trillion"],
    ["14987987654321", "15 trln", "15 trillion"],
    ["159876987654321", "160 trln", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 ming", "10 ming"],
    ["99999", "100 ming", "100 ming"],
    ["99999", "100 ming", "100 ming"],
    ["999999", "1 mln", "1 million"],
    ["9999999", "10 mln", "10 million"],
    ["99999999", "100 mln", "100 million"],
    ["9994", "10 ming", "10 ming"],
    ["99944", "100 ming", "100 ming"],
    ["999444", "999 ming", "999 ming"],
    ["9994444", "10 mln", "10 million"],
    ["999444444", "999 mln", "999 million"],
    ["9994444444", "10 mlrd", "10 milliard"],
  ],
  "vi": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 N", "4,3 nghìn"],
    ["54321", "54 N", "54 nghìn"],
    ["654321", "654 N", "654 nghìn"],
    ["7654321", "7,7 Tr", "7,7 triệu"],
    ["87654321", "88 Tr", "88 triệu"],
    ["987654321", "988 Tr", "988 triệu"],
    ["1087654321", "1,1 T", "1,1 tỷ"],
    ["11987654321", "12 T", "12 tỷ"],
    ["129987654321", "130 T", "130 tỷ"],
    ["1398987654321", "1,4 NT", "1,4 nghìn tỷ"],
    ["14987987654321", "15 NT", "15 nghìn tỷ"],
    ["159876987654321", "160 NT", "160 nghìn tỷ"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 N", "10 nghìn"],
    ["99999", "100 N", "100 nghìn"],
    ["99999", "100 N", "100 nghìn"],
    ["999999", "1 Tr", "1 triệu"],
    ["9999999", "10 Tr", "10 triệu"],
    ["99999999", "100 Tr", "100 triệu"],
    ["9994", "10 N", "10 nghìn"],
    ["99944", "100 N", "100 nghìn"],
    ["999444", "999 N", "999 nghìn"],
    ["9994444", "10 Tr", "10 triệu"],
    ["999444444", "999 Tr", "999 triệu"],
    ["9994444444", "10 T", "10 tỷ"],
  ],
  "zh": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4321"],
    ["54321", "5.4万", "5.4万"],
    ["654321", "65万", "65万"],
    ["7654321", "765万", "765万"],
    ["87654321", "8765万", "8765万"],
    ["987654321", "9.9亿", "9.9亿"],
    ["1087654321", "11亿", "11亿"],
    ["11987654321", "120亿", "120亿"],
    ["129987654321", "1300亿", "1300亿"],
    ["1398987654321", "1.4兆", "1.4兆"],
    ["14987987654321", "15兆", "15兆"],
    ["159876987654321", "160兆", "160兆"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "9999"],
    ["99999", "10万", "10万"],
    ["99999", "10万", "10万"],
    ["999999", "100万", "100万"],
    ["9999999", "1000万", "1000万"],
    ["99999999", "1亿", "1亿"],
    ["9994", "9994", "9994"],
    ["99944", "10万", "10万"],
    ["999444", "100万", "100万"],
    ["9994444", "999万", "999万"],
    ["999444444", "10亿", "10亿"],
    ["9994444444", "100亿", "100亿"],
  ],
  "zh_CN": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4321"],
    ["54321", "5.4万", "5.4万"],
    ["654321", "65万", "65万"],
    ["7654321", "765万", "765万"],
    ["87654321", "8765万", "8765万"],
    ["987654321", "9.9亿", "9.9亿"],
    ["1087654321", "11亿", "11亿"],
    ["11987654321", "120亿", "120亿"],
    ["129987654321", "1300亿", "1300亿"],
    ["1398987654321", "1.4兆", "1.4兆"],
    ["14987987654321", "15兆", "15兆"],
    ["159876987654321", "160兆", "160兆"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "9999"],
    ["99999", "10万", "10万"],
    ["99999", "10万", "10万"],
    ["999999", "100万", "100万"],
    ["9999999", "1000万", "1000万"],
    ["99999999", "1亿", "1亿"],
    ["9994", "9994", "9994"],
    ["99944", "10万", "10万"],
    ["999444", "100万", "100万"],
    ["9994444", "999万", "999万"],
    ["999444444", "10亿", "10亿"],
    ["9994444444", "100亿", "100亿"],
  ],
  "zh_HK": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4321"],
    ["54321", "54K", "5.4萬"],
    ["654321", "654K", "65萬"],
    ["7654321", "7.7M", "765萬"],
    ["87654321", "88M", "8765萬"],
    ["987654321", "988M", "9.9億"],
    ["1087654321", "1.1B", "11億"],
    ["11987654321", "12B", "120億"],
    ["129987654321", "130B", "1300億"],
    ["1398987654321", "1.4T", "1.4兆"],
    ["14987987654321", "15T", "15兆"],
    ["159876987654321", "160T", "160兆"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "9999"],
    ["99999", "100K", "10萬"],
    ["99999", "100K", "10萬"],
    ["999999", "1M", "100萬"],
    ["9999999", "10M", "1000萬"],
    ["99999999", "100M", "1億"],
    ["9994", "10K", "9994"],
    ["99944", "100K", "10萬"],
    ["999444", "999K", "100萬"],
    ["9994444", "10M", "999萬"],
    ["999444444", "999M", "10億"],
    ["9994444444", "10B", "100億"],
  ],
  "zh_TW": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4321"],
    ["54321", "5.4萬", "5.4萬"],
    ["654321", "65萬", "65萬"],
    ["7654321", "765萬", "765萬"],
    ["87654321", "8765萬", "8765萬"],
    ["987654321", "9.9億", "9.9億"],
    ["1087654321", "11億", "11億"],
    ["11987654321", "120億", "120億"],
    ["129987654321", "1300億", "1300億"],
    ["1398987654321", "1.4兆", "1.4兆"],
    ["14987987654321", "15兆", "15兆"],
    ["159876987654321", "160兆", "160兆"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "9999"],
    ["99999", "10萬", "10萬"],
    ["99999", "10萬", "10萬"],
    ["999999", "100萬", "100萬"],
    ["9999999", "1000萬", "1000萬"],
    ["99999999", "1億", "1億"],
    ["9994", "9994", "9994"],
    ["99944", "10萬", "10萬"],
    ["999444", "100萬", "100萬"],
    ["9994444", "999萬", "999萬"],
    ["999444444", "10億", "10億"],
    ["9994444444", "100億", "100億"],
  ],
  "zu": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 inkulungwane"],
    ["54321", "54K", "54 inkulungwane"],
    ["654321", "654K", "654 inkulungwane"],
    ["7654321", "7.7M", "7.7 isigidi"],
    ["87654321", "88M", "88 isigidi"],
    ["987654321", "988M", "988 isigidi"],
    ["1087654321", "1.1B", "1.1 isigidi sezigidi"],
    ["11987654321", "12B", "12 isigidi sezigidi"],
    ["129987654321", "130B", "130 isigidi sezigidi"],
    ["1398987654321", "1.4T", "1.4 isigidintathu"],
    ["14987987654321", "15T", "15 isigidintathu"],
    ["159876987654321", "160T", "160 isigidintathu"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 inkulungwane"],
    ["99999", "100K", "100 inkulungwane"],
    ["99999", "100K", "100 inkulungwane"],
    ["999999", "1M", "1 isigidi"],
    ["9999999", "10M", "10 isigidi"],
    ["99999999", "100M", "100 isigidi"],
    ["9994", "10K", "10 inkulungwane"],
    ["99944", "100K", "100 inkulungwane"],
    ["999444", "999K", "999 inkulungwane"],
    ["9994444", "10M", "10 isigidi"],
    ["999444444", "999M", "999 isigidi"],
    ["9994444444", "10B", "10 isigidi sezigidi"],
  ],
  "en_MY": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4.3K", "4.3 thousand"],
    ["54321", "54K", "54 thousand"],
    ["654321", "654K", "654 thousand"],
    ["7654321", "7.7M", "7.7 million"],
    ["87654321", "88M", "88 million"],
    ["987654321", "988M", "988 million"],
    ["1087654321", "1.1B", "1.1 billion"],
    ["11987654321", "12B", "12 billion"],
    ["129987654321", "130B", "130 billion"],
    ["1398987654321", "1.4T", "1.4 trillion"],
    ["14987987654321", "15T", "15 trillion"],
    ["159876987654321", "160T", "160 trillion"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10K", "10 thousand"],
    ["99999", "100K", "100 thousand"],
    ["99999", "100K", "100 thousand"],
    ["999999", "1M", "1 million"],
    ["9999999", "10M", "10 million"],
    ["99999999", "100M", "100 million"],
    ["9994", "10K", "10 thousand"],
    ["99944", "100K", "100 thousand"],
    ["999444", "999K", "999 thousand"],
    ["9994444", "10M", "10 million"],
    ["999444444", "999M", "999 million"],
    ["9994444444", "10B", "10 billion"],
  ],
  "fr_CH": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4,3 k", "4,3 mille"],
    ["54321", "54 k", "54 mille"],
    ["654321", "654 k", "654 mille"],
    ["7654321", "7,7 M", "7,7 millions"],
    ["87654321", "88 M", "88 millions"],
    ["987654321", "988 M", "988 millions"],
    ["1087654321", "1,1 Md", "1,1 milliard"],
    ["11987654321", "12 Md", "12 milliards"],
    ["129987654321", "130 Md", "130 milliards"],
    ["1398987654321", "1,4 Bn", "1,4 billion"],
    ["14987987654321", "15 Bn", "15 billions"],
    ["159876987654321", "160 Bn", "160 billions"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "10 k", "10 mille"],
    ["99999", "100 k", "100 mille"],
    ["99999", "100 k", "100 mille"],
    ["999999", "1 M", "1 million"],
    ["9999999", "10 M", "10 millions"],
    ["99999999", "100 M", "100 millions"],
    ["9994", "10 k", "10 mille"],
    ["99944", "100 k", "100 mille"],
    ["999444", "999 k", "999 mille"],
    ["9994444", "10 M", "10 millions"],
    ["999444444", "999 M", "999 millions"],
    ["9994444444", "10 Md", "10 milliards"],
  ],
  "it_CH": [
    ["1", "1", "1"],
    ["21", "21", "21"],
    ["321", "321", "321"],
    ["4321", "4321", "4.3 mila"],
    ["54321", "54’321", "54 mila"],
    ["654321", "654’321", "654 mila"],
    ["7654321", "7.7 Mln", "7.7 milioni"],
    ["87654321", "88 Mln", "88 milioni"],
    ["987654321", "988 Mln", "988 milioni"],
    ["1087654321", "1.1 Mrd", "1.1 miliardi"],
    ["11987654321", "12 Mrd", "12 miliardi"],
    ["129987654321", "130 Mrd", "130 miliardi"],
    ["1398987654321", "1.4 Bln", "1.4 mila miliardi"],
    ["14987987654321", "15 Bln", "15 mila miliardi"],
    ["159876987654321", "160 Bln", "160 mila miliardi"],
    ["9", "9", "9"],
    ["99", "99", "99"],
    ["999", "999", "999"],
    ["9999", "9999", "10 mila"],
    ["99999", "99’999", "100 mila"],
    ["99999", "99’999", "100 mila"],
    ["999999", "999’999", "1 milione"],
    ["9999999", "10 Mln", "10 milioni"],
    ["99999999", "100 Mln", "100 milioni"],
    ["9994", "9994", "10 mila"],
    ["99944", "99’944", "100 mila"],
    ["999444", "999’444", "999 mila"],
    ["9994444", "10 Mln", "10 milioni"],
    ["999444444", "999 Mln", "999 milioni"],
    ["9994444444", "10 Mrd", "10 miliardi"],
  ],
  "ps": [
    ["1", "۱", "۱"],
    ["21", "۲۱", "۲۱"],
    ["321", "۳۲۱", "۳۲۱"],
    ["4321", "۴٫۳K", "۴٫۳K"],
    ["54321", "۵۴K", "۵۴K"],
    ["654321", "۶۵۴K", "۶۵۴K"],
    ["7654321", "۷٫۷M", "۷٫۷M"],
    ["87654321", "۸۸M", "۸۸M"],
    ["987654321", "۹۸۸M", "۹۸۸M"],
    ["1087654321", "۱٫۱B", "۱٫۱G"],
    ["11987654321", "۱۲B", "۱۲G"],
    ["129987654321", "۱۳۰B", "۱۳۰G"],
    ["1398987654321", "۱٫۴T", "۱٫۴T"],
    ["14987987654321", "۱۵T", "۱۵T"],
    ["159876987654321", "۱۶۰T", "۱۶۰T"],
    ["9", "۹", "۹"],
    ["99", "۹۹", "۹۹"],
    ["999", "۹۹۹", "۹۹۹"],
    ["9999", "۱۰K", "۱۰K"],
    ["99999", "۱۰۰K", "۱۰۰K"],
    ["99999", "۱۰۰K", "۱۰۰K"],
    ["999999", "۱M", "۱M"],
    ["9999999", "۱۰M", "۱۰M"],
    ["99999999", "۱۰۰M", "۱۰۰M"],
    ["9994", "۱۰K", "۱۰K"],
    ["99944", "۱۰۰K", "۱۰۰K"],
    ["999444", "۹۹۹K", "۹۹۹K"],
    ["9994444", "۱۰M", "۱۰M"],
    ["999444444", "۹۹۹M", "۹۹۹M"],
    ["9994444444", "۱۰B", "۱۰G"],
  ],
};
