/*
 * Decompiled with CFR 0.152.
 */
package io.flutter;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import io.flutter.embedding.engine.loader.FlutterLoader;

public final class FlutterInjector {
    private static FlutterInjector instance;
    private static boolean accessed;
    private boolean shouldLoadNative;
    private FlutterLoader flutterLoader;

    @VisibleForTesting
    public static void setInstance(@NonNull FlutterInjector injector) {
        if (accessed) {
            throw new IllegalStateException("Cannot change the FlutterInjector instance once it's been read. If you're trying to dependency inject, be sure to do so at the beginning of the program");
        }
        instance = injector;
    }

    public static FlutterInjector instance() {
        accessed = true;
        if (instance == null) {
            instance = new Builder().build();
        }
        return instance;
    }

    @VisibleForTesting
    public static void reset() {
        accessed = false;
        instance = null;
    }

    private FlutterInjector(boolean shouldLoadNative, @NonNull FlutterLoader flutterLoader) {
        this.shouldLoadNative = shouldLoadNative;
        this.flutterLoader = flutterLoader;
    }

    public boolean shouldLoadNative() {
        return this.shouldLoadNative;
    }

    @NonNull
    public FlutterLoader flutterLoader() {
        return this.flutterLoader;
    }

    public static final class Builder {
        private boolean shouldLoadNative = true;
        private FlutterLoader flutterLoader;

        public Builder setShouldLoadNative(boolean shouldLoadNative) {
            this.shouldLoadNative = shouldLoadNative;
            return this;
        }

        public Builder setFlutterLoader(@NonNull FlutterLoader flutterLoader) {
            this.flutterLoader = flutterLoader;
            return this;
        }

        private void fillDefaults() {
            if (this.flutterLoader == null) {
                this.flutterLoader = new FlutterLoader();
            }
        }

        public FlutterInjector build() {
            this.fillDefaults();
            System.out.println("should load native is " + this.shouldLoadNative);
            return new FlutterInjector(this.shouldLoadNative, this.flutterLoader);
        }
    }
}

