/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.wizards;

import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.rcp.wizards.RcpWizardPage;
import org.eclipse.wb.internal.xwt.Activator;

public abstract class XwtWizardPage
extends RcpWizardPage {
    private IFile m_javaFile;
    private IFile m_xwtFile;

    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        String templatePath = this.getTemplatePath_Java();
        InputStream template = Activator.getFile(templatePath);
        this.fillTypeFromTemplate(newType, imports, monitor, template);
        this.m_javaFile = (IFile)newType.getUnderlyingResource();
    }

    protected void createXWT() throws Exception {
        IType newType = this.getCreatedType();
        String templatePath = this.getTemplatePath_XWT();
        InputStream templateStream = Activator.getFile(templatePath);
        String template = IOUtils2.readString((InputStream)templateStream);
        String qualifiedTypeName = newType.getFullyQualifiedName();
        String content = StringUtils.replace((String)template, (String)"%TypeName%", (String)qualifiedTypeName);
        IFolder folder = (IFolder)this.getPackageFragment().getUnderlyingResource();
        this.m_xwtFile = folder.getFile(String.valueOf(newType.getElementName()) + ".xwt");
        IOUtils2.setFileContents((IFile)this.m_xwtFile, (String)content);
    }

    protected abstract String getTemplatePath_Java();

    protected abstract String getTemplatePath_XWT();

    public IFile getFileJava() {
        return this.m_javaFile;
    }

    public IFile getFileXWT() {
        return this.m_xwtFile;
    }
}

