/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.gef.policy.layout;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.figure.TextFeedback;
import org.eclipse.wb.core.gef.policy.PolicyUtils;
import org.eclipse.wb.core.model.IObjectInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.draw2d.RectangleFigure;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Translatable;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.handles.MoveHandle;
import org.eclipse.wb.gef.graphical.handles.ResizeHandle;
import org.eclipse.wb.gef.graphical.policies.SelectionEditPolicy;
import org.eclipse.wb.gef.graphical.tools.ResizeTracker;
import org.eclipse.wb.internal.swt.model.layout.IRowDataInfo;
import org.eclipse.wb.internal.swt.model.layout.IRowLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public final class RowLayoutSelectionEditPolicy<C extends IControlInfo>
extends SelectionEditPolicy {
    private static final String REQ_RESIZE = "resize";
    private final IRowLayoutInfo<C> m_layout;
    private final C m_control;
    private Figure m_resizeFeedback;
    private TextFeedback m_textFeedback;

    public RowLayoutSelectionEditPolicy(IRowLayoutInfo<C> layout, C control) {
        this.m_layout = layout;
        this.m_control = control;
    }

    protected List<Handle> createSelectionHandles() {
        ArrayList handles = Lists.newArrayList();
        handles.add(new MoveHandle(this.getHost()));
        handles.add(this.createHandle(16));
        handles.add(this.createHandle(4));
        handles.add(this.createHandle(20));
        return handles;
    }

    private Handle createHandle(int direction) {
        ResizeHandle handle = new ResizeHandle(this.getHost(), direction);
        handle.setDragTrackerTool((Tool)new ResizeTracker(direction, (Object)REQ_RESIZE));
        return handle;
    }

    public boolean understandsRequest(Request request) {
        return super.understandsRequest(request) || request.getType() == REQ_RESIZE;
    }

    public Command getCommand(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            return this.getResizeCommand((ChangeBoundsRequest)request);
        }
        return null;
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            this.showResizeFeedback((ChangeBoundsRequest)request);
        }
    }

    public void eraseSourceFeedback(Request request) {
        if (request instanceof ChangeBoundsRequest) {
            this.eraseResizeFeedback((ChangeBoundsRequest)request);
        }
    }

    private Command getResizeCommand(ChangeBoundsRequest request) {
        final int resizeDirection = request.getResizeDirection();
        final Rectangle newBounds = request.getTransformedRectangle(this.getHost().getFigure().getBounds());
        return new EditCommand((IObjectInfo)this.m_control){

            protected void executeEdit() throws Exception {
                IRowDataInfo rowData = RowLayoutSelectionEditPolicy.this.m_layout.getRowData2(RowLayoutSelectionEditPolicy.this.m_control);
                if (PolicyUtils.hasDirection((int)resizeDirection, (int)16)) {
                    rowData.setWidth(newBounds.width);
                }
                if (PolicyUtils.hasDirection((int)resizeDirection, (int)4)) {
                    rowData.setHeight(newBounds.height);
                }
            }
        };
    }

    private void showResizeFeedback(ChangeBoundsRequest request) {
        if (this.m_resizeFeedback == null) {
            this.m_resizeFeedback = new RectangleFigure();
            this.m_resizeFeedback.setForeground(IColorConstants.red);
            this.addFeedback(this.m_resizeFeedback);
            this.m_textFeedback = new TextFeedback(this.getFeedbackLayer());
            this.m_textFeedback.add();
        }
        Figure hostFigure = this.getHostFigure();
        Rectangle bounds = request.getTransformedRectangle(hostFigure.getBounds());
        FigureUtils.translateFigureToAbsolute((Figure)hostFigure, (Translatable)bounds);
        this.m_resizeFeedback.setBounds(bounds);
        this.m_textFeedback.setText(String.valueOf(bounds.width) + " x " + bounds.height);
        this.m_textFeedback.setLocation(request.getLocation().getTranslated(10, 10));
    }

    private void eraseResizeFeedback(ChangeBoundsRequest request) {
        this.removeFeedback(this.m_resizeFeedback);
        this.m_resizeFeedback = null;
        this.m_textFeedback.remove();
        this.m_textFeedback = null;
    }
}

