"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = void 0;
function create() {
    return {
        name: 'vue-autoinsert-space',
        create(context) {
            return {
                async provideAutoInsertionEdit(document, selection, change) {
                    if (document.languageId === 'html' || document.languageId === 'jade') {
                        const enabled = await context.env.getConfiguration?.('vue.autoInsert.bracketSpacing') ?? true;
                        if (!enabled) {
                            return;
                        }
                        if (change.text === '{}'
                            && document.getText().substring(change.rangeOffset - 1, change.rangeOffset + 3) === '{{}}'
                            && document.offsetAt(selection) === change.rangeOffset + 1) {
                            return ` $0 `;
                        }
                    }
                },
            };
        },
    };
}
exports.create = create;
//# sourceMappingURL=vue-autoinsert-space.js.map