/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.oniguruma;

import java.util.Arrays;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.oniguruma.OnigCaptureIndex;
import org.eclipse.tm4e.core.internal.oniguruma.OnigResult;
import org.eclipse.tm4e.core.internal.oniguruma.OnigString;

public final class OnigNextMatchResult {
    private final int index;
    private final OnigCaptureIndex[] captureIndices;

    OnigNextMatchResult(OnigResult result, OnigString source) {
        this.index = result.getIndex();
        this.captureIndices = this.captureIndicesOfMatch(result, source);
    }

    private OnigCaptureIndex[] captureIndicesOfMatch(OnigResult result, OnigString source) {
        int resultCount = result.count();
        OnigCaptureIndex[] captures = new OnigCaptureIndex[resultCount];
        int i = 0;
        while (i < resultCount) {
            int loc = result.locationAt(i);
            int captureStart = source.getCharIndexOfByte(loc);
            int captureEnd = source.getCharIndexOfByte(loc + result.lengthAt(i));
            captures[i] = new OnigCaptureIndex(i, captureStart, captureEnd);
            ++i;
        }
        return captures;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OnigNextMatchResult other = (OnigNextMatchResult)obj;
        return this.index == other.index && Arrays.equals(this.captureIndices, other.captureIndices);
    }

    public OnigCaptureIndex[] getCaptureIndices() {
        return this.captureIndices;
    }

    public int getIndex() {
        return this.index;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.index;
        result = 31 * result + Arrays.hashCode(this.captureIndices);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("{\n");
        result.append("  \"index\": ");
        result.append(this.getIndex());
        result.append(",\n");
        result.append("  \"captureIndices\": [\n");
        int i = 0;
        OnigCaptureIndex[] onigCaptureIndexArray = this.getCaptureIndices();
        int n = onigCaptureIndexArray.length;
        int n2 = 0;
        while (n2 < n) {
            OnigCaptureIndex captureIndex = onigCaptureIndexArray[n2];
            if (i > 0) {
                result.append(",\n");
            }
            result.append("    ");
            result.append(captureIndex);
            ++i;
            ++n2;
        }
        result.append("\n");
        result.append("  ]\n");
        result.append("}");
        return result.toString();
    }
}

