import { TextDocument, Position, Range } from 'vscode-languageserver-types';
export interface HTMLFormatConfiguration {
    tabSize?: number;
    insertSpaces?: boolean;
    wrapLineLength?: number;
    unformatted?: string;
    contentUnformatted?: string;
    indentInnerHtml?: boolean;
    wrapAttributes?: 'auto' | 'force' | 'force-aligned' | 'force-expand-multiline' | 'aligned-multiple' | 'preserve' | 'preserve-aligned';
    wrapAttributesIndentSize?: number;
    preserveNewLines?: boolean;
    maxPreserveNewLines?: number;
    indentHandlebars?: boolean;
    endWithNewline?: boolean;
    extraLiners?: string;
}
export interface CompletionConfiguration {
    [provider: string]: boolean | undefined;
    hideAutoCompleteProposals?: boolean;
}
export interface Node {
    tag: string | undefined;
    start: number;
    startTagEnd: number | undefined;
    end: number;
    endTagStart: number | undefined;
    children: Node[];
    parent?: Node;
    attributes?: {
        [name: string]: string | null;
    } | undefined;
}
export declare enum TokenType {
    StartCommentTag = 0,
    Comment = 1,
    EndCommentTag = 2,
    StartTagOpen = 3,
    StartTagClose = 4,
    StartTagSelfClose = 5,
    StartTag = 6,
    EndTagOpen = 7,
    EndTagClose = 8,
    EndTag = 9,
    DelimiterAssign = 10,
    AttributeName = 11,
    AttributeValue = 12,
    StartDoctypeTag = 13,
    Doctype = 14,
    EndDoctypeTag = 15,
    Content = 16,
    Whitespace = 17,
    Unknown = 18,
    Script = 19,
    Styles = 20,
    EOS = 21
}
export declare enum ScannerState {
    WithinContent = 0,
    AfterOpeningStartTag = 1,
    AfterOpeningEndTag = 2,
    WithinDoctype = 3,
    WithinTag = 4,
    WithinEndTag = 5,
    WithinComment = 6,
    WithinScriptContent = 7,
    WithinStyleContent = 8,
    AfterAttributeName = 9,
    BeforeAttributeValue = 10
}
export interface Scanner {
    scan(): TokenType;
    getTokenType(): TokenType;
    getTokenOffset(): number;
    getTokenLength(): number;
    getTokenEnd(): number;
    getTokenText(): string;
    getTokenError(): string | undefined;
    getScannerState(): ScannerState;
}
export declare type HTMLDocument = {
    roots: Node[];
    findNodeBefore(offset: number): Node;
    findNodeAt(offset: number): Node;
};
export interface DocumentContext {
    resolveReference(ref: string, base?: string): string;
}
export interface HtmlAttributeValueContext {
    document: TextDocument;
    position: Position;
    tag: string;
    attribute: string;
    value: string;
    range: Range;
}
export interface HtmlContentContext {
    document: TextDocument;
    position: Position;
}
export interface ICompletionParticipant {
    onHtmlAttributeValue?: (context: HtmlAttributeValueContext) => void;
    onHtmlContent?: (context: HtmlContentContext) => void;
}
export interface ITagData {
    name: string;
    description?: string;
    attributes: IAttributeData[];
}
export interface IAttributeData {
    name: string;
    description?: string;
    valueSet?: string;
    values?: IValueData[];
}
export interface IValueData {
    name: string;
    description?: string;
}
export interface IValueSet {
    name: string;
    values: IValueData[];
}
export interface HTMLDataV1 {
    version: 1;
    tags?: ITagData[];
    globalAttributes?: IAttributeData[];
    valueSets?: IValueSet[];
}
export interface IHTMLDataProvider {
    getId(): string;
    isApplicable(languageId: string): boolean;
    provideTags(): ITagData[];
    provideAttributes(tag: string): IAttributeData[];
    provideValues(tag: string, attribute: string): IValueData[];
}
