/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.widgets;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tm4e.languageconfiguration.ILanguageConfiguration;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationMessages;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.supports.Comments;
import org.eclipse.tm4e.languageconfiguration.internal.supports.Folding;
import org.eclipse.tm4e.languageconfiguration.internal.widgets.AutoClosingPairConditionalTableWidget;
import org.eclipse.tm4e.languageconfiguration.internal.widgets.CharacterPairsTableWidget;
import org.eclipse.tm4e.languageconfiguration.internal.widgets.OnEnterRuleTableWidget;

public class LanguageConfigurationInfoWidget
extends Composite {
    protected TabItem commentsTab;
    private Text lineCommentText;
    private Text blockCommentStartText;
    private Text blockCommentEndText;
    protected TabItem bracketsTab;
    private CharacterPairsTableWidget bracketsTable;
    protected TabItem autoClosingPairsTab;
    private AutoClosingPairConditionalTableWidget autoClosingPairsTable;
    protected TabItem surroundingPairsTab;
    private CharacterPairsTableWidget surroundingPairsTable;
    protected TabItem foldingTab;
    private Text offsideText;
    private Text markersStartText;
    private Text markersEndText;
    protected TabItem wordPatternTab;
    private Text wordPatternText;
    protected TabItem onEnterRulesTab;
    private OnEnterRuleTableWidget onEnterRuleTable;

    public LanguageConfigurationInfoWidget(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        super.setLayout((Layout)layout);
        super.setLayoutData((Object)new GridData(1808));
        this.createUI(this);
    }

    private void createUI(Composite ancestor) {
        TabFolder folder = new TabFolder(ancestor, 0);
        GridData gd = new GridData(768);
        folder.setLayoutData((Object)gd);
        this.createCommentsTab(folder);
        this.createBracketsTab(folder);
        this.createAutoClosingPairsTab(folder);
        this.createSurroundingPairsTab(folder);
        this.createFoldingTab(folder);
        this.createWordPatternTab(folder);
        this.createOnEnterRulesTab(folder);
    }

    public void refresh(ILanguageConfiguration configuration) {
        String wordPattern;
        this.lineCommentText.setText("");
        this.blockCommentStartText.setText("");
        this.blockCommentEndText.setText("");
        this.bracketsTable.setInput(null);
        this.autoClosingPairsTable.setInput(null);
        this.surroundingPairsTable.setInput(null);
        this.offsideText.setText("");
        this.markersStartText.setText("");
        this.markersEndText.setText("");
        this.wordPatternText.setText("");
        this.onEnterRuleTable.setInput(null);
        if (configuration == null) {
            return;
        }
        Comments comments = configuration.getComments();
        if (comments != null) {
            this.lineCommentText.setText(comments.getLineComment() == null ? "" : comments.getLineComment());
            CharacterPair blockComment = comments.getBlockComment();
            if (blockComment != null) {
                this.blockCommentStartText.setText((String)comments.getBlockComment().getKey());
                this.blockCommentEndText.setText((String)comments.getBlockComment().getValue());
            }
        }
        this.bracketsTable.setInput(this.removeNullElements(configuration.getBrackets()));
        this.autoClosingPairsTable.setInput(this.removeNullElements(configuration.getAutoClosingPairs()));
        this.surroundingPairsTable.setInput(this.removeNullElements(configuration.getSurroundingPairs()));
        Folding folding = configuration.getFolding();
        if (folding != null) {
            this.offsideText.setText(folding.getOffSide().toString());
            this.markersStartText.setText(folding.getMarkersStart());
            this.markersEndText.setText(folding.getMarkersEnd());
        }
        if ((wordPattern = configuration.getWordPattern()) != null) {
            this.wordPatternText.setText(wordPattern);
        }
        this.onEnterRuleTable.setInput(this.removeNullElements(configuration.getOnEnterRules()));
    }

    private List<?> removeNullElements(List<?> list) {
        if (list == null) {
            return null;
        }
        return list.stream().filter(el -> el != null).collect(Collectors.toList());
    }

    protected void createCommentsTab(TabFolder folder) {
        this.commentsTab = this.createTab(folder, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_comments);
        Composite parent = (Composite)this.commentsTab.getControl();
        this.lineCommentText = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_lineComments);
        this.blockCommentStartText = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_blockCommentsStart);
        this.blockCommentEndText = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_blockCommentsEnd);
    }

    protected void createBracketsTab(TabFolder folder) {
        this.bracketsTab = this.createTab(folder, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_brackets);
        this.bracketsTable = new CharacterPairsTableWidget(this.createTable((Composite)this.bracketsTab.getControl()));
    }

    protected void createAutoClosingPairsTab(TabFolder folder) {
        this.autoClosingPairsTab = this.createTab(folder, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_autoClosingPairs);
        this.autoClosingPairsTable = new AutoClosingPairConditionalTableWidget(this.createTable((Composite)this.autoClosingPairsTab.getControl()));
    }

    protected void createSurroundingPairsTab(TabFolder folder) {
        this.surroundingPairsTab = this.createTab(folder, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_surroundingPairs);
        this.surroundingPairsTable = new CharacterPairsTableWidget(this.createTable((Composite)this.surroundingPairsTab.getControl()));
    }

    protected void createFoldingTab(TabFolder folder) {
        this.foldingTab = this.createTab(folder, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_folding_title);
        Composite parent = (Composite)this.foldingTab.getControl();
        this.offsideText = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_offSide);
        this.offsideText.setToolTipText(LanguageConfigurationMessages.LanguageConfigurationInfoWidget_offSide_tooltip);
        new Label(parent, 0).setText(LanguageConfigurationMessages.LanguageConfigurationInfoWidget_markers);
        this.markersStartText = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_start);
        this.markersEndText = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_end);
    }

    protected void createWordPatternTab(TabFolder folder) {
        this.wordPatternTab = this.createTab(folder, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_wordPattern_title);
        Composite parent = (Composite)this.wordPatternTab.getControl();
        this.wordPatternText = this.createText(parent, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_wordPattern_message);
    }

    protected void createOnEnterRulesTab(TabFolder folder) {
        this.onEnterRulesTab = this.createTab(folder, LanguageConfigurationMessages.LanguageConfigurationInfoWidget_onEnterRules);
        this.onEnterRuleTable = new OnEnterRuleTableWidget(this.createTable((Composite)this.onEnterRulesTab.getControl()));
    }

    private Table createTable(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayoutData((Object)new GridData(1808));
        tableComposite.setLayout((Layout)new TableColumnLayout());
        Table table = new Table(tableComposite, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        return table;
    }

    private TabItem createTab(TabFolder folder, String title) {
        TabItem tab = new TabItem(folder, 0);
        tab.setText(title);
        Composite parent = new Composite((Composite)folder, 0);
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        tab.setControl((Control)parent);
        return tab;
    }

    protected Text createText(Composite parent, String s) {
        Label label = new Label(parent, 0);
        label.setText(s);
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        text.setEditable(false);
        return text;
    }
}

