/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.widgets;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.ui.text.TMPresentationReconciler;
import org.eclipse.tm4e.ui.themes.ITheme;

public class TMViewer
extends SourceViewer {
    private TMPresentationReconciler reconciler;

    public TMViewer(Composite parent, IVerticalRuler ruler, int styles) {
        super(parent, ruler, styles);
        this.init();
    }

    public TMViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.init();
    }

    private void init() {
        this.reconciler = new TMPresentationReconciler();
        TMSourceViewerConfiguration configuration = new TMSourceViewerConfiguration();
        this.configure(configuration);
    }

    public void setGrammar(IGrammar grammar) {
        this.reconciler.setGrammar(grammar);
        if (this.getDocument() == null) {
            super.setDocument((IDocument)new Document());
        }
    }

    public void setTheme(ITheme theme) {
        this.reconciler.setTheme(theme);
        StyledText styledText = this.getTextWidget();
        styledText.setForeground(null);
        styledText.setBackground(null);
        theme.initializeViewerColors(styledText);
        this.getTextWidget().setFont(JFaceResources.getTextFont());
    }

    public void setText(String text) {
        if (this.getDocument() == null) {
            super.setDocument((IDocument)new Document());
        }
        this.getDocument().set(text);
    }

    private class TMSourceViewerConfiguration
    extends SourceViewerConfiguration {
        private TMSourceViewerConfiguration() {
        }

        public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
            return TMViewer.this.reconciler;
        }
    }
}

