/**
 * **IMPORTANT** this module should not depend on `vscode-languageserver` only protocol and types
 */
import * as lsp from 'vscode-languageserver-protocol';
import { FormatCodeSettings, UserPreferences } from 'typescript/lib/protocol';
import { InlayHintsOptions } from './lsp-protocol.inlayHints.proposed';
export declare namespace TypeScriptRenameRequest {
    const type: lsp.RequestType<lsp.TextDocumentPositionParams, void, void>;
}
export interface TypeScriptPlugin {
    name: string;
    location: string;
}
export interface TypeScriptInitializationOptions {
    logVerbosity?: string;
    maxTsServerMemory?: number;
    plugins: TypeScriptPlugin[];
    preferences?: UserPreferences;
    hostInfo?: string;
}
export declare type TypeScriptInitializeParams = lsp.InitializeParams & {
    initializationOptions?: Partial<TypeScriptInitializationOptions>;
};
export interface TypeScriptInitializeResult extends lsp.InitializeResult {
    logFileUri?: string;
}
export interface TypeScriptWorkspaceSettingsLanguageSettings {
    format?: FormatCodeSettings;
    inlayHints?: InlayHintsOptions;
}
export interface TypeScriptWorkspaceSettings {
    javascript?: TypeScriptWorkspaceSettingsLanguageSettings;
    typescript?: TypeScriptWorkspaceSettingsLanguageSettings;
}
//# sourceMappingURL=ts-protocol.d.ts.map