/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactStorage;
import org.eclipse.virgo.kernel.install.artifact.GraphAssociableInstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.kernel.install.artifact.internal.ArtifactStateMonitor;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.nano.core.AbortableSignal;
import org.eclipse.virgo.nano.core.Signal;
import org.eclipse.virgo.nano.deployer.api.core.DeployerLogEvents;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.serviceability.NonNull;
import org.eclipse.virgo.util.common.GraphNode;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInstallArtifact
implements GraphAssociableInstallArtifact {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Object monitor = new Object();
    private final ArtifactIdentity identity;
    protected final ArtifactStorage artifactStorage;
    private final Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private final Map<String, String> deploymentProperties = new ConcurrentHashMap<String, String>();
    private final ArtifactStateMonitor artifactStateMonitor;
    private final String repositoryName;
    protected final EventLogger eventLogger;
    private GraphNode<InstallArtifact> graph;
    private volatile boolean isRefreshing;
    private boolean isTopLevelDeployed = false;
    private boolean isTopLevelActive = false;

    protected AbstractInstallArtifact(@NonNull ArtifactIdentity identity, @NonNull ArtifactStorage artifactStorage, @NonNull ArtifactStateMonitor artifactStateMonitor, String repositoryName, EventLogger eventLogger) {
        this.identity = identity;
        this.artifactStorage = artifactStorage;
        this.artifactStateMonitor = artifactStateMonitor;
        this.repositoryName = repositoryName;
        this.eventLogger = eventLogger;
        this.isRefreshing = false;
    }

    final ArtifactIdentity getIdentity() {
        return this.identity;
    }

    public final boolean isRefreshing() {
        return this.isRefreshing;
    }

    public void beginInstall() throws DeploymentException {
        try {
            this.artifactStateMonitor.onInstalling(this);
        }
        catch (DeploymentException de) {
            this.failInstall();
            throw de;
        }
    }

    public void failInstall() throws DeploymentException {
        this.artifactStateMonitor.onInstallFailed(this);
    }

    public void endInstall() throws DeploymentException {
        this.artifactStateMonitor.onInstalled(this);
    }

    public void beginResolve() throws DeploymentException {
        this.pushThreadContext();
        try {
            this.artifactStateMonitor.onResolving(this);
        }
        finally {
            this.popThreadContext();
        }
    }

    public void failResolve() throws DeploymentException {
        this.pushThreadContext();
        try {
            this.artifactStateMonitor.onResolveFailed(this);
        }
        finally {
            this.popThreadContext();
        }
    }

    public void endResolve() throws DeploymentException {
        this.pushThreadContext();
        try {
            this.artifactStateMonitor.onResolved(this);
        }
        finally {
            this.popThreadContext();
        }
    }

    @Override
    public final String getType() {
        return this.identity.getType();
    }

    @Override
    public final String getName() {
        return this.identity.getName();
    }

    @Override
    public final Version getVersion() {
        return this.identity.getVersion();
    }

    @Override
    public final String getScopeName() {
        return this.identity.getScopeName();
    }

    @Override
    public InstallArtifact.State getState() {
        return this.artifactStateMonitor.getState();
    }

    @Override
    public void start() throws DeploymentException {
        this.start(null);
    }

    @Override
    public void start(AbortableSignal signal) throws DeploymentException {
        if (this.getState().equals((Object)InstallArtifact.State.ACTIVE)) {
            if (signal != null) {
                signal.signalSuccessfulCompletion();
            }
        } else {
            if (!this.hasStartingParent()) {
                this.topLevelStart();
            }
            this.pushThreadContext();
            try {
                boolean stateChanged = this.artifactStateMonitor.onStarting(this);
                if (stateChanged || signal != null) {
                    this.driveDoStart(signal);
                }
            }
            finally {
                this.popThreadContext();
            }
        }
    }

    protected final void driveDoStart(AbortableSignal signal) throws DeploymentException {
        AbortableSignal stateMonitorSignal = this.createStateMonitorSignal(signal);
        this.doStart(stateMonitorSignal);
    }

    protected final AbortableSignal createStateMonitorSignal(AbortableSignal signal) {
        return new StateMonitorSignal(signal);
    }

    protected static void signalSuccessfulCompletion(Signal signal) {
        if (signal != null) {
            signal.signalSuccessfulCompletion();
        }
    }

    protected static void signalFailure(Signal signal, Throwable e) {
        if (signal != null) {
            signal.signalFailure(e);
        }
    }

    protected static void signalAbortion(AbortableSignal signal) {
        if (signal != null) {
            signal.signalAborted();
        }
    }

    protected abstract void doStart(AbortableSignal var1) throws DeploymentException;

    private final void asyncStartSucceeded() throws DeploymentException {
        this.pushThreadContext();
        try {
            this.artifactStateMonitor.onStarted(this);
        }
        finally {
            this.popThreadContext();
        }
    }

    private final void asyncStartFailed(Throwable cause) {
        this.topLevelStop();
        this.pushThreadContext();
        try {
            try {
                this.artifactStateMonitor.onStartFailed(this, cause);
            }
            catch (DeploymentException e) {
                this.logger.error(String.format("listener for %s threw DeploymentException", this), (Throwable)e);
                this.popThreadContext();
            }
        }
        finally {
            this.popThreadContext();
        }
    }

    private final void asyncStartAborted() {
        this.topLevelStop();
        this.pushThreadContext();
        try {
            try {
                this.artifactStateMonitor.onStartAborted(this);
            }
            catch (DeploymentException e) {
                this.logger.error(String.format("listener for %s threw DeploymentException", this), (Throwable)e);
                this.popThreadContext();
            }
        }
        finally {
            this.popThreadContext();
        }
    }

    @Override
    public void stop() throws DeploymentException {
        if ((this.getState().equals((Object)InstallArtifact.State.ACTIVE) || this.getState().equals((Object)InstallArtifact.State.STARTING)) && this.shouldStop()) {
            this.pushThreadContext();
            try {
                this.artifactStateMonitor.onStopping(this);
                try {
                    this.doStop();
                    this.artifactStateMonitor.onStopped(this);
                }
                catch (DeploymentException e) {
                    this.artifactStateMonitor.onStopFailed(this, e);
                }
            }
            finally {
                this.popThreadContext();
            }
        }
    }

    protected boolean shouldStop() {
        boolean explicitStop = this.explicitStop();
        if (explicitStop) {
            this.topLevelStop();
        }
        return explicitStop || !this.hasActiveParent();
    }

    public boolean explicitStop() {
        return !this.hasStoppingParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasActiveParent() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.isTopLevelDeployed && this.isTopLevelActive) {
                return true;
            }
        }
        for (GraphNode parent : this.graph.getParents()) {
            InstallArtifact.State parentState = ((InstallArtifact)parent.getValue()).getState();
            if (!parentState.equals((Object)InstallArtifact.State.ACTIVE) && !parentState.equals((Object)InstallArtifact.State.STARTING)) continue;
            return true;
        }
        return false;
    }

    private boolean hasStoppingParent() {
        return this.hasParentInState(InstallArtifact.State.STOPPING);
    }

    private boolean hasParentInState(InstallArtifact.State state) {
        for (GraphNode parent : this.graph.getParents()) {
            InstallArtifact.State parentState = ((InstallArtifact)parent.getValue()).getState();
            if (!parentState.equals((Object)state)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void topLevelStop() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.isTopLevelDeployed) {
                this.isTopLevelActive = false;
            }
        }
    }

    protected boolean hasStartingParent() {
        for (GraphNode parent : this.graph.getParents()) {
            InstallArtifact.State parentState = ((InstallArtifact)parent.getValue()).getState();
            if (!parentState.equals((Object)InstallArtifact.State.STARTING)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void topLevelStart() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.isTopLevelDeployed) {
                this.isTopLevelActive = true;
            }
        }
    }

    protected abstract void doStop() throws DeploymentException;

    @Override
    public void uninstall() throws DeploymentException {
        block11: {
            if (this.getState().equals((Object)InstallArtifact.State.STARTING) || this.getState().equals((Object)InstallArtifact.State.ACTIVE) || this.getState().equals((Object)InstallArtifact.State.RESOLVED) || this.getState().equals((Object)InstallArtifact.State.INSTALLED) || this.getState().equals((Object)InstallArtifact.State.INITIAL)) {
                try {
                    if (this.getState().equals((Object)InstallArtifact.State.INITIAL)) break block11;
                    this.pushThreadContext();
                    try {
                        if (this.getState().equals((Object)InstallArtifact.State.ACTIVE) || this.getState().equals((Object)InstallArtifact.State.STARTING)) {
                            this.stop();
                        }
                        if (this.shouldUninstall()) {
                            this.artifactStateMonitor.onUninstalling(this);
                            try {
                                this.doUninstall();
                                this.artifactStateMonitor.onUninstalled(this);
                            }
                            catch (DeploymentException e) {
                                this.artifactStateMonitor.onUninstallFailed(this, e);
                            }
                        }
                    }
                    finally {
                        this.popThreadContext();
                    }
                }
                finally {
                    this.artifactStorage.delete();
                }
            }
        }
    }

    private boolean shouldUninstall() {
        boolean explicitUninstall = this.explicitUninstall();
        if (explicitUninstall) {
            this.topLevelUninstall();
        }
        return this.allParentsInState(InstallArtifact.State.UNINSTALLING);
    }

    private boolean allParentsInState(InstallArtifact.State state) {
        for (GraphNode parent : this.graph.getParents()) {
            InstallArtifact.State parentState = ((InstallArtifact)parent.getValue()).getState();
            if (parentState.equals((Object)state)) continue;
            return false;
        }
        return true;
    }

    public boolean explicitUninstall() {
        return !this.hasUninstallingParent();
    }

    private boolean hasUninstallingParent() {
        return this.hasParentInState(InstallArtifact.State.UNINSTALLING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void topLevelUninstall() {
        Object object = this.monitor;
        synchronized (object) {
            this.isTopLevelDeployed = false;
        }
    }

    protected abstract void doUninstall() throws DeploymentException;

    @Override
    public final ArtifactFS getArtifactFS() {
        return this.artifactStorage.getArtifactFS();
    }

    public String toString() {
        return this.identity.toString();
    }

    public void pushThreadContext() {
    }

    public void popThreadContext() {
    }

    protected final ArtifactStateMonitor getStateMonitor() {
        return this.artifactStateMonitor;
    }

    @Override
    public boolean refresh() throws DeploymentException {
        try {
            this.isRefreshing = true;
            this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESHING, new Object[]{this.getType(), this.getName(), this.getVersion()});
            this.artifactStorage.synchronize();
            boolean refreshed = this.doRefresh();
            if (refreshed) {
                this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESHED, new Object[]{this.getType(), this.getName(), this.getVersion()});
            } else {
                this.failRefresh();
            }
            boolean bl = refreshed;
            return bl;
        }
        catch (DeploymentException de) {
            this.failRefresh((Exception)((Object)de));
            throw de;
        }
        catch (RuntimeException re) {
            this.failRefresh(re);
            throw re;
        }
        finally {
            this.isRefreshing = false;
        }
    }

    private void failRefresh() {
        this.failRefresh(null);
    }

    private void failRefresh(Exception ex) {
        this.artifactStorage.rollBack();
        this.issueFailedRefreshMessage(ex);
    }

    public void issueFailedRefreshMessage(Exception ex) {
        if (ex == null) {
            this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_FAILED, new Object[]{this.getType(), this.getName(), this.getVersion()});
        } else {
            this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESH_FAILED, (Throwable)ex, new Object[]{this.getType(), this.getName(), this.getVersion()});
        }
    }

    protected boolean doRefresh() throws DeploymentException {
        return false;
    }

    public boolean refresh(String symbolicName) throws DeploymentException {
        try {
            this.isRefreshing = true;
            this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESHING, new Object[]{this.getType(), this.getName(), this.getVersion()});
            boolean refreshed = this.doRefresh(symbolicName);
            if (refreshed) {
                this.eventLogger.log((LogEvent)DeployerLogEvents.REFRESHED, new Object[]{this.getType(), this.getName(), this.getVersion()});
            } else {
                this.issueFailedRefreshMessage(null);
            }
            boolean bl = refreshed;
            return bl;
        }
        catch (DeploymentException de) {
            this.issueFailedRefreshMessage((Exception)((Object)de));
            throw de;
        }
        catch (RuntimeException re) {
            this.issueFailedRefreshMessage(re);
            throw re;
        }
        finally {
            this.isRefreshing = false;
        }
    }

    protected boolean doRefresh(String symbolicName) throws DeploymentException {
        return false;
    }

    @Override
    public final String getProperty(@NonNull String name) {
        return this.properties.get(name);
    }

    @Override
    public final Set<String> getPropertyNames() {
        HashSet<String> propertyNames = new HashSet<String>(this.properties.keySet());
        return Collections.unmodifiableSet(propertyNames);
    }

    @Override
    public final String setProperty(String name, String value) {
        return this.properties.put(name, value);
    }

    public Map<String, String> getDeploymentProperties() {
        return this.deploymentProperties;
    }

    @Override
    public final String getRepositoryName() {
        return this.repositoryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGraph(GraphNode<InstallArtifact> graph) throws DeploymentException {
        Object object = this.monitor;
        synchronized (object) {
            this.graph = graph;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GraphNode<InstallArtifact> getGraph() {
        Object object = this.monitor;
        synchronized (object) {
            return this.graph;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTopLevelDeployed() {
        Object object = this.monitor;
        synchronized (object) {
            this.isTopLevelDeployed = true;
            this.isTopLevelActive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getTopLevelDeployed() {
        Object object = this.monitor;
        synchronized (object) {
            return this.isTopLevelDeployed;
        }
    }

    private final class StateMonitorSignal
    implements AbortableSignal {
        private final AbortableSignal signal;

        public StateMonitorSignal(AbortableSignal signal) {
            this.signal = signal;
        }

        public void signalSuccessfulCompletion() {
            try {
                AbstractInstallArtifact.this.asyncStartSucceeded();
                AbstractInstallArtifact.signalSuccessfulCompletion((Signal)this.signal);
            }
            catch (DeploymentException de) {
                this.signalFailure(de);
            }
        }

        public void signalFailure(Throwable cause) {
            AbstractInstallArtifact.this.asyncStartFailed(cause);
            try {
                AbstractInstallArtifact.this.stop();
            }
            catch (DeploymentException de) {
                AbstractInstallArtifact.this.logger.error("Stop failed", (Throwable)de);
            }
            AbstractInstallArtifact.signalFailure((Signal)this.signal, cause);
        }

        public void signalAborted() {
            AbstractInstallArtifact.this.asyncStartAborted();
            try {
                AbstractInstallArtifact.this.stop();
            }
            catch (DeploymentException de) {
                AbstractInstallArtifact.this.logger.error("Stop aborted", (Throwable)de);
            }
            AbstractInstallArtifact.signalAbortion(this.signal);
        }
    }
}

