/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.parsers.custom;

import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTraceDefinition;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtEvent;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTrace;
import org.eclipse.tracecompass.tmf.core.parsers.custom.CustomTxtTraceDefinition;
import org.eclipse.tracecompass.tmf.core.tests.parsers.custom.AbstractCustomTraceDataTest;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CustomTxtTraceDataTest
extends AbstractCustomTraceDataTest {
    private static final String TRACE_PATH = String.valueOf(TRACE_DIRECTORY) + File.separator + "test.txt";
    private static final String DEFINITION_PATH = "testfiles" + File.separator + "txt" + File.separator + "testTxtDefinition.xml";
    private static final AbstractCustomTraceDataTest.ICustomTestData CUSTOM_TXT = new AbstractCustomTraceDataTest.ICustomTestData(){
        private static final int NB_EVENTS = 10;
        private CustomTxtTraceDefinition fDefinition;
        private ITmfEventAspect<?> fTimestampAspect;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public ITmfTrace getTrace() throws IOException, TmfTraceException {
            this.fDefinition = CustomTxtTraceDataTest.getDefinition(0);
            File file = new File(TRACE_PATH);
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                int i = 0;
                while (i < 10) {
                    SimpleDateFormat f = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss:SSS");
                    String eventStr = String.valueOf(f.format(new Date(i))) + " hello world\n";
                    writer.write(eventStr);
                    int extra = i % 3;
                    int j = 0;
                    while (j < extra) {
                        writer.write("extra line\n");
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            CustomTxtTrace trace = new CustomTxtTrace(null, this.fDefinition, file.getPath(), 100);
            @NonNull ArrayList aspects = Lists.newArrayList((Iterable)trace.getEventAspects());
            this.fTimestampAspect = aspects.stream().filter(aspect -> aspect.getName().equals("Timestamp")).findFirst().get();
            return trace;
        }

        @Override
        public void validateEvent(ITmfEvent event) {
            Assert.assertTrue((boolean)(event instanceof CustomTxtEvent));
            String name = this.fDefinition.definitionName;
            Assert.assertEquals((String)"Event name", (Object)name, (Object)event.getName());
            Assert.assertEquals((String)"Event name and type", (Object)event.getType().getName(), (Object)event.getName());
            Assert.assertEquals((String)"Timestamp", (Object)Long.toString(event.getTimestamp().toNanos()), (Object)this.fTimestampAspect.resolve(event));
        }

        @Override
        public void validateEventCount(int eventCount) {
            Assert.assertEquals((String)"Event count", (long)10L, (long)eventCount);
        }
    };
    private static final AbstractCustomTraceDataTest.ICustomTestData CUSTOM_TXT_EVENT_NAME = new AbstractCustomTraceDataTest.ICustomTestData(){
        private static final int NB_EVENTS = 10;
        private static final String DEFAULT_EVENT = "DefaultName";
        private static final String ODD_EVENT = "OddName";
        private static final String EVEN_EVENT = "EvenName";
        private CustomTxtTraceDefinition fDefinition;
        private ITmfEventAspect<?> fTimestampAspect;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public ITmfTrace getTrace() throws IOException, TmfTraceException {
            this.fDefinition = CustomTxtTraceDataTest.getDefinition(1);
            File file = new File(TRACE_PATH);
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                int i = 1;
                while (i <= 10) {
                    String evName = i % 5 == 0 ? DEFAULT_EVENT : (i % 2 == 0 ? EVEN_EVENT : ODD_EVENT);
                    String eventStr = String.valueOf(i) + " " + evName + "\n";
                    writer.write(eventStr);
                    int extra = i % 3;
                    int j = 0;
                    while (j < extra) {
                        writer.write("extra line\n");
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            CustomTxtTrace trace = new CustomTxtTrace(null, this.fDefinition, file.getPath(), 100);
            @NonNull ArrayList aspects = Lists.newArrayList((Iterable)trace.getEventAspects());
            this.fTimestampAspect = aspects.stream().filter(aspect -> aspect.getName().equals("Timestamp")).findFirst().get();
            return trace;
        }

        @Override
        public void validateEvent(ITmfEvent event) {
            Assert.assertTrue((boolean)(event instanceof CustomTxtEvent));
            long ts = event.getTimestamp().getValue();
            if (ts % 5L == 0L) {
                Assert.assertEquals((String)"Event name", (Object)DEFAULT_EVENT, (Object)event.getName());
            } else if (ts % 2L == 0L) {
                Assert.assertEquals((String)"Event name", (Object)EVEN_EVENT, (Object)event.getName());
            } else {
                Assert.assertEquals((String)"Event name", (Object)ODD_EVENT, (Object)event.getName());
            }
            Assert.assertEquals((String)"Event name and type", (Object)event.getType().getName(), (Object)event.getName());
            Assert.assertEquals((String)"Timestamp", (Object)TmfBaseAspects.getTimestampAspect().resolve(event), (Object)this.fTimestampAspect.resolve(event));
        }

        @Override
        public void validateEventCount(int eventCount) {
            Assert.assertEquals((String)"Event count", (long)10L, (long)eventCount);
        }
    };
    private static final AbstractCustomTraceDataTest.ICustomTestData CUSTOM_TXT_EXTRA_FIELDS = new AbstractCustomTraceDataTest.ICustomTestData(){
        private static final int NB_EVENTS = 6;
        private static final String FOO = "foo";
        private static final String BAR = "bar";
        private static final String BAZ = "baz";
        private static final String MESSAGE = "message";
        private CustomTxtTraceDefinition fDefinition;

        @Override
        public ITmfTrace getTrace() throws IOException, TmfTraceException {
            this.fDefinition = CustomTxtTraceDataTest.getDefinition(2);
            File file = new File(TRACE_PATH);
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                String eventStr = String.format("1 %s %s=%s\n", MESSAGE, FOO, BAR);
                writer.write(eventStr);
                eventStr = String.format("2 %s %s=%s %s=%s\n", MESSAGE, FOO, BAR, BAR, FOO);
                writer.write(eventStr);
                eventStr = String.format("3 %s Message=%s\n", MESSAGE, FOO);
                writer.write(eventStr);
                eventStr = String.format("4 %s %s=%s %s=%s\n", MESSAGE, FOO, BAR, FOO, BAZ);
                writer.write(eventStr);
                eventStr = String.format("5 %s %s=%s %s=%s %s=%s\n", MESSAGE, FOO, BAR, FOO, BAZ, BAR, BAZ);
                writer.write(eventStr);
                eventStr = String.format("6 %s %s=%s other %s\n", MESSAGE, FOO, BAR, BAZ);
                writer.write(eventStr);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return new CustomTxtTrace(null, this.fDefinition, file.getPath(), 100);
        }

        @Override
        public void validateEvent(ITmfEvent event) {
            Assert.assertTrue((boolean)(event instanceof CustomTxtEvent));
            long ts = event.getTimestamp().getValue();
            switch ((int)ts) {
                case 1: {
                    Assert.assertNotNull((Object)event.getContent().getField(new String[]{FOO}));
                    Assert.assertEquals((Object)BAR, (Object)event.getContent().getField(new String[]{FOO}).getValue());
                    Assert.assertNull((Object)event.getContent().getField(new String[]{BAR}));
                    break;
                }
                case 2: {
                    Assert.assertNotNull((Object)event.getContent().getField(new String[]{FOO}));
                    Assert.assertEquals((Object)BAR, (Object)event.getContent().getField(new String[]{FOO}).getValue());
                    Assert.assertNotNull((Object)event.getContent().getField(new String[]{BAR}));
                    Assert.assertEquals((Object)FOO, (Object)event.getContent().getField(new String[]{BAR}).getValue());
                    break;
                }
                case 3: {
                    Assert.assertNotNull((Object)event.getContent().getField(new String[]{CustomTraceDefinition.Tag.MESSAGE.toString()}));
                    Assert.assertEquals((Object)MESSAGE, (Object)event.getContent().getField(new String[]{CustomTraceDefinition.Tag.MESSAGE.toString()}).getValue());
                    break;
                }
                case 4: {
                    Assert.assertNotNull((Object)event.getContent().getField(new String[]{FOO}));
                    Assert.assertEquals((Object)"bar | baz", (Object)event.getContent().getField(new String[]{FOO}).getValue());
                    Assert.assertNull((Object)event.getContent().getField(new String[]{BAR}));
                    break;
                }
                case 5: {
                    Assert.assertNotNull((Object)event.getContent().getField(new String[]{FOO}));
                    Assert.assertEquals((Object)BAZ, (Object)event.getContent().getField(new String[]{FOO}).getValue());
                    Assert.assertNotNull((Object)event.getContent().getField(new String[]{BAR}));
                    Assert.assertEquals((Object)BAZ, (Object)event.getContent().getField(new String[]{BAR}).getValue());
                    break;
                }
                case 6: {
                    Assert.assertNotNull((Object)event.getContent().getField(new String[]{FOO}));
                    Assert.assertEquals((Object)"bar | baz", (Object)event.getContent().getField(new String[]{FOO}).getValue());
                    Assert.assertNull((Object)event.getContent().getField(new String[]{BAR}));
                    break;
                }
                default: {
                    Assert.fail((String)("unknown timestamp " + ts));
                }
            }
            Assert.assertEquals((String)"Event name and type", (Object)event.getType().getName(), (Object)event.getName());
        }

        @Override
        public void validateEventCount(int eventCount) {
            Assert.assertEquals((String)"Event count", (long)6L, (long)eventCount);
        }
    };

    public CustomTxtTraceDataTest(String name, @NonNull AbstractCustomTraceDataTest.ICustomTestData data) {
        super(data);
    }

    private static CustomTxtTraceDefinition getDefinition(int index) {
        CustomTxtTraceDefinition[] definitions = CustomTxtTraceDefinition.loadAll((String)new File(DEFINITION_PATH).toString());
        return definitions[index];
    }

    @Parameterized.Parameters(name="{index}: {0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList({"Base parser", CUSTOM_TXT}, {"Parse with event name", CUSTOM_TXT_EVENT_NAME}, {"Parse with extra fields", CUSTOM_TXT_EXTRA_FIELDS});
    }
}

