/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.kernel.core.tests.perf.analysis.execgraph;

import java.io.File;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.lttng2.kernel.core.trace.LttngKernelTrace;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.tests.shared.TmfTestHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEvent;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.junit.Assert;
import org.junit.Test;

public class LttngTraceAnalysisBenchmark {
    public static final String TEST_ID = "org.eclipse.tracecompass.lttng2.kernel#Lttng trace Analysis test#";
    private static final String TEST_CPU = "CPU Usage (%s)";
    private static final String TEST_MEMORY = "Memory Usage (%s)";
    private static final int LOOP_COUNT = 5;
    private runMethod cpu = (pm, module) -> {
        pm.start();
        TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        pm.stop();
    };
    private runMethod memory = (pm, module) -> {
        System.gc();
        pm.start();
        TmfTestHelper.executeAnalysis((IAnalysisModule)module);
        System.gc();
        pm.stop();
    };

    @Test
    public void runAllBenchmarks() {
        File[] filesList;
        Supplier<IAnalysisModule> moduleSupplier = () -> new KernelAnalysisModule();
        String directoryPath = "null";
        File parentDirectory = new File(directoryPath);
        if (!parentDirectory.isDirectory() || parentDirectory.list() == null) {
            System.err.println(String.format("Trace directory not found !\nYou need to setup the directory path before running this benchmark. See the javadoc of this class.", new Object[0]));
            return;
        }
        File[] fileArray = filesList = parentDirectory.listFiles();
        int n = filesList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String path = String.valueOf(file.getAbsolutePath()) + "/kernel";
            CtfTmfTrace trace = new CtfTmfTrace();
            try {
                trace.initTrace(null, path, CtfTmfEvent.class);
            }
            catch (TmfTraceException e) {
                e.printStackTrace();
                break;
            }
            LttngTraceAnalysisBenchmark.runOneBenchmark(trace, String.format(TEST_CPU, trace.toString()), this.cpu, Dimension.CPU_TIME, moduleSupplier);
            LttngTraceAnalysisBenchmark.runOneBenchmark(trace, String.format(TEST_MEMORY, trace.toString()), this.memory, Dimension.USED_JAVA_HEAP, moduleSupplier);
            trace.dispose();
            ++n2;
        }
    }

    private static void runOneBenchmark(@NonNull CtfTmfTrace testTrace, String testName, runMethod method, Dimension dimension, Supplier<IAnalysisModule> moduleSupplier) {
        Performance perf = Performance.getDefault();
        PerformanceMeter pm = perf.createPerformanceMeter(TEST_ID + testName);
        perf.tagAsSummary(pm, "Trace Compass Analysis " + testName, dimension);
        int i = 0;
        while (i < 5) {
            block13: {
                LttngKernelTrace trace = null;
                IAnalysisModule module = null;
                String path = testTrace.getPath();
                try {
                    try {
                        trace = new LttngKernelTrace();
                        module = moduleSupplier.get();
                        module.setId("test");
                        trace.initTrace(null, path, CtfTmfEvent.class);
                        module.setTrace((ITmfTrace)trace);
                        method.execute(pm, module);
                        File suppDir = new File(TmfTraceManager.getSupplementaryFileDir((ITmfTrace)trace));
                        File[] fileArray = suppDir.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File file = fileArray[n2];
                            file.delete();
                            ++n2;
                        }
                    }
                    catch (TmfAnalysisException | TmfTraceException e) {
                        Assert.fail((String)e.getMessage());
                        if (module != null) {
                            module.dispose();
                        }
                        if (trace != null) {
                            trace.dispose();
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    if (module != null) {
                        module.dispose();
                    }
                    if (trace != null) {
                        trace.dispose();
                    }
                    throw throwable;
                }
                if (module != null) {
                    module.dispose();
                }
                if (trace != null) {
                    trace.dispose();
                }
            }
            ++i;
        }
        pm.commit();
    }

    private static interface runMethod {
        public void execute(PerformanceMeter var1, IAnalysisModule var2);
    }
}

