/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.ISimpleDatatypeDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ArrayDeclaration;

public final class StructDeclarationFlattener {
    private StructDeclarationFlattener() {
    }

    public static @NonNull StructDeclaration tryFlattenStruct(@NonNull StructDeclaration sd) {
        if (StructDeclarationFlattener.canBeFlattened(sd)) {
            return StructDeclarationFlattener.newFlattenedStruct(sd);
        }
        return sd;
    }

    private static boolean canBeFlattened(@NonNull StructDeclaration sd) {
        for (String field : sd.getFieldsList()) {
            IDeclaration dec = sd.getField(field);
            if (StructDeclarationFlattener.isFixedSize(dec)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFixedSize(IDeclaration dec) {
        if (dec instanceof ISimpleDatatypeDeclaration) {
            return true;
        }
        if (dec instanceof ArrayDeclaration) {
            return StructDeclarationFlattener.isFixedSize(((ArrayDeclaration)dec).getElementType());
        }
        if (dec instanceof StructDeclaration) {
            StructDeclaration sDec = (StructDeclaration)dec;
            return StructDeclarationFlattener.canBeFlattened(sDec);
        }
        return false;
    }

    private static @NonNull StructDeclaration newFlattenedStruct(@NonNull StructDeclaration sd) {
        StructDeclaration flatStruct = new StructDeclaration(sd.getAlignment());
        for (String name : sd.getFieldsList()) {
            StructDeclarationFlattener.depthFirstAdd(name, flatStruct, sd.getField(name));
        }
        return flatStruct;
    }

    private static void depthFirstAdd(@NonNull String path, StructDeclaration flatStruct, IDeclaration dec) {
        block5: {
            block6: {
                String name;
                block4: {
                    if (!(dec instanceof ISimpleDatatypeDeclaration)) break block4;
                    flatStruct.addField(path, dec);
                    break block5;
                }
                if (!(dec instanceof ArrayDeclaration)) break block6;
                ArrayDeclaration ad = (ArrayDeclaration)dec;
                int lastIndexOf = path.lastIndexOf(46);
                String string = name = lastIndexOf > 0 ? path.substring(lastIndexOf) : path;
                if (ad.isAlignedBytes()) {
                    flatStruct.addField(path, dec);
                } else {
                    int i = 0;
                    while (i < ad.getLength()) {
                        StructDeclarationFlattener.depthFirstAdd(String.valueOf(path) + '.' + name + '[' + i + ']', flatStruct, ad.getElementType());
                        ++i;
                    }
                }
                break block5;
            }
            if (!(dec instanceof StructDeclaration)) break block5;
            StructDeclaration sDec = (StructDeclaration)dec;
            for (String name : sDec.getFieldsList()) {
                StructDeclarationFlattener.depthFirstAdd(String.valueOf(path) + '.' + name, flatStruct, sDec.getField(name));
            }
        }
    }
}

