/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.tests.kernel;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.Activator;
import org.eclipse.tracecompass.analysis.os.linux.core.tests.stubs.trace.TmfXmlKernelTraceStub;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadEntryModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadStatusDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.junit.Assert;
import org.junit.Test;

public class ThreadStatusDataProviderTest {
    private static final String KERNEL_ANALYSIS = "testfiles/kernel_analysis/lttng_kernel_analysis.xml";

    @Test
    public void testThreadStatusDataProvider() throws TmfTraceException, IOException {
        TmfXmlKernelTraceStub trace = new TmfXmlKernelTraceStub();
        try {
            IPath filePath = Activator.getAbsoluteFilePath(KERNEL_ANALYSIS);
            trace.initTrace(null, filePath.toOSString(), TmfEvent.class);
            trace.traceOpened(new TmfTraceOpenedSignal((Object)this, (ITmfTrace)trace, null));
            KernelAnalysisModule module = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
            Assert.assertNotNull((Object)module);
            Assert.assertTrue((boolean)module.schedule().isOK());
            Assert.assertTrue((boolean)module.waitForCompletion());
            ThreadStatusDataProvider provider = new ThreadStatusDataProvider((ITmfTrace)trace, module);
            Map<Long, String> idsToNames = ThreadStatusDataProviderTest.assertAndGetTree(provider);
            ThreadStatusDataProviderTest.assertRows(provider, idsToNames);
            ThreadStatusDataProviderTest.assertArrows(provider, idsToNames);
        }
        finally {
            trace.dispose();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Map<Long, String> assertAndGetTree(ThreadStatusDataProvider provider) throws IOException {
        @NonNull TmfModelResponse treeResponse = provider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(0L, Long.MAX_VALUE, 2)), null);
        Assert.assertNotNull((Object)treeResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)treeResponse.getStatus());
        @NonNull TmfTreeModel treeModel = (TmfTreeModel)treeResponse.getModel();
        Assert.assertNotNull((Object)treeModel);
        @NonNull List treeEntries = treeModel.getEntries();
        List<String> expectedStrings = Files.readAllLines(Paths.get("testfiles/kernel_analysis/expectedThreadStatusTree", new String[0]));
        Assert.assertEquals((long)expectedStrings.size(), (long)treeEntries.size());
        int i = 0;
        while (i < expectedStrings.size()) {
            String expectedString = expectedStrings.get(i);
            String[] split = expectedString.split(",");
            TimeGraphEntryModel threadEntry = (TimeGraphEntryModel)treeEntries.get(i);
            Assert.assertEquals((Object)split[0], (Object)threadEntry.getName());
            Assert.assertEquals((long)Long.parseLong(split[1]), (long)threadEntry.getStartTime());
            Assert.assertEquals((long)Long.parseLong(split[2]), (long)threadEntry.getEndTime());
            if (threadEntry instanceof ThreadEntryModel) {
                ThreadEntryModel threadEntryModel = (ThreadEntryModel)threadEntry;
                Assert.assertEquals((long)Integer.parseInt(split[3]), (long)threadEntryModel.getThreadId());
                Assert.assertEquals((long)Integer.parseInt(split[4]), (long)threadEntryModel.getProcessId());
                Assert.assertEquals((long)Integer.parseInt(split[5]), (long)threadEntryModel.getParentThreadId());
            } else {
                Assert.assertEquals((long)3L, (long)split.length);
            }
            ++i;
        }
        HashMap<Long, String> map = new HashMap<Long, String>();
        for (TimeGraphEntryModel threadModel : treeEntries) {
            map.put(threadModel.getId(), threadModel.getName());
        }
        return map;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void assertRows(ThreadStatusDataProvider provider, Map<Long, String> idsToNames) throws IOException {
        TmfModelResponse rowResponse = provider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(1L, 80L, 80, idsToNames.keySet())), null);
        Assert.assertNotNull((Object)rowResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)rowResponse.getStatus());
        TimeGraphModel rowModel = (TimeGraphModel)rowResponse.getModel();
        Assert.assertNotNull((Object)rowModel);
        @NonNull List rows = rowModel.getRows();
        rows.sort(Comparator.comparingLong(ITimeGraphRowModel::getEntryID));
        List<String> expectedStrings = Files.readAllLines(Paths.get("testfiles/kernel_analysis/expectedThreadStatusRows", new String[0]));
        Assert.assertEquals((long)expectedStrings.size(), (long)rows.size());
        int i = 0;
        while (i < expectedStrings.size()) {
            String expectedString = expectedStrings.get(i);
            String[] split = expectedString.split(":");
            ITimeGraphRowModel row = (ITimeGraphRowModel)rows.get(i);
            Assert.assertEquals((Object)split[0], (Object)idsToNames.get(row.getEntryID()));
            ThreadStatusDataProviderTest.assertEqualsStates(split[1], row.getStates(), split[0]);
            ++i;
        }
    }

    private static void assertEqualsStates(String string, @NonNull List<@NonNull ITimeGraphState> states, String element) {
        String[] stringStates = string.split(",");
        int i = 0;
        while (i < stringStates.length / 4) {
            ITimeGraphState state = states.get(i);
            Assert.assertEquals((String)(String.valueOf(element) + ": start time at position " + i), (long)Long.parseLong(stringStates[i * 4]), (long)state.getStartTime());
            Assert.assertEquals((String)(String.valueOf(element) + ": duration at position " + i), (long)Long.parseLong(stringStates[i * 4 + 1]), (long)state.getDuration());
            OutputElementStyle style = state.getStyle();
            if (style == null) {
                try {
                    Assert.assertEquals((String)(String.valueOf(element) + ": value at position " + i), (long)Long.parseLong(stringStates[i * 4 + 2]), (long)state.getValue());
                }
                catch (NumberFormatException e) {
                    Assert.fail((String)(String.valueOf(element) + ": value at position " + i + ": did not expect a null style"));
                }
            } else {
                Assert.assertEquals((String)(String.valueOf(element) + ": value at position " + i), (Object)stringStates[i * 4 + 2], (Object)style.getParentKey());
            }
            Assert.assertEquals((String)(String.valueOf(element) + ": label at position " + i), (Object)stringStates[i * 4 + 3], (Object)String.valueOf(state.getLabel()));
            ++i;
        }
    }

    private static void assertArrows(ThreadStatusDataProvider provider, Map<Long, String> idsToNames) throws IOException {
        TmfModelResponse arrowResponse = provider.fetchArrows(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(1L, 80L, 80)), null);
        Assert.assertNotNull((Object)arrowResponse);
        Assert.assertEquals((Object)ITmfResponse.Status.COMPLETED, (Object)arrowResponse.getStatus());
        List arrows = (List)arrowResponse.getModel();
        Assert.assertNotNull((Object)arrows);
        List<String> expectedStrings = Files.readAllLines(Paths.get("testfiles/kernel_analysis/expectedThreadStatusArrows", new String[0]));
        Assert.assertEquals((long)expectedStrings.size(), (long)arrows.size());
        int i = 0;
        while (i < expectedStrings.size()) {
            String expectedString = expectedStrings.get(i);
            String[] split = expectedString.split(",");
            ITimeGraphArrow arrow = (ITimeGraphArrow)arrows.get(i);
            Assert.assertEquals((Object)split[0], (Object)idsToNames.get(arrow.getSourceId()));
            Assert.assertEquals((Object)split[1], (Object)idsToNames.get(arrow.getDestinationId()));
            Assert.assertEquals((long)Long.parseLong(split[2]), (long)arrow.getStartTime());
            Assert.assertEquals((long)Long.parseLong(split[3]), (long)arrow.getDuration());
            ++i;
        }
    }
}

